/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote;

import com.intellij.jupyter.core.jupyter.JupyterErrorHandlingUtilKt;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameterSettingsUtilsKt;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.CachingFileContentsApi;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.ContentsApiModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.DirectoryModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.LeafContentsApiModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.RemoteTimeStampCache;
import com.intellij.jupyter.core.jupyter.connections.settings.ConfiguredServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.py.JupyterRemoteBundle;
import com.intellij.jupyter.py.JupyterRemoteNotifier;
import com.intellij.jupyter.py.remote.vfs.JupyterRemoteVfsUtilKt;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteNodeAsyncChildrenLoader;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileSystem;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterVFileEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u00020\u00132\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/intellij/jupyter/py/ui/remote/ReloadSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "nodesToReload", "", "Lcom/intellij/jupyter/py/ui/remote/JupyterRemoteNode;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;)V", "deque", "Lkotlin/collections/ArrayDeque;", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "askUser", "", "userAnswer", "Ljava/lang/Boolean;", "isCancelledByUser", "()Z", "launch", "", "postReload", "reloadResult", "Lcom/intellij/jupyter/py/ui/remote/ReloadSession$ReloadResult;", "notify", "message", "", "reloadRemoteFile", "file", "Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;", "isReloadNeeded", "contentApiModel", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/LeafContentsApiModel;", "remotePath", "ReloadResult", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterRemoteNodeReloadService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteNodeReloadService.kt\ncom/intellij/jupyter/py/ui/remote/ReloadSession\n+ 2 JupyterErrorHandlingUtil.kt\ncom/intellij/jupyter/core/jupyter/JupyterErrorHandlingUtilKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,178:1\n41#2:179\n73#2,6:180\n43#2:186\n79#2:187\n77#2,7:188\n47#2:195\n1317#3,2:196\n1557#4:198\n1628#4,3:199\n1557#4:202\n1628#4,3:203\n1557#4:206\n1628#4,3:207\n1782#4,4:210\n1863#4,2:214\n14#5:216\n*S KotlinDebug\n*F\n+ 1 JupyterRemoteNodeReloadService.kt\ncom/intellij/jupyter/py/ui/remote/ReloadSession\n*L\n75#1:179\n75#1:180,6\n75#1:186\n75#1:187\n75#1:188,7\n75#1:195\n98#1:196,2\n101#1:198\n101#1:199,3\n103#1:202\n103#1:203,3\n109#1:206\n109#1:207,3\n109#1:210,4\n125#1:214,2\n176#1:216\n*E\n"})
final class ReloadSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ArrayDeque<JupyterRemotePath> deque;
    private boolean askUser;
    @Nullable
    private Boolean userAnswer;
    @NotNull
    private static final Logger LOG;

    public ReloadSession(@NotNull Project project, @NotNull Collection<? extends JupyterRemoteNode> nodesToReload) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(nodesToReload, (String)"nodesToReload");
        this.project = project;
        this.deque = new ArrayDeque();
        this.askUser = true;
        for (JupyterRemoteNode jupyterRemoteNode : nodesToReload) {
            this.deque.add((Object)jupyterRemoteNode.getRemotePath());
        }
    }

    private final boolean isCancelledByUser() {
        return this.askUser && Intrinsics.areEqual((Object)this.userAnswer, (Object)false);
    }

    /*
     * WARNING - void declaration
     */
    public final void launch() {
        ReloadResult reloadResult = new ReloadResult();
        while (!this.isCancelledByUser() && !((Collection)this.deque).isEmpty()) {
            block20: {
                JupyterRemotePath remotePath;
                block21: {
                    int n;
                    void $this$count$iv;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    Object item$iv$iv3;
                    Collection collection;
                    Set cachedFileNames;
                    JupyterRemotePath it;
                    Iterable<String> iterable;
                    block23: {
                        block22: {
                            void $this$mapTo$iv$iv2;
                            Iterable<String> destination$iv$iv;
                            Sequence $i$f$runHandlingConnectionErrors3;
                            Sequence $i$f$runHandlingConnectionErrors22;
                            Logger contentsApiModel;
                            Sequence $this$runHandlingConnectionErrors$iv$iv;
                            Logger logger;
                            JupyterRemoteVirtualFile jupyterRemoteVirtualFile;
                            remotePath = (JupyterRemotePath)this.deque.removeFirst();
                            if (JupyterRemoteFileSystem.Companion.getInstance().findFileByPath(remotePath) == null) continue;
                            JupyterRemoteVirtualFile vFile = jupyterRemoteVirtualFile;
                            boolean bl = false;
                            try {
                                ContentsApiModel contentsApiModel2;
                                void $this$runHandlingConnectionErrors$iv;
                                logger = LOG;
                                boolean suggestRemovingConnection$iv = false;
                                boolean $i$f$runHandlingConnectionErrors22 = false;
                                $this$runHandlingConnectionErrors$iv$iv = $this$runHandlingConnectionErrors$iv;
                                boolean $i$f$runHandlingConnectionErrors3 = false;
                                try {
                                    boolean bl2 = false;
                                    CachingFileContentsApi cachingFileContentsApi = JupyterRemoteVfsUtilKt.getFileContentsApi(remotePath);
                                    contentsApiModel2 = cachingFileContentsApi != null ? cachingFileContentsApi.getFileNode(remotePath.getJupyterPath(), vFile.isDirectory(), ContentsApiModel.class) : null;
                                }
                                catch (IOException e$iv$iv) {
                                    boolean bl3 = false;
                                    ConfiguredServerJupyterModuleConnectionSettings configuredServerJupyterModuleConnectionSettings = JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority((String)remotePath.getAuthority());
                                    if (configuredServerJupyterModuleConnectionSettings == null) {
                                        throw e$iv$iv;
                                    }
                                    JupyterErrorHandlingUtilKt.suggestRemovingConnection((ConfiguredServerJupyterModuleConnectionSettings)configuredServerJupyterModuleConnectionSettings, (boolean)suggestRemovingConnection$iv);
                                    Iterator iterator = $this$runHandlingConnectionErrors$iv$iv;
                                    bl3 = false;
                                    iterator.warn("Unexpected exception for " + JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority((String)remotePath.getAuthority()), e$iv$iv);
                                    contentsApiModel2 = null;
                                }
                                logger = contentsApiModel2;
                            }
                            catch (Throwable err) {
                                logger = null;
                            }
                            if ((logger = (contentsApiModel = logger)) == null) continue;
                            if (logger instanceof LeafContentsApiModel) {
                                if (!this.isReloadNeeded((LeafContentsApiModel)contentsApiModel, remotePath)) continue;
                                int err = reloadResult.getNumberOfUpdatedFiles();
                                reloadResult.setNumberOfUpdatedFiles(err + 1);
                                this.reloadRemoteFile(vFile);
                                continue;
                            }
                            if (!(logger instanceof DirectoryModel)) break block20;
                            Collection err = ((DirectoryModel)contentsApiModel).getContent();
                            if (err != null && ($i$f$runHandlingConnectionErrors22 = CollectionsKt.asSequence((Iterable)err)) != null && ($this$runHandlingConnectionErrors$iv$iv = SequencesKt.map((Sequence)$i$f$runHandlingConnectionErrors22, arg_0 -> ReloadSession.launch$lambda$7$lambda$1(remotePath, arg_0))) != null && ($i$f$runHandlingConnectionErrors3 = SequencesKt.mapNotNull((Sequence)$this$runHandlingConnectionErrors$iv$iv, (Function1)((Function1)new Function1<JupyterRemotePath, JupyterRemoteVirtualFile>((Object)JupyterRemoteFileSystem.Companion.getInstance()){

                                public final JupyterRemoteVirtualFile invoke(JupyterRemotePath p0) {
                                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                    return ((JupyterRemoteFileSystem)this.receiver).findFileByPath(p0);
                                }
                            }))) != null) {
                                void $this$forEach$iv;
                                Sequence bl2 = $i$f$runHandlingConnectionErrors3;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    JupyterRemoteVirtualFile it2 = (JupyterRemoteVirtualFile)element$iv;
                                    boolean bl4 = false;
                                    this.deque.add((Object)it2.getRemotePath());
                                }
                            }
                            Collection<ContentsApiModel> collection2 = JupyterRemoteNodeAsyncChildrenLoader.Companion.getInstance(this.project).getCachedChildren$intellij_jupyter_py(remotePath);
                            if (collection2 != null) {
                                void $this$mapTo$iv$iv3;
                                Iterable $this$map$iv2 = collection2;
                                boolean $i$f$map = false;
                                Iterable $i$f$forEach = $this$map$iv2;
                                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                                    ContentsApiModel contentsApiModel3 = (ContentsApiModel)item$iv$iv2;
                                    iterable = destination$iv$iv;
                                    boolean bl5 = false;
                                    iterable.add(it.getName());
                                }
                                v3 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                            } else {
                                v3 = cachedFileNames = null;
                            }
                            if (cachedFileNames == null) break block21;
                            collection = ((DirectoryModel)contentsApiModel).getContent();
                            if (collection == null) break block22;
                            Iterable $this$map$iv3 = collection;
                            boolean $i$f$map = false;
                            destination$iv$iv = $this$map$iv3;
                            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                                void it3;
                                ContentsApiModel bl5 = (ContentsApiModel)item$iv$iv3;
                                iterable = destination$iv$iv2;
                                boolean bl6 = false;
                                iterable.add((String)it3.getName());
                            }
                            collection = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                            if (collection != null) break block23;
                        }
                        collection = SetsKt.emptySet();
                    }
                    Collection actualRemoteFileNames = collection;
                    int intersectionSize = CollectionsKt.intersect((Iterable)actualRemoteFileNames, (Iterable)cachedFileNames).size();
                    int numberOfAddedFiles = actualRemoteFileNames.size() - intersectionSize;
                    Iterable $i$f$map = SetsKt.minus((Set)cachedFileNames, (Iterable)actualRemoteFileNames);
                    boolean $i$f$map2 = false;
                    void destination$iv$iv2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    item$iv$iv3 = $this$mapTo$iv$iv.iterator();
                    while (item$iv$iv3.hasNext()) {
                        void it4;
                        Object item$iv$iv4 = item$iv$iv3.next();
                        String bl6 = (String)item$iv$iv4;
                        iterable = destination$iv$iv;
                        boolean bl = false;
                        String[] stringArray = new String[]{it4};
                        iterable.add((JupyterRemotePath)remotePath.resolve(stringArray));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv) {
                            it = (JupyterRemotePath)element$iv;
                            boolean bl = false;
                            JupyterRemoteVirtualFile deletedFile = JupyterRemoteFileSystem.Companion.getInstance().findFileByPath(it);
                            if (!(deletedFile == null || deletedFile.isDirectory()) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    int numberOfDeletedFiles = n;
                    int delta = numberOfAddedFiles + numberOfDeletedFiles;
                    reloadResult.setNumberOfUpdatedFiles(reloadResult.getNumberOfUpdatedFiles() + delta);
                }
                reloadResult.getReloadedPaths().add(remotePath);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        this.postReload(reloadResult);
    }

    private final void postReload(ReloadResult reloadResult) {
        Iterable $this$forEach$iv = reloadResult.getReloadedPaths();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterRemotePath it = (JupyterRemotePath)element$iv;
            boolean bl = false;
            JupyterVFileEvent.DirectoryContentChanged event = new JupyterVFileEvent.DirectoryContentChanged(it);
            ((JupyterVFileEvent.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(JupyterVFileEvent.Companion.getTOPIC())).invoke((JupyterVFileEvent)event);
        }
        if (reloadResult.getNumberOfUpdatedFiles() > 0) {
            Object[] objectArray = new Object[]{reloadResult.getNumberOfUpdatedFiles()};
            this.notify(JupyterRemoteBundle.message("Jupyter.remote.reload.file.from.server.number.of.files.reloaded", objectArray));
        } else if (reloadResult.getAllFilesAreUpToDate()) {
            this.notify(JupyterRemoteBundle.message("Jupyter.remote.reload.file.from.server.all.files.are.up.to.date", new Object[0]));
        }
    }

    private final void notify(@Nls String message2) {
        JupyterRemoteNotifier.INSTANCE.notifyInfo(this.project, message2);
    }

    public final void reloadRemoteFile(@NotNull JupyterRemoteVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.askUser) {
            Boolean answer2 = (Boolean)UIUtil.invokeAndWaitIfNeeded(() -> ReloadSession.reloadRemoteFile$lambda$9(file, this));
            if (!this.askUser) {
                this.userAnswer = answer2;
            }
            if (!answer2.booleanValue()) {
                return;
            }
        }
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(file, null){
            int label;
            final /* synthetic */ JupyterRemoteVirtualFile $file;
            {
                this.$file = $file;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = JupyterRemoteFileSystem.Companion.getInstance().reloadRemoteFile(this.$file, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final boolean isReloadNeeded(LeafContentsApiModel contentApiModel, JupyterRemotePath remotePath) {
        ZonedDateTime zonedDateTime = contentApiModel.getLastModified();
        if (zonedDateTime == null) {
            return false;
        }
        ZonedDateTime lastModified = zonedDateTime;
        Long l = RemoteTimeStampCache.Companion.getInstance().getTimeStampForPath(remotePath.getFullPath());
        if (l == null) {
            return true;
        }
        long cachedRemoteTimeStamp = l;
        return lastModified.toInstant().toEpochMilli() > cachedRemoteTimeStamp;
    }

    private static final JupyterRemotePath launch$lambda$7$lambda$1(JupyterRemotePath $remotePath, ContentsApiModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{it.getName()};
        return $remotePath.resolve(stringArray);
    }

    private static final Boolean reloadRemoteFile$lambda$9(JupyterRemoteVirtualFile $file, ReloadSession this$0) {
        Object[] objectArray = new Object[]{$file.getRemotePath()};
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(JupyterRemoteBundle.message("Jupyter.remote.reload.file.from.server.dialog.title", new Object[0]), JupyterRemoteBundle.message("Jupyter.remote.reload.file.from.server.dialog.question", objectArray)).icon(Messages.getWarningIcon())).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(this$0){
            final /* synthetic */ ReloadSession this$0;
            {
                this.this$0 = $receiver;
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected) {
                    ReloadSession.access$setAskUser$p(this.this$0, false);
                }
            }

            public String getDoNotShowMessage() {
                return JupyterRemoteBundle.message("Jupyter.remote.reload.file.from.server.dialog.checkbox.remember.my.choice", new Object[0]);
            }
        })).ask(this$0.project);
    }

    public static final /* synthetic */ void access$setAskUser$p(ReloadSession $this, boolean bl) {
        $this.askUser = bl;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ReloadSession.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/py/ui/remote/ReloadSession$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/py/ui/remote/ReloadSession$ReloadResult;", "", "<init>", "()V", "numberOfUpdatedFiles", "", "getNumberOfUpdatedFiles", "()I", "setNumberOfUpdatedFiles", "(I)V", "allFilesAreUpToDate", "", "getAllFilesAreUpToDate", "()Z", "reloadedPaths", "", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "getReloadedPaths", "()Ljava/util/List;", "intellij.jupyter.py"})
    private static final class ReloadResult {
        private int numberOfUpdatedFiles;
        @NotNull
        private final List<JupyterRemotePath> reloadedPaths = new ArrayList();

        public final int getNumberOfUpdatedFiles() {
            return this.numberOfUpdatedFiles;
        }

        public final void setNumberOfUpdatedFiles(int n) {
            this.numberOfUpdatedFiles = n;
        }

        public final boolean getAllFilesAreUpToDate() {
            return this.numberOfUpdatedFiles == 0;
        }

        @NotNull
        public final List<JupyterRemotePath> getReloadedPaths() {
            return this.reloadedPaths;
        }
    }
}

