/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.settings.data;

import com.google.gson.JsonObject;
import com.intellij.charts.core.utils.GroupingResult;
import com.intellij.charts.core.utils.GroupingUtils;
import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.dataframe.columns.Column;
import com.intellij.charts.settings.data.ColumnSettings;
import com.intellij.charts.settings.data.SeriesSettings;
import com.intellij.charts.settings.data.type.BarSeriesType;
import com.intellij.charts.style.ChartsConfig;
import com.intellij.charts.utils.ChartJsonUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.geom.geomBar;
import org.jetbrains.letsPlot.intern.Layer;
import org.jetbrains.letsPlot.intern.PosKind;
import org.jetbrains.letsPlot.intern.layer.PosOptions;
import org.jetbrains.letsPlot.intern.layer.SamplingOptions;
import org.jetbrains.letsPlot.intern.layer.geom.BarMapping;
import org.jetbrains.letsPlot.tooltips.layerTooltips;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001BW\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\b\u0010 \u001a\u00020\u000eH\u0016J\b\u0010!\u001a\u00020\u0003H\u0016J\u0013\u0010\"\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'H\u0016J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00062\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020+H\u0016R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0019\"\u0004\b\u001d\u0010\u001bR\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0019\"\u0004\b\u001f\u0010\u001b\u00a8\u0006-"}, d2={"Lcom/intellij/charts/settings/data/BarSeriesSettings;", "Lcom/intellij/charts/settings/data/SeriesSettings;", "horizontal", "", "stacked", "keys", "", "Lcom/intellij/charts/settings/data/ColumnSettings;", "groups", "values", "showLegend", "<init>", "(ZZLjava/util/List;Ljava/util/List;Ljava/util/List;Z)V", "json", "Lcom/google/gson/JsonObject;", "(Lcom/google/gson/JsonObject;)V", "type", "Lcom/intellij/charts/settings/data/type/BarSeriesType;", "getType", "()Lcom/intellij/charts/settings/data/type/BarSeriesType;", "getKeys", "()Ljava/util/List;", "getGroups", "getValues", "getHorizontal", "()Z", "setHorizontal", "(Z)V", "getStacked", "setStacked", "getShowLegend", "setShowLegend", "toJson", "isEmpty", "equals", "other", "", "filterByNewDataFrame", "dataFrame", "Lcom/intellij/charts/dataframe/DataFrame;", "getLetsPlotLayer", "Lorg/jetbrains/letsPlot/intern/Layer;", "chartIndex", "", "hashCode", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nBarSeriesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarSeriesSettings.kt\ncom/intellij/charts/settings/data/BarSeriesSettings\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n24#2:182\n774#3:183\n865#3,2:184\n1368#3:186\n1454#3,5:187\n1368#3:192\n1454#3,2:193\n1456#3,3:196\n1368#3:199\n1454#3,5:200\n1#4:195\n*S KotlinDebug\n*F\n+ 1 BarSeriesSettings.kt\ncom/intellij/charts/settings/data/BarSeriesSettings\n*L\n90#1:182\n102#1:183\n102#1:184,2\n138#1:186\n138#1:187,5\n139#1:192\n139#1:193,2\n139#1:196,3\n142#1:199\n142#1:200,5\n*E\n"})
public final class BarSeriesSettings
extends SeriesSettings {
    @NotNull
    private final BarSeriesType type;
    @NotNull
    private final List<ColumnSettings> keys;
    @NotNull
    private final List<ColumnSettings> groups;
    @NotNull
    private final List<ColumnSettings> values;
    private boolean horizontal;
    private boolean stacked;
    private boolean showLegend;

    @Override
    @NotNull
    public BarSeriesType getType() {
        return this.type;
    }

    @NotNull
    public final List<ColumnSettings> getKeys() {
        return this.keys;
    }

    @NotNull
    public final List<ColumnSettings> getGroups() {
        return this.groups;
    }

    @NotNull
    public final List<ColumnSettings> getValues() {
        return this.values;
    }

    public final boolean getHorizontal() {
        return this.horizontal;
    }

    public final void setHorizontal(boolean bl) {
        this.horizontal = bl;
    }

    public final boolean getStacked() {
        return this.stacked;
    }

    public final void setStacked(boolean bl) {
        this.stacked = bl;
    }

    public final boolean getShowLegend() {
        return this.showLegend;
    }

    public final void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public BarSeriesSettings(boolean horizontal, boolean stacked, @NotNull List<ColumnSettings> keys, @NotNull List<ColumnSettings> groups2, @NotNull List<ColumnSettings> values2, boolean showLegend) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        this.type = BarSeriesType.Companion.getInstance();
        this.horizontal = horizontal;
        this.stacked = stacked;
        this.keys = keys;
        this.groups = groups2;
        this.values = values2;
        this.showLegend = showLegend;
    }

    public /* synthetic */ BarSeriesSettings(boolean bl, boolean bl2, List list2, List list3, List list4, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        this(bl, bl2, list2, list3, list4, bl3);
    }

    public BarSeriesSettings(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.type = BarSeriesType.Companion.getInstance();
        this.keys = ChartJsonUtilsKt.optColumnSettingsList(json, "keys");
        this.groups = ChartJsonUtilsKt.optColumnSettingsList(json, "groups");
        this.values = ChartJsonUtilsKt.optColumnSettingsList(json, "values");
        this.horizontal = ChartJsonUtilsKt.optBoolean(json, "horizontal");
        this.stacked = ChartJsonUtilsKt.optBoolean(json, "stacked");
        this.showLegend = ChartJsonUtilsKt.optBoolean(json, "showLegend");
    }

    @Override
    @NotNull
    public JsonObject toJson() {
        JsonObject jsonObject;
        JsonObject $this$toJson_u24lambda_u240 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u240.addProperty("type", this.getType().getId());
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "horizontal", this.horizontal);
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "stacked", this.stacked);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "keys", this.keys);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "groups", this.groups);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "values", this.values);
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "showLegend", this.showLegend);
        return jsonObject;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty() && this.groups.isEmpty() && this.values.isEmpty();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof BarSeriesSettings && Intrinsics.areEqual(((BarSeriesSettings)other).keys, this.keys) && Intrinsics.areEqual(((BarSeriesSettings)other).groups, this.groups) && Intrinsics.areEqual(((BarSeriesSettings)other).values, this.values) && ((BarSeriesSettings)other).horizontal == this.horizontal && ((BarSeriesSettings)other).stacked == this.stacked && ((BarSeriesSettings)other).showLegend == this.showLegend;
    }

    @Override
    @NotNull
    public BarSeriesSettings filterByNewDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        return new BarSeriesSettings(this.horizontal, this.stacked, SeriesSettings.Companion.filterByDataFrame(this.keys, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.groups, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.values, dataFrame), this.showLegend);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Layer> getLetsPlotLayer(@NotNull DataFrame dataFrame, int chartIndex) {
        List list2;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (this.keys.isEmpty() || this.values.isEmpty()) {
            BarSeriesSettings $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(BarSeriesSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Bar series should have one categories and at least one value axis");
            return CollectionsKt.emptyList();
        }
        List[] $this$thisLogger$iv = new List[]{this.keys, this.groups, this.values};
        if (!SeriesSettings.Companion.dataFrameHasAllColumns(dataFrame, $this$thisLogger$iv)) {
            return CollectionsKt.emptyList();
        }
        GroupingResult groupingResult = GroupingUtils.INSTANCE.get(dataFrame, this.keys, this.groups, this.values);
        if (groupingResult == null) {
            return CollectionsKt.emptyList();
        }
        GroupingResult res = groupingResult;
        Iterable $this$filter$iv = res.getYColumns();
        boolean $i$f$filter2 = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = (Pair[])new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Column it = (Column)element$iv$iv;
            boolean bl = false;
            if (!it.isNumerical()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List barsColumns = (List)destination$iv$iv;
        if (barsColumns.isEmpty()) {
            list2 = CollectionsKt.emptyList();
        } else if (barsColumns.size() == 1) {
            Pair[] $i$f$filter2 = new Pair[]{TuplesKt.to((Object)res.getXColumn().getName(), res.getXColumn().toList()), TuplesKt.to((Object)((Column)CollectionsKt.first((List)barsColumns)).getName(), ((Column)CollectionsKt.first((List)barsColumns)).toList())};
            Map data = MapsKt.mapOf((Pair[])$i$f$filter2);
            Color color = ChartsConfig.Companion.getInstance().getSettings().getPaletteColor(chartIndex);
            destination$iv$iv = SeriesSettings.Companion.getSampling(res);
            String $i$f$filterTo2 = this.horizontal ? "y" : "x";
            layerTooltips layerTooltips2 = new layerTooltips(new String[0]).line(res.getXColumn().getName() + "|@{" + res.getXColumn().getName() + "}").line(((Column)CollectionsKt.first((List)barsColumns)).getName() + "|@{" + ((Column)CollectionsKt.first((List)barsColumns)).getName() + "}");
            element$iv$iv = new PosOptions(this.stacked ? PosKind.STACK : PosKind.DODGE, null, 2, null);
            geomBar plot = new geomBar(data, null, (PosOptions)element$iv$iv, false, null, (SamplingOptions)destination$iv$iv, layerTooltips2, null, $i$f$filterTo2, null, null, null, color, color, null, null, null, null, null, arg_0 -> BarSeriesSettings.getLetsPlotLayer$lambda$2(this, res, barsColumns, arg_0), 511634, null);
            list2 = CollectionsKt.listOf((Object)plot);
        } else {
            Iterable list$iv$iv;
            int element$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            String groupColumnName = CollectionsKt.joinToString$default((Iterable)this.groups, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            String yColumnName = SeriesSettings.Companion.getPresentableAxisText$default(SeriesSettings.Companion, this.values, null, 2, null);
            destination$iv$iv = new Pair[3];
            Iterable $i$f$filterTo2 = (Iterable)CollectionsKt.getIndices((Collection)barsColumns);
            String string = res.getXColumn().getName();
            int n = 0;
            Pair[] pairArray = destination$iv$iv;
            boolean $i$f$flatMap = false;
            element$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                int it = element$iv$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                list$iv$iv = res.getXColumn().toList();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List list3 = (List)destination$iv$iv2;
            pairArray[n] = TuplesKt.to((Object)string, (Object)list3);
            $this$flatMap$iv = (Iterable)CollectionsKt.getIndices((Collection)barsColumns);
            string = groupColumnName;
            n = 1;
            pairArray = destination$iv$iv;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$flatMapTo = false;
            iterator2 = $this$flatMapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                int columnIndex = element$iv$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                int n2 = res.getXColumn().getSize();
                ArrayList<String> arrayList = new ArrayList<String>(n2);
                int n3 = 0;
                while (n3 < n2) {
                    int n4;
                    int n5 = n4 = n3++;
                    ArrayList<String> arrayList2 = arrayList;
                    boolean bl2 = false;
                    arrayList2.add(((Column)barsColumns.get(columnIndex)).getName());
                }
                list$iv$iv = arrayList;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            list3 = (List)destination$iv$iv2;
            pairArray[n] = TuplesKt.to((Object)string, (Object)list3);
            $this$flatMap$iv = (Iterable)CollectionsKt.getIndices((Collection)barsColumns);
            string = yColumnName;
            n = 2;
            pairArray = destination$iv$iv;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$flatMapTo = false;
            iterator2 = $this$flatMapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                int it = element$iv$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                list$iv$iv = ((Column)barsColumns.get(it)).toList();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            list3 = (List)destination$iv$iv2;
            pairArray[n] = TuplesKt.to((Object)string, (Object)list3);
            Map data = MapsKt.mutableMapOf((Pair[])destination$iv$iv);
            layerTooltips tooltips = new layerTooltips(new String[0]).line(res.getXColumn().getName() + "|@{" + res.getXColumn().getName() + "}").line("@{" + groupColumnName + "}  @{" + yColumnName + "}");
            SamplingOptions samplingOptions = SeriesSettings.Companion.getSampling(res);
            String string2 = this.horizontal ? "y" : "x";
            PosOptions posOptions = new PosOptions(this.stacked ? PosKind.STACK : PosKind.DODGE, null, 2, null);
            geomBar plot = new geomBar(data, null, posOptions, false, null, samplingOptions, tooltips, null, string2, null, null, null, null, null, null, 0, null, null, null, arg_0 -> BarSeriesSettings.getLetsPlotLayer$lambda$7(this, res, yColumnName, groupColumnName, arg_0), 491154, null);
            list2 = CollectionsKt.listOf((Object)plot);
        }
        return list2;
    }

    public int hashCode() {
        int result2 = this.getType().hashCode();
        result2 = 31 * result2 + ((Object)this.keys).hashCode();
        result2 = 31 * result2 + ((Object)this.groups).hashCode();
        result2 = 31 * result2 + ((Object)this.values).hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.horizontal);
        result2 = 31 * result2 + Boolean.hashCode(this.stacked);
        result2 = 31 * result2 + Boolean.hashCode(this.showLegend);
        return result2;
    }

    private static final Unit getLetsPlotLayer$lambda$2(BarSeriesSettings this$0, GroupingResult $res, List $barsColumns, BarMapping $this$geomBar) {
        Intrinsics.checkNotNullParameter((Object)$this$geomBar, (String)"$this$geomBar");
        if (this$0.horizontal) {
            $this$geomBar.setY($res.getXColumn().getName());
            $this$geomBar.setX(((Column)CollectionsKt.first((List)$barsColumns)).getName());
        } else {
            $this$geomBar.setX($res.getXColumn().getName());
            $this$geomBar.setY(((Column)CollectionsKt.first((List)$barsColumns)).getName());
        }
        $this$geomBar.setWeight(((Column)CollectionsKt.first((List)$barsColumns)).getName());
        return Unit.INSTANCE;
    }

    private static final Unit getLetsPlotLayer$lambda$7(BarSeriesSettings this$0, GroupingResult $res, String $yColumnName, String $groupColumnName, BarMapping $this$geomBar) {
        Intrinsics.checkNotNullParameter((Object)$this$geomBar, (String)"$this$geomBar");
        if (this$0.horizontal) {
            $this$geomBar.setY($res.getXColumn().getName());
            $this$geomBar.setX($yColumnName);
        } else {
            $this$geomBar.setX($res.getXColumn().getName());
            $this$geomBar.setY($yColumnName);
        }
        $this$geomBar.setWeight($yColumnName);
        $this$geomBar.setFill($groupColumnName);
        return Unit.INSTANCE;
    }
}

