/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.awt.plot.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.awt.plot.FigureModel;
import org.jetbrains.letsPlot.awt.plot.component.ApplicationContext;
import org.jetbrains.letsPlot.awt.plot.component.PlotComponentProvider;
import org.jetbrains.letsPlot.awt.plot.component.PlotPanelFigureModel;
import org.jetbrains.letsPlot.awt.plot.component.ResizeHook;
import org.jetbrains.letsPlot.commons.registration.Disposable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J*\u0010\u0019\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0016\b\u0002\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001dH\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/awt/plot/component/PlotPanel;", "Ljavax/swing/JPanel;", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "plotComponentProvider", "Lorg/jetbrains/letsPlot/awt/plot/component/PlotComponentProvider;", "preferredSizeFromPlot", "", "repaintDelay", "", "applicationContext", "Lorg/jetbrains/letsPlot/awt/plot/component/ApplicationContext;", "(Lorg/jetbrains/letsPlot/awt/plot/component/PlotComponentProvider;ZILorg/jetbrains/letsPlot/awt/plot/component/ApplicationContext;)V", "figureModel", "Lorg/jetbrains/letsPlot/awt/plot/FigureModel;", "getFigureModel", "()Lorg/jetbrains/letsPlot/awt/plot/FigureModel;", "dispose", "", "handleChildRemoved", "child", "Ljava/awt/Component;", "handleChildRemovedIntern", "plotComponentCreated", "plotComponent", "Ljavax/swing/JComponent;", "rebuildProvidedComponent", "containerSize", "Ljava/awt/Dimension;", "specOverride", "", "", "", "Companion", "platf-awt"})
public class PlotPanel
extends JPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlotComponentProvider plotComponentProvider;
    @NotNull
    private final FigureModel figureModel;

    public PlotPanel(@NotNull PlotComponentProvider plotComponentProvider, boolean preferredSizeFromPlot, int repaintDelay, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)plotComponentProvider, (String)"plotComponentProvider");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.plotComponentProvider = plotComponentProvider;
        this.setLayout(new BorderLayout(0, 0));
        this.setOpaque(false);
        this.setBorder(null);
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentRemoved(@NotNull ContainerEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Component component2 = e.getChild();
                Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getChild(...)");
                this.handleChildRemovedIntern(component2);
            }
        });
        JComponent providedComponent = preferredSizeFromPlot ? PlotPanel.rebuildProvidedComponent$default(this, null, null, 2, null) : null;
        this.figureModel = new PlotPanelFigureModel(this, providedComponent, (Function2<? super Dimension, ? super Map<String, ? extends Object>, ? extends JComponent>)((Function2)new Function2<Dimension, Map<String, ? extends Object>, JComponent>(){

            @NotNull
            public final JComponent invoke(@NotNull Dimension containerSize, @Nullable Map<String, ? extends Object> specOverride) {
                Intrinsics.checkNotNullParameter((Object)containerSize, (String)"containerSize");
                return this.rebuildProvidedComponent(containerSize, specOverride);
            }
        }), applicationContext);
        this.addComponentListener(new ResizeHook(this, providedComponent != null, providedComponent instanceof JScrollPane ? (JScrollPane)providedComponent : null, (Function1<? super Dimension, ? extends Dimension>)((Function1)new Function1<Dimension, Dimension>(){

            @NotNull
            public final Dimension invoke(@NotNull Dimension containerSize) {
                Intrinsics.checkNotNullParameter((Object)containerSize, (String)"containerSize");
                return plotComponentProvider.getPreferredSize(containerSize);
            }
        }), (PlotPanelFigureModel)this.figureModel, applicationContext, repaintDelay));
    }

    @NotNull
    public final FigureModel getFigureModel() {
        return this.figureModel;
    }

    @Override
    public void dispose() {
        this.removeAll();
    }

    private final void handleChildRemovedIntern(Component child) {
        this.handleChildRemoved(child);
        Component component2 = child;
        if (component2 instanceof Disposable) {
            ((Disposable)((Object)child)).dispose();
        } else if (component2 instanceof JScrollPane) {
            Component component3 = ((JScrollPane)child).getViewport().getView();
            Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"getView(...)");
            this.handleChildRemovedIntern(component3);
        }
    }

    protected void handleChildRemoved(@NotNull Component child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
    }

    protected void plotComponentCreated(@NotNull JComponent plotComponent) {
        Intrinsics.checkNotNullParameter((Object)plotComponent, (String)"plotComponent");
    }

    private final JComponent rebuildProvidedComponent(Dimension containerSize, Map<String, ? extends Object> specOverride) {
        this.removeAll();
        JComponent providedComponent = this.plotComponentProvider.createComponent(containerSize, specOverride);
        this.plotComponentCreated(Companion.actualPlotComponentFromProvidedComponent(providedComponent));
        this.add(providedComponent);
        return providedComponent;
    }

    static /* synthetic */ JComponent rebuildProvidedComponent$default(PlotPanel plotPanel2, Dimension dimension, Map map2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: rebuildProvidedComponent");
        }
        if ((n & 2) != 0) {
            map2 = null;
        }
        return plotPanel2.rebuildProvidedComponent(dimension, map2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/awt/plot/component/PlotPanel$Companion;", "", "()V", "actualPlotComponentFromProvidedComponent", "Ljavax/swing/JComponent;", "providedComponent", "platf-awt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JComponent actualPlotComponentFromProvidedComponent(@NotNull JComponent providedComponent) {
            JComponent jComponent;
            Intrinsics.checkNotNullParameter((Object)providedComponent, (String)"providedComponent");
            if (providedComponent instanceof JScrollPane) {
                Component component2 = ((JScrollPane)providedComponent).getViewport().getView();
                Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                jComponent = (JComponent)component2;
            } else {
                jComponent = providedComponent;
            }
            return jComponent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

