/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.LineRangeGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.VLineGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.util.FlippableGeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\rH\u0002J0\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J&\u0010#\u001a\u0010\u0012\u0004\u0012\u00020%\u0012\u0006\u0012\u0004\u0018\u00010\u00110$2\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006)"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/LineRangeGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "isVertical", "", "(Z)V", "flipHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/FlippableGeomHelper;", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "wontRender", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "getWontRender", "()Ljava/util/List;", "afterRotation", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "rectangle", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "vector", "", "aes", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "clientRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nLineRangeGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineRangeGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/LineRangeGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1549#2:112\n1620#2,3:113\n1#3:116\n*S KotlinDebug\n*F\n+ 1 LineRangeGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/LineRangeGeom\n*L\n41#1:112\n41#1:113,3\n*E\n"})
public final class LineRangeGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isVertical;
    @NotNull
    private final FlippableGeomHelper flipHelper;
    public static final boolean HANDLES_GROUPS = false;
    public static final double MIN_TOOLTIP_RECTANGLE_WIDTH = 2.0;

    public LineRangeGeom(boolean isVertical) {
        this.isVertical = isVertical;
        this.flipHelper = new FlippableGeomHelper(this.isVertical);
    }

    private final Aes<Double> afterRotation(Aes<Double> aes2) {
        return this.flipHelper.getEffectiveAes(aes2);
    }

    private final DoubleRectangle afterRotation(DoubleRectangle rectangle) {
        return this.flipHelper.flip(rectangle);
    }

    private final DoubleVector afterRotation(DoubleVector vector) {
        return this.flipHelper.flip(vector);
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return VLineGeom.Companion.getLEGEND_KEY_ELEMENT_FACTORY();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Aes<?>> getWontRender() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Aes[]{Aes.Companion.getY(), Aes.Companion.getXMIN(), Aes.Companion.getXMAX()};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Aes aes2 = (Aes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.afterRotation((Aes<Double>)p0));
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Aes<Double> xAes = this.afterRotation(Aes.Companion.getX());
        Aes<Double> yMinAes = this.afterRotation(Aes.Companion.getYMIN());
        Aes<Double> yMaxAes = this.afterRotation(Aes.Companion.getYMAX());
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        GeomHelper.SvgElementHelper helper2 = geomHelper.createSvgElementHelper();
        helper2.setStrokeAlphaEnabled(true);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.LINE_RANGE, ctx2);
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            Pair pair2;
            DoubleVector doubleVector = GeomUtil.INSTANCE.toLocation(p, xAes, yMinAes);
            if (doubleVector == null) continue;
            DoubleVector p0 = doubleVector;
            boolean bl = false;
            DoubleVector doubleVector2 = this.afterRotation(p0);
            doubleVector = doubleVector2;
            if (doubleVector2 == null) {
                continue;
            }
            DoubleVector start2 = doubleVector;
            DoubleVector doubleVector3 = GeomUtil.INSTANCE.toLocation(p, xAes, yMaxAes);
            if (doubleVector3 == null) continue;
            DoubleVector p02 = doubleVector3;
            boolean bl2 = false;
            DoubleVector doubleVector4 = this.afterRotation(p02);
            doubleVector3 = doubleVector4;
            if (doubleVector4 == null) {
                continue;
            }
            DoubleVector end = doubleVector3;
            if (GeomHelper.SvgElementHelper.createLine$default(helper2, start2, end, p, null, 8, null) == null) continue;
            boolean bl3 = false;
            SvgNode svgElement = (SvgNode)pair2.component1();
            root.add(svgElement);
        }
        Object[] objectArray = new Aes[]{yMinAes, yMaxAes};
        FlippableGeomHelper.buildHints$default(this.flipHelper, CollectionsKt.listOf((Object[])objectArray), aesthetics2, pos, coord, ctx2, this.clientRectByDataPoint(ctx2, geomHelper), buildIntern.2.INSTANCE, colorsByDataPoint, null, 256, null);
    }

    private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomContext ctx2, GeomHelper geomHelper) {
        return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(this, geomHelper, ctx2){
            final /* synthetic */ LineRangeGeom this$0;
            final /* synthetic */ GeomHelper $geomHelper;
            final /* synthetic */ GeomContext $ctx;
            {
                this.this$0 = $receiver;
                this.$geomHelper = $geomHelper;
                this.$ctx = $ctx;
                super(1, Intrinsics.Kotlin.class, "factory", "clientRectByDataPoint$factory(Lorg/jetbrains/letsPlot/core/plot/base/geom/LineRangeGeom;Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", 0);
            }

            @Nullable
            public final DoubleRectangle invoke(@NotNull DataPointAesthetics p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return LineRangeGeom.access$clientRectByDataPoint$factory(this.this$0, this.$geomHelper, this.$ctx, p0);
            }
        };
    }

    private static final DoubleRectangle clientRectByDataPoint$factory(LineRangeGeom this$0, GeomHelper $geomHelper, GeomContext $ctx, DataPointAesthetics p) {
        Aes<Double> xAes = this$0.afterRotation(Aes.Companion.getX());
        Aes<Double> yMinAes = this$0.afterRotation(Aes.Companion.getYMIN());
        Aes<Double> yMaxAes = this$0.afterRotation(Aes.Companion.getYMAX());
        Double d = p.finiteOrNull(xAes);
        if (d == null) {
            return null;
        }
        double x2 = d;
        Double d2 = p.finiteOrNull(yMinAes);
        if (d2 == null) {
            return null;
        }
        double ymin = d2;
        Double d3 = p.finiteOrNull(yMaxAes);
        if (d3 == null) {
            return null;
        }
        double ymax = d3;
        double height = ymax - ymin;
        DoubleRectangle doubleRectangle = $geomHelper.toClient(this$0.afterRotation(new DoubleRectangle(new DoubleVector(x2, ymax - height / 2.0), DoubleVector.Companion.getZERO())), p);
        Intrinsics.checkNotNull((Object)doubleRectangle);
        DoubleRectangle rect2 = doubleRectangle;
        double width2 = Math.max(AesScaling.INSTANCE.strokeWidth(p), 2.0);
        boolean needToFlip = this$0.isVertical ? $ctx.getFlipped() : !$ctx.getFlipped();
        return GeomUtil.INSTANCE.extendWidth$plot_base(rect2, width2, needToFlip);
    }

    public static final /* synthetic */ DoubleRectangle access$clientRectByDataPoint$factory(LineRangeGeom this$0, GeomHelper $geomHelper, GeomContext $ctx, DataPointAesthetics p) {
        return LineRangeGeom.clientRectByDataPoint$factory(this$0, $geomHelper, $ctx, p);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/LineRangeGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "MIN_TOOLTIP_RECTANGLE_WIDTH", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

