/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.transform;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.base.scale.BreaksGenerator;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleUtil;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.LinearBreaksGen;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.NonlinearBreaksGen;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.ContinuousTransformWithLimits;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.IdentityTransform;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.Log10Transform;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.Log2Transform;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.ReverseTransform;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.SqrtTransform;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.SymlogTransform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0016\u0010\u0013\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0018\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\""}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/Transforms;", "", "()V", "IDENTITY", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "getIDENTITY", "()Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "LOG10", "getLOG10", "LOG2", "getLOG2", "REVERSE", "getREVERSE", "SQRT", "getSQRT", "SYMLOG", "getSYMLOG", "continuousWithLimits", "actual", "limits", "Lkotlin/Pair;", "", "createBreaksGeneratorForTransformedDomain", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "transform", "providedFormatter", "Lkotlin/Function1;", "", "superscriptExponent", "", "ensureApplicableDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "dataRange", "BreaksGeneratorForTransformedDomain", "plot-base"})
public final class Transforms {
    @NotNull
    public static final Transforms INSTANCE = new Transforms();
    @NotNull
    private static final ContinuousTransform IDENTITY = new IdentityTransform();
    @NotNull
    private static final ContinuousTransform REVERSE = new ReverseTransform();
    @NotNull
    private static final ContinuousTransform SQRT = new SqrtTransform();
    @NotNull
    private static final ContinuousTransform LOG10 = new Log10Transform();
    @NotNull
    private static final ContinuousTransform LOG2 = new Log2Transform();
    @NotNull
    private static final ContinuousTransform SYMLOG = new SymlogTransform();

    private Transforms() {
    }

    @NotNull
    public final ContinuousTransform getIDENTITY() {
        return IDENTITY;
    }

    @NotNull
    public final ContinuousTransform getREVERSE() {
        return REVERSE;
    }

    @NotNull
    public final ContinuousTransform getSQRT() {
        return SQRT;
    }

    @NotNull
    public final ContinuousTransform getLOG10() {
        return LOG10;
    }

    @NotNull
    public final ContinuousTransform getLOG2() {
        return LOG2;
    }

    @NotNull
    public final ContinuousTransform getSYMLOG() {
        return SYMLOG;
    }

    @NotNull
    public final ContinuousTransform continuousWithLimits(@NotNull ContinuousTransform actual, @NotNull Pair<Double, Double> limits) {
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter(limits, (String)"limits");
        return new ContinuousTransformWithLimits(actual, (Double)limits.getFirst(), (Double)limits.getSecond());
    }

    @NotNull
    public final BreaksGenerator createBreaksGeneratorForTransformedDomain(@NotNull ContinuousTransform transform2, @Nullable Function1<Object, String> providedFormatter, boolean superscriptExponent) {
        BreaksGenerator breaksGenerator;
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        Transform transform3 = transform2.unwrap();
        if (Intrinsics.areEqual((Object)transform3, (Object)IDENTITY)) {
            breaksGenerator = new LinearBreaksGen(providedFormatter, superscriptExponent);
        } else if (Intrinsics.areEqual((Object)transform3, (Object)REVERSE)) {
            breaksGenerator = new LinearBreaksGen(providedFormatter, superscriptExponent);
        } else if (Intrinsics.areEqual((Object)transform3, (Object)SQRT)) {
            breaksGenerator = new NonlinearBreaksGen(SQRT, providedFormatter, superscriptExponent);
        } else if (Intrinsics.areEqual((Object)transform3, (Object)LOG10)) {
            breaksGenerator = new NonlinearBreaksGen(LOG10, providedFormatter, superscriptExponent);
        } else if (Intrinsics.areEqual((Object)transform3, (Object)LOG2)) {
            breaksGenerator = new NonlinearBreaksGen(LOG2, providedFormatter, superscriptExponent);
        } else if (Intrinsics.areEqual((Object)transform3, (Object)SYMLOG)) {
            breaksGenerator = new NonlinearBreaksGen(SYMLOG, providedFormatter, superscriptExponent);
        } else {
            throw new IllegalStateException("Unexpected 'transform' type: " + Reflection.getOrCreateKotlinClass(transform2.getClass()).getSimpleName());
        }
        BreaksGenerator breaksGenerator2 = breaksGenerator;
        return new BreaksGeneratorForTransformedDomain(transform2, breaksGenerator2);
    }

    public static /* synthetic */ BreaksGenerator createBreaksGeneratorForTransformedDomain$default(Transforms transforms, ContinuousTransform continuousTransform, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return transforms.createBreaksGeneratorForTransformedDomain(continuousTransform, (Function1<Object, String>)function1, bl);
    }

    @NotNull
    public final DoubleSpan ensureApplicableDomain(@Nullable DoubleSpan dataRange, @NotNull ContinuousTransform transform2) {
        DoubleSpan doubleSpan;
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        if (dataRange == null) {
            return ContinuousTransform.DefaultImpls.createApplicableDomain$default(transform2, null, 1, null);
        }
        DoubleSpan domain = transform2.toApplicableDomain(dataRange);
        boolean bl = SeriesUtil.INSTANCE.isBeyondPrecision(domain);
        if (bl) {
            doubleSpan = transform2.createApplicableDomain(domain.getUpperEnd());
        } else if (!bl) {
            doubleSpan = domain;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return doubleSpan;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J$\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/Transforms$BreaksGeneratorForTransformedDomain;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "breaksGenerator", "(Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;)V", "getBreaksGenerator", "()Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "defaultFormatter", "Lkotlin/Function1;", "", "", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "targetCount", "", "generateBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "plot-base"})
    public static final class BreaksGeneratorForTransformedDomain
    implements BreaksGenerator {
        @NotNull
        private final ContinuousTransform transform;
        @NotNull
        private final BreaksGenerator breaksGenerator;

        public BreaksGeneratorForTransformedDomain(@NotNull ContinuousTransform transform2, @NotNull BreaksGenerator breaksGenerator) {
            Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
            Intrinsics.checkNotNullParameter((Object)breaksGenerator, (String)"breaksGenerator");
            this.transform = transform2;
            this.breaksGenerator = breaksGenerator;
        }

        @NotNull
        public final BreaksGenerator getBreaksGenerator() {
            return this.breaksGenerator;
        }

        @Override
        @NotNull
        public Function1<Object, String> defaultFormatter(@NotNull DoubleSpan domain, int targetCount) {
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            DoubleSpan domainBeforeTransform = ScaleUtil.INSTANCE.applyInverseTransform(domain, this.transform);
            return this.breaksGenerator.defaultFormatter(domainBeforeTransform, targetCount);
        }

        @Override
        @NotNull
        public ScaleBreaks generateBreaks(@NotNull DoubleSpan domain, int targetCount) {
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            DoubleSpan domainBeforeTransform = ScaleUtil.INSTANCE.applyInverseTransform(domain, this.transform);
            ScaleBreaks breaksNoTransform = this.breaksGenerator.generateBreaks(domainBeforeTransform, targetCount);
            return breaksNoTransform.withTransform(this.transform);
        }
    }
}

