/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.config;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.spec.OptionsSelectorKt;
import org.jetbrains.letsPlot.core.spec.config.ConfigUtil;
import org.jetbrains.letsPlot.core.spec.config.CoordinatesCollector;
import org.jetbrains.letsPlot.core.spec.config.GeoConfig;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/GeoDataFrameProcessor;", "", "geomKind", "Lorg/jetbrains/letsPlot/core/plot/base/GeomKind;", "data", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "layerOptions", "", "mappingOptions", "(Lorg/jetbrains/letsPlot/core/plot/base/GeomKind;Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;Ljava/util/Map;Ljava/util/Map;)V", "dataAndCoordinates", "getDataAndCoordinates", "()Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "mappings", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "getMappings", "()Ljava/util/Map;", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nGeoConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeoConfig.kt\norg/jetbrains/letsPlot/core/spec/config/GeoDataFrameProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,398:1\n1#2:399\n*E\n"})
public final class GeoDataFrameProcessor {
    @NotNull
    private final DataFrame dataAndCoordinates;
    @NotNull
    private final Map<Aes<?>, DataFrame.Variable> mappings;

    public GeoDataFrameProcessor(@NotNull GeomKind geomKind, @NotNull DataFrame data, @NotNull Map<?, ?> layerOptions, @NotNull Map<?, ?> mappingOptions) {
        CoordinatesCollector coordinatesCollector;
        Intrinsics.checkNotNullParameter((Object)((Object)geomKind), (String)"geomKind");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(layerOptions, (String)"layerOptions");
        Intrinsics.checkNotNullParameter(mappingOptions, (String)"mappingOptions");
        DataFrame dataFrame = null;
        DataFrame.Variable geometries = null;
        String[] $this$_init__u24lambda_u240 = layerOptions;
        boolean bl = false;
        String[] stringArray = new String[]{"map_data_meta", "geodataframe", "geometry"};
        boolean bl2 = OptionsSelectorKt.has($this$_init__u24lambda_u240, stringArray) && !OptionsSelectorKt.has($this$_init__u24lambda_u240, stringArray = new String[]{"map_join"}) && !data.isEmpty() && !mappingOptions.isEmpty();
        if (bl2) {
            throw new IllegalStateException("map_join is required when both data and map parameters used".toString());
        }
        String[] $this$_init__u24lambda_u241 = layerOptions;
        boolean bl3 = false;
        stringArray = new String[]{"map_data_meta", "geodataframe", "geometry"};
        boolean bl4 = OptionsSelectorKt.has($this$_init__u24lambda_u241, stringArray) && OptionsSelectorKt.has($this$_init__u24lambda_u241, stringArray = new String[]{"map_join"});
        if (bl4) {
            $this$_init__u24lambda_u241 = new String[]{"map"};
            if (!OptionsSelectorKt.has(layerOptions, $this$_init__u24lambda_u241)) {
                boolean $i$a$-require-GeoDataFrameProcessor$42 = false;
                String $i$a$-require-GeoDataFrameProcessor$42 = "'map' parameter is mandatory with MAP_DATA_META";
                throw new IllegalArgumentException($i$a$-require-GeoDataFrameProcessor$42.toString());
            }
            stringArray = new String[]{"map_join"};
            List<?> list2 = OptionsSelectorKt.getList(layerOptions, stringArray);
            if (list2 == null) {
                throw new IllegalStateException("require map_join parameter".toString());
            }
            List<?> mapJoin = list2;
            Object obj = mapJoin.get(0);
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            List list3 = (List)obj;
            DataFrame dataFrame2 = GeoDataFrameProcessor._init_$getGeoDataFrame(layerOptions, "map");
            Object obj2 = mapJoin.get(1);
            Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            dataFrame = ConfigUtil.INSTANCE.join(data, list3, dataFrame2, (List)obj2);
            geometries = DataFrameUtil.INSTANCE.findVariableOrFail(dataFrame, GeoConfig.Companion.getGeometryColumn((Map<?, ?>)layerOptions, "map"));
        } else {
            String[] $this$_init__u24lambda_u243 = layerOptions;
            boolean bl5 = false;
            stringArray = new String[]{"map_data_meta", "geodataframe", "geometry"};
            boolean bl6 = OptionsSelectorKt.has($this$_init__u24lambda_u243, stringArray) && !OptionsSelectorKt.has($this$_init__u24lambda_u243, stringArray = new String[]{"map_join"});
            if (bl6) {
                $this$_init__u24lambda_u243 = new String[]{"map"};
                if (!OptionsSelectorKt.has(layerOptions, $this$_init__u24lambda_u243)) {
                    boolean $i$a$-require-GeoDataFrameProcessor$62 = false;
                    String $i$a$-require-GeoDataFrameProcessor$62 = "'map' parameter is mandatory with MAP_DATA_META";
                    throw new IllegalArgumentException($i$a$-require-GeoDataFrameProcessor$62.toString());
                }
                dataFrame = GeoDataFrameProcessor._init_$getGeoDataFrame(layerOptions, "map");
                geometries = DataFrameUtil.INSTANCE.findVariableOrFail(dataFrame, GeoConfig.Companion.getGeometryColumn((Map<?, ?>)layerOptions, "map"));
            } else {
                String[] $this$_init__u24lambda_u245 = layerOptions;
                boolean bl7 = false;
                stringArray = new String[]{"data_meta", "geodataframe", "geometry"};
                boolean bl8 = OptionsSelectorKt.has($this$_init__u24lambda_u245, stringArray) && !OptionsSelectorKt.has($this$_init__u24lambda_u245, stringArray = new String[]{"map"}) && !OptionsSelectorKt.has($this$_init__u24lambda_u245, stringArray = new String[]{"map_join"});
                if (bl8) {
                    $this$_init__u24lambda_u245 = new String[]{"data"};
                    if (!OptionsSelectorKt.has(layerOptions, $this$_init__u24lambda_u245)) {
                        boolean bl9 = false;
                        String string = "'data' parameter is mandatory with DATA_META";
                        throw new IllegalArgumentException(string.toString());
                    }
                    dataFrame = data;
                    geometries = DataFrameUtil.INSTANCE.findVariableOrFail(dataFrame, GeoConfig.Companion.getGeometryColumn((Map<?, ?>)layerOptions, "data"));
                } else {
                    throw new IllegalStateException("GeoDataFrame not found in data or map".toString());
                }
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[geomKind.ordinal()]) {
            case 1: 
            case 2: {
                coordinatesCollector = new CoordinatesCollector.BoundaryCoordinatesCollector(dataFrame, geometries);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                coordinatesCollector = new CoordinatesCollector.PointCoordinatesCollector(dataFrame, geometries);
                break;
            }
            case 8: {
                coordinatesCollector = new CoordinatesCollector.BboxCoordinatesCollector(dataFrame, geometries);
                break;
            }
            case 9: {
                coordinatesCollector = new CoordinatesCollector.PathCoordinatesCollector(dataFrame, geometries);
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported geom: " + (Object)((Object)geomKind)).toString());
            }
        }
        CoordinatesCollector coordinatesCollector2 = coordinatesCollector;
        this.dataAndCoordinates = coordinatesCollector2.buildDataFrame();
        this.mappings = ConfigUtil.INSTANCE.createAesMapping$plot_stem(this.dataAndCoordinates, MapsKt.plus(mappingOptions, coordinatesCollector2.getMappings()));
    }

    @NotNull
    public final DataFrame getDataAndCoordinates() {
        return this.dataAndCoordinates;
    }

    @NotNull
    public final Map<Aes<?>, DataFrame.Variable> getMappings() {
        return this.mappings;
    }

    private static final DataFrame _init_$getGeoDataFrame(Map<?, ?> $layerOptions, String gdfLocation) {
        Map<String, Object> map2;
        String[] stringArray;
        String string = gdfLocation;
        if (Intrinsics.areEqual((Object)string, (Object)"map")) {
            stringArray = new String[]{"map"};
            map2 = OptionsSelectorKt.getMap($layerOptions, stringArray);
            if (map2 == null) {
                throw new IllegalStateException("require 'map' parameter".toString());
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)"data")) {
            stringArray = new String[]{"data"};
            map2 = OptionsSelectorKt.getMap($layerOptions, stringArray);
            if (map2 == null) {
                throw new IllegalStateException("require 'data' parameter".toString());
            }
        } else {
            throw new IllegalStateException(("Unknown gdf location: " + gdfLocation).toString());
        }
        Map<String, Object> geoDataFrame = map2;
        return DataFrameUtil.INSTANCE.fromMap(geoDataFrame);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GeomKind.values().length];
            try {
                nArray[GeomKind.MAP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.POLYGON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.LIVE_MAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.POINT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.TEXT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.LABEL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.PIE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.RECT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.PATH.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

