/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge.svg12;

import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.SVGBridgeExtension;
import org.jetbrains.relocated.apache.batik.bridge.svg12.BindableElementBridge;
import org.jetbrains.relocated.apache.batik.bridge.svg12.SVG12TextElementBridge;
import org.jetbrains.relocated.apache.batik.bridge.svg12.SVGFlowRootElementBridge;
import org.jetbrains.relocated.apache.batik.bridge.svg12.SVGMultiImageElementBridge;
import org.jetbrains.relocated.apache.batik.bridge.svg12.SVGSolidColorElementBridge;
import org.jetbrains.relocated.apache.batik.bridge.svg12.XBLContentElementBridge;
import org.jetbrains.relocated.apache.batik.bridge.svg12.XBLShadowTreeElementBridge;
import org.w3c.dom.Element;

public class SVG12BridgeExtension
extends SVGBridgeExtension {
    @Override
    public float getPriority() {
        return 0.0f;
    }

    @Override
    public Iterator getImplementedExtensions() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public String getAuthor() {
        return "The Apache Batik Team.";
    }

    @Override
    public String getContactAddress() {
        return "batik-dev@xmlgraphics.apache.org";
    }

    @Override
    public String getURL() {
        return "http://xml.apache.org/batik";
    }

    @Override
    public String getDescription() {
        return "The required SVG 1.2 tags";
    }

    @Override
    public void registerTags(BridgeContext ctx2) {
        super.registerTags(ctx2);
        ctx2.putBridge(new SVGFlowRootElementBridge());
        ctx2.putBridge(new SVGMultiImageElementBridge());
        ctx2.putBridge(new SVGSolidColorElementBridge());
        ctx2.putBridge(new SVG12TextElementBridge());
        ctx2.putBridge(new XBLShadowTreeElementBridge());
        ctx2.putBridge(new XBLContentElementBridge());
        ctx2.setDefaultBridge(new BindableElementBridge());
        ctx2.putReservedNamespaceURI(null);
        ctx2.putReservedNamespaceURI("http://www.w3.org/2000/svg");
        ctx2.putReservedNamespaceURI("http://www.w3.org/2004/xbl");
    }

    @Override
    public boolean isDynamicElement(Element e) {
        String ns = e.getNamespaceURI();
        if ("http://www.w3.org/2004/xbl".equals(ns)) {
            return true;
        }
        if (!"http://www.w3.org/2000/svg".equals(ns)) {
            return false;
        }
        String ln = e.getLocalName();
        return ln.equals("script") || ln.equals("handler") || ln.startsWith("animate") || ln.equals("set");
    }
}

