/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.expression.editor;

import com.intellij.lang.injection.general.Injection;
import com.intellij.lang.injection.general.LanguageInjectionContributor;
import com.intellij.psi.PsiElement;
import com.intellij.vcs.github.ultimate.expression.editor.GithubExpressionInjection;
import com.intellij.vcs.github.ultimate.expression.editor.GithubExpressionLanguageInjectionContributorKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.extensions.GithubYamlFileDetectionKt;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/github/ultimate/expression/editor/GithubExpressionLanguageInjectionContributor;", "Lcom/intellij/lang/injection/general/LanguageInjectionContributor;", "<init>", "()V", "getInjection", "Lcom/intellij/lang/injection/general/Injection;", "context", "Lcom/intellij/psi/PsiElement;", "isSuitableElementType", "", "hasGithubLanguageMarkers", "intellij.vcs.github.ultimate"})
public final class GithubExpressionLanguageInjectionContributor
implements LanguageInjectionContributor {
    @Nullable
    public Injection getInjection(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.isSuitableElementType(context)) {
            return null;
        }
        return (Injection)GithubExpressionInjection.INSTANCE;
    }

    private final boolean isSuitableElementType(PsiElement context) {
        return context instanceof YAMLScalar && GithubYamlFileDetectionKt.isGithubActionsFile(((YAMLScalar)context).getContainingFile().getOriginalFile()) && this.hasGithubLanguageMarkers(context);
    }

    private final boolean hasGithubLanguageMarkers(PsiElement context) {
        Regex regex = GithubExpressionLanguageInjectionContributorKt.getInjectedGithubExpressionLanguageSegmentPattern();
        String string = context.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return regex.containsMatchIn((CharSequence)string) || GithubExpressionLanguageInjectionContributorKt.shouldInjectIntoEntireElementRange(context);
    }
}

