/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.settingsSync.core.SettingsSnapshot;
import com.intellij.settingsSync.core.SettingsSyncBundle;
import com.intellij.settingsSync.core.SettingsSyncEvents;
import com.intellij.settingsSync.core.SettingsSyncStatusTracker;
import com.intellij.settingsSync.core.SyncSettingsEvent;
import com.intellij.settingsSync.core.UpdateResult;
import com.intellij.settingsSync.core.communicator.RemoteCommunicatorHolder;
import com.intellij.settingsSync.core.statistics.SettingsSyncEventsStatistics;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncUpdateChecker;", "", "<init>", "()V", "scheduleUpdateFromServer", "Lcom/intellij/settingsSync/core/UpdateResult;", "Companion", "intellij.settingsSync.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSettingsSyncUpdateChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncUpdateChecker.kt\ncom/intellij/settingsSync/core/SettingsSyncUpdateChecker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,46:1\n14#2:47\n*S KotlinDebug\n*F\n+ 1 SettingsSyncUpdateChecker.kt\ncom/intellij/settingsSync/core/SettingsSyncUpdateChecker\n*L\n13#1:47\n*E\n"})
public final class SettingsSyncUpdateChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @RequiresBackgroundThread
    @NotNull
    public final UpdateResult scheduleUpdateFromServer() {
        Object object = RemoteCommunicatorHolder.INSTANCE.getRemoteCommunicator();
        if (object == null || (object = object.receiveUpdates()) == null) {
            SettingsSyncUpdateChecker $this$scheduleUpdateFromServer_u24lambda_u240 = this;
            boolean bl = false;
            String errorMsg = "Cannot get update from server - no communicator provider";
            LOG.info(errorMsg);
            return new UpdateResult.Error(errorMsg);
        }
        Object updateResult = object;
        Object object2 = updateResult;
        if (object2 instanceof UpdateResult.Success) {
            SettingsSnapshot snapshot = ((UpdateResult.Success)updateResult).getSettingsSnapshot();
            SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(new SyncSettingsEvent.CloudChange(snapshot, ((UpdateResult.Success)updateResult).getServerVersionId(), null, 4, null));
        } else if (object2 instanceof UpdateResult.FileDeletedFromServer) {
            SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(SyncSettingsEvent.DeletedOnCloud.INSTANCE);
            SettingsSyncEventsStatistics.INSTANCE.getDISABLED_AUTOMATICALLY().log((Object)SettingsSyncEventsStatistics.AutomaticDisableReason.REMOVED_FROM_SERVER);
        } else if (object2 instanceof UpdateResult.NoFileOnServer) {
            LOG.info("Settings update requested, but there was no file on the server.");
        } else if (object2 instanceof UpdateResult.Error) {
            LOG.warn("Settings update requested, but failed with error: " + ((UpdateResult.Error)updateResult).getMessage());
            SettingsSyncStatusTracker.Companion.getInstance().updateOnError(SettingsSyncBundle.INSTANCE.message("notification.title.update.error", new Object[0]) + ": " + ((UpdateResult.Error)updateResult).getMessage());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return updateResult;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncUpdateChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncUpdateChecker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

