/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webpack;

import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigEvaluationContext;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigExecutor;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.webpack.WebpackConfigLocator;
import com.intellij.webpack.WebpackConfigManagerKt;
import com.intellij.webpack.WebpackConfiguration;
import java.util.Arrays;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@State(name="WebPackConfiguration")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/intellij/webpack/WebpackConfigManager;", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "configuration", "Lcom/intellij/webpack/WebpackConfiguration;", "getConfiguration", "()Lcom/intellij/webpack/WebpackConfiguration;", "bundlerId", "", "getBundlerId", "()Ljava/lang/String;", "computeConfigEvaluationContext", "Ljava/util/Optional;", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigEvaluationContext;", "element", "Lcom/intellij/psi/PsiElement;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "preferGlobalConfig", "", "findConfigFile", "from", "overrideWorkingDir", "config", "Companion", "intellij.webpack"})
@SourceDebugExtension(value={"SMAP\nWebpackConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebpackConfigManager.kt\ncom/intellij/webpack/WebpackConfigManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class WebpackConfigManager
extends WebBundlerConfigManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebpackConfiguration configuration;
    @NotNull
    private final String bundlerId;

    public WebpackConfigManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.configuration = new WebpackConfiguration(null, null, 2, null);
        this.bundlerId = "Webpack";
    }

    @NotNull
    protected WebpackConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public String getBundlerId() {
        return this.bundlerId;
    }

    @NotNull
    protected Optional<WebBundlerConfigEvaluationContext> computeConfigEvaluationContext(@NotNull PsiElement element, @NotNull VirtualFile directory, boolean preferGlobalConfig) {
        WebBundlerConfigEvaluationContext webBundlerConfigEvaluationContext;
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        VirtualFile usedConfig = this.findConfigFile(element, directory, preferGlobalConfig);
        String workingDir = this.overrideWorkingDir(usedConfig, directory);
        VirtualFile it = virtualFile2 = usedConfig;
        boolean bl = false;
        Object object = virtualFile = WebpackConfigLocator.Companion.isAcceptableForWebpackConfig(it) ? virtualFile2 : null;
        if (virtualFile != null) {
            it = virtualFile;
            boolean bl2 = false;
            webBundlerConfigEvaluationContext = new WebBundlerConfigEvaluationContext(it, workingDir, this.getBundlerId());
        } else {
            webBundlerConfigEvaluationContext = null;
        }
        WebBundlerConfigEvaluationContext context = webBundlerConfigEvaluationContext;
        Optional<Object> optional = Optional.ofNullable(context);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    private final VirtualFile findConfigFile(PsiElement element, VirtualFile from, boolean preferGlobalConfig) {
        if (preferGlobalConfig) {
            VirtualFile virtualFile;
            String string;
            String it = string = this.getGlobalConfigPath();
            boolean bl = false;
            String string2 = ((CharSequence)it).length() > 0 ? string : null;
            if (string2 != null) {
                it = string2;
                boolean bl2 = false;
                virtualFile = this.findFile(it);
            } else {
                virtualFile = null;
            }
            return virtualFile;
        }
        VirtualFile virtualFile = (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)WebpackConfigManagerKt.access$getEP_NAME$p().lazySequence(), arg_0 -> WebpackConfigManager.findConfigFile$lambda$4(this, element, arg_0)));
        if (virtualFile == null) {
            String[] stringArray = WebpackConfigLocator.Companion.getWEBPACK_NAMES_ARRAY$intellij_webpack();
            virtualFile = JSProjectUtil.findFileUpToContentRoot((Project)this.getProject(), (VirtualFile)from, (String[])Arrays.copyOf(stringArray, stringArray.length));
        }
        return virtualFile;
    }

    private final String overrideWorkingDir(VirtualFile config, VirtualFile from) {
        if (config != null && JSLibraryUtil.hasDirectoryInPath((VirtualFile)config, (String)"node_modules", null)) {
            VirtualFile modulePackageJson = WebBundlerConfigExecutor.Companion.findPackageJson(from);
            VirtualFile virtualFile = modulePackageJson;
            return virtualFile != null && (virtualFile = virtualFile.getParent()) != null ? virtualFile.getPath() : null;
        }
        return null;
    }

    private static final VirtualFile findConfigFile$lambda$4(WebpackConfigManager this$0, PsiElement $element, WebpackConfigLocator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.detectConfig(this$0.getProject(), $element);
    }

    @JvmStatic
    @NotNull
    public static final WebpackConfigManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/webpack/WebpackConfigManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/webpack/WebpackConfigManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.webpack"})
    @SourceDebugExtension(value={"SMAP\nWebpackConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebpackConfigManager.kt\ncom/intellij/webpack/WebpackConfigManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,58:1\n31#2,2:59\n*S KotlinDebug\n*F\n+ 1 WebpackConfigManager.kt\ncom/intellij/webpack/WebpackConfigManager$Companion\n*L\n54#1:59,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final WebpackConfigManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<WebpackConfigManager> serviceClass$iv = WebpackConfigManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (WebpackConfigManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

