/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;

public final class YAMLUnusedAnchorInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            YAMLUnusedAnchorInspection.$$$reportNull$$$0(0);
        }
        return new YamlPsiElementVisitor(){

            public void visitAnchor(@NotNull YAMLAnchor anchor) {
                Collection references;
                if (anchor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((references = ReferencesSearch.search((PsiElement)anchor, (SearchScope)GlobalSearchScope.fileScope((PsiFile)anchor.getContainingFile())).findAll()).isEmpty()) {
                    holder.registerProblem((PsiElement)anchor, YAMLBundle.message((String)"inspections.unused.anchor.message", (Object[])new Object[]{anchor.getName()}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveAnchorQuickFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "org/jetbrains/yaml/inspections/YAMLUnusedAnchorInspection$1", "visitAnchor"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/yaml/inspections/YAMLUnusedAnchorInspection", "buildVisitor"));
    }

    private static class RemoveAnchorQuickFix
    implements LocalQuickFix {
        private RemoveAnchorQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = YAMLBundle.message((String)"inspections.unused.anchor.quickfix.name", (Object[])new Object[0]);
            if (string == null) {
                RemoveAnchorQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            YAMLAnchor anchor;
            if (project == null) {
                RemoveAnchorQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveAnchorQuickFix.$$$reportNull$$$0(2);
            }
            if ((anchor = (YAMLAnchor)descriptor.getPsiElement()) == null) {
                return;
            }
            PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> {
                ASTNode node = TreeUtil.prevLeaf((ASTNode)anchor.getNode());
                while (YAMLElementTypes.SPACE_ELEMENTS.contains(PsiUtilCore.getElementType((ASTNode)node))) {
                    ASTNode prev = TreeUtil.prevLeaf((ASTNode)node);
                    ASTNode parent = node.getTreeParent();
                    if (parent != null) {
                        CodeEditUtil.removeChild((ASTNode)parent, (ASTNode)node);
                    }
                    node = prev;
                }
                anchor.delete();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/yaml/inspections/YAMLUnusedAnchorInspection$RemoveAnchorQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/yaml/inspections/YAMLUnusedAnchorInspection$RemoveAnchorQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

