/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react.refactoring;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSArrowFunctionBracesCanBeRemovedInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.react.ReactBundle;
import com.intellij.react.ReactFilterProvider;
import com.intellij.react.ReactPropTypesUtil;
import com.intellij.react.refactoring.ReactFunctionToClassComponentHandler;
import com.intellij.react.refactoring.extractComponent.ReactExtractComponentHandlerBase;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactClassToFunctionComponentHandler
implements RefactoringActionHandler {
    private static final String DEFAULT_COMPONENT_NAME = "Component";
    private static final String DUMB_COMPONENT_SUFFIX = "Component";
    private static final String DEFAULT_DUMB_COMPONENT_NAME = "WrappedComponent";

    public boolean isAvailable(@NotNull JSClass componentClass) {
        if (componentClass == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(0);
        }
        if (ReactFilterProvider.isAcceptableClassComponent(componentClass) != ThreeState.YES) {
            return false;
        }
        if (JSRefactoringUtil.isAbstract((PsiElement)componentClass, (JSAttributeListOwner)componentClass)) {
            return false;
        }
        if (JSClassSearch.searchClassInheritors((JSClass)componentClass, (boolean)false).findFirst() != null) {
            return false;
        }
        for (JSElement member : componentClass.getMembers()) {
            JSContext context;
            if (!(member instanceof JSElementBase) || (context = ((JSElementBase)member).getJSContext()) == JSContext.STATIC && member instanceof JSField) continue;
            if (member instanceof JSFunction && ((JSFunction)member).isConstructor()) {
                if (ReactClassToFunctionComponentHandler.isTrivialConstructor((JSFunction)member)) continue;
                return false;
            }
            if (StringUtil.equals((CharSequence)member.getName(), (CharSequence)"render") && !ReactClassToFunctionComponentHandler.referencesState(member)) continue;
            return false;
        }
        return true;
    }

    private static ES6Decorator @NotNull [] getSpecifiedDecorators(@NotNull PsiElement element) {
        if (element == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(1);
        }
        if (!(element instanceof JSAttributeListOwner)) {
            if (ES6Decorator.EMPTY_ARRAY == null) {
                ReactClassToFunctionComponentHandler.$$$reportNull$$$0(2);
            }
            return ES6Decorator.EMPTY_ARRAY;
        }
        JSAttributeListOwner attributeListOwner = (JSAttributeListOwner)element;
        JSAttributeList list = attributeListOwner.getAttributeList();
        if (list != null) {
            ES6Decorator[] eS6DecoratorArray = list.getDecorators();
            if (eS6DecoratorArray == null) {
                ReactClassToFunctionComponentHandler.$$$reportNull$$$0(3);
            }
            return eS6DecoratorArray;
        }
        if (ES6Decorator.EMPTY_ARRAY == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(4);
        }
        return ES6Decorator.EMPTY_ARRAY;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(6);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(7);
        }
        this.invoke(project, editor, file);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        JSClass clazz;
        if (project == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(9);
        }
        if (file == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(10);
        }
        if ((clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), JSClass.class, (boolean)false)) == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)ReactBundle.message("react.class.to.function.caret.at.class", new Object[0]));
            ReactClassToFunctionComponentHandler.showErrorHint(project, editor, message);
            return;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)clazz, (Editor)editor, (String)ReactClassToFunctionComponentHandler.getRefactoringTitle())) {
            return;
        }
        String introducedName = clazz.getName();
        List<JSField> staticFields = ReactClassToFunctionComponentHandler.getStaticFields((PsiElement)clazz);
        if (StringUtil.isEmpty((String)introducedName)) {
            if (staticFields.size() > 0) {
                introducedName = ReactClassToFunctionComponentHandler.showNameDialog(project, (JSNamedElement)clazz);
                if (StringUtil.isEmpty((String)introducedName)) {
                    return;
                }
            } else {
                introducedName = "Component";
            }
        }
        ArrayList typeUsages = new ArrayList();
        MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> {
            SearchScope useScope = clazz.getUseScope();
            String elementDescription = StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)clazz, (boolean)false));
            ReferencesSearch.search((PsiElement)clazz, (SearchScope)useScope).forEach(psiReference -> {
                PsiElement refElement = psiReference.getElement();
                if (refElement instanceof JSReferenceExpression && refElement.getParent() instanceof TypeScriptSingleType) {
                    typeUsages.add((TypeScriptSingleType)refElement.getParent());
                } else if (refElement instanceof JSXmlLiteralExpression && ((JSXmlLiteralExpression)refElement).getAttribute("ref") != null) {
                    conflicts.putValue((Object)refElement, (Object)ReactBundle.message("refactoring.react.class.to.function.conflict.used.with.ref", elementDescription));
                }
            });
        }), JavaScriptBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), true, project)) {
            return;
        }
        if (!BaseRefactoringProcessor.processConflicts((Project)project, (MultiMap)conflicts)) {
            return;
        }
        String finalIntroducedName = introducedName;
        WriteCommandAction.runWriteCommandAction((Project)project, (String)ReactClassToFunctionComponentHandler.getRefactoringTitle(), null, () -> this.doRefactoringInWriteAction(finalIntroducedName, clazz, editor, staticFields, typeUsages), (PsiFile[])new PsiFile[0]);
    }

    @Nullable
    protected PsiElement doRefactoringInWriteAction(@NotNull String introducedName, @NotNull JSClass componentClass, @NotNull Editor editor, @NotNull List<JSField> staticFields, @NotNull List<TypeScriptSingleType> typeUsages) {
        JSStatement replacementPsi;
        boolean hasSfcTypeDeclaration;
        JSParameterList createdFunctionParameterList;
        String codeTemplateName;
        JSNamedElement createdNamedElement;
        JSField defaultPropsField;
        if (introducedName == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(11);
        }
        if (componentClass == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(13);
        }
        if (staticFields == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(14);
        }
        if (typeUsages == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(15);
        }
        boolean isTypedDialect = DialectDetector.hasFeature((PsiElement)componentClass, (JSLanguageFeature)JSLanguageFeature.TYPES);
        boolean hasDecorators = ReactClassToFunctionComponentHandler.getSpecifiedDecorators((PsiElement)componentClass).length != 0;
        boolean hasStaticFields = !staticFields.isEmpty();
        String dumbComponentName = ReactClassToFunctionComponentHandler.getDumbComponentName(introducedName, hasDecorators, hasStaticFields);
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)componentClass.getProject());
        Properties properties = fileTemplateManager.getDefaultProperties();
        if (!StringUtil.isEmpty((String)dumbComponentName)) {
            properties.setProperty("NAME", dumbComponentName);
        }
        JSField propTypesField = ReactClassToFunctionComponentHandler.findByName(staticFields, "propTypes");
        if (!isTypedDialect && propTypesField != null && propTypesField.getInitializer() != null) {
            properties.setProperty("PROP_TYPES", propTypesField.getInitializer().getText());
        }
        if ((defaultPropsField = ReactClassToFunctionComponentHandler.findByName(staticFields, "defaultProps")) != null && defaultPropsField.getInitializer() != null) {
            properties.setProperty("DEFAULT_PROPS", defaultPropsField.getInitializer().getText());
        }
        PsiFile createdFile = (createdNamedElement = ReactExtractComponentHandlerBase.expandTemplate((PsiElement)componentClass, properties, codeTemplateName = ReactExtractComponentHandlerBase.getCodeTemplateName(ReactExtractComponentHandlerBase.ComponentType.Function, isTypedDialect), JSNamedElement.class)) != null ? createdNamedElement.getContainingFile() : null;
        JSFunction createdFunction = JSPsiImplUtils.getPossibleFunction((PsiElement)createdNamedElement);
        JSElement createdFunctionBody = (JSElement)ObjectUtils.coalesce((Object)ReactFunctionToClassComponentHandler.findFunctionBlockBody(createdFunction), (Object)JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)createdFunction));
        JSParameterList jSParameterList = createdFunctionParameterList = createdFunction != null ? createdFunction.getParameterList() : null;
        if (createdFunctionBody == null || createdFunctionParameterList == null) {
            String message = ReactBundle.message("refactoring.react.could.not.find.in.template", introducedName, codeTemplateName);
            ReactClassToFunctionComponentHandler.showErrorHint(componentClass.getProject(), editor, message);
            return null;
        }
        JSFunction renderMethod = componentClass.findFunctionByNameAndKind("render", JSFunction.FunctionKind.SIMPLE);
        JSBlockStatement renderMethodBody = ReactFunctionToClassComponentHandler.findFunctionBlockBody(renderMethod);
        JSExpression renderReturnExpression = JSArrowFunctionBracesCanBeRemovedInspection.getSingleExpression((JSBlockStatement)renderMethodBody);
        String typedDialectPropsType = ReactClassToFunctionComponentHandler.getPropsTypeFromClassGenericArgument(componentClass);
        String propsParameterName = ReactClassToFunctionComponentHandler.getParameterName(createdFunctionParameterList, 0, "props");
        String contextParameterName = ReactClassToFunctionComponentHandler.getParameterName(createdFunctionParameterList, 1, "context");
        TypeScriptSingleType createdSfcTypeDeclaration = ReactFunctionToClassComponentHandler.getSFCTypeDeclaration(createdNamedElement);
        if (createdNamedElement instanceof JSAttributeListOwner && !hasDecorators) {
            ReactFunctionToClassComponentHandler.copyExportStatus((JSNamedElement)componentClass, (JSAttributeListOwner)createdNamedElement);
        }
        ReactFunctionToClassComponentHandler.copyReturnType((JSNamedElement)renderMethod, (JSNamedElement)createdFunction);
        boolean bl = hasSfcTypeDeclaration = createdSfcTypeDeclaration != null;
        if (hasSfcTypeDeclaration && !StringUtil.isEmpty((String)typedDialectPropsType)) {
            String genericSfcText = createdSfcTypeDeclaration.getQualifiedTypeName() + "<" + typedDialectPropsType + ">";
            createdSfcTypeDeclaration.replace((PsiElement)JSPsiElementFactory.createTypeScriptType((String)genericSfcText, (PsiElement)createdSfcTypeDeclaration));
        }
        Ref hasProps = new Ref((Object)Boolean.FALSE);
        Ref hasContext = new Ref((Object)Boolean.FALSE);
        if (createdFunctionBody instanceof JSExpression && renderReturnExpression != null) {
            replacementText = ReactClassToFunctionComponentHandler.processRenderMethod((JSElement)renderReturnExpression, propsParameterName, contextParameterName, (Ref<Boolean>)hasProps, (Ref<Boolean>)hasContext);
            replacementPsi = JSPsiElementFactory.createJSExpression((String)((String)ObjectUtils.coalesce((Object)replacementText, (Object)"null")), (PsiElement)componentClass);
        } else {
            replacementText = ReactClassToFunctionComponentHandler.processRenderMethod((JSElement)renderMethodBody, propsParameterName, contextParameterName, (Ref<Boolean>)hasProps, (Ref<Boolean>)hasContext);
            replacementPsi = JSPsiElementFactory.createJSStatement((String)((String)ObjectUtils.coalesce((Object)replacementText, (Object)"{}")), (PsiElement)componentClass, JSBlockStatement.class);
        }
        createdFunctionBody.replace((PsiElement)replacementPsi);
        createdFunctionParameterList.replace((PsiElement)ReactClassToFunctionComponentHandler.createParameterList(hasProps.get() == Boolean.TRUE ? propsParameterName : null, !hasSfcTypeDeclaration ? typedDialectPropsType : null, hasContext.get() == Boolean.TRUE ? contextParameterName : null, (PsiElement)createdFunction));
        ReactClassToFunctionComponentHandler.copyStaticFields(dumbComponentName, createdFile, ContainerUtil.filter(staticFields, field -> field != defaultPropsField && field != propTypesField));
        JSNamedElement expressionOrDeclarationStatement = createdNamedElement;
        if (hasDecorators) {
            expressionOrDeclarationStatement = ReactClassToFunctionComponentHandler.processDecorators(componentClass, createdFile, createdNamedElement, !staticFields.isEmpty(), introducedName);
        }
        PsiElement resultElement = ReactClassToFunctionComponentHandler.expressionAwareReplace((JSNamedElement)componentClass, createdFile, (JSElement)expressionOrDeclarationStatement, introducedName);
        ReactClassToFunctionComponentHandler.moveCaretToElement(editor, resultElement);
        FormatFixer.create((PsiElement)resultElement, (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
        ES6CreateImportUtil.optimizeImports((PsiElement)resultElement);
        for (TypeScriptSingleType typeUsage : typeUsages) {
            typeUsage.replace((PsiElement)JSChangeUtil.createTypeScriptType((String)("typeof " + typeUsage.getText()), (PsiElement)typeUsage));
        }
        return resultElement;
    }

    @NotNull
    private static String getDumbComponentName(@NotNull String introducedName, boolean hasDecorators, boolean hasStaticFields) {
        if (introducedName == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(16);
        }
        Object name = introducedName;
        if (hasDecorators && hasStaticFields) {
            name = introducedName.endsWith("Component") ? StringUtil.trimEnd((String)introducedName, (String)"Component") : introducedName + "Component";
        }
        if (StringUtil.isEmpty((String)name)) {
            name = DEFAULT_DUMB_COMPONENT_NAME;
        }
        String string = name;
        if (string == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static void copyStaticFields(@NotNull String introducedName, @NotNull PsiFile createdFile, @NotNull List<JSField> fields) {
        if (introducedName == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(18);
        }
        if (createdFile == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(19);
        }
        if (fields == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(20);
        }
        for (JSField field : fields) {
            JSExpression initializer = field.getInitializer();
            if (initializer == null) continue;
            SyntaxTraverser.psiTraverser((PsiElement)initializer).filter(JSThisExpression.class).forEach(thisExpr -> thisExpr.replace(JSPsiElementFactory.createJSExpression((String)introducedName, (PsiElement)initializer)));
            PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)field);
            JSStatement statement = JSPsiElementFactory.createJSStatement((String)(introducedName + "." + field.getName() + "=" + initializer.getText()), (PsiElement)field);
            statement = (JSStatement)createdFile.add((PsiElement)statement);
            JSDocumentationUtils.moveJSDoc((PsiComment)docComment, (PsiElement)statement);
        }
    }

    @Nullable
    private static JSField findByName(@NotNull List<JSField> staticFields, @NotNull String property) {
        if (staticFields == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(21);
        }
        if (property == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(22);
        }
        return (JSField)ContainerUtil.find(staticFields, field -> StringUtil.equals((CharSequence)field.getName(), (CharSequence)property));
    }

    @NotNull
    public static PsiElement expressionAwareReplace(@NotNull JSNamedElement toReplace, @NotNull PsiFile createdFile, @NotNull JSElement createdDeclaration, @Nullable String introducedName) {
        if (toReplace == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(23);
        }
        if (createdFile == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(24);
        }
        if (createdDeclaration == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(25);
        }
        boolean templateHasMultipleTopLevelEntities = ReactClassToFunctionComponentHandler.getFileLevelEntitiesCount(createdFile) > 1;
        boolean hasDecorators = ReactClassToFunctionComponentHandler.getSpecifiedDecorators((PsiElement)toReplace).length != 0;
        boolean hasStaticFields = !ReactClassToFunctionComponentHandler.getStaticFields((PsiElement)toReplace).isEmpty();
        boolean declarationCanBeConvertedToExpression = createdDeclaration instanceof JSExpression || createdDeclaration instanceof JSFunctionDeclaration || createdDeclaration instanceof JSClass;
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)toReplace);
        if (toReplace instanceof JSExpression) {
            JSSourceElement sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)toReplace, JSSourceElement.class);
            assert (sourceElement != null);
            if (declarationCanBeConvertedToExpression) {
                if (!(!(toReplace.getParent() instanceof ES6ExportDefaultAssignment) || hasDecorators && hasStaticFields)) {
                    PsiElement result = toReplace.replace((PsiElement)ReactClassToFunctionComponentHandler.convertToExpression(createdDeclaration));
                    if (templateHasMultipleTopLevelEntities) {
                        createdDeclaration.delete();
                        JSChangeUtil.doAddRangeAfter((PsiElement)sourceElement.getParent(), (PsiElement)createdFile.getFirstChild(), (PsiElement)createdFile.getLastChild(), (PsiElement)sourceElement);
                    }
                    PsiElement psiElement = result;
                    if (psiElement == null) {
                        ReactClassToFunctionComponentHandler.$$$reportNull$$$0(26);
                    }
                    return psiElement;
                }
                if (!templateHasMultipleTopLevelEntities) {
                    JSExpression expression = ReactClassToFunctionComponentHandler.convertToExpression(createdDeclaration);
                    PsiElement result = toReplace.replace((PsiElement)expression);
                    JSDocumentationUtils.moveJSDoc((PsiComment)docComment, (PsiElement)result);
                    PsiElement psiElement = result;
                    if (psiElement == null) {
                        ReactClassToFunctionComponentHandler.$$$reportNull$$$0(27);
                    }
                    return psiElement;
                }
            }
            JSElement jsDocTarget = createdDeclaration instanceof JSVariable ? createdDeclaration.getParent() : createdDeclaration;
            JSDocumentationUtils.moveJSDoc((PsiComment)docComment, (PsiElement)jsDocTarget);
            JSChangeUtil.doAddRangeBefore((PsiElement)sourceElement.getParent(), (PsiElement)createdFile.getFirstChild(), (PsiElement)createdFile.getLastChild(), (PsiElement)sourceElement);
            PsiElement psiElement = toReplace.replace((PsiElement)(createdDeclaration instanceof JSNamedElement ? ReactClassToFunctionComponentHandler.createReferenceTo(introducedName, (PsiElement)createdDeclaration) : createdDeclaration));
            if (psiElement == null) {
                ReactClassToFunctionComponentHandler.$$$reportNull$$$0(28);
            }
            return psiElement;
        }
        return ReactClassToFunctionComponentHandler.replaceSourceElement((PsiElement)toReplace, createdDeclaration, createdFile, docComment);
    }

    @NotNull
    private static JSElement processDecorators(@NotNull JSClass componentClass, @NotNull PsiFile createdFile, @NotNull JSNamedElement createdDeclaration, boolean hasStaticMembers, @NotNull String introducedName) {
        PsiElement statementAnchor;
        if (componentClass == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(29);
        }
        if (createdFile == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(30);
        }
        if (createdDeclaration == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(31);
        }
        if (introducedName == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(32);
        }
        boolean isInStatement = (statementAnchor = JSUtils.findStatementAnchor((PsiElement)componentClass)) != null;
        ES6Decorator[] decorators = ReactClassToFunctionComponentHandler.getSpecifiedDecorators((PsiElement)componentClass);
        StringBuilder builder = new StringBuilder();
        for (ES6Decorator decorator : decorators) {
            builder.append(StringUtil.trimStart((String)decorator.getText(), (String)"@"));
            builder.append("(");
        }
        String decoratedExpressionText = hasStaticMembers ? createdDeclaration.getName() : (createdDeclaration instanceof JSVariable ? Objects.requireNonNull(((JSVariable)createdDeclaration).getInitializer()).getText() : createdDeclaration.getText());
        builder.append(decoratedExpressionText);
        builder.append(StringUtil.repeat((String)")", (int)decorators.length));
        String expressionText = builder.toString();
        if (isInStatement && !hasStaticMembers) {
            JSExpression newDeclaration = JSUtils.unparenthesize((JSExpression)JSPsiElementFactory.createJSExpression((String)expressionText, (PsiElement)componentClass));
            JSElement jSElement = (JSElement)Objects.requireNonNull(newDeclaration);
            if (jSElement == null) {
                ReactClassToFunctionComponentHandler.$$$reportNull$$$0(33);
            }
            return jSElement;
        }
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)componentClass);
        String declarationText = String.format("%s%s %s = %s%s", componentClass.isExported() ? "export " : "", DialectDetector.hasFeature((PsiElement)componentClass, (JSLanguageFeature)JSLanguageFeature.LET_DEFINITIONS) ? "const" : "var", introducedName, expressionText, semicolon);
        JSStatement newDeclaration = JSPsiElementFactory.createJSStatement((String)declarationText, (PsiElement)componentClass);
        if (!hasStaticMembers) {
            createdDeclaration.delete();
            JSStatement jSStatement = newDeclaration;
            if (jSStatement == null) {
                ReactClassToFunctionComponentHandler.$$$reportNull$$$0(34);
            }
            return jSStatement;
        }
        createdFile.add((PsiElement)newDeclaration);
        JSNamedElement jSNamedElement = createdDeclaration;
        if (jSNamedElement == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(35);
        }
        return jSNamedElement;
    }

    private static int getFileLevelEntitiesCount(@NotNull PsiFile createdFile) {
        if (createdFile == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(36);
        }
        return (int)Arrays.stream(createdFile.getChildren()).filter(JSChangeUtil::isSourceElementOrComment).count();
    }

    public static void moveCaretToElement(@NotNull Editor editor, @NotNull PsiElement element) {
        if (editor == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(37);
        }
        if (element == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(38);
        }
        editor.getCaretModel().moveToOffset(element.getTextOffset());
    }

    @NotNull
    private static JSExpression convertToExpression(@NotNull JSElement element) {
        if (element == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(39);
        }
        if (element instanceof JSExpression) {
            JSExpression jSExpression = (JSExpression)element;
            if (jSExpression == null) {
                ReactClassToFunctionComponentHandler.$$$reportNull$$$0(40);
            }
            return jSExpression;
        }
        assert (element instanceof JSFunctionDeclaration || element instanceof JSClass);
        JSExpression jSExpression = JSPsiElementFactory.createJSExpression((String)element.getText(), (PsiElement)element, JSExpression.class);
        if (jSExpression == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(41);
        }
        return jSExpression;
    }

    private static JSReferenceExpression createReferenceTo(@Nullable String name, @NotNull PsiElement context) {
        if (context == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(42);
        }
        assert (name != null);
        return (JSReferenceExpression)JSPsiElementFactory.createJSExpression((String)name, (PsiElement)context, JSReferenceExpression.class);
    }

    @NotNull
    private static PsiElement replaceSourceElement(@NotNull PsiElement toReplace, @NotNull JSElement createdDeclaration, @NotNull PsiFile createdFile, @Nullable PsiComment docComment) {
        if (toReplace == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(43);
        }
        if (createdDeclaration == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(44);
        }
        if (createdFile == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(45);
        }
        JSSourceElement sourceElementToReplace = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)toReplace, JSSourceElement.class, (boolean)false);
        JSSourceElement createdSourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)createdDeclaration, JSSourceElement.class, (boolean)false);
        assert (sourceElementToReplace != null && createdSourceElement != null);
        PsiElement resultDeclaration = sourceElementToReplace.replace((PsiElement)createdSourceElement);
        PsiElement jsDocTarget = resultDeclaration instanceof JSVariable ? resultDeclaration.getParent() : resultDeclaration;
        JSDocumentationUtils.moveJSDoc((PsiComment)docComment, (PsiElement)jsDocTarget);
        createdDeclaration.delete();
        if (ReactClassToFunctionComponentHandler.getFileLevelEntitiesCount(createdFile) > 0) {
            JSChangeUtil.doAddRangeAfter((PsiElement)resultDeclaration.getParent(), (PsiElement)createdFile.getFirstChild(), (PsiElement)createdFile.getLastChild(), (PsiElement)resultDeclaration);
        }
        Object object = resultDeclaration instanceof JSVarStatement ? ((JSVarStatement)resultDeclaration).getVariables()[0] : resultDeclaration;
        if (object == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(46);
        }
        return object;
    }

    @NotNull
    private static List<JSField> getStaticFields(@NotNull PsiElement element) {
        if (element == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(47);
        }
        if (!(element instanceof JSClass)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ReactClassToFunctionComponentHandler.$$$reportNull$$$0(48);
            }
            return list;
        }
        List<JSField> list = Arrays.stream(((JSClass)element).getFields()).filter(field -> field.getJSContext() == JSContext.STATIC).sorted(Comparator.comparingInt(PsiElement::getTextOffset)).collect(Collectors.toList());
        if (list == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(49);
        }
        return list;
    }

    @Nullable
    private static String getPropsTypeFromClassGenericArgument(@NotNull JSClass clazz) {
        JSTypeDeclaration genericArgument;
        if (clazz == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(50);
        }
        return (genericArgument = ReactPropTypesUtil.getClassComponentGenericDeclaration(clazz, false)) != null ? genericArgument.getText() : null;
    }

    @NotNull
    private static JSParameterList createParameterList(@Nullable String propsParameterName, @Nullable String propsTypeText, @Nullable String contextParameterName, @NotNull PsiElement context) {
        if (context == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(51);
        }
        StringBuilder text = new StringBuilder("(");
        if (!StringUtil.isEmpty((String)propsParameterName)) {
            text.append(propsParameterName);
            if (!StringUtil.isEmpty((String)propsTypeText)) {
                text.append(": ").append(propsTypeText);
            }
        }
        if (!StringUtil.isEmpty((String)contextParameterName)) {
            text.append(", ").append(contextParameterName);
        }
        text.append(")");
        JSFunction function = (JSFunction)JSPsiElementFactory.createJSSourceElement((String)("function dummy" + text + "{}"), (PsiElement)context, JSFunction.class);
        JSParameterList jSParameterList = Objects.requireNonNull(function.getParameterList());
        if (jSParameterList == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(52);
        }
        return jSParameterList;
    }

    @Nullable
    private static String processRenderMethod(@Nullable JSElement toProcess, @NotNull String propsParameterName, @NotNull String contextParameterName, @NotNull Ref<Boolean> hasProps, @NotNull Ref<Boolean> hasContext) {
        if (propsParameterName == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(53);
        }
        if (contextParameterName == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(54);
        }
        if (hasProps == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(55);
        }
        if (hasContext == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(56);
        }
        if (toProcess == null) {
            return null;
        }
        HashMap referencesToReplace = new HashMap();
        ReactClassToFunctionComponentHandler.processThisReferences(toProcess, (Processor<? super JSReferenceExpression>)((Processor)element -> {
            if (StringUtil.equals((CharSequence)element.getReferenceName(), (CharSequence)"props")) {
                referencesToReplace.put(element, propsParameterName);
                hasProps.set((Object)Boolean.TRUE);
            } else if (StringUtil.equals((CharSequence)element.getReferenceName(), (CharSequence)"context")) {
                referencesToReplace.put(element, contextParameterName);
                hasContext.set((Object)Boolean.TRUE);
            }
            return true;
        }));
        return ReactExtractComponentHandlerBase.replaceOccurrences(toProcess, toProcess.getTextRange(), referencesToReplace);
    }

    private static boolean referencesState(@NotNull JSElement member) {
        if (member == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(57);
        }
        return !ReactClassToFunctionComponentHandler.processThisReferences(member, (Processor<? super JSReferenceExpression>)((Processor)referenceExpression -> !StringUtil.equals((CharSequence)referenceExpression.getReferenceName(), (CharSequence)"state") && !StringUtil.equals((CharSequence)referenceExpression.getReferenceName(), (CharSequence)"setState")));
    }

    private static boolean processThisReferences(@NotNull JSElement member, @NotNull Processor<? super JSReferenceExpression> processor) {
        if (member == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(58);
        }
        if (processor == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(59);
        }
        return PsiTreeUtil.processElements((PsiElement)member, element -> {
            JSReferenceExpression referenceExpression;
            return !(element instanceof JSReferenceExpression) || !((referenceExpression = (JSReferenceExpression)element).getQualifier() instanceof JSThisExpression) || processor.process((Object)referenceExpression);
        });
    }

    @NotNull
    private static String getParameterName(@NotNull JSParameterList createdFunctionParameters, int index, String defaultName) {
        String name;
        JSParameterListElement[] parameters;
        if (createdFunctionParameters == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(60);
        }
        if ((parameters = createdFunctionParameters.getParameters()).length > index && !StringUtil.isEmpty((String)(name = parameters[index].getName()))) {
            String string = name;
            if (string == null) {
                ReactClassToFunctionComponentHandler.$$$reportNull$$$0(61);
            }
            return string;
        }
        String string = defaultName;
        if (string == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(62);
        }
        return string;
    }

    private static boolean isTrivialConstructor(@NotNull JSFunction member) {
        JSBlockStatement block;
        if (member == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(63);
        }
        if ((block = member.getBlock()) == null) {
            return true;
        }
        for (JSSourceElement item : block.getStatementListItems()) {
            if (item instanceof JSFunction || JSRefactoringUtil.isSuperCall((JSSourceElement)item) || ReactClassToFunctionComponentHandler.isStateAssignment(item)) continue;
            return false;
        }
        return true;
    }

    private static boolean isStateAssignment(@NotNull JSSourceElement item) {
        if (item == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(64);
        }
        if (!(item instanceof JSExpressionStatement)) {
            return false;
        }
        JSExpression expression = ((JSExpressionStatement)item).getExpression();
        if (!(expression instanceof JSAssignmentExpression)) {
            return false;
        }
        JSDefinitionExpression definitionExpression = ((JSAssignmentExpression)expression).getDefinitionExpression();
        return definitionExpression != null && StringUtil.equals((CharSequence)definitionExpression.getName(), (CharSequence)"state");
    }

    @Nullable
    public static String showNameDialog(@NotNull Project project, @NotNull JSNamedElement elementForName) {
        if (project == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(65);
        }
        if (elementForName == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(66);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return "Component";
        }
        PsiElement scope = (PsiElement)ObjectUtils.coalesce((Object)JSUseScopeProvider.getUseScopeElement((JSNamedElement)elementForName), (Object)elementForName.getContainingFile());
        InputValidatorEx nameValidator = ReactExtractComponentHandlerBase.createNameValidator(scope);
        return Messages.showInputDialog((Project)project, (String)ReactBundle.message("refactoring.react.class.to.function.dialog.message", new Object[0]), (String)ReactClassToFunctionComponentHandler.getRefactoringTitle(), (Icon)Messages.getQuestionIcon(), null, (InputValidator)nameValidator);
    }

    private static void showErrorHint(@NotNull Project project, @NotNull Editor editor, @NlsContexts.DialogMessage @NotNull String message) {
        if (project == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(67);
        }
        if (editor == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(68);
        }
        if (message == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(69);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)ReactClassToFunctionComponentHandler.getRefactoringTitle(), null);
    }

    @NlsContexts.DialogTitle
    @NotNull
    public static String getRefactoringTitle() {
        String string = ReactBundle.message("refactoring.react.class.to.function.refactoring.title", new Object[0]);
        if (string == null) {
            ReactClassToFunctionComponentHandler.$$$reportNull$$$0(70);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 17, 26, 27, 28, 33, 34, 35, 40, 41, 46, 48, 49, 52, 61, 62, 70 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentClass";
                break;
            }
            case 1: 
            case 38: 
            case 39: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 61: 
            case 62: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/react/refactoring/ReactClassToFunctionComponentHandler";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 9: 
            case 13: 
            case 37: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 16: 
            case 18: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introducedName";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticFields";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeUsages";
                break;
            }
            case 19: 
            case 24: 
            case 30: 
            case 36: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdFile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 23: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
            case 25: 
            case 31: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdDeclaration";
                break;
            }
            case 42: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propsParameterName";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextParameterName";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasProps";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasContext";
                break;
            }
            case 57: 
            case 58: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdFunctionParameters";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementForName";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/react/refactoring/ReactClassToFunctionComponentHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecifiedDecorators";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDumbComponentName";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "expressionAwareReplace";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "processDecorators";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToExpression";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSourceElement";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticFields";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterList";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterName";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSpecifiedDecorators";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 61: 
            case 62: 
            case 70: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoringInWriteAction";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDumbComponentName";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyStaticFields";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "expressionAwareReplace";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processDecorators";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getFileLevelEntitiesCount";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToElement";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "convertToExpression";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceTo";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "replaceSourceElement";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getStaticFields";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromClassGenericArgument";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createParameterList";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "processRenderMethod";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "referencesState";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "processThisReferences";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getParameterName";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isTrivialConstructor";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isStateAssignment";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "showNameDialog";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 17, 26, 27, 28, 33, 34, 35, 40, 41, 46, 48, 49, 52, 61, 62, 70 -> new IllegalStateException(string);
        };
    }
}

