/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadService;
import com.intellij.indexing.shared.download.SharedIndexLookup;
import com.intellij.indexing.shared.download.SharedIndexSuggester;
import com.intellij.indexing.shared.download.SharedIndexSuggestion;
import com.intellij.indexing.shared.download.SharedIndexSuggestionKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexSuggestionService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "resolveSuggestions", "", "Lcom/intellij/indexing/shared/download/SharedIndexSuggestion;", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexSuggestion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexSuggestion.kt\ncom/intellij/indexing/shared/download/SharedIndexSuggestionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,109:1\n1454#2,5:110\n1454#2,5:115\n1485#2:120\n1510#2,3:121\n1513#2,3:131\n1246#2,4:136\n381#3,7:124\n462#3:134\n412#3:135\n*S KotlinDebug\n*F\n+ 1 SharedIndexSuggestion.kt\ncom/intellij/indexing/shared/download/SharedIndexSuggestionService\n*L\n91#1:110,5\n94#1:115,5\n100#1:120\n100#1:121,3\n100#1:131,3\n101#1:136,4\n100#1:124,7\n101#1:134\n101#1:135\n*E\n"})
public final class SharedIndexSuggestionService {
    @NotNull
    private final Project project;

    public SharedIndexSuggestionService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        SharedIndexSuggestionKt.getSharedIndexSuggesterEP().addExtensionPointListener(coroutineScope, (ExtensionPointListener)new ExtensionPointListener<SharedIndexSuggester>(){

            public void extensionAdded(SharedIndexSuggester extension, PluginDescriptor pluginDescriptor) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    boolean $i$f$serviceIfCreated = false;
                    Application application = ApplicationManager.getApplication();
                    SharedIndexDownloadService sharedIndexDownloadService = (SharedIndexDownloadService)(application != null ? application.getServiceIfCreated(SharedIndexDownloadService.class) : null);
                    if (sharedIndexDownloadService == null) break block0;
                    sharedIndexDownloadService.rescanNow(project);
                }
            }

            public void extensionRemoved(SharedIndexSuggester extension, PluginDescriptor pluginDescriptor) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    boolean $i$f$serviceIfCreated = false;
                    Application application = ApplicationManager.getApplication();
                    SharedIndexLookup sharedIndexLookup = (SharedIndexLookup)(application != null ? application.getServiceIfCreated(SharedIndexLookup.class) : null);
                    if (sharedIndexLookup == null) break block0;
                    sharedIndexLookup.invalidateCaches();
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SharedIndexSuggestion> resolveSuggestions() {
        void $this$mapValuesTo$iv$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$flatMapTo$iv;
        List suggestions = new ArrayList();
        Iterable $this$flatMapTo$iv2 = SharedIndexSuggestionKt.getSharedIndexSuggesterEP().getExtensionList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            SharedIndexSuggester it = (SharedIndexSuggester)element$iv;
            boolean bl = false;
            Iterable list$iv = it.suggestRequests(this.project);
            CollectionsKt.addAll((Collection)suggestions, (Iterable)list$iv);
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexEx");
        for (IndexableFilesIterator provider : ((FileBasedIndexEx)fileBasedIndex).getIndexableFilesProviders(this.project)) {
            $this$flatMapTo$iv = SharedIndexSuggestionKt.getSharedIndexSuggesterEP().getExtensionList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                SharedIndexSuggester it = (SharedIndexSuggester)element$iv;
                boolean bl = false;
                IndexableSetOrigin indexableSetOrigin = provider.getOrigin();
                Intrinsics.checkNotNullExpressionValue((Object)indexableSetOrigin, (String)"getOrigin(...)");
                Iterable list$iv = it.suggestRequests(indexableSetOrigin);
                CollectionsKt.addAll((Collection)suggestions, (Iterable)list$iv);
            }
        }
        Iterable $this$groupBy$iv = suggestions;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator element$iv = $this$groupByTo$iv$iv.iterator();
        while (element$iv.hasNext()) {
            Object object;
            Object element$iv$iv = element$iv.next();
            SharedIndexSuggestion it = (SharedIndexSuggestion)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getSharedIndexId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl3 = false;
            if (((List)it.getValue()).size() > 1 && SharedIndexDownloadLoggerKt.getDownloadLogger().isDebugEnabled()) {
                SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Several extensions reported the same kind/id for shared index. Only one will be used from: " + it.getValue());
            }
            SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)CollectionsKt.last((List)((List)it.getValue()));
            map2.put(k, sharedIndexSuggestion);
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.values());
    }
}

