/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.api.SharedIndexStats;
import com.intellij.indexing.shared.platform.api.SharedIndexStorage;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SingleChunkReadonlyZipStorage;", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStorage;", "chunkId", "", "storagePath", "Ljava/nio/file/Path;", "storageId", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/lang/String;)V", "getChunkId", "()Ljava/lang/String;", "getStorageId", "readSystem", "Lcom/intellij/indexing/shared/util/zipFs/UncompressedZipFileSystem;", "Lorg/jetbrains/annotations/NotNull;", "chunkRoot", "getChunkRoot", "()Ljava/nio/file/Path;", "metadata", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "getSharedIndexStats", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStats;", "isCompatibleChunk", "", "close", "", "toString", "intellij.indexing.shared"})
public class SingleChunkReadonlyZipStorage
implements SharedIndexStorage {
    @NotNull
    private final String chunkId;
    @NotNull
    private final Path storagePath;
    @NotNull
    private final String storageId;
    @NotNull
    private final UncompressedZipFileSystem readSystem;
    @Nullable
    private final SharedIndexMetadata metadata;

    public SingleChunkReadonlyZipStorage(@NotNull String chunkId, @NotNull Path storagePath, @NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Intrinsics.checkNotNullParameter((Object)storagePath, (String)"storagePath");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        this.chunkId = chunkId;
        this.storagePath = storagePath;
        this.storageId = storageId;
        UncompressedZipFileSystem uncompressedZipFileSystem = UncompressedZipFileSystem.create(this.storagePath, true);
        Intrinsics.checkNotNullExpressionValue((Object)uncompressedZipFileSystem, (String)"create(...)");
        this.readSystem = uncompressedZipFileSystem;
        this.metadata = SharedIndexMetadata.Companion.readSharedIndexMetadata(this.getChunkRoot());
    }

    @NotNull
    public final String getChunkId() {
        return this.chunkId;
    }

    @Override
    @NotNull
    public String getStorageId() {
        return this.storageId;
    }

    private final Path getChunkRoot() {
        Path path = this.readSystem.getRootDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getRootDirectory(...)");
        return path;
    }

    @Override
    @NotNull
    public SharedIndexStats getSharedIndexStats() {
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists((Path)this.storagePath);
        return new SharedIndexStats(basicFileAttributes != null ? basicFileAttributes.size() : 0L, 1);
    }

    @Override
    public boolean isCompatibleChunk(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        return Intrinsics.areEqual((Object)chunkId, (Object)this.chunkId) && this.metadata != null && SharedIndexInfrastructureVersion.getIdeVersion().isSuitableMetadata(this.metadata);
    }

    @Override
    @Nullable
    public Path getChunkRoot(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        return Intrinsics.areEqual((Object)chunkId, (Object)this.chunkId) ? this.getChunkRoot() : null;
    }

    @Override
    public void close() {
        this.readSystem.close();
    }

    @NotNull
    public String toString() {
        return "SingleChunkReadonlyZipStorage(chunkId='" + this.chunkId + "', storagePath=" + this.storagePath + ")";
    }
}

