/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.codeInsight.template;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.Processor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.codeInsight.template.VueTemplateScope;
import org.jetbrains.vuejs.codeInsight.template.VueTemplateScopesProvider;
import org.jetbrains.vuejs.lang.expr.VueExprLanguagesKt;
import org.jetbrains.vuejs.lang.html.VueLanguage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/vuejs/codeInsight/template/VueTemplateScopesResolver;", "", "<init>", "()V", "resolve", "", "element", "Lcom/intellij/psi/PsiElement;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/ResolveResult;", "checkLanguage", "", "intellij.vuejs"})
public final class VueTemplateScopesResolver {
    @NotNull
    public static final VueTemplateScopesResolver INSTANCE = new VueTemplateScopesResolver();

    private VueTemplateScopesResolver() {
    }

    public final void resolve(@NotNull PsiElement element, @NotNull Processor<? super ResolveResult> processor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        PsiElement psiElement = CompletionUtil.getOriginalOrSelf((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getOriginalOrSelf(...)");
        PsiElement original = psiElement;
        if (!this.checkLanguage(original)) {
            return;
        }
        boolean expressionIsInjected = VueExprLanguagesKt.isVueExprMetaLanguage(original.getContainingFile().getLanguage());
        PsiElement hostElement = null;
        if (expressionIsInjected) {
            hostElement = (PsiElement)InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element);
            if (hostElement == null) {
                return;
            }
        } else {
            hostElement = null;
        }
        StreamEx.of((Collection)VueTemplateScopesProvider.Companion.getEP_NAME$intellij_vuejs().getExtensionList()).flatCollection(arg_0 -> VueTemplateScopesResolver.resolve$lambda$1(arg_0 -> VueTemplateScopesResolver.resolve$lambda$0(element, hostElement, arg_0), arg_0)).findFirst(arg_0 -> VueTemplateScopesResolver.resolve$lambda$3(arg_0 -> VueTemplateScopesResolver.resolve$lambda$2(processor, arg_0), arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkLanguage(PsiElement element) {
        Language it = element.getLanguage();
        boolean bl = false;
        if (VueExprLanguagesKt.isVueExprMetaLanguage(it)) return true;
        if (Intrinsics.areEqual((Object)it, (Object)((Object)VueLanguage.Companion.getINSTANCE()))) return true;
        if (it.isKindOf((Language)CSSLanguage.INSTANCE)) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        PsiElement psiElement = element.getParent();
        it = psiElement != null ? psiElement.getLanguage() : null;
        boolean bl3 = false;
        if (VueExprLanguagesKt.isVueExprMetaLanguage(it)) return true;
        if (!Intrinsics.areEqual((Object)it, (Object)((Object)VueLanguage.Companion.getINSTANCE()))) return false;
        return true;
    }

    private static final Collection resolve$lambda$0(PsiElement $element, PsiElement $hostElement, VueTemplateScopesProvider provider) {
        return provider.getScopes($element, $hostElement);
    }

    private static final Collection resolve$lambda$1(Function1 $tmp0, Object p0) {
        return (Collection)$tmp0.invoke(p0);
    }

    private static final boolean resolve$lambda$2(Processor $processor, VueTemplateScope s) {
        return !s.processAllScopesInHierarchy((Processor<? super ResolveResult>)$processor);
    }

    private static final boolean resolve$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

