/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.RemoteJdbcServer;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public final class JdbcClassLoader {
    private static final ClassLoader ourLoader = JdbcClassLoader.createJdbcClassLoader();
    private static final Class<?> mainClass = RemoteJdbcServer.class;

    public static ClassLoader getInstance() {
        return ourLoader;
    }

    @NotNull
    private static ClassLoader createJdbcClassLoader() {
        String cp = System.getProperty("jdbc.classpath");
        ClassLoader appLoader = Thread.currentThread().getContextClassLoader();
        if (cp == null || cp.isEmpty()) {
            ClassLoader classLoader = appLoader;
            if (classLoader == null) {
                JdbcClassLoader.$$$reportNull$$$0(0);
            }
            return classLoader;
        }
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        ClassLoader platformOrExt = systemLoader.getParent();
        if (platformOrExt == null) {
            JdbcNativeUtil.logInfo("Failed to isolate classpath. No parent for " + systemLoader);
            ClassLoader classLoader = appLoader;
            if (classLoader == null) {
                JdbcClassLoader.$$$reportNull$$$0(1);
            }
            return classLoader;
        }
        JdbcNativeUtil.logInfo("Using classpath: " + cp + "\n\tand base loader " + platformOrExt);
        try {
            return new JdbcClassLoaderImpl(platformOrExt, appLoader, JdbcClassLoader.parseClassPath(cp));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load classpath from file", e);
        }
    }

    private static URL @NotNull [] parseClassPath(@NotNull String cp) throws IOException {
        if (cp == null) {
            JdbcClassLoader.$$$reportNull$$$0(2);
        }
        if (cp.endsWith(".classpath.txt")) {
            String cpString = FileUtilRt.loadFile((File)new File(cp), (String)StandardCharsets.UTF_8.name());
            JdbcNativeUtil.logInfo("Loaded classpath: " + cpString);
            return JdbcClassLoader.parseClassPathString(cpString);
        }
        return JdbcClassLoader.parseClassPathString(cp);
    }

    private static URL @NotNull [] parseClassPathString(String cp) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            StringTokenizer tok = new StringTokenizer(cp, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String path = tok.nextToken();
                urls.add(new File(path).toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to parse JDBC classpath", e);
        }
        URL[] uRLArray = urls.toArray(new URL[0]);
        if (uRLArray == null) {
            JdbcClassLoader.$$$reportNull$$$0(3);
        }
        return uRLArray;
    }

    public static ClassLoader createAppAndJdbcClassLoader() {
        return new ClassLoader(){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                return JdbcClassLoader.getInstance().loadClass(name);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/impl/JdbcClassLoader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createJdbcClassLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/impl/JdbcClassLoader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseClassPathString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseClassPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JdbcClassLoaderImpl
    extends URLClassLoader {
        private final ClassLoader myAppLoader;

        private JdbcClassLoaderImpl(ClassLoader cleanClassLoader, ClassLoader appLoader, URL @NotNull [] urls) {
            if (urls == null) {
                JdbcClassLoaderImpl.$$$reportNull$$$0(0);
            }
            super(urls, cleanClassLoader);
            this.myAppLoader = appLoader;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (JdbcClassLoaderImpl.shareWithJdbc(name)) {
                return this.myAppLoader.loadClass(name);
            }
            return super.findClass(name);
        }

        private static boolean shareWithJdbc(String name) {
            if (mainClass.getName().equals(name)) {
                return true;
            }
            return name.startsWith("com.intellij.execution.rmi.ssl.") || name.startsWith("com.intellij.database.remote.jdbc.helpers.RemoteLogHelper");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/database/remote/jdbc/impl/JdbcClassLoader$JdbcClassLoaderImpl", "<init>"));
        }
    }
}

