/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.psi.base;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.language.psi.EditorConfigOption;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.language.psi.interfaces.EditorConfigDescribableElement;
import org.editorconfig.language.psi.reference.EditorConfigConstantReference;
import org.editorconfig.language.psi.reference.EditorConfigDeclarationReference;
import org.editorconfig.language.psi.reference.EditorConfigIdentifierReference;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigConstantDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigDeclarationDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigReferenceDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigUnionDescriptor;
import org.editorconfig.language.util.EditorConfigDescriptorUtil;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0013R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/editorconfig/language/psi/base/EditorConfigDescribableElementBase;", "Lcom/intellij/extapi/psi/ASTWrapperPsiElement;", "Lorg/editorconfig/language/psi/interfaces/EditorConfigDescribableElement;", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "option", "Lorg/editorconfig/language/psi/EditorConfigOption;", "getOption", "()Lorg/editorconfig/language/psi/EditorConfigOption;", "section", "Lorg/editorconfig/language/psi/EditorConfigSection;", "getSection", "()Lorg/editorconfig/language/psi/EditorConfigSection;", "describableParent", "getDescribableParent", "()Lorg/editorconfig/language/psi/interfaces/EditorConfigDescribableElement;", "declarationSite", "", "getDeclarationSite", "()Ljava/lang/String;", "getReference", "Lcom/intellij/psi/PsiReference;", "toString", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigDescribableElementBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigDescribableElementBase.kt\norg/editorconfig/language/psi/base/EditorConfigDescribableElementBase\n+ 2 EditorConfigPsiTreeUtil.kt\norg/editorconfig/language/util/EditorConfigPsiTreeUtil\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,60:1\n23#2,2:61\n23#2,2:63\n14#3:65\n*S KotlinDebug\n*F\n+ 1 EditorConfigDescribableElementBase.kt\norg/editorconfig/language/psi/base/EditorConfigDescribableElementBase\n*L\n23#1:61,2\n26#1:63,2\n50#1:65\n*E\n"})
public abstract class EditorConfigDescribableElementBase
extends ASTWrapperPsiElement
implements EditorConfigDescribableElement {
    public EditorConfigDescribableElementBase(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    @Override
    @NotNull
    public final EditorConfigOption getOption() {
        EditorConfigPsiTreeUtil editorConfigPsiTreeUtil = EditorConfigPsiTreeUtil.INSTANCE;
        Class[] stopAt$iv = new Class[]{};
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        EditorConfigOption editorConfigOption = (EditorConfigOption)PsiTreeUtil.getParentOfType((PsiElement)this, EditorConfigOption.class, (boolean)strict$iv, (Class[])Arrays.copyOf(stopAt$iv, stopAt$iv.length));
        if (editorConfigOption == null) {
            throw new IllegalStateException();
        }
        return editorConfigOption;
    }

    @Override
    @NotNull
    public final EditorConfigSection getSection() {
        EditorConfigPsiTreeUtil editorConfigPsiTreeUtil = EditorConfigPsiTreeUtil.INSTANCE;
        Class[] stopAt$iv = new Class[]{};
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        EditorConfigSection editorConfigSection = (EditorConfigSection)PsiTreeUtil.getParentOfType((PsiElement)this, EditorConfigSection.class, (boolean)strict$iv, (Class[])Arrays.copyOf(stopAt$iv, stopAt$iv.length));
        if (editorConfigSection == null) {
            throw new IllegalStateException();
        }
        return editorConfigSection;
    }

    @Override
    @Nullable
    public EditorConfigDescribableElement getDescribableParent() {
        PsiElement psiElement = this.getParent();
        return psiElement instanceof EditorConfigDescribableElement ? (EditorConfigDescribableElement)psiElement : null;
    }

    @Override
    @NotNull
    public String getDeclarationSite() {
        String header = this.getSection().getHeader().getText();
        VirtualFile virtualFile = this.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            Intrinsics.checkNotNull((Object)header);
            return header;
        }
        VirtualFile virtualFile2 = virtualFile;
        String string = virtualFile2.getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
        String fileName = string;
        return header + " (" + fileName + ")";
    }

    @Nullable
    public PsiReference getReference() {
        PsiReference psiReference;
        EditorConfigDescriptor descriptor = this.getDescriptor(false);
        if (descriptor instanceof EditorConfigDeclarationDescriptor) {
            psiReference = (PsiReference)new EditorConfigDeclarationReference(this);
        } else if (descriptor instanceof EditorConfigReferenceDescriptor) {
            psiReference = (PsiReference)new EditorConfigIdentifierReference(this, ((EditorConfigReferenceDescriptor)descriptor).getId());
        } else if (descriptor instanceof EditorConfigConstantDescriptor) {
            psiReference = (PsiReference)new EditorConfigConstantReference(this);
        } else if (descriptor instanceof EditorConfigUnionDescriptor) {
            EditorConfigConstantReference editorConfigConstantReference;
            if (EditorConfigDescriptorUtil.INSTANCE.isConstant(descriptor)) {
                editorConfigConstantReference = new EditorConfigConstantReference(this);
            } else {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(EditorConfigDescribableElementBase.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Got non-constant union");
                editorConfigConstantReference = null;
            }
            psiReference = (PsiReference)editorConfigConstantReference;
        } else {
            psiReference = null;
        }
        return psiReference;
    }

    @NotNull
    public final String toString() {
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }
}

