/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.python.formatters.indents;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonIndentingLexer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.language.formatters.TextFormatter;
import org.jetbrains.completion.full.line.python.formatters.indents.IndentFormatterState;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H$J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\"\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0003X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/completion/full/line/python/formatters/indents/PyIndentToScopeFormatterBase;", "Lorg/jetbrains/completion/full/line/language/formatters/TextFormatter;", "scopeIn", "", "scopeOut", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getScopeIn", "()Ljava/lang/String;", "getScopeOut", "lexer", "Lcom/jetbrains/python/lexer/PythonIndentingLexer;", "getLexer", "()Lcom/jetbrains/python/lexer/PythonIndentingLexer;", "tmpSuffix", "getTmpSuffix", "format", "text", "formatIndents", "state", "Lorg/jetbrains/completion/full/line/python/formatters/indents/IndentFormatterState;", "handleDedent", "", "handleLexerToken", "handleToken", "tokenText", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "handleIndent", "handleDocstring", "removeDocstringIndents", "intellij.fullLine.python"})
public abstract class PyIndentToScopeFormatterBase
implements TextFormatter {
    @NotNull
    private final String scopeIn;
    @NotNull
    private final String scopeOut;
    @NotNull
    private final PythonIndentingLexer lexer;
    @NotNull
    private final String tmpSuffix;

    public PyIndentToScopeFormatterBase(@NotNull String scopeIn, @NotNull String scopeOut) {
        Intrinsics.checkNotNullParameter((Object)scopeIn, (String)"scopeIn");
        Intrinsics.checkNotNullParameter((Object)scopeOut, (String)"scopeOut");
        this.scopeIn = scopeIn;
        this.scopeOut = scopeOut;
        this.lexer = new PythonIndentingLexer();
        this.tmpSuffix = "\u20b7";
    }

    public /* synthetic */ PyIndentToScopeFormatterBase(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "\u21e5";
        }
        if ((n & 2) != 0) {
            string2 = "\u21e4";
        }
        this(string, string2);
    }

    @NotNull
    protected final String getScopeIn() {
        return this.scopeIn;
    }

    @NotNull
    protected final String getScopeOut() {
        return this.scopeOut;
    }

    @NotNull
    protected final PythonIndentingLexer getLexer() {
        return this.lexer;
    }

    @NotNull
    protected final String getTmpSuffix() {
        return this.tmpSuffix;
    }

    @NotNull
    public String format(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        IndentFormatterState state = new IndentFormatterState(null, 1, null);
        return this.formatIndents(text, state);
    }

    @NotNull
    public abstract String formatIndents(@NotNull String var1, @NotNull IndentFormatterState var2);

    protected abstract void handleDedent(@NotNull IndentFormatterState var1);

    protected final void handleLexerToken(@NotNull IndentFormatterState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String string = this.lexer.getTokenText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenText(...)");
        this.handleToken(string, this.lexer.getTokenType(), state);
    }

    protected final void handleToken(@NotNull String tokenText, @Nullable IElementType tokenType, @NotNull IndentFormatterState state) {
        Intrinsics.checkNotNullParameter((Object)tokenText, (String)"tokenText");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        IElementType iElementType = tokenType;
        if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.INDENT)) {
            this.handleIndent(state);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.DOCSTRING) || Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.TRIPLE_QUOTED_UNICODE) || Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.TRIPLE_QUOTED_STRING)) {
            this.handleDocstring(state);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.DEDENT)) {
            this.handleDedent(state);
        } else {
            state.append(tokenText);
        }
    }

    protected final void handleIndent(@NotNull IndentFormatterState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        state.append(this.scopeIn);
    }

    protected final void handleDocstring(@NotNull IndentFormatterState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String string = this.lexer.getTokenText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenText(...)");
        state.append(this.removeDocstringIndents(string));
    }

    @NotNull
    protected final String removeDocstringIndents(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)text), (CharSequence)"\n", null, null, (int)0, null, PyIndentToScopeFormatterBase::removeDocstringIndents$lambda$0, (int)30, null);
    }

    private static final CharSequence removeDocstringIndents$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    public PyIndentToScopeFormatterBase() {
        this(null, null, 3, null);
    }
}

