/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.firefox.FirefoxCallFrame;
import com.jetbrains.firefox.FirefoxCommandProcessor;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.FirefoxScript;
import com.jetbrains.firefox.FirefoxVm;
import com.jetbrains.firefox.rdp.Source;
import com.jetbrains.firefox.rdp.SourceResult;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManagerBaseEx;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.rpc.CommandProcessorKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J#\u0010\u0014\u001a\u0015\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015\u00a2\u0006\u0002\b\u00182\u0006\u0010\t\u001a\u00020\u0002H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/firefox/FirefoxScriptManager;", "Lorg/jetbrains/debugger/ScriptManagerBaseEx;", "Lcom/jetbrains/firefox/FirefoxScript;", "vm", "Lcom/jetbrains/firefox/FirefoxVm;", "<init>", "(Lcom/jetbrains/firefox/FirefoxVm;)V", "addScript", "", "script", "Lcom/jetbrains/firefox/rdp/Source;", "containsScript", "", "Lorg/jetbrains/debugger/Script;", "getScript", "", "function", "Lorg/jetbrains/debugger/values/FunctionValue;", "frame", "Lorg/jetbrains/debugger/CallFrame;", "loadScriptSource", "Lorg/jetbrains/concurrency/Promise;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.javascript.firefox.connector"})
public final class FirefoxScriptManager
extends ScriptManagerBaseEx<FirefoxScript> {
    @NotNull
    private final FirefoxVm vm;

    public FirefoxScriptManager(@NotNull FirefoxVm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.vm = vm;
    }

    public final void addScript(@NotNull Source script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String rawScriptUrl = script.url();
        if (rawScriptUrl == null || Intrinsics.areEqual((Object)rawScriptUrl, (Object)"debugger eval code") || Intrinsics.areEqual((Object)rawScriptUrl, (Object)"self-hosted")) {
            return;
        }
        Url url = Urls.parseEncoded((String)rawScriptUrl);
        if (url == null && StringsKt.endsWith$default((String)rawScriptUrl, (String)"Bundle", (boolean)false, (int)2, null)) {
            return;
        }
        CommandProcessorKt.getLOG().assertTrue(url != null, (Object)rawScriptUrl);
        String string = script.actor();
        Script.Type type = script.isBlackBoxed() ? Script.Type.NATIVE : Script.Type.NORMAL;
        Url url2 = url;
        Intrinsics.checkNotNull((Object)url2);
        FirefoxScript vmScript = new FirefoxScript(string, type, rawScriptUrl, url2, 0, 0, -1, (Vm)this.vm);
        if (this.getIdToScript().putIfAbsent(script.actor(), vmScript) != null) {
            return;
        }
        this.vm.getDebugListener().scriptAdded((Vm)this.vm, (Script)vmScript);
    }

    public boolean containsScript(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return script instanceof FirefoxScript && this.getIdToScript().containsKey(((FirefoxScript)script).actor);
    }

    @NotNull
    public Void getScript(@NotNull FunctionValue function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Script getScript(@NotNull CallFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        FirefoxCallFrame fxFrame = (FirefoxCallFrame)frame;
        if (fxFrame.scriptId != null) {
            return (Script)this.getIdToScript().get(fxFrame.scriptId);
        }
        for (FirefoxScript script : this.getIdToScript().values()) {
            if (!Intrinsics.areEqual((Object)script.rawUrl, (Object)fxFrame.scriptUrl)) continue;
            return (Script)script;
        }
        return null;
    }

    @NotNull
    protected Promise<String> loadScriptSource(@NotNull FirefoxScript script) {
        Intrinsics.checkNotNullParameter((Object)((Object)script), (String)"script");
        FirefoxCommandProcessor firefoxCommandProcessor = this.vm.getCommandProcessor();
        String string = script.actor;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"actor");
        Promise promise = firefoxCommandProcessor.send(FirefoxRequest.Companion.getScriptSource(string)).then(arg_0 -> FirefoxScriptManager.loadScriptSource$lambda$1(FirefoxScriptManager::loadScriptSource$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private static final String loadScriptSource$lambda$0(SourceResult it) {
        return it.source();
    }

    private static final String loadScriptSource$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

