/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.document;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizer;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdPatchDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdResetDocumentChange;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.document.FrontendPatchDocumentItemHandlerKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandler;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/document/FrontendPatchDocumentItemHandler;", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchItemHandler;", "Lcom/jetbrains/rd/ide/model/RdPatchDocumentVersion;", "Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;", "<init>", "()V", "validate", "", "version", "context", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "update", "", "apply", "item", "(Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDocumentSynchronizer", "Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "id", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendPatchDocumentItemHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendPatchDocumentItemHandler.kt\ncom/jetbrains/rdclient/document/FrontendPatchDocumentItemHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,94:1\n68#2,4:95\n68#2,4:99\n68#2,4:103\n68#2,4:107\n68#2,4:111\n*S KotlinDebug\n*F\n+ 1 FrontendPatchDocumentItemHandler.kt\ncom/jetbrains/rdclient/document/FrontendPatchDocumentItemHandler\n*L\n30#1:95,4\n41#1:99,4\n45#1:103,4\n82#1:107,4\n88#1:111,4\n*E\n"})
public final class FrontendPatchDocumentItemHandler
implements FrontendRdPatchItemHandler<RdPatchDocumentVersion, RdDocumentChangeBase> {
    @Override
    public boolean validate(@NotNull RdPatchDocumentVersion version, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RdPatchItemId rdPatchItemId = version.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentId");
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this.getDocumentSynchronizer((RdDocumentId)rdPatchItemId, context.getSession());
        if (patchEngineDocumentSynchronizer == null) {
            return true;
        }
        PatchEngineDocumentSynchronizer synchronizer = patchEngineDocumentSynchronizer;
        if (!Intrinsics.areEqual((Object)synchronizer.getVersion(), (Object)version.getVersion())) {
            FrontendPatchDocumentItemHandlerKt.access$getLogger$p().error("Not matched versions for " + version.getId() + " documentId, actual: " + synchronizer.getVersion() + ", expected: " + version.getVersion());
            return false;
        }
        return true;
    }

    @Override
    public void update(@NotNull RdPatchDocumentVersion version, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Logger $this$trace$iv = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Update document version: " + version.getId() + " to " + version.getVersion() + " with operation type " + context.getOperation());
        }
        RdPatchItemId rdPatchItemId = version.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentId");
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this.getDocumentSynchronizer((RdDocumentId)rdPatchItemId, context.getSession());
        if (patchEngineDocumentSynchronizer == null) {
            return;
        }
        PatchEngineDocumentSynchronizer synchronizer = patchEngineDocumentSynchronizer;
        PatchItemOperationType patchItemOperationType = context.getOperation();
        if (patchItemOperationType instanceof PatchItemOperationType.Rollback) {
            synchronizer.resetVersion((AbstractDocumentVersion)version.getVersion());
        } else if (patchItemOperationType instanceof PatchItemOperationType.Perform) {
            synchronizer.updateLastKnownVersion(version.getVersion());
        }
    }

    @Override
    @Nullable
    public Object apply(@NotNull RdDocumentChangeBase item, @NotNull FrontendRdPatchHandlerContext context, @NotNull Continuation<? super Unit> $completion) {
        RdDocumentChangeBase rdDocumentChangeBase;
        Logger logger;
        PatchItemOperationType operation = context.getOperation();
        Logger $this$trace$iv = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Apply document step: " + IPrintableKt.printToString((Object)item) + " with operation type " + operation);
        }
        PatchEngineDocumentSynchronizer synchronizer = this.getDocumentSynchronizer(item.getDocumentId(), context.getSession());
        if (synchronizer == null) {
            Logger $this$trace$iv2 = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl = false;
                logger.trace("Document synchronizer not found for " + item.getDocumentId() + ": can not apply change: " + IPrintableKt.printToString((Object)item));
            }
            return Unit.INSTANCE;
        }
        PatchItemOperationType $i$f$trace2 = operation;
        if ($i$f$trace2 instanceof PatchItemOperationType.Rollback) {
            bl = item;
            if (bl instanceof RdResetDocumentChange) {
                throw new IllegalStateException(("Can't revert initial change for " + DocumentExKt.toDebugString((RdDocumentId)item.getDocumentId())).toString());
            }
            if (!(bl instanceof RdDocumentChange)) {
                throw new IllegalStateException((item.getClass() + " is not supported for revert operation").toString());
            }
            rdDocumentChangeBase = (RdDocumentChangeBase)UtilKt.reverse((RdDocumentChange)((RdDocumentChange)item));
        } else if ($i$f$trace2 instanceof PatchItemOperationType.Redo) {
            RdDocumentChange replayChange;
            bl = item;
            if (bl instanceof RdResetDocumentChange) {
                throw new IllegalStateException(("Can't redo initial change for " + DocumentExKt.toDebugString((RdDocumentId)item.getDocumentId())).toString());
            }
            if (bl instanceof RdDocumentChange) {
                boolean bl;
                replayChange = ((PatchItemOperationType.Redo)operation).getRebaseSession().replay((RdDocumentChange)item);
                if (replayChange.getOffset() == -1 || replayChange.getMoveOffset() == -1 || replayChange.getOldDocumentLength() == -1) {
                    FrontendPatchDocumentItemHandlerKt.access$getLogger$p().warn("Can't redo change for " + DocumentExKt.toDebugString((RdDocumentId)item.getDocumentId()) + ": " + IPrintableKt.printToString((Object)item));
                    return Unit.INSTANCE;
                }
                boolean bl2 = bl = synchronizer.getDocument().getTextLength() == replayChange.getOldDocumentLength();
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "Document length " + synchronizer.getDocument().getTextLength() + " does not match with expected change length " + replayChange.getOldDocumentLength();
                    throw new AssertionError((Object)string);
                }
            } else {
                throw new IllegalStateException((item.getClass() + " is not supported for redo operation").toString());
            }
            rdDocumentChangeBase = (RdDocumentChangeBase)replayChange;
        } else {
            rdDocumentChangeBase = item;
        }
        RdDocumentChangeBase change = rdDocumentChangeBase;
        synchronizer.receiveDocumentChange(change, operation instanceof PatchItemOperationType.Redo);
        if (operation instanceof PatchItemOperationType.Rollback) {
            ((PatchItemOperationType.Rollback)operation).getRebaseSession().record((RdPatchItem)item);
        }
        Logger $this$trace$iv3 = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
        boolean $i$f$trace3 = false;
        if ($this$trace$iv3.isTraceEnabled()) {
            logger = $this$trace$iv3;
            boolean bl = false;
            logger.trace("Change " + IPrintableKt.printToString((Object)change) + " from operation type " + operation + " was applied. New document length: " + synchronizer.getDocument().getTextLength());
        }
        return Unit.INSTANCE;
    }

    private final PatchEngineDocumentSynchronizer getDocumentSynchronizer(RdDocumentId id, ClientAppSession session) {
        FrontendDocumentHost documentHost = FrontendDocumentHost.Companion.getInstance(session);
        if (documentHost.isRecentlyClosed(id)) {
            Logger $this$trace$iv = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Do not promote document version for a recently closed document (it is an expected race case); document: " + id);
            }
            return null;
        }
        DocumentSynchronizer documentSynchronizer = documentHost.getSynchronizer(id);
        return documentSynchronizer instanceof PatchEngineDocumentSynchronizer ? (PatchEngineDocumentSynchronizer)documentSynchronizer : null;
    }
}

