/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt.diagram;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.codeWithMe.ClientId;
import com.intellij.dbt.DbtModuleEntity;
import com.intellij.dbt.DbtUtils;
import com.intellij.dbt.console.DbtConsoleService;
import com.intellij.dbt.diagram.DbtGraphSummaryContainerObject;
import com.intellij.dbt.diagram.DbtGraphSummaryNode;
import com.intellij.dbt.diagram.DbtLineageModelNode;
import com.intellij.dbt.diagram.DbtLineageNode;
import com.intellij.dbt.diagram.DbtLineageSeedNode;
import com.intellij.diagram.v2.GraphChartConfiguration;
import com.intellij.diagram.v2.GraphChartFactory;
import com.intellij.diagram.v2.dsl.GraphChartKtConfigurator;
import com.intellij.diagram.v2.dsl.GraphChartNodePainterKtBuilder;
import com.intellij.diagram.v2.dsl.GraphChartTooltipProviderKtBuilder;
import com.intellij.diagram.v2.dsl.GraphChartViewSettingKtBuilder;
import com.intellij.diagram.v2.elements.GraphChartGraphElement;
import com.intellij.diagram.v2.handles.GraphChartHandle;
import com.intellij.diagram.v2.handles.GraphChartSelectionHandle;
import com.intellij.diagram.v2.handles.GraphChartUpdateHandle;
import com.intellij.diagram.v2.layout.GraphChartLayoutOrientation;
import com.intellij.diagram.v2.layout.GraphChartLayoutService;
import com.intellij.diagram.v2.listeners.GraphChartSelectionEvent;
import com.intellij.diagram.v2.painting.GraphChartPainterService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.graph.GraphFactory;
import com.intellij.util.graph.MutableNetwork;
import com.intellij.util.graph.Network;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001c\u0010\u0003\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a$\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\"\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a&\u0010\u0015\u001a\u00020\u00102\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"trimNodeName", "", "nodeName", "splitPackageAndName", "Lkotlin/Pair;", "fqn", "NODE_TYPE_MODEL", "NODE_TYPE_SEED", "readLineage", "Lcom/intellij/util/graph/Network;", "Lcom/intellij/dbt/diagram/DbtLineageNode;", "", "graphSummaryContent", "module", "Lcom/intellij/openapi/module/Module;", "openLineage", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "forced", "", "selectNodeForFile", "graphHandle", "Lcom/intellij/diagram/v2/handles/GraphChartHandle;", "intellij.dbt"})
@SourceDebugExtension(value={"SMAP\nDbtLineageUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbtLineageUtil.kt\ncom/intellij/dbt/diagram/DbtLineageUtilKt\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n58#2:258\n51#2:259\n216#3,2:260\n216#3,2:262\n40#4,3:264\n295#5,2:267\n1863#5,2:269\n*S KotlinDebug\n*F\n+ 1 DbtLineageUtil.kt\ncom/intellij/dbt/diagram/DbtLineageUtilKt\n*L\n89#1:258\n89#1:259\n98#1:260,2\n111#1:262,2\n142#1:264,3\n248#1:267,2\n251#1:269,2\n*E\n"})
public final class DbtLineageUtilKt {
    @NotNull
    private static final String NODE_TYPE_MODEL = "model";
    @NotNull
    private static final String NODE_TYPE_SEED = "seed";

    @NotNull
    public static final String trimNodeName(@NotNull String nodeName) {
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        if (StringsKt.startsWith$default((String)nodeName, (String)"model.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)nodeName, (String)"seed.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)nodeName, (String)"test.", (boolean)false, (int)2, null)) {
            String string = nodeName.substring(StringsKt.indexOf$default((CharSequence)nodeName, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return nodeName;
    }

    @NotNull
    public static final Pair<String, String> splitPackageAndName(@NotNull String fqn) {
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        int idx = StringsKt.lastIndexOf$default((CharSequence)fqn, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (idx > 0 && idx < fqn.length() - 1) {
            String string = fqn.substring(0, idx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = fqn.substring(idx + 1, fqn.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return new Pair((Object)string, (Object)string2);
        }
        return new Pair(null, (Object)fqn);
    }

    @Nullable
    public static final Network<DbtLineageNode, Object> readLineage(@NotNull String graphSummaryContent, @NotNull Module module) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)graphSummaryContent, (String)"graphSummaryContent");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
        DbtGraphSummaryContainerObject dbtGraphSummaryContainerObject = null;
        try {
            ObjectMapper $this$readValue$iv = mapper;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            dbtGraphSummaryContainerObject = (DbtGraphSummaryContainerObject)$this$readValue$iv.readValue(graphSummaryContent, (TypeReference)new TypeReference<DbtGraphSummaryContainerObject>(){});
        }
        catch (Exception e) {
            return null;
        }
        Map<String, DbtGraphSummaryNode> nodes = dbtGraphSummaryContainerObject.getLinked();
        MutableNetwork graph = GraphFactory.getInstance().directedNetwork().build();
        int edgeCount = 0;
        Map diagramNodes = new LinkedHashMap();
        Map<String, DbtGraphSummaryNode> $this$forEach$iv = nodes;
        boolean $i$f$forEach22 = false;
        Iterator<Map.Entry<String, DbtGraphSummaryNode>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DbtGraphSummaryNode> element$iv;
            Map.Entry<String, DbtGraphSummaryNode> it = element$iv = iterator.next();
            boolean bl = false;
            String nodeFQN = DbtLineageUtilKt.trimNodeName(it.getValue().getName());
            Pair<String, String> pkgAndName = DbtLineageUtilKt.splitPackageAndName(nodeFQN);
            object = it.getValue().getType();
            DbtLineageNode diagramNode = Intrinsics.areEqual((Object)object, (Object)NODE_TYPE_MODEL) ? (DbtLineageNode)new DbtLineageModelNode((String)pkgAndName.getFirst(), (String)pkgAndName.getSecond(), module) : (Intrinsics.areEqual((Object)object, (Object)NODE_TYPE_SEED) ? (DbtLineageNode)new DbtLineageSeedNode((String)pkgAndName.getFirst(), (String)pkgAndName.getSecond(), module) : new DbtLineageNode((String)pkgAndName.getFirst(), (String)pkgAndName.getSecond(), module));
            diagramNodes.put(it.getKey(), diagramNode);
        }
        Object[] $i$f$forEach22 = new String[]{NODE_TYPE_MODEL, NODE_TYPE_SEED};
        List typeFilter = CollectionsKt.listOf((Object[])$i$f$forEach22);
        Map<String, DbtGraphSummaryNode> $this$forEach$iv2 = nodes;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DbtGraphSummaryNode>> iterator2 = $this$forEach$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            List<Integer> successors;
            Map.Entry<String, DbtGraphSummaryNode> element$iv;
            Map.Entry<String, DbtGraphSummaryNode> it = element$iv = iterator2.next();
            boolean bl = false;
            if (!typeFilter.contains(it.getValue().getType()) || (successors = it.getValue().getSucc()) == null) continue;
            object = successors.iterator();
            while (object.hasNext()) {
                int nr = ((Number)object.next()).intValue();
                DbtGraphSummaryNode linked = nodes.get(String.valueOf(nr));
                if (linked == null || !typeFilter.contains(linked.getType())) continue;
                graph.addEdge(diagramNodes.get(it.getKey()), diagramNodes.get(String.valueOf(nr)), (Object)(++edgeCount));
            }
        }
        return (Network)graph;
    }

    public static final void openLineage(@Nullable VirtualFile virtualFile, @NotNull Module module, boolean forced) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        DbtModuleEntity dbtModuleEntity = DbtUtils.Companion.getDbtSettings(module);
        if (dbtModuleEntity == null) {
            return;
        }
        DbtModuleEntity dbtSettings = dbtModuleEntity;
        boolean $i$f$service = false;
        Class<DbtConsoleService> serviceClass$iv = DbtConsoleService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        DbtConsoleService dbtService = (DbtConsoleService)object;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (!forced && dbtService.isDbtToolwindowCreated(project2) && !dbtService.isLineageVisible(project2)) {
            return;
        }
        Object object2 = dbtSettings.getDbtProjectPath();
        if (object2 == null || (object2 = VirtualFileUrls.getVirtualFile((VirtualFileUrl)object2)) == null || (object2 = object2.getPath()) == null) {
            return;
        }
        Object projectPath = object2;
        Path path = NioPathUtil.toNioPathOrNull((String)((String)projectPath + "/target/graph_summary.json"));
        if (path == null) {
            dbtService.setGraphHash(module, 0);
            return;
        }
        if (!path.toFile().exists()) {
            return;
        }
        String graphSummaryContent = null;
        try {
            graphSummaryContent = Files.readString(path);
        }
        catch (IOException e) {
            return;
        }
        int newGraphSummaryHash = graphSummaryContent.hashCode();
        if (!forced && dbtService.getGraphHash(module) == newGraphSummaryHash) {
            GraphChartHandle<DbtLineageNode, Object> graphHandle;
            if (newGraphSummaryHash != 0 && virtualFile != null && DbtUtils.Companion.isUnderModelsDirectory(virtualFile, module) && (graphHandle = dbtService.getGraphHandle(module)) != null) {
                ApplicationManager.getApplication().invokeLater(() -> DbtLineageUtilKt.openLineage$lambda$2(graphHandle, virtualFile));
            }
            return;
        }
        if (virtualFile != null && !DbtUtils.Companion.isUnderModelsDirectory(virtualFile, module)) {
            return;
        }
        Network<DbtLineageNode, Object> lineageGraph = DbtLineageUtilKt.readLineage(graphSummaryContent, module);
        if (lineageGraph == null) {
            dbtService.setGraphHash(module, 0);
            return;
        }
        GraphChartConfiguration chartConfiguration = GraphChartFactory.Companion.getInstance().graphChart(project2, lineageGraph, DbtLineageUtilKt::openLineage$lambda$8);
        GraphChartFactory.instantiateAndGetComponent$default((GraphChartFactory)GraphChartFactory.Companion.getInstance(), (GraphChartConfiguration)chartConfiguration, null, (int)2, null).thenApply(arg_0 -> DbtLineageUtilKt.openLineage$lambda$13(arg_0 -> DbtLineageUtilKt.openLineage$lambda$12(dbtService, project2, module, newGraphSummaryHash, virtualFile, arg_0), arg_0)).thenCompose(arg_0 -> DbtLineageUtilKt.openLineage$lambda$16(DbtLineageUtilKt::openLineage$lambda$15, arg_0));
    }

    public static /* synthetic */ void openLineage$default(VirtualFile virtualFile, Module module, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        DbtLineageUtilKt.openLineage(virtualFile, module, bl);
    }

    private static final void selectNodeForFile(GraphChartHandle<DbtLineageNode, Object> graphHandle, VirtualFile virtualFile) {
        Object v3;
        block3: {
            MutableNetwork mutableNetwork = graphHandle.getGraph();
            Intrinsics.checkNotNullExpressionValue((Object)mutableNetwork, (String)"getGraph(...)");
            MutableNetwork graph = mutableNetwork;
            Set set = graph.nodes();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"nodes(...)");
            Iterable $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DbtLineageNode it = (DbtLineageNode)element$iv;
                boolean bl = false;
                VirtualFile virtualFile2 = virtualFile;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)(virtualFile2 != null ? virtualFile2.getNameWithoutExtension() : null))) continue;
                v3 = element$iv;
                break block3;
            }
            v3 = null;
        }
        DbtLineageNode selectedNode = v3;
        if (selectedNode != null) {
            GraphChartSelectionHandle graphChartSelectionHandle = graphHandle.asSelectionHandle();
            Intrinsics.checkNotNullExpressionValue((Object)graphChartSelectionHandle, (String)"asSelectionHandle(...)");
            GraphChartSelectionHandle asSelectionHandle = graphChartSelectionHandle;
            List list = asSelectionHandle.getSelectedNodes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedNodes(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DbtLineageNode it = (DbtLineageNode)element$iv;
                boolean bl = false;
                asSelectionHandle.switchNodeSelection((Object)it, false);
            }
            asSelectionHandle.switchNodeSelection((Object)selectedNode, true);
        }
    }

    private static final void openLineage$lambda$2(GraphChartHandle $graphHandle, VirtualFile $virtualFile) {
        DbtLineageUtilKt.selectNodeForFile((GraphChartHandle<DbtLineageNode, Object>)$graphHandle, $virtualFile);
    }

    private static final Unit openLineage$lambda$8$lambda$3(GraphChartViewSettingKtBuilder $this$initialViewSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$initialViewSettings, (String)"$this$initialViewSettings");
        $this$initialViewSettings.setCurrentLayouter(GraphChartLayoutService.getInstance().getHierarchicLayouter());
        $this$initialViewSettings.setCurrentLayoutOrientation(GraphChartLayoutOrientation.LEFT_TO_RIGHT);
        return Unit.INSTANCE;
    }

    private static final GraphChartPainterService.LabelWithIconNodeStyleProvider.LabelWithIcon openLineage$lambda$8$lambda$5$lambda$4(GraphChartHandle graphChartHandle, DbtLineageNode node) {
        Intrinsics.checkNotNullParameter((Object)graphChartHandle, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return new GraphChartPainterService.LabelWithIconNodeStyleProvider.LabelWithIcon(node.getIcon(), node.getName(), null);
    }

    private static final Unit openLineage$lambda$8$lambda$5(GraphChartNodePainterKtBuilder $this$nodePainter) {
        Intrinsics.checkNotNullParameter((Object)$this$nodePainter, (String)"$this$nodePainter");
        $this$nodePainter.labelWithIconNodePainter(DbtLineageUtilKt::openLineage$lambda$8$lambda$5$lambda$4);
        return Unit.INSTANCE;
    }

    private static final HtmlChunk openLineage$lambda$8$lambda$7$lambda$6(GraphChartHandle<DbtLineageNode, Object> graphChartHandle, DbtLineageNode node) {
        HtmlBuilder builder = new HtmlBuilder();
        if (node.getPkg() != null) {
            builder.appendRaw(node.getPkg()).appendRaw(".");
        }
        HtmlChunk htmlChunk = builder.append(node.getName()).toFragment();
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"toFragment(...)");
        return htmlChunk;
    }

    private static final Unit openLineage$lambda$8$lambda$7(GraphChartTooltipProviderKtBuilder $this$tooltipProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$tooltipProvider, (String)"$this$tooltipProvider");
        $this$tooltipProvider.htmlBasedNodePopup(DbtLineageUtilKt::openLineage$lambda$8$lambda$7$lambda$6);
        return Unit.INSTANCE;
    }

    private static final Unit openLineage$lambda$8(GraphChartKtConfigurator $this$graphChart) {
        Intrinsics.checkNotNullParameter((Object)$this$graphChart, (String)"$this$graphChart");
        $this$graphChart.initialViewSettings(DbtLineageUtilKt::openLineage$lambda$8$lambda$3);
        $this$graphChart.nodePainter(DbtLineageUtilKt::openLineage$lambda$8$lambda$5);
        $this$graphChart.tooltipProvider(DbtLineageUtilKt::openLineage$lambda$8$lambda$7);
        return Unit.INSTANCE;
    }

    private static final void openLineage$lambda$12$lambda$10$lambda$9(DbtLineageNode $node) {
        $node.navigate(true);
    }

    private static final void openLineage$lambda$12$lambda$10(DbtConsoleService $dbtService, Project $project, GraphChartHandle $graphHandle, GraphChartSelectionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!$dbtService.isLineageVisible($project)) {
            return;
        }
        GraphChartGraphElement graphChartGraphElement = event.getElementWhichSelectionChanged();
        Intrinsics.checkNotNullExpressionValue((Object)graphChartGraphElement, (String)"getElementWhichSelectionChanged(...)");
        GraphChartGraphElement element = graphChartGraphElement;
        if (element instanceof GraphChartGraphElement.Node) {
            Object object = ((GraphChartGraphElement.Node)element).getNode();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getNode(...)");
            DbtLineageNode node = (DbtLineageNode)object;
            boolean isSelected = $graphHandle.asSelectionHandle().getSelectedNodes().contains(node);
            if (isSelected) {
                ApplicationManager.getApplication().invokeLater(() -> DbtLineageUtilKt.openLineage$lambda$12$lambda$10$lambda$9(node));
            }
        }
    }

    private static final void openLineage$lambda$12$lambda$11(DbtConsoleService $dbtService, Project $project, com.intellij.openapi.util.Pair $it, Module $module, GraphChartHandle $graphHandle, int $newGraphSummaryHash, VirtualFile $virtualFile) {
        Object object = $it.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
        $dbtService.showComponent($project, (JComponent)object);
        Intrinsics.checkNotNull((Object)$graphHandle);
        $dbtService.setLineageInfo($module, (GraphChartHandle<DbtLineageNode, Object>)$graphHandle, $newGraphSummaryHash);
        DbtLineageUtilKt.selectNodeForFile((GraphChartHandle<DbtLineageNode, Object>)$graphHandle, $virtualFile);
    }

    private static final GraphChartHandle openLineage$lambda$12(DbtConsoleService $dbtService, Project $project, Module $module, int $newGraphSummaryHash, VirtualFile $virtualFile, com.intellij.openapi.util.Pair it) {
        GraphChartHandle graphHandle = (GraphChartHandle)it.first;
        graphHandle.asSelectionHandle().addSelectionListener((Disposable)$dbtService, arg_0 -> DbtLineageUtilKt.openLineage$lambda$12$lambda$10($dbtService, $project, graphHandle, arg_0));
        ApplicationManager.getApplication().invokeLater(() -> DbtLineageUtilKt.openLineage$lambda$12$lambda$11($dbtService, $project, it, $module, graphHandle, $newGraphSummaryHash, $virtualFile));
        return graphHandle;
    }

    private static final GraphChartHandle openLineage$lambda$13(Function1 $tmp0, Object p0) {
        return (GraphChartHandle)$tmp0.invoke(p0);
    }

    private static final void openLineage$lambda$15$lambda$14(GraphChartHandle $handle) {
        $handle.asViewActionsHandle().fitContent(false);
    }

    private static final CompletionStage openLineage$lambda$15(GraphChartHandle handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        handle.asUpdateHandle().queryLayout().withFitContent(GraphChartUpdateHandle.GraphChartLayoutQueryParams.FitContentOption.BEFORE).run();
        ApplicationManager.getApplication().invokeLater(() -> DbtLineageUtilKt.openLineage$lambda$15$lambda$14(handle));
        return CompletableFuture.completedFuture(null);
    }

    private static final CompletionStage openLineage$lambda$16(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }
}

