/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn.smartstep;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import org.jetbrains.annotations.Nullable;

public class NashornMethodFilter
implements BreakpointStepMethodFilter {
    private final SourcePosition myBreakpointPosition;
    private final Range<Integer> myCallingExpressionLines;

    public NashornMethodFilter(JSFunction function, Range<Integer> callingExpressionLines) {
        this.myCallingExpressionLines = callingExpressionLines;
        SourcePosition firstStatementPosition = null;
        JSBlockStatement body = function.getBlock();
        if (body != null) {
            JSStatement firstStatement = (JSStatement)PsiTreeUtil.getChildOfType((PsiElement)body, JSStatement.class);
            firstStatementPosition = SourcePosition.createFromElement((PsiElement)firstStatement);
        }
        this.myBreakpointPosition = firstStatementPosition;
    }

    public boolean locationMatches(DebugProcessImpl process, Location location) throws EvaluateException {
        return true;
    }

    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.myCallingExpressionLines;
    }

    @Nullable
    public SourcePosition getBreakpointPosition() {
        return this.myBreakpointPosition;
    }

    public int getLastStatementLine() {
        return -1;
    }
}

