/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyExecutionStack;
import com.jetbrains.python.debugger.PyThreadInfo;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PySuspendContext
extends XSuspendContext {
    private final PyExecutionStack myActiveStack;
    private final PyDebugProcess myDebugProcess;

    public PySuspendContext(@NotNull PyDebugProcess debugProcess, @NotNull PyThreadInfo threadInfo) {
        if (debugProcess == null) {
            PySuspendContext.$$$reportNull$$$0(0);
        }
        if (threadInfo == null) {
            PySuspendContext.$$$reportNull$$$0(1);
        }
        this.myDebugProcess = debugProcess;
        this.myActiveStack = new PyExecutionStack(debugProcess, threadInfo, PySuspendContext.getThreadIcon(threadInfo));
    }

    @NotNull
    public PyExecutionStack getActiveExecutionStack() {
        PyExecutionStack pyExecutionStack = this.myActiveStack;
        if (pyExecutionStack == null) {
            PySuspendContext.$$$reportNull$$$0(2);
        }
        return pyExecutionStack;
    }

    @NotNull
    public static Icon getThreadIcon(@NotNull PyThreadInfo threadInfo) {
        if (threadInfo == null) {
            PySuspendContext.$$$reportNull$$$0(3);
        }
        if (threadInfo.getState() == PyThreadInfo.State.SUSPENDED && threadInfo.getStopReason() == 111) {
            Icon icon = AllIcons.Debugger.ThreadAtBreakpoint;
            if (icon == null) {
                PySuspendContext.$$$reportNull$$$0(4);
            }
            return icon;
        }
        Icon icon = AllIcons.Debugger.ThreadSuspended;
        if (icon == null) {
            PySuspendContext.$$$reportNull$$$0(5);
        }
        return icon;
    }

    public XExecutionStack @NotNull [] getExecutionStacks() {
        Collection<PyThreadInfo> threads = this.myDebugProcess.getThreads();
        if (threads.size() < 1) {
            if (XExecutionStack.EMPTY_ARRAY == null) {
                PySuspendContext.$$$reportNull$$$0(6);
            }
            return XExecutionStack.EMPTY_ARRAY;
        }
        XExecutionStack[] stacks = new XExecutionStack[threads.size()];
        int i = 0;
        for (PyThreadInfo thread : threads) {
            stacks[i++] = new PyExecutionStack(this.myDebugProcess, thread, PySuspendContext.getThreadIcon(thread));
        }
        if (stacks == null) {
            PySuspendContext.$$$reportNull$$$0(7);
        }
        return stacks;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadInfo";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PySuspendContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PySuspendContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveExecutionStack";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadIcon";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionStacks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getThreadIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

