/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonTemplateRunner;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnresolvedRefCreateFunctionQuickFix
implements LocalQuickFix {
    private final String myFunctionName;
    private final boolean myAsync;

    public UnresolvedRefCreateFunctionQuickFix(@NotNull PyReferenceExpression reference) {
        if (reference == null) {
            UnresolvedRefCreateFunctionQuickFix.$$$reportNull$$$0(0);
        }
        this.myFunctionName = reference.getReferencedName();
        PyCallSiteExpression callSiteExpression = PyUtil.as(reference.getParent(), PyCallSiteExpression.class);
        PyPrefixExpression prefixExpression = callSiteExpression != null ? PyUtil.as(callSiteExpression.getParent(), PyPrefixExpression.class) : null;
        this.myAsync = prefixExpression != null && prefixExpression.getOperator() == PyTokenTypes.AWAIT_KEYWORD;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = PyPsiBundle.message("QFIX.NAME.unresolved.reference.create.function", this.myFunctionName);
        if (string == null) {
            UnresolvedRefCreateFunctionQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.unresolved.reference.create.function", new Object[0]);
        if (string == null) {
            UnresolvedRefCreateFunctionQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            UnresolvedRefCreateFunctionQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            UnresolvedRefCreateFunctionQuickFix.$$$reportNull$$$0(4);
        }
        PyReferenceExpression referenceExpr = PyUtil.as(descriptor2.getPsiElement(), PyReferenceExpression.class);
        PyCallExpression callExpr = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)referenceExpr, PyCallExpression.class);
        if (referenceExpr == null || callExpr == null) {
            return;
        }
        PyFunctionBuilder functionBuilder = new PyFunctionBuilder(referenceExpr.getText(), (PsiElement)callExpr);
        PyArgumentList argumentList = callExpr.getArgumentList();
        if (argumentList != null && !PsiTreeUtil.isAncestor((PsiElement)argumentList, (PsiElement)referenceExpr, (boolean)false)) {
            for (PyExpression param : argumentList.getArguments()) {
                if (param instanceof PyKeywordArgument) {
                    functionBuilder.parameter(((PyKeywordArgument)param).getKeyword());
                    continue;
                }
                if (param instanceof PyReferenceExpression) {
                    PyReferenceExpression refex = (PyReferenceExpression)param;
                    functionBuilder.parameter(refex.getReferencedName());
                    continue;
                }
                functionBuilder.parameter("param");
            }
        } else {
            functionBuilder.parameter("args");
        }
        if (this.myAsync) {
            functionBuilder.makeAsync();
        }
        PyFunction function = functionBuilder.buildFunction();
        InjectedLanguageManager instance = InjectedLanguageManager.getInstance((Project)project);
        PsiLanguageInjectionHost host = instance.getInjectionHost((PsiElement)callExpr);
        Object insertAnchor = host != null ? host : callExpr;
        PyFunction parentFunction = (PyFunction)PsiTreeUtil.getTopmostParentOfType((PsiElement)insertAnchor, PyFunction.class);
        if (parentFunction != null) {
            PyClass parentClass = (PyClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)parentFunction, PyClass.class);
            if (parentClass != null) {
                PsiElement parent = parentClass.getParent();
                function = (PyFunction)parent.addBefore((PsiElement)function, (PsiElement)parentClass);
            } else {
                PsiElement parent = parentFunction.getParent();
                function = (PyFunction)parent.addBefore((PsiElement)function, (PsiElement)parentFunction);
            }
        } else {
            PsiElement parent;
            PyStatement statement = (PyStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)insertAnchor, PyStatement.class);
            if (statement != null && (parent = statement.getParent()) != null) {
                function = (PyFunction)parent.addBefore((PsiElement)function, (PsiElement)statement);
            }
        }
        function = (PyFunction)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)function);
        final TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)function);
        ParamHelper.walkDownParamArray(function.getParameterList().getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                builder.replaceElement((PsiElement)param, param.getName());
            }
        });
        builder.replaceElement((PsiElement)function.getStatementList(), "pass");
        PythonTemplateRunner.runTemplateInSelectedEditor(project, (PsiElement)insertAnchor, builder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/UnresolvedRefCreateFunctionQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/UnresolvedRefCreateFunctionQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

