/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkToInstallManager;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.SdksKt;
import com.jetbrains.python.sdk.installer.BinaryInstallation;
import com.jetbrains.python.sdk.installer.BinaryInstallerKt;
import com.jetbrains.python.sdk.installer.ResourcePreview;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\rH\u0007J3\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00160\u0015H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/sdk/PySdkToInstall;", "Lcom/intellij/openapi/projectRoots/impl/ProjectJdkImpl;", "installation", "Lcom/jetbrains/python/sdk/installer/BinaryInstallation;", "<init>", "(Lcom/jetbrains/python/sdk/installer/BinaryInstallation;)V", "getInstallation", "()Lcom/jetbrains/python/sdk/installer/BinaryInstallation;", "renderInList", "", "renderer", "Lcom/intellij/ui/SimpleColoredComponent;", "getInstallationWarning", "", "defaultButtonName", "install", "Lkotlin/Result;", "Lcom/jetbrains/python/sdk/PyDetectedSdk;", "module", "Lcom/intellij/openapi/module/Module;", "systemWideSdksDetector", "Lkotlin/Function0;", "", "install-gIAlu-s", "(Lcom/intellij/openapi/module/Module;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.python.community.impl"})
@ApiStatus.Internal
public final class PySdkToInstall
extends ProjectJdkImpl {
    @NotNull
    private final BinaryInstallation installation;

    public PySdkToInstall(@NotNull BinaryInstallation installation) {
        Intrinsics.checkNotNullParameter((Object)installation, (String)"installation");
        super(installation.getRelease().getTitle(), (SdkTypeId)PythonSdkType.getInstance(), "", installation.getRelease().getVersion());
        this.installation = installation;
    }

    @NotNull
    public final BinaryInstallation getInstallation() {
        return this.installation;
    }

    @ApiStatus.Internal
    public final void renderInList(@NotNull SimpleColoredComponent renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        renderer.append(this.getName());
        ResourcePreview preview = BinaryInstallerKt.toResourcePreview(this.installation);
        renderer.append(" " + preview.getDescription(), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        renderer.setIcon(AllIcons.Actions.Download);
    }

    @NlsContexts.DialogMessage
    @NotNull
    public final String getInstallationWarning(@NlsContexts.Button @NotNull String defaultButtonName) {
        Intrinsics.checkNotNullParameter((Object)defaultButtonName, (String)"defaultButtonName");
        ResourcePreview preview = BinaryInstallerKt.toResourcePreview(this.installation);
        String string = StringUtil.formatFileSize((long)preview.getSize());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
        String fileSize = string;
        HtmlChunk[] htmlChunkArray = new HtmlChunk[2];
        HtmlChunk[] htmlChunkArray2 = new HtmlChunk[1];
        Object[] objectArray = new Object[]{HtmlChunk.text((String)"...").bold(), "python.exe"};
        htmlChunkArray2[0] = HtmlChunk.raw((String)PyBundle.message("python.sdk.executable.not.found.option.specify.path", objectArray));
        htmlChunkArray[0] = HtmlChunk.tag((String)"li").children(htmlChunkArray2);
        htmlChunkArray2 = new HtmlChunk[1];
        objectArray = new Object[]{HtmlChunk.text((String)defaultButtonName).bold(), fileSize};
        htmlChunkArray2[0] = HtmlChunk.raw((String)PyBundle.message("python.sdk.executable.not.found.option.download.and.install", objectArray));
        htmlChunkArray[1] = HtmlChunk.tag((String)"li").children(htmlChunkArray2);
        String string2 = new HtmlBuilder().append(PyBundle.message("python.sdk.executable.not.found.header", new Object[0])).append((HtmlChunk)HtmlChunk.tag((String)"ul").children(htmlChunkArray)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @RequiresEdt
    @ApiStatus.Internal
    @NotNull
    public final Object install-gIAlu-s(@Nullable Module module, @NotNull Function0<? extends List<? extends PyDetectedSdk>> systemWideSdksDetector) {
        Intrinsics.checkNotNullParameter(systemWideSdksDetector, (String)"systemWideSdksDetector");
        Module module2 = module;
        Project project = module2 != null ? module2.getProject() : null;
        return BinaryInstallerKt.installBinary(this.installation, project, () -> PySdkToInstall.install_gIAlu_s$lambda$0(this, project, systemWideSdksDetector));
    }

    private static final PyDetectedSdk install_gIAlu_s$lambda$0(PySdkToInstall this$0, Project $project, Function0 $systemWideSdksDetector) {
        return PySdkToInstallManager.INSTANCE.findInstalledSdk(SdksKt.toLanguageLevel(Version.parseVersion((String)this$0.installation.getRelease().getVersion())), $project, (Function0<? extends List<? extends PyDetectedSdk>>)$systemWideSdksDetector);
    }
}

