/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringParser;
import com.jetbrains.python.documentation.docstrings.DocStringReferenceProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.SphinxDocString;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.validation.PyAnnotator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/validation/DocStringAnnotator;", "Lcom/jetbrains/python/validation/PyAnnotator;", "<init>", "()V", "visitPyFile", "", "node", "Lcom/jetbrains/python/psi/PyFile;", "visitPyFunction", "Lcom/jetbrains/python/psi/PyFunction;", "visitPyClass", "Lcom/jetbrains/python/psi/PyClass;", "visitPyAssignmentStatement", "Lcom/jetbrains/python/psi/PyAssignmentStatement;", "visitPyExpressionStatement", "Lcom/jetbrains/python/psi/PyExpressionStatement;", "annotateDocStringStmt", "stmt", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "intellij.python.psi.impl"})
public final class DocStringAnnotator
extends PyAnnotator {
    @Override
    public void visitPyFile(@NotNull PyFile node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.annotateDocStringStmt(DocStringUtil.findDocStringExpression(node));
    }

    @Override
    public void visitPyFunction(@NotNull PyFunction node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.annotateDocStringStmt(DocStringUtil.findDocStringExpression(node.getStatementList()));
    }

    @Override
    public void visitPyClass(@NotNull PyClass node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.annotateDocStringStmt(DocStringUtil.findDocStringExpression(node.getStatementList()));
    }

    @Override
    public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
        PyExpression right;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.isAssignmentTo("__doc__") && (right = node.getAssignedValue()) instanceof PyStringLiteralExpression) {
            this.getHolder().newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)right).textAttributes(PyHighlighter.PY_DOC_COMMENT).create();
            this.annotateDocStringStmt((PyStringLiteralExpression)right);
        }
    }

    @Override
    public void visitPyExpressionStatement(@NotNull PyExpressionStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.getExpression() instanceof PyStringLiteralExpression) {
            PyExpression pyExpression = node.getExpression();
            Intrinsics.checkNotNull((Object)pyExpression, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyStringLiteralExpression");
            if (DocStringUtil.isVariableDocString((PyStringLiteralExpression)pyExpression)) {
                PyExpression pyExpression2 = node.getExpression();
                Intrinsics.checkNotNull((Object)pyExpression2, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyStringLiteralExpression");
                this.annotateDocStringStmt((PyStringLiteralExpression)pyExpression2);
            }
        }
    }

    private final void annotateDocStringStmt(PyStringLiteralExpression stmt) {
        if (stmt == null) {
            return;
        }
        if (DocStringParser.getConfiguredDocStringFormat((PsiElement)((PsiElement)stmt)) == DocStringFormat.REST) {
            TextRange textRange;
            String[] tags = SphinxDocString.ALL_TAGS;
            int pos = 0;
            while ((textRange = DocStringReferenceProvider.findNextTag(stmt.getText(), pos, tags)) != null) {
                this.getHolder().newSilentAnnotation(HighlightSeverity.INFORMATION).range(textRange.shiftRight(stmt.getTextRange().getStartOffset())).textAttributes(PyHighlighter.PY_DOC_COMMENT_TAG).create();
                pos = textRange.getEndOffset();
            }
        }
    }
}

