/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.plist;

import com.intellij.openapi.util.text.Strings;
import com.intellij.util.xml.dom.XmlDomReader;
import com.intellij.util.xml.dom.XmlElement;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;
import org.jetbrains.plugins.textmate.plist.PlistValueType;

public final class XmlPlistReader
implements PlistReader {
    @Override
    public Plist read(@NotNull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            XmlPlistReader.$$$reportNull$$$0(0);
        }
        return XmlPlistReader.internalRead(XmlDomReader.readXmlAsModel((InputStream)inputStream));
    }

    private static Plist internalRead(@NotNull XmlElement root) throws IOException {
        if (root == null) {
            XmlPlistReader.$$$reportNull$$$0(1);
        }
        if (root.children.isEmpty()) {
            return Plist.EMPTY_PLIST;
        }
        if (!"plist".equals(root.name)) {
            throw new IOException("Unknown xml format. Root element is '" + root.name + "'");
        }
        XmlElement dictElement = root.getChild("dict");
        return dictElement != null ? (Plist)XmlPlistReader.readDict(dictElement).getValue() : Plist.EMPTY_PLIST;
    }

    private static PListValue readDict(@NotNull XmlElement dictElement) throws IOException {
        if (dictElement == null) {
            XmlPlistReader.$$$reportNull$$$0(2);
        }
        Plist dict = new Plist();
        List children = dictElement.children;
        for (int i = 0; i < children.size(); ++i) {
            PListValue value;
            XmlElement keyElement = (XmlElement)children.get(i);
            if (!"key".equals(keyElement.name)) continue;
            String attributeKey = keyElement.content;
            PListValue pListValue = value = attributeKey != null ? XmlPlistReader.readValue(attributeKey, (XmlElement)children.get(++i)) : null;
            if (value == null) continue;
            dict.setEntry(attributeKey, value);
        }
        return PListValue.value(dict, PlistValueType.DICT);
    }

    @Nullable
    private static PListValue readValue(@NotNull String key, @NotNull XmlElement valueElement) throws IOException {
        String type;
        if (key == null) {
            XmlPlistReader.$$$reportNull$$$0(3);
        }
        if (valueElement == null) {
            XmlPlistReader.$$$reportNull$$$0(4);
        }
        if ("dict".equals(type = valueElement.name)) {
            return XmlPlistReader.readDict(valueElement);
        }
        if ("array".equals(type)) {
            return XmlPlistReader.readArray(key, valueElement);
        }
        return XmlPlistReader.readBasicValue(type, valueElement);
    }

    private static PListValue readArray(String key, XmlElement element) throws IOException {
        ArrayList<PListValue> result = new ArrayList<PListValue>();
        for (XmlElement child : element.children) {
            PListValue val = XmlPlistReader.readValue(key, child);
            if (val == null) continue;
            result.add(val);
        }
        return PListValue.value(result, PlistValueType.ARRAY);
    }

    @Nullable
    private static PListValue readBasicValue(@NotNull String type, @NotNull XmlElement valueElement) throws IOException {
        if (type == null) {
            XmlPlistReader.$$$reportNull$$$0(5);
        }
        if (valueElement == null) {
            XmlPlistReader.$$$reportNull$$$0(6);
        }
        String content = valueElement.content;
        if ("string".equals(type) && content != null) {
            return PListValue.value(Strings.unescapeXmlEntities((String)content), PlistValueType.STRING);
        }
        if ("true".equals(type)) {
            return PListValue.value(Boolean.TRUE, PlistValueType.BOOLEAN);
        }
        if ("false".equals(type)) {
            return PListValue.value(Boolean.FALSE, PlistValueType.BOOLEAN);
        }
        if ("integer".equals(type) && content != null) {
            return PListValue.value(Integer.parseInt(content), PlistValueType.INTEGER);
        }
        if ("real".equals(type) && content != null) {
            return PListValue.value(Double.parseDouble(content), PlistValueType.REAL);
        }
        if ("date".equals(type) && content != null) {
            try {
                return PListValue.value(Plist.dateFormatter().parse(content), PlistValueType.DATE);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/plist/XmlPlistReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "internalRead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readDict";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "readBasicValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

