/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramBuilderFactory;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramNodeEditingManager;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.diagram.settings.DiagramLayoutOnCategorySwitch;
import com.intellij.diagram.state.DiagramLayoutSnapshot;
import com.intellij.diagram.util.DiagramUpdateService;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.services.GraphUndoService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.PlatformUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlCategorySwitcher
extends DiagramAction
implements Toggleable {
    private static final int UPDATE_REALIZERS_LATENCY_MILLIS = 1000;
    @NotNull
    private final DiagramCategory myCategory;
    @NotNull
    private final DiagramBuilder myBuilder;

    public UmlCategorySwitcher(@NotNull DiagramCategory category, @NotNull DiagramBuilder builder) {
        if (category == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(1);
        }
        super(category.getName(), "", category.getIcon());
        this.myCategory = category;
        this.myBuilder = builder;
    }

    @Override
    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(2);
        }
        return this.myCategory.isRefreshDataModel();
    }

    @Override
    public void perform(@Nullable AnActionEvent e) {
        DiagramNodeEditingManager.getInstance().stopEditing(this.myBuilder);
        if (this.myCategory.isRefreshDataModel() || this.myCategory.isUpdateNodePresentations()) {
            this.switchWithDataModelRebuild(!this.isSelected());
        } else {
            this.switchWithoutDataModelRebuild(!this.isSelected());
        }
    }

    protected void switchWithoutDataModelRebuild(boolean enabled) {
        GraphUndoService.getInstance().performPositionsOnlyChangingAction(this.myBuilder.getGraphBuilder(), this.getActionName(), (recordUndoRealizers, recordRedoRealizers) -> {
            recordUndoRealizers.run();
            this.doSwitchCategory(enabled);
            ((CompletableFuture)((CompletableFuture)this.runCategorySwitchedCallbacksAsync(enabled, () -> this.myBuilder.queryUpdate().withPresentationUpdate().withAllNodeSizeUpdate().run()).whenCompleteAsync((__, ___) -> recordRedoRealizers.run(), Futures.inEdt())).thenComposeAsync(ThreadContext.captureThreadContext(__ -> UmlCategorySwitcher.updateModelBuilderIfNeededAsync(this.myBuilder, enabled)))).whenComplete(Futures.logIfFailed(UmlCategorySwitcher.class));
        }, restoreRealizers -> {
            this.doSwitchCategory(!enabled);
            restoreRealizers.run();
            this.myBuilder.queryUpdate().withPresentationUpdate().run();
        }, restoreRealizers -> {
            this.doSwitchCategory(enabled);
            restoreRealizers.run();
            this.myBuilder.queryUpdate().withPresentationUpdate().run();
        });
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletableFuture<Void> updateModelBuilderIfNeededAsync(@NotNull DiagramBuilder builder, boolean doRemoveOverlaps) {
        if (builder == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(3);
        }
        DiagramBuilder modelBuilder = DiagramBuilderFactory.getInstance().getModelBuilder(builder);
        Layouter layouter = UmlCategorySwitcher.getLayouterForCategorySwitch(modelBuilder, doRemoveOverlaps);
        if (modelBuilder != builder && layouter != null) {
            CompletableFuture<Void> completableFuture = modelBuilder.queryUpdate().withPresentationUpdate().withAllNodeSizeUpdate().withRelayout(layouter).runAsync();
            if (completableFuture == null) {
                UmlCategorySwitcher.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(5);
        }
        return completableFuture;
    }

    protected void switchWithDataModelRebuild(boolean enabled) {
        this.doSwitchCategory(enabled);
        DiagramLayoutSnapshot snapshot = DiagramLayoutSnapshot.Factory.getInstance().makeSnapshot(this.myBuilder);
        boolean updateNodePresentations = this.myCategory.isUpdateNodePresentations();
        CompletableFuture<Void> future = DiagramUpdateService.getInstance().requestDataModelRefreshPreservingLayout(this.myBuilder, snapshot, updateNodePresentations).withAllNodeSizeUpdate().runAsync();
        if (updateNodePresentations) {
            future.whenComplete((unused, throwable) -> Futures.runInEdtAsync(() -> this.switchWithoutDataModelRebuild(enabled)));
        }
    }

    private void doSwitchCategory(boolean enabled) {
        DiagramNodeContentManager nodeContentManager = this.myBuilder.getDataModel().getNodeContentManager();
        nodeContentManager.setCategoryEnabled(this.myCategory, enabled);
        nodeContentManager.onCategoryEnabled(this.myCategory, enabled);
    }

    @NotNull
    private CompletableFuture<Void> runCategorySwitchedCallbacksAsync(boolean enabled, @NotNull Runnable updateRealizers) {
        if (updateRealizers == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(6);
        }
        CompletableFuture afterLayoutAndRealizersChange = this.myBuilder.isPopupMode() || this.myCategory.isRefreshLayout() ? UmlCategorySwitcher.relayoutOnCategorySwitchAsync(this.myBuilder, enabled, updateRealizers) : Futures.runInEdtAsync((Runnable)updateRealizers);
        CompletionStage completionStage = afterLayoutAndRealizersChange.thenRunAsync(() -> {
            if (!this.myCategory.isRefreshLayout() && this.myCategory.isFitContent()) {
                if (PlatformUtils.isRider()) {
                    this.myBuilder.getGraph().fitGraph2DView();
                } else {
                    GraphAnimationService.getInstance().fitContent(this.myBuilder.getView(), true);
                }
            }
        }, Futures.inEdt());
        if (completionStage == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(7);
        }
        return completionStage;
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletableFuture<Void> relayoutOnCategorySwitchAsync(@NotNull DiagramBuilder builder, boolean doRemoveOverlaps, @NotNull Runnable updateRealizers) {
        Layouter layouter;
        if (builder == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(8);
        }
        if (updateRealizers == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(9);
        }
        if ((layouter = UmlCategorySwitcher.getLayouterForCategorySwitch(builder, doRemoveOverlaps)) != null) {
            CompletableFuture completableFuture = GraphLayoutService.getInstance().queryLayoutWithRealizersChange(builder.getGraphBuilder(), doRemoveOverlaps, updateRealizers).animated().withAnimationDuration((doRemoveOverlaps ? 1000 : 0) + GraphAnimationService.getInstance().getLayoutAnimationDuration()).withLayouter(layouter).withFitContent(doRemoveOverlaps ? GraphLayoutService.GraphLayoutQueryParams.FitContentOption.BEFORE : GraphLayoutService.GraphLayoutQueryParams.FitContentOption.AFTER).runAsync();
            if (completableFuture == null) {
                UmlCategorySwitcher.$$$reportNull$$$0(10);
            }
            return completableFuture;
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(11);
        }
        return completableFuture;
    }

    @Nullable
    private static Layouter getLayouterForCategorySwitch(@NotNull DiagramBuilder builder, boolean doRemoveOverlaps) {
        if (builder == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(12);
        }
        Layouter layouter = switch (DiagramConfiguration.getInstance().getLayoutOnCategorySwitch()) {
            default -> throw new IncompatibleClassChangeError();
            case DiagramLayoutOnCategorySwitch.WITH_CURRENT_LAYOUTER -> builder.getPresentationModel().getSettings().getCurrentLayouter();
            case DiagramLayoutOnCategorySwitch.WITH_LIGHT_LAYOUTER -> GraphLayoutService.getInstance().getPolishingCurrentLayoutLayouter(builder.getGraphBuilder(), !doRemoveOverlaps);
            case DiagramLayoutOnCategorySwitch.NEVER -> null;
        };
        return layouter;
    }

    @Override
    @NotNull
    public String getActionName() {
        String string = this.isSelected() ? DiagramBundle.message("action.name.disable.category", this.myCategory.getName()) : DiagramBundle.message("action.name.enable.category", this.myCategory.getName());
        if (string == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(13);
        }
        return string;
    }

    private boolean isSelected() {
        return this.myBuilder.getDataModel().getNodeContentManager().isCategoryEnabled(this.myCategory);
    }

    @Override
    public boolean isSelected(@NotNull AnActionEvent e, @NotNull DiagramBuilder b) {
        if (e == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(14);
        }
        if (b == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(15);
        }
        return this.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 10, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/UmlCategorySwitcher";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateRealizers";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/UmlCategorySwitcher";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "updateModelBuilderIfNeededAsync";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "runCategorySwitchedCallbacksAsync";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "relayoutOnCategorySwitchAsync";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUndoable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateModelBuilderIfNeededAsync";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runCategorySwitchedCallbacksAsync";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "relayoutOnCategorySwitchAsync";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLayouterForCategorySwitch";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 10, 11, 13 -> new IllegalStateException(string);
        };
    }
}

