/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.analysis;

import com.intellij.diagnostic.Checks;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.state.DiagramNodeIdentity;
import com.intellij.diagram.util.DiagramAlgorithmsService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.graph.GraphLayoutOrientation;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.impl.GraphNotifications;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.focusview.GraphFocusOnNodesView;
import com.intellij.openapi.graph.view.focusview.GraphFocusViewProvider;
import com.intellij.openapi.project.Project;
import com.intellij.uml.core.actions.analysis.DiagramAbstractEnableFocusViewAction;
import com.intellij.uml.core.actions.analysis.DiagramFocusViewOnPathBetweenTwoNodesDialog;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramFocusViewOnPathsBetweenTwoNodesAction
extends DiagramAbstractEnableFocusViewAction {
    @Override
    protected @NotNull CompletableFuture<@Nullable GraphFocusViewProvider> createFocusViewProviderAsync(@NotNull DiagramBuilder modelBuilder) {
        List selectedNodes;
        if (modelBuilder == null) {
            DiagramFocusViewOnPathsBetweenTwoNodesAction.$$$reportNull$$$0(0);
        }
        Checks.require(((selectedNodes = GraphSelectionService.getInstance().getSelectedNodes(modelBuilder.getGraph())).size() == 2 ? 1 : 0) != 0);
        DiagramNode<?> source = Objects.requireNonNull(modelBuilder.getNodeObject((Node)selectedNodes.get(0)));
        DiagramNode<?> target = Objects.requireNonNull(modelBuilder.getNodeObject((Node)selectedNodes.get(1)));
        DiagramAlgorithmsService.PathFindingParams requestParams = new DiagramAlgorithmsService.PathFindingParams(source, target, DiagramAlgorithmsService.PathDirection.DIRECTED_BOTH, DiagramAlgorithmsService.PathFilter.All.getInstance());
        CompletionStage completionStage = ((CompletableFuture)new DiagramFocusViewOnPathBetweenTwoNodesDialog(requestParams, modelBuilder.getProject()).showAsync().thenComposeAsync(__ -> DiagramAlgorithmsService.getInstance().findNodesWhichBelongToAnyPathBetweenTwoNodesAsync(modelBuilder, requestParams), Futures.inEdt())).thenApplyAsync(nodes -> this.createFocusViewProviderForComputedNodes(modelBuilder, (Set<DiagramNode<?>>)nodes), Futures.inEdt());
        if (completionStage == null) {
            DiagramFocusViewOnPathsBetweenTwoNodesAction.$$$reportNull$$$0(1);
        }
        return completionStage;
    }

    @RequiresEdt
    @Nullable
    private GraphFocusOnNodesView<Object, Object> createFocusViewProviderForComputedNodes(@NotNull DiagramBuilder modelBuilder, @NotNull Set<DiagramNode<?>> nodes) {
        if (modelBuilder == null) {
            DiagramFocusViewOnPathsBetweenTwoNodesAction.$$$reportNull$$$0(2);
        }
        if (nodes == null) {
            DiagramFocusViewOnPathsBetweenTwoNodesAction.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (nodes.isEmpty()) {
            Notification noPathHasBeenFoundNotification = GraphNotifications.getGeneralGroup().createNotification(DiagramBundle.message("diagram.focus.view.no.path.has.been.found.notification", new Object[0]), NotificationType.INFORMATION);
            Notifications.Bus.notifyAndHide((Notification)noPathHasBeenFoundNotification, (Project)modelBuilder.getProject());
            return null;
        }
        return new GraphFocusOnNodesView(ContainerUtil.map2Set(nodes, it -> DiagramNodeIdentity.of(it)), DiagramFocusViewOnPathsBetweenTwoNodesAction::customizeViewSettings);
    }

    private static void customizeViewSettings(@NotNull GraphSettings viewSettings) {
        if (viewSettings == null) {
            DiagramFocusViewOnPathsBetweenTwoNodesAction.$$$reportNull$$$0(4);
        }
        viewSettings.setCurrentLayouter((Layouter)GraphLayoutService.getInstance().getSeriesParallelLayouter());
        viewSettings.setCurrentLayoutOrientation(GraphLayoutOrientation.TOP_TO_BOTTOM);
    }

    @Override
    protected boolean canBeEnabledFor(@NotNull DiagramBuilder modelBuilder) {
        if (modelBuilder == null) {
            DiagramFocusViewOnPathsBetweenTwoNodesAction.$$$reportNull$$$0(5);
        }
        return GraphSelectionService.getInstance().getSelectedNodes(modelBuilder.getGraph()).size() == 2;
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            DiagramFocusViewOnPathsBetweenTwoNodesAction.$$$reportNull$$$0(6);
        }
        return actionUpdateThread;
    }

    @Override
    @Nls
    @NotNull
    public String getActionName() {
        String string = DiagramBundle.message("action.Diagram.AnalyzeGraph.FocusOnPathsBetweenTwoNodes.text", new Object[0]);
        if (string == null) {
            DiagramFocusViewOnPathsBetweenTwoNodesAction.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelBuilder";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/analysis/DiagramFocusViewOnPathsBetweenTwoNodesAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/analysis/DiagramFocusViewOnPathsBetweenTwoNodesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFocusViewProviderAsync";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFocusViewProviderAsync";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFocusViewProviderForComputedNodes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "customizeViewSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canBeEnabledFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7 -> new IllegalStateException(string);
        };
    }
}

