/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssClassOrIdReference
extends PsiPolyVariantReferenceBase<PsiElement>
implements CssReference {
    public CssClassOrIdReference(PsiElement element, @Nullable TextRange range) {
        super(element, range, true);
    }

    protected TextRange calculateDefaultRangeInElement() {
        TextRange range = super.calculateDefaultRangeInElement();
        boolean id = this.isId();
        if (range.isEmpty()) {
            return range;
        }
        if (id && this.hasExplicitIdMark() || !id && this.hasExplicitClassMark()) {
            range = new TextRange(range.getStartOffset() + 1, range.getEndOffset());
        }
        return range;
    }

    protected boolean hasExplicitIdMark() {
        return true;
    }

    protected boolean hasExplicitClassMark() {
        return false;
    }

    public Object @NotNull [] getVariants() {
        CssSelectorSuffixType selectorType = this.isId() ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
        Project project = this.myElement.getProject();
        GlobalSearchScope scope = this.getSearchScope();
        ArrayList result = new ArrayList();
        CssIndexUtil.processAllSelectorNamesInScope(selectorType, project, scope, (Processor<? super String>)((Processor)suffix -> {
            result.add(LookupElementBuilder.create((String)suffix).withIcon(selectorType.getIcon()));
            return true;
        }));
        CssIndexUtil.processSelectorNamesFromHtmlAttributes(project, scope, (Processor<? super String>)((Processor)suffix -> {
            if (suffix.length() < 2) {
                return true;
            }
            if (selectorType == CssSelectorSuffixType.CLASS && StringUtil.startsWithChar((CharSequence)suffix, (char)'.') || selectorType == CssSelectorSuffixType.ID && StringUtil.startsWithChar((CharSequence)suffix, (char)'#')) {
                result.add(CssCompletionUtil.lookupForSelectorSuffixFromHtml(suffix.substring(1), selectorType, this.getElement().getContainingFile(), null, project));
            }
            return true;
        }));
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            CssClassOrIdReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    protected GlobalSearchScope getSearchScope() {
        return CssUtil.getCompletionAndResolvingScopeForElement(this.myElement);
    }

    public abstract boolean isId();

    public boolean isSoft() {
        return true;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CssBundle.message(this.isId() ? "invalid.css.id.reference" : "invalid.css.class.reference", new Object[0]);
        if (string == null) {
            CssClassOrIdReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        Project project = this.myElement.getProject();
        String text = this.getCanonicalText();
        CssSelectorSuffixType selectorType = this.isId() ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
        ArrayList result = new ArrayList();
        CssIndexUtil.processSelectorSuffixes(selectorType, text, project, this.getSearchScope(), (PairProcessor<? super String, ? super CssSelectorSuffix>)((PairProcessor)(name, selectorSuffix) -> result.add(new PsiElementResolveResult((PsiElement)selectorSuffix))));
        ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            CssClassOrIdReference.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/css/resolve/CssClassOrIdReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

