/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.tables;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.tables.JupyterInlayPanelInfo;
import com.intellij.jupyter.tables.JupyterTableCommandExecutor;
import com.intellij.jupyter.tables.JupyterTableCommandExecutorKt;
import com.intellij.jupyter.tables.JupyterTableOutputDataKey;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.scientific.tables.DSTableDataManager;
import com.intellij.scientific.tables.DataId;
import com.intellij.scientific.tables.api.DSPanelInfo;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DSTableOutputData;
import com.intellij.scientific.tables.editor.DSTableFileEditorKt;
import java.awt.BorderLayout;
import java.awt.event.ContainerListener;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0016J.\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010$\u001a\u00020\u0018H\u0002J\b\u0010%\u001a\u00020\u0018H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0018\u0010\u001f\u001a\t\u0018\u00010 \u00a2\u0006\u0002\b!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lcom/intellij/jupyter/tables/JupyterTableOutputComponent;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "dataId", "Lcom/intellij/scientific/tables/DataId;", "disposed", "", "dataKey", "Lcom/intellij/jupyter/tables/JupyterTableOutputDataKey;", "getDataKey", "()Lcom/intellij/jupyter/tables/JupyterTableOutputDataKey;", "setDataKey", "(Lcom/intellij/jupyter/tables/JupyterTableOutputDataKey;)V", "isEmpty", "()Z", "setEmpty", "(Z)V", "updateUI", "", "addData", "newData", "isDynamicTable", "isLastComponent", "containerListener", "Ljava/awt/event/ContainerListener;", "dimensionText", "", "Lcom/intellij/openapi/util/NlsSafe;", "getDimensionText", "()Ljava/lang/String;", "cleanCurrentData", "dispose", "intellij.jupyter.tables"})
@SourceDebugExtension(value={"SMAP\nJupyterTableOutputComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterTableOutputComponent.kt\ncom/intellij/jupyter/tables/JupyterTableOutputComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class JupyterTableOutputComponent
extends JPanel
implements Disposable {
    @NotNull
    private final EditorImpl editor;
    @Nullable
    private DataId dataId;
    private boolean disposed;
    @Nullable
    private JupyterTableOutputDataKey dataKey;
    private boolean isEmpty;

    public JupyterTableOutputComponent(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(new BorderLayout());
        this.editor = editor;
        this.isEmpty = true;
        this.putClientProperty("AuxEditorComponent", true);
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @Nullable
    public final JupyterTableOutputDataKey getDataKey() {
        return this.dataKey;
    }

    public final void setDataKey(@Nullable JupyterTableOutputDataKey jupyterTableOutputDataKey) {
        this.dataKey = jupyterTableOutputDataKey;
    }

    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public final void setEmpty(boolean bl) {
        this.isEmpty = bl;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setOpaque(false);
    }

    public final void addData(@NotNull EditorImpl editor, @NotNull JupyterTableOutputDataKey newData, boolean isDynamicTable, boolean isLastComponent, @NotNull ContainerListener containerListener) {
        Integer executionCount;
        Integer n;
        VirtualFile virtualFile;
        Project project;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)newData, (String)"newData");
                Intrinsics.checkNotNullParameter((Object)containerListener, (String)"containerListener");
                Project project2 = editor.getProject();
                if (project2 == null) {
                    return;
                }
                project = project2;
                virtualFile = editor.getVirtualFile();
                if (virtualFile == null) break block7;
                VirtualFile virtualFile2 = virtualFile;
                BackedNotebookVirtualFile.Companion companion = BackedNotebookVirtualFile.Companion;
                VirtualFile p0 = virtualFile2;
                boolean $i$f$addData$stub_for_inlining = false;
                boolean bl = false;
                BackedNotebookVirtualFile backedNotebookVirtualFile = companion.takeIfBacked(p0);
                virtualFile = backedNotebookVirtualFile;
                if (backedNotebookVirtualFile != null) break block8;
            }
            return;
        }
        VirtualFile notebookFile = virtualFile;
        this.dataKey = newData;
        DataId dataId = this.dataId;
        if (dataId != null) {
            DataId it = dataId;
            boolean bl = false;
            this.cleanCurrentData();
        }
        if ((n = newData.getExecutionCount()) == null) {
            n = notebookFile.getNotebook().getCell(newData.getInterval().getOrdinal()).getExecutionCount();
        }
        Integer n2 = executionCount = n;
        Object outName = n2 != null ? "Out " + n2 : DSTableFileEditorKt.getDEFAULT_EDITOR_TAB_NAME();
        String editorTabName = notebookFile.getFile().getNameWithoutExtension() + ": " + (String)outName;
        this.isEmpty = false;
        ApplicationManager.getApplication().executeOnPooledThread(() -> JupyterTableOutputComponent.addData$lambda$2(this, editor, isLastComponent, containerListener, project, (BackedNotebookVirtualFile)notebookFile, newData, executionCount, editorTabName, isDynamicTable));
    }

    @Nullable
    public final String getDimensionText() {
        Project project = this.editor.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        DataId dataId = this.dataId;
        if (dataId == null) {
            return null;
        }
        DataId dataId2 = dataId;
        return DSTableDataManager.Companion.getInstance(project2).getDimensionText(dataId2);
    }

    private final void cleanCurrentData() {
        DataId dataId = this.dataId;
        if (dataId != null) {
            DataId it = dataId;
            boolean bl = false;
            Project project = this.editor.getProject();
            if (project != null) {
                Project project2 = project;
                boolean bl2 = false;
                DSTableDataManager.Companion.getInstance(project2).removeData(it);
            }
        }
        this.dataId = null;
    }

    public void dispose() {
        this.cleanCurrentData();
        this.disposed = true;
    }

    private static final IntRange addData$lambda$2$lambda$1(JupyterTableOutputDataKey $newData) {
        return $newData.getInterval().getLines();
    }

    private static final void addData$lambda$2(JupyterTableOutputComponent this$0, EditorImpl $editor, boolean $isLastComponent, ContainerListener $containerListener, Project $project, BackedNotebookVirtualFile $notebookFile, JupyterTableOutputDataKey $newData, Integer $executionCount, String $editorTabName, boolean $isDynamicTable) {
        if (!this$0.disposed) {
            JupyterInlayPanelInfo panelInfo = new JupyterInlayPanelInfo(this$0, $editor, () -> JupyterTableOutputComponent.addData$lambda$2$lambda$1($newData), $isLastComponent, this$0, false, false, false, false, 480, null);
            panelInfo.getMainPanel().addContainerListener($containerListener);
            JupyterTableCommandExecutor commandExecutor = new JupyterTableCommandExecutor($project, $notebookFile, $newData.getCellPointer(), (Editor)$editor);
            Integer n = $executionCount;
            String varName = n == null ? null : JupyterTableCommandExecutorKt.getContentName(n);
            DSTableOutputData outputData = new DSTableOutputData(varName, $editorTabName, $newData.getData(), $newData.getDataType());
            this$0.dataId = DSTableDataManager.addNewTableData$default((DSTableDataManager)DSTableDataManager.Companion.getInstance($project), (Project)$project, (DSTableCommandExecutor)commandExecutor, (DSTableOutputData)outputData, (DSPanelInfo)panelInfo, (boolean)$isDynamicTable, null, (int)32, null);
        }
    }
}

