/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.notification;

import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.ide.notification.GrazieToastNotifications;
import com.intellij.grazie.ide.notification.IgnoreAction;
import com.intellij.grazie.ide.notification.InstallGrazieProfessionalAction;
import com.intellij.grazie.ide.notification.RemindLaterAction;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u000f\u001a\u00020\u0006H\u0002\u001a\b\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\b\u0010\u0012\u001a\u00020\u0011H\u0002\u001a\b\u0010\u0013\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"grazieProfessionalPluginId", "Lcom/intellij/openapi/extensions/PluginId;", "Lorg/jetbrains/annotations/NotNull;", "getGrazieProfessionalPluginId", "()Lcom/intellij/openapi/extensions/PluginId;", "isGrazieProfessionalInstalled", "", "()Z", "NOTIFICATION_SHOWN", "", "IGNORE_DELAY", "", "INVOCATION_COUNT", "SHOW_AFTER_INVOCATIONS", "", "shouldShow", "markDelayed", "", "markShown", "obtainInvocationCount", "updateInvocationCount", "count", "advertiseGrazieProfessional", "project", "Lcom/intellij/openapi/project/Project;", "intellij.grazie.core"})
public final class GrazieProAdvertisementKt {
    @NotNull
    private static final String NOTIFICATION_SHOWN = "Grazie.Professional.Advertisement.Shown";
    private static final long IGNORE_DELAY = Duration.ofDays(14L).toMillis();
    @NotNull
    private static final String INVOCATION_COUNT = "Grazie.Professional.Advertisement.Invoked";
    private static final int SHOW_AFTER_INVOCATIONS = 3;

    private static final PluginId getGrazieProfessionalPluginId() {
        PluginId pluginId = PluginId.getId((String)"com.intellij.grazie.pro");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        return pluginId;
    }

    private static final boolean isGrazieProfessionalInstalled() {
        return PluginManager.isPluginInstalled((PluginId)GrazieProAdvertisementKt.getGrazieProfessionalPluginId());
    }

    private static final boolean shouldShow() {
        long timestamp = PropertiesComponent.getInstance().getLong(NOTIFICATION_SHOWN, 0L);
        if (timestamp < 0L) {
            return false;
        }
        long current = System.currentTimeMillis();
        return current - timestamp > IGNORE_DELAY;
    }

    private static final void markDelayed() {
        PropertiesComponent.getInstance().setValue(NOTIFICATION_SHOWN, String.valueOf(System.currentTimeMillis()));
    }

    private static final void markShown() {
        PropertiesComponent.getInstance().setValue(NOTIFICATION_SHOWN, "-1");
    }

    private static final int obtainInvocationCount() {
        return PropertiesComponent.getInstance().getInt(INVOCATION_COUNT, 0);
    }

    private static final void updateInvocationCount(int count) {
        PropertiesComponent.getInstance().setValue(INVOCATION_COUNT, String.valueOf(count));
    }

    public static final void advertiseGrazieProfessional(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (GrazieProAdvertisementKt.isGrazieProfessionalInstalled() || ApplicationKt.getApplication().isUnitTestMode() || !GrazieProAdvertisementKt.shouldShow()) {
            return;
        }
        int invocationCount = GrazieProAdvertisementKt.obtainInvocationCount();
        if (invocationCount < 3) {
            GrazieProAdvertisementKt.updateInvocationCount(invocationCount + 1);
            return;
        }
        GrazieProAdvertisementKt.markDelayed();
        ActionsKt.invokeLater$default(null, () -> GrazieProAdvertisementKt.advertiseGrazieProfessional$lambda$0(project), (int)1, null);
    }

    private static final Unit advertiseGrazieProfessional$lambda$0(Project $project) {
        String text2 = GrazieBundle.message("grazie.notification.pro.advertisement.text", new Object[0]);
        NotificationGroup group = GrazieToastNotifications.INSTANCE.getGENERAL_GROUP$intellij_grazie_core();
        group.createNotification(text2, NotificationType.INFORMATION).setTitle(GrazieBundle.message("grazie.notification.pro.advertisement.title", new Object[0])).addAction((AnAction)new InstallGrazieProfessionalAction()).addAction((AnAction)new RemindLaterAction()).addAction((AnAction)new IgnoreAction()).setSuggestionType(true).setDisplayId("grazie.pro.advertisement").notify($project);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$markDelayed() {
        GrazieProAdvertisementKt.markDelayed();
    }

    public static final /* synthetic */ void access$markShown() {
        GrazieProAdvertisementKt.markShown();
    }

    public static final /* synthetic */ PluginId access$getGrazieProfessionalPluginId() {
        return GrazieProAdvertisementKt.getGrazieProfessionalPluginId();
    }
}

