/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.GlobalConfig;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.en.AbstractEnglishSpellerRule;
import org.languagetool.rules.en.VariantInfo;

public final class MorfologikAmericanSpellerRule
extends AbstractEnglishSpellerRule {
    public static final String RULE_ID = "MORFOLOGIK_RULE_EN_US";
    private static final String RESOURCE_FILENAME = "/en/hunspell/en_US.dict";
    private static final String LANGUAGE_SPECIFIC_PLAIN_TEXT_DICT = "en/hunspell/spelling_en-US.txt";
    private static final Map<String, String> BRITISH_ENGLISH = MorfologikAmericanSpellerRule.loadWordlist("en/en-US-GB.txt", 1);

    public MorfologikAmericanSpellerRule(ResourceBundle messages, Language language) throws IOException {
        this(messages, language, null, null, Collections.emptyList(), null, null);
    }

    public MorfologikAmericanSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        this(messages, language, null, userConfig, altLanguages, null, null);
    }

    public MorfologikAmericanSpellerRule(ResourceBundle messages, Language language, GlobalConfig globalConfig, UserConfig userConfig, List<Language> altLanguages, LanguageModel languageModel, Language motherTongue) throws IOException {
        super(messages, language, globalConfig, userConfig, altLanguages, languageModel, motherTongue);
    }

    @Override
    protected VariantInfo isValidInOtherVariant(String word) {
        String otherVariant = BRITISH_ENGLISH.get(word.toLowerCase());
        if (otherVariant != null) {
            return new VariantInfo("British English", otherVariant);
        }
        return null;
    }

    @Override
    public String getFileName() {
        return RESOURCE_FILENAME;
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public String getLanguageVariantSpellingFileName() {
        return LANGUAGE_SPECIFIC_PLAIN_TEXT_DICT;
    }

    @Override
    protected List<SuggestedReplacement> getAdditionalTopSuggestions(List<SuggestedReplacement> suggestions, String word) throws IOException {
        List<String> s = null;
        if ("automize".equals(word)) {
            s = Arrays.asList("automate");
        } else if ("automized".equals(word)) {
            s = Arrays.asList("automated");
        } else if ("automizing".equals(word)) {
            s = Arrays.asList("automating");
        } else if ("automizes".equals(word)) {
            s = Arrays.asList("automates");
        }
        if (s != null) {
            return SuggestedReplacement.convert(s);
        }
        return super.getAdditionalTopSuggestions(suggestions, word);
    }
}

