/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.timeline;

import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.ZoomableViewport;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.JViewport;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0010\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0012\u0010\u0017\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/intellij/profiler/ui/timeline/ScrollableMouseAdapter;", "Ljava/awt/event/MouseAdapter;", "Lcom/intellij/ui/components/Magnificator;", "<init>", "()V", "pressed", "Ljava/awt/Point;", "getPressed", "()Ljava/awt/Point;", "setPressed", "(Ljava/awt/Point;)V", "mousePressed", "", "event", "Ljava/awt/event/MouseEvent;", "mouseDragged", "mouseReleased", "mouseWheelMoved", "e", "Ljava/awt/event/MouseWheelEvent;", "mouseClicked", "mouseMoved", "mouseExited", "mouseEntered", "magnify", "scale", "", "at", "Companion", "intellij.profiler.common"})
public class ScrollableMouseAdapter
extends MouseAdapter
implements Magnificator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Point pressed;
    public static final double ZOOM_SCALE_FACTOR = 1.2;

    @Nullable
    protected final Point getPressed() {
        return this.pressed;
    }

    protected final void setPressed(@Nullable Point point) {
        this.pressed = point;
    }

    @Override
    public void mousePressed(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getButton() == 1) {
            this.pressed = event.getPoint();
        }
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getSource();
        JViewport vp = ComponentUtil.getViewport((Component)(object instanceof JComponent ? (JComponent)object : null));
        if (this.pressed != null && vp != null) {
            Point position = vp.getViewPosition();
            int n = event.getX();
            Point point = this.pressed;
            Intrinsics.checkNotNull((Object)point);
            int xOffset = n - point.x;
            int n2 = event.getY();
            Point point2 = this.pressed;
            Intrinsics.checkNotNull((Object)point2);
            int yOffset = n2 - point2.y;
            int newX = Math.max(Math.min(position.x - xOffset, vp.getView().getWidth() - vp.getWidth()), 0);
            int newY = Math.max(Math.min(position.y - yOffset, vp.getView().getHeight() - vp.getHeight()), 0);
            vp.setViewPosition(new Point(newX, newY));
        }
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.pressed = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (ProfilerUIUtilsKt.isZoomKeyDown(e)) {
            Point p = e.getPoint();
            int sign = e.getWheelRotation();
            ZoomableViewport zoomable = (ZoomableViewport)ComponentUtil.getParentOfType(ZoomableViewport.class, (Component)e.getComponent());
            ZoomableViewport zoomableViewport = zoomable;
            if (zoomableViewport == null || (zoomableViewport = zoomableViewport.getMagnificator()) == null) return;
            ZoomableViewport it = zoomableViewport;
            boolean bl = false;
            if (sign < 0) {
                it.magnify(1.2, p);
                return;
            } else {
                if (sign <= 0) return;
                it.magnify(0.8333333333333334, p);
            }
            return;
        } else {
            e.getComponent().getParent().dispatchEvent(e);
        }
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void mouseExited(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void mouseEntered(@Nullable MouseEvent e) {
    }

    @NotNull
    public Point magnify(double scale, @NotNull Point at) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return at;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/ui/timeline/ScrollableMouseAdapter$Companion;", "", "<init>", "()V", "ZOOM_SCALE_FACTOR", "", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

