/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.portForwarding.utils.WindowsProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 39807076584131L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1319743830 - -((char)-9190), -1319612760 + -((char)-6442), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1319743830 - -((char)-9189), -1319612760 + -((char)-10090), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 99732226302868L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.Y();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (!bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1209251820 + 19365, 1209251820 + (char)-19426, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1209251820 + 19364, 1209251820 + 19681, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1209251820 + 19371, -1209251820 + -((char)-22077), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 83353290904476L;
                            Object object = this.lock;
                            synchronized (object) {
                                boolean bl3;
                                bl2 = SshAgentIpcService.B();
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-860605620 - -16466, 860605620 + 9534, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-860605620 - -16465, -860605620 + -4769, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    windowsNamedPipeAgentIpc = this;
                                    if (bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-860605620 - -16464, 860605620 + 12662, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-860605620 - -16455, -860605620 - -2283, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-860605620 - -16454, 860605620 - 15521, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-860605620 - -16464, 860605620 + 12662, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-860605620 - -16453, -860605620 + -2106, (int)l2));
                            if (ActionTimestamp.Y() == null) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.Y(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 72509532404126L;
                    bl = SshAgentIpcService.Y();
                    try {
                        try {
                            n = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (!bl) break block6;
                            if (n < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (!bl) break block8;
                    if (n > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n = 1;
                break block8;
            }
            n = 0;
        }
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        boolean bl;
        long l2;
        block27: {
            block28: {
                l2 = 114061027467417L;
                boolean bl2 = SshAgentIpcService.Y();
                this.assertConnectionThread();
                bl = bl2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl4 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (!bl) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(419030790 - 26225, 419030790 - 1674, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(419030790 - 26221, -419030790 + -3019, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(419030790 - 26228, 419030790 + 3195, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(419030790 - 26221, -419030790 + -3019, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(419030790 - 26227, 419030790 - 4824, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(419030790 - 26225, 419030790 - 1674, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(419030790 - 26221, -419030790 + -3019, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(419030790 - 26230, -419030790 - -13760, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (!bl) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n = Kernel32.INSTANCE.GetLastError();
                if (n == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl8 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(419030790 - 26225, 419030790 - 1674, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(419030790 - 26221, -419030790 + -3019, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(419030790 - 26229, -419030790 - -2331, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(419030790 - 26221, -419030790 + -3019, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(419030790 - 26232, -419030790 + -2614, (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl9;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl10 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (!bl) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl9 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl9) {
                boolean bl11 = false;
                String string = WindowsNamedPipeAgentIpc.b(419030790 - 26221, -419030790 + -3019, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(419030790 - 26227, 419030790 - 4824, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl12 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(419030790 - 26225, 419030790 - 1674, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(419030790 - 26221, -419030790 + -3019, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(419030790 - 26231, 419030790 - 10464, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 87322141124090L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1161018060 + -8620, 1161018060 - 1425, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 5337587412116L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1056948480 - 5657, 1056948480 - 15880, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "yl\u009f\u0013Q\u009eLV\u00c4 \u00cd\u00ce\b\u00cd\u00eb\u0092\u001a\u0089\u00d4\u0014V\u00b2z\u00ce\u00f6\u00e7\u00c5\u00fcws~p\u00bc\u00e3\u00bc\u00dc\u001d\u00863\u00fe";
                        var4_3 = "yl\u009f\u0013Q\u009eLV\u00c4 \u00cd\u00ce\b\u00cd\u00eb\u0092\u001a\u0089\u00d4\u0014V\u00b2z\u00ce\u00f6\u00e7\u00c5\u00fcws~p\u00bc\u00e3\u00bc\u00dc\u001d\u00863\u00fe".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 29;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 118;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 31;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 20;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 67;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 105;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 58;
                                        break;
                                    }
                                    default: {
                                        v11 = 35;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n, int n2, int n3) {
                    int n4 = (n ^ n3 ^ 0xFFFFC672) & 0xFFFF;
                    if (b[n4] == null) {
                        int n5;
                        char[] cArray = a[n4].toCharArray();
                        int n6 = switch (cArray[0] & 0xFF) {
                            case 0 -> 40;
                            case 1 -> 147;
                            case 2 -> 23;
                            case 3 -> 156;
                            case 4 -> 215;
                            case 5 -> 168;
                            case 6 -> 63;
                            case 7 -> 94;
                            case 8 -> 75;
                            case 9 -> 182;
                            case 10 -> 96;
                            case 11 -> 248;
                            case 12 -> 246;
                            case 13 -> 203;
                            case 14 -> 176;
                            case 15 -> 118;
                            case 16 -> 196;
                            case 17 -> 145;
                            case 18 -> 69;
                            case 19 -> 139;
                            case 20 -> 194;
                            case 21 -> 149;
                            case 22 -> 46;
                            case 23 -> 211;
                            case 24 -> 49;
                            case 25 -> 207;
                            case 26 -> 150;
                            case 27 -> 68;
                            case 28 -> 55;
                            case 29 -> 122;
                            case 30 -> 204;
                            case 31 -> 212;
                            case 32 -> 158;
                            case 33 -> 127;
                            case 34 -> 142;
                            case 35 -> 238;
                            case 36 -> 236;
                            case 37 -> 243;
                            case 38 -> 199;
                            case 39 -> 231;
                            case 40 -> 112;
                            case 41 -> 29;
                            case 42 -> 37;
                            case 43 -> 54;
                            case 44 -> 148;
                            case 45 -> 124;
                            case 46 -> 45;
                            case 47 -> 67;
                            case 48 -> 229;
                            case 49 -> 86;
                            case 50 -> 103;
                            case 51 -> 73;
                            case 52 -> 202;
                            case 53 -> 183;
                            case 54 -> 254;
                            case 55 -> 11;
                            case 56 -> 88;
                            case 57 -> 132;
                            case 58 -> 197;
                            case 59 -> 87;
                            case 60 -> 134;
                            case 61 -> 25;
                            case 62 -> 242;
                            case 63 -> 66;
                            case 64 -> 115;
                            case 65 -> 223;
                            case 66 -> 171;
                            case 67 -> 119;
                            case 68 -> 89;
                            case 69 -> 224;
                            case 70 -> 187;
                            case 71 -> 108;
                            case 72 -> 191;
                            case 73 -> 155;
                            case 74 -> 104;
                            case 75 -> 31;
                            case 76 -> 56;
                            case 77 -> 151;
                            case 78 -> 111;
                            case 79 -> 144;
                            case 80 -> 159;
                            case 81 -> 220;
                            case 82 -> 239;
                            case 83 -> 51;
                            case 84 -> 228;
                            case 85 -> 28;
                            case 86 -> 84;
                            case 87 -> 33;
                            case 88 -> 180;
                            case 89 -> 135;
                            case 90 -> 19;
                            case 91 -> 38;
                            case 92 -> 210;
                            case 93 -> 167;
                            case 94 -> 3;
                            case 95 -> 232;
                            case 96 -> 170;
                            case 97 -> 57;
                            case 98 -> 91;
                            case 99 -> 128;
                            case 100 -> 117;
                            case 101 -> 72;
                            case 102 -> 26;
                            case 103 -> 80;
                            case 104 -> 82;
                            case 105 -> 48;
                            case 106 -> 169;
                            case 107 -> 208;
                            case 108 -> 198;
                            case 109 -> 249;
                            case 110 -> 99;
                            case 111 -> 237;
                            case 112 -> 20;
                            case 113 -> 189;
                            case 114 -> 92;
                            case 115 -> 100;
                            case 116 -> 226;
                            case 117 -> 140;
                            case 118 -> 206;
                            case 119 -> 123;
                            case 120 -> 166;
                            case 121 -> 36;
                            case 122 -> 185;
                            case 123 -> 32;
                            case 124 -> 184;
                            case 125 -> 76;
                            case 126 -> 121;
                            case 127 -> 173;
                            case 128 -> 175;
                            case 129 -> 234;
                            case 130 -> 116;
                            case 131 -> 172;
                            case 132 -> 107;
                            case 133 -> 225;
                            case 134 -> 71;
                            case 135 -> 27;
                            case 136 -> 113;
                            case 137 -> 205;
                            case 138 -> 105;
                            case 139 -> 178;
                            case 140 -> 22;
                            case 141 -> 16;
                            case 142 -> 42;
                            case 143 -> 5;
                            case 144 -> 193;
                            case 145 -> 146;
                            case 146 -> 179;
                            case 147 -> 13;
                            case 148 -> 153;
                            case 149 -> 130;
                            case 150 -> 235;
                            case 151 -> 44;
                            case 152 -> 110;
                            case 153 -> 34;
                            case 154 -> 218;
                            case 155 -> 77;
                            case 156 -> 60;
                            case 157 -> 240;
                            case 158 -> 53;
                            case 159 -> 219;
                            case 160 -> 74;
                            case 161 -> 152;
                            case 162 -> 177;
                            case 163 -> 163;
                            case 164 -> 164;
                            case 165 -> 21;
                            case 166 -> 52;
                            case 167 -> 162;
                            case 168 -> 192;
                            case 169 -> 12;
                            case 170 -> 250;
                            case 171 -> 9;
                            case 172 -> 255;
                            case 173 -> 125;
                            case 174 -> 137;
                            case 175 -> 18;
                            case 176 -> 201;
                            case 177 -> 181;
                            case 178 -> 35;
                            case 179 -> 85;
                            case 180 -> 2;
                            case 181 -> 58;
                            case 182 -> 65;
                            case 183 -> 120;
                            case 184 -> 70;
                            case 185 -> 186;
                            case 186 -> 95;
                            case 187 -> 39;
                            case 188 -> 0;
                            case 189 -> 216;
                            case 190 -> 252;
                            case 191 -> 190;
                            case 192 -> 213;
                            case 193 -> 214;
                            case 194 -> 90;
                            case 195 -> 97;
                            case 196 -> 62;
                            case 197 -> 43;
                            case 198 -> 10;
                            case 199 -> 222;
                            case 200 -> 143;
                            case 201 -> 251;
                            case 202 -> 14;
                            case 203 -> 8;
                            case 204 -> 126;
                            case 205 -> 98;
                            case 206 -> 93;
                            case 207 -> 64;
                            case 208 -> 241;
                            case 209 -> 217;
                            case 210 -> 102;
                            case 211 -> 1;
                            case 212 -> 78;
                            case 213 -> 81;
                            case 214 -> 138;
                            case 215 -> 161;
                            case 216 -> 227;
                            case 217 -> 133;
                            case 218 -> 154;
                            case 219 -> 160;
                            case 220 -> 188;
                            case 221 -> 50;
                            case 222 -> 79;
                            case 223 -> 253;
                            case 224 -> 136;
                            case 225 -> 101;
                            case 226 -> 165;
                            case 227 -> 245;
                            case 228 -> 109;
                            case 229 -> 7;
                            case 230 -> 230;
                            case 231 -> 47;
                            case 232 -> 24;
                            case 233 -> 114;
                            case 234 -> 221;
                            case 235 -> 30;
                            case 236 -> 200;
                            case 237 -> 61;
                            case 238 -> 209;
                            case 239 -> 157;
                            case 240 -> 129;
                            case 241 -> 41;
                            case 242 -> 4;
                            case 243 -> 131;
                            case 244 -> 195;
                            case 245 -> 17;
                            case 246 -> 244;
                            case 247 -> 59;
                            case 248 -> 141;
                            case 249 -> 15;
                            case 250 -> 247;
                            case 251 -> 83;
                            case 252 -> 233;
                            case 253 -> 106;
                            case 254 -> 6;
                            default -> 174;
                        };
                        int n7 = ((n2 ^= n3) & 0xFF) - n6;
                        if (n7 < 0) {
                            n7 += 256;
                        }
                        if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                            n5 += 256;
                        }
                        int n8 = 0;
                        while (n8 < cArray.length) {
                            int n9 = n8 % 2;
                            int n10 = n8;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n10];
                            if (n9 == 0) {
                                cArray2[n10] = (char)(c2 ^ n7);
                                n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                            } else {
                                cArray2[n10] = (char)(c2 ^ n5);
                                n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                            }
                            ++n8;
                        }
                        accept.3.b[n4] = new String(cArray).intern();
                    }
                    return b[n4];
                }
            };
            if (!bl) {
                ActionTimestamp.Y(new ActionTimestamp[2]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n;
            long l3;
            block2: {
                block3: {
                    l3 = 55147341249177L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.B();
                    try {
                        n = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (bl2) break block2;
                        if (n == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(38796720 + (char)-25371, 38796720 + (char)-820, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(38796720 + (char)-25367, -38796720 + -((char)-5343), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(38796720 + (char)-25380, -38796720 + -((char)-18382), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n = Kernel32.INSTANCE.GetLastError();
            }
            int n2 = n;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(38796720 + (char)-25371, 38796720 + (char)-820, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(38796720 + (char)-25367, -38796720 + -((char)-5343), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(38796720 + (char)-25379, -38796720 + -((char)-6507), (int)l3) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n2));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 19826002249041L;
                        boolean bl3 = SshAgentIpcService.Y();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-433186350 + -29840, -433186350 + -((char)-30980), (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (!bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (!bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-433186350 + -29839, 433186350 + 19900, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (!bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 87818174426921L;
                boolean bl2 = SshAgentIpcService.Y();
                this.assertConnectionThread();
                bl = bl2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl4 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (!bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (!bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1021821720 + (char)-13299, 1021952790 - (char)-11446, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1021821720 + (char)-13295, -1021952790 - -((char)-14923), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1021821720 + (char)-13280, -1021821720 + -((char)-4393), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1021821720 + (char)-13295, -1021952790 - -((char)-14923), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1021821720 + (char)-13301, 1021952790 - (char)-6280, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1021821720 + (char)-13299, 1021952790 - (char)-11446, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1021821720 + (char)-13295, -1021952790 - -((char)-14923), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1021821720 + (char)-13279, -1021821720 + -((char)-16962), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (!bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl7 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1021821720 + (char)-13299, 1021952790 - (char)-11446, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1021821720 + (char)-13295, -1021952790 - -((char)-14923), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1021821720 + (char)-13282, 1021952790 - (char)-8029, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl8 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (!bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl9 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1021821720 + (char)-13299, 1021952790 - (char)-11446, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1021821720 + (char)-13295, -1021952790 - -((char)-14923), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1021821720 + (char)-13281, -1021821720 + -((char)-4848), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 99693960698923L;
                    Object object = this.lock;
                    bl2 = SshAgentIpcService.Y();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (!bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(820236060 - (char)-11531, 820104990 + (char)-12880, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(820236060 - (char)-11535, -820104990 + -((char)-16571), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(820236060 - (char)-11546, -820236060 - -((char)-8613), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(820236060 - (char)-11547, -820104990 + -((char)-8458), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(820236060 - (char)-11531, 820104990 + (char)-12880, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(820236060 - (char)-11535, -820104990 + -((char)-16571), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(820236060 - (char)-11540, -820236060 - -((char)-5098), (int)l2));
                            n = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (!bl2) break block15;
                            if (n != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = Kernel32.INSTANCE.GetLastError();
                        if (!bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n2 = n;
                    if (n2 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(820236060 - (char)-11531, 820104990 + (char)-12880, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(820236060 - (char)-11535, -820104990 + -((char)-16571), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(820236060 - (char)-11541, -820104990 + -((char)-17654), (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n2));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(820236060 - (char)-11531, 820104990 + (char)-12880, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(820236060 - (char)-11535, -820104990 + -((char)-16571), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(820236060 - (char)-11542, -820104990 + -((char)-7378), (int)l2));
                    if (!bl2) break block17;
                    n = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(820236060 - (char)-11531, 820104990 + (char)-12880, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(820236060 - (char)-11535, -820104990 + -((char)-16571), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(820236060 - (char)-11543, -820104990 + -((char)-892), (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u00d6V\u0005\u00c3\u000b{x\u00ca\u0014\u00fa\u00ef\u00b8\u0013B\u00e9\u00fe\u0082ut\u0089&Qz0\u00da\"\u00a3\u00fd_\u0006\u00ae\u00a5\n\u00bd\u0080\u00f5\u0018\u00bd\u00910\u00ec\u00d1\u00d3\u008e\u0005\u00b3\u00f9^\u00e7\u00cd\u00bd\u00f1\u00a0\u00b3\u0085\u00e1\u0006\u00b6*f`\tf\u00a7\u00d5\u009b\u0006\u00a2lc\u00d3\u0005\u0083\u0083\u00afy.\b\u0014\u0087]\u0088R4U\u00c1\u0005\u00adfj\u00c5\u0096\u001eAb\u00e2!\u001a\u00aeU\u00d0mW\u00ce\u00b5\u0093\u00d7\u0098\u0089\u007f1\u00aadsI\u00d2\u00c1*5q\u00c2\u00e0\u00c9\u0010W\u00cc\u00c41\u0089\u009e\u00d1/\u0080\u001a\u00fe\u00e1\u0093\b7\u00ed\t\u00e0\u00a9\u00d3K\u0095\u009f8[\u00b7\u0010E\u00e7\u0086T\u00c12\u00d8\u00ba\u00a1\u00a8\u00da\u00b7\u0017\u00c2\u00a7\u00b4?1\u00a9\u00e4X\u00d7\u0088ix\u009b\u0093U\u00d6_M<\u00e3.\u0019\u00fd\u00a4\u0017\u0003%\u00ee\u00c48\u00a1\u00d7\u00cd=\u00ef\u00d9\u00da\u00cf$\u00198\u0019\\\u0085\u00af,\u00bf\u00eeG\u00d6\u00a1\u00a6\u00a1\u00cf]\u0006\u00e9:+ ?\u00b2f\u0002\u00c7\u00c3\b\b\u00b2\u00aa\u0089-\u00c8\u0080\u0006W\f\u009c\u008e\\\u00b2o\u0011\u001cb\u0010\u00fb\u00be\u00d9Fn\u00a7\u0002\u0097\u00a4\u00b5e\u00f6?eQ\u00ceIF\u00e1\u00a4i\u0096\u0015\u00fa\u0018\u009a\u00c7\u00ef\u00ae3\u001f\u00bd\u00a5Y\u00d8i\u0000o\u00bd,\u00d1\u00f2\u00ca<\u00ee\u000e\u001cQ\u00ed\u00a4\u00a0\u0095fQ\u00c3\u007f\u00d5\u0083\u00ba\f\u0092CE\u0080\u0090\u00fa\u00be5\u00d1\u00d3\u008b~\u00f0\u00d9\u001f5;l\n\u00cb\u00cbo|*\u00c2&\u0007\u008e\u009c0Q\u0011\u00c2\u001a\u00d0\u00ae_\u00be\u00a8\u00c6\u00c8\u00fb\u00b1\u00acV\u00fb\u000b`\u001e\u00c3\u00a0\u009cSb*\u00df\u00feM\u0015\u00e9\u001f\u00f2\u0083\u00bd_\u00aa\u00d6\u00f8\u0081a\u00a4\u00d8D\u00e7\u001c\u0010\u00ff\u00e7\u000e')~ \u0005i\u00e6\u00a7\u00ca\u00f1\u009es\u00b01XPt\u00cd\u00c6\u00d9;\u0014z\u00bf\u00e2\u00ac\"\u0001\u00b0\u00f0\u00ea\u008a\u00b1-\u00d3B\u00a1\u0004L\u00ea\u00f2\u0096J\u0007k\u00dc\u00ad\u00ec\u00d7Jw\u0007_\u0017O\u00f9l\u0007\u0016(\r8'K\u0012\u0089\u00a2\u0013\u00e3\u00f85v\u00cb9Dc\u00c7\u00a1\u00b5X\u00ca\b\u009b\u0091\u009d\u001a\u00f1\u00e8\u00f5\u00e9\u0089X/\u0087\u00a0\u0011\u00d652\u009e\u000f\u001f\r+\u00c4{\u0014*c\u0087{\u0018W\u00ceIz\"j(\u0087h\u00b6\u0087\u00c0\u00f5\u00df\u00f3\u0098!^^\u00d0\u00c2\u00b9\u0011^O<\u00d4\u008a\u0091\u00bc\u00f2\u00aeP\r\u00ac\u00ef\u00ee6\u00c9\u000e/\u00df-\u009e\u00bb_2\n\u0084Vx\u00f2\u00ce\u00f7\u001b\u00d3\u00cb\u00b5\u0019S\u001a\u00ba\u00fe\u00c2O=\u00d06\u0085\u00fb\u00aft\u0016Z3\u0087o\u008e@w\u00a5\u0082\n4C\u008d\u000f@<\u000b\u0010_\u00f0\u0018\u009d\u00b1|[k\u00ee\u009c>\u0018\u009e\u00a4u\u00bcbVr\u00b6\u00ac\u00d5\u001d\u000e\u00e1\u00e4\u00c2)\u0018\u00fd\u00c9\u00d2\u007f\u00d0\u00f9\u001f\u00f8\u00ae|\u008a\u00c5.Xy=:\u009b\u00adT\u0098nD\u00c6\u008e\u00b1\u00ed\u0099udCLQ\u0087\u00f2V\u0010\u00b1\u00c9\"";
                var4_3 = "\u00d6V\u0005\u00c3\u000b{x\u00ca\u0014\u00fa\u00ef\u00b8\u0013B\u00e9\u00fe\u0082ut\u0089&Qz0\u00da\"\u00a3\u00fd_\u0006\u00ae\u00a5\n\u00bd\u0080\u00f5\u0018\u00bd\u00910\u00ec\u00d1\u00d3\u008e\u0005\u00b3\u00f9^\u00e7\u00cd\u00bd\u00f1\u00a0\u00b3\u0085\u00e1\u0006\u00b6*f`\tf\u00a7\u00d5\u009b\u0006\u00a2lc\u00d3\u0005\u0083\u0083\u00afy.\b\u0014\u0087]\u0088R4U\u00c1\u0005\u00adfj\u00c5\u0096\u001eAb\u00e2!\u001a\u00aeU\u00d0mW\u00ce\u00b5\u0093\u00d7\u0098\u0089\u007f1\u00aadsI\u00d2\u00c1*5q\u00c2\u00e0\u00c9\u0010W\u00cc\u00c41\u0089\u009e\u00d1/\u0080\u001a\u00fe\u00e1\u0093\b7\u00ed\t\u00e0\u00a9\u00d3K\u0095\u009f8[\u00b7\u0010E\u00e7\u0086T\u00c12\u00d8\u00ba\u00a1\u00a8\u00da\u00b7\u0017\u00c2\u00a7\u00b4?1\u00a9\u00e4X\u00d7\u0088ix\u009b\u0093U\u00d6_M<\u00e3.\u0019\u00fd\u00a4\u0017\u0003%\u00ee\u00c48\u00a1\u00d7\u00cd=\u00ef\u00d9\u00da\u00cf$\u00198\u0019\\\u0085\u00af,\u00bf\u00eeG\u00d6\u00a1\u00a6\u00a1\u00cf]\u0006\u00e9:+ ?\u00b2f\u0002\u00c7\u00c3\b\b\u00b2\u00aa\u0089-\u00c8\u0080\u0006W\f\u009c\u008e\\\u00b2o\u0011\u001cb\u0010\u00fb\u00be\u00d9Fn\u00a7\u0002\u0097\u00a4\u00b5e\u00f6?eQ\u00ceIF\u00e1\u00a4i\u0096\u0015\u00fa\u0018\u009a\u00c7\u00ef\u00ae3\u001f\u00bd\u00a5Y\u00d8i\u0000o\u00bd,\u00d1\u00f2\u00ca<\u00ee\u000e\u001cQ\u00ed\u00a4\u00a0\u0095fQ\u00c3\u007f\u00d5\u0083\u00ba\f\u0092CE\u0080\u0090\u00fa\u00be5\u00d1\u00d3\u008b~\u00f0\u00d9\u001f5;l\n\u00cb\u00cbo|*\u00c2&\u0007\u008e\u009c0Q\u0011\u00c2\u001a\u00d0\u00ae_\u00be\u00a8\u00c6\u00c8\u00fb\u00b1\u00acV\u00fb\u000b`\u001e\u00c3\u00a0\u009cSb*\u00df\u00feM\u0015\u00e9\u001f\u00f2\u0083\u00bd_\u00aa\u00d6\u00f8\u0081a\u00a4\u00d8D\u00e7\u001c\u0010\u00ff\u00e7\u000e')~ \u0005i\u00e6\u00a7\u00ca\u00f1\u009es\u00b01XPt\u00cd\u00c6\u00d9;\u0014z\u00bf\u00e2\u00ac\"\u0001\u00b0\u00f0\u00ea\u008a\u00b1-\u00d3B\u00a1\u0004L\u00ea\u00f2\u0096J\u0007k\u00dc\u00ad\u00ec\u00d7Jw\u0007_\u0017O\u00f9l\u0007\u0016(\r8'K\u0012\u0089\u00a2\u0013\u00e3\u00f85v\u00cb9Dc\u00c7\u00a1\u00b5X\u00ca\b\u009b\u0091\u009d\u001a\u00f1\u00e8\u00f5\u00e9\u0089X/\u0087\u00a0\u0011\u00d652\u009e\u000f\u001f\r+\u00c4{\u0014*c\u0087{\u0018W\u00ceIz\"j(\u0087h\u00b6\u0087\u00c0\u00f5\u00df\u00f3\u0098!^^\u00d0\u00c2\u00b9\u0011^O<\u00d4\u008a\u0091\u00bc\u00f2\u00aeP\r\u00ac\u00ef\u00ee6\u00c9\u000e/\u00df-\u009e\u00bb_2\n\u0084Vx\u00f2\u00ce\u00f7\u001b\u00d3\u00cb\u00b5\u0019S\u001a\u00ba\u00fe\u00c2O=\u00d06\u0085\u00fb\u00aft\u0016Z3\u0087o\u008e@w\u00a5\u0082\n4C\u008d\u000f@<\u000b\u0010_\u00f0\u0018\u009d\u00b1|[k\u00ee\u009c>\u0018\u009e\u00a4u\u00bcbVr\u00b6\u00ac\u00d5\u001d\u000e\u00e1\u00e4\u00c2)\u0018\u00fd\u00c9\u00d2\u007f\u00d0\u00f9\u001f\u00f8\u00ae|\u008a\u00c5.Xy=:\u009b\u00adT\u0098nD\u00c6\u008e\u00b1\u00ed\u0099udCLQ\u0087\u00f2V\u0010\u00b1\u00c9\"".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 19;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00f9PY\u00c3g\u00e8\u0099G\u0097\u001d\u00a7\u00eb\u0097\u00b9\u001d\u0014\u001c.\u00ed!w\u00d2\r\u008c\u00e8\u0084\u0082 \u0095\u00c3i\u00c3\u0093X{\u00b8>\u00c7Q";
                    var4_3 = "\u00f9PY\u00c3g\u00e8\u0099G\u0097\u001d\u00a7\u00eb\u0097\u00b9\u001d\u0014\u001c.\u00ed!w\u00d2\r\u008c\u00e8\u0084\u0082 \u0095\u00c3i\u00c3\u0093X{\u00b8>\u00c7Q".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 63;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 118;
                            break;
                        }
                        case 1: {
                            v15 = 115;
                            break;
                        }
                        case 2: {
                            v15 = 110;
                            break;
                        }
                        case 3: {
                            v15 = 55;
                            break;
                        }
                        case 4: {
                            v15 = 57;
                            break;
                        }
                        case 5: {
                            v15 = 60;
                            break;
                        }
                        default: {
                            v15 = 97;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n, int n2, int n3) {
        int n4 = (n ^ n3 ^ 0xFFFFE007) & 0xFFFF;
        if (d[n4] == null) {
            int n5;
            char[] cArray = c[n4].toCharArray();
            int n6 = switch (cArray[0] & 0xFF) {
                case 0 -> 95;
                case 1 -> 31;
                case 2 -> 46;
                case 3 -> 150;
                case 4 -> 183;
                case 5 -> 128;
                case 6 -> 120;
                case 7 -> 131;
                case 8 -> 59;
                case 9 -> 49;
                case 10 -> 29;
                case 11 -> 91;
                case 12 -> 250;
                case 13 -> 219;
                case 14 -> 9;
                case 15 -> 37;
                case 16 -> 232;
                case 17 -> 17;
                case 18 -> 121;
                case 19 -> 44;
                case 20 -> 185;
                case 21 -> 35;
                case 22 -> 192;
                case 23 -> 115;
                case 24 -> 159;
                case 25 -> 51;
                case 26 -> 233;
                case 27 -> 1;
                case 28 -> 171;
                case 29 -> 127;
                case 30 -> 118;
                case 31 -> 0;
                case 32 -> 158;
                case 33 -> 184;
                case 34 -> 61;
                case 35 -> 203;
                case 36 -> 141;
                case 37 -> 188;
                case 38 -> 84;
                case 39 -> 62;
                case 40 -> 25;
                case 41 -> 205;
                case 42 -> 38;
                case 43 -> 113;
                case 44 -> 147;
                case 45 -> 151;
                case 46 -> 30;
                case 47 -> 177;
                case 48 -> 80;
                case 49 -> 85;
                case 50 -> 58;
                case 51 -> 101;
                case 52 -> 228;
                case 53 -> 40;
                case 54 -> 89;
                case 55 -> 7;
                case 56 -> 241;
                case 57 -> 16;
                case 58 -> 114;
                case 59 -> 104;
                case 60 -> 36;
                case 61 -> 152;
                case 62 -> 4;
                case 63 -> 252;
                case 64 -> 137;
                case 65 -> 73;
                case 66 -> 146;
                case 67 -> 92;
                case 68 -> 77;
                case 69 -> 34;
                case 70 -> 224;
                case 71 -> 19;
                case 72 -> 135;
                case 73 -> 204;
                case 74 -> 129;
                case 75 -> 55;
                case 76 -> 83;
                case 77 -> 247;
                case 78 -> 162;
                case 79 -> 245;
                case 80 -> 243;
                case 81 -> 74;
                case 82 -> 12;
                case 83 -> 103;
                case 84 -> 170;
                case 85 -> 235;
                case 86 -> 67;
                case 87 -> 132;
                case 88 -> 220;
                case 89 -> 10;
                case 90 -> 2;
                case 91 -> 230;
                case 92 -> 208;
                case 93 -> 33;
                case 94 -> 23;
                case 95 -> 199;
                case 96 -> 176;
                case 97 -> 41;
                case 98 -> 179;
                case 99 -> 174;
                case 100 -> 53;
                case 101 -> 187;
                case 102 -> 43;
                case 103 -> 13;
                case 104 -> 240;
                case 105 -> 175;
                case 106 -> 79;
                case 107 -> 226;
                case 108 -> 197;
                case 109 -> 155;
                case 110 -> 66;
                case 111 -> 153;
                case 112 -> 168;
                case 113 -> 236;
                case 114 -> 134;
                case 115 -> 157;
                case 116 -> 72;
                case 117 -> 238;
                case 118 -> 246;
                case 119 -> 210;
                case 120 -> 173;
                case 121 -> 214;
                case 122 -> 195;
                case 123 -> 87;
                case 124 -> 163;
                case 125 -> 172;
                case 126 -> 198;
                case 127 -> 98;
                case 128 -> 223;
                case 129 -> 76;
                case 130 -> 94;
                case 131 -> 211;
                case 132 -> 133;
                case 133 -> 207;
                case 134 -> 54;
                case 135 -> 71;
                case 136 -> 221;
                case 137 -> 237;
                case 138 -> 108;
                case 139 -> 65;
                case 140 -> 209;
                case 141 -> 190;
                case 142 -> 64;
                case 143 -> 81;
                case 144 -> 225;
                case 145 -> 107;
                case 146 -> 215;
                case 147 -> 88;
                case 148 -> 178;
                case 149 -> 39;
                case 150 -> 253;
                case 151 -> 50;
                case 152 -> 165;
                case 153 -> 14;
                case 154 -> 248;
                case 155 -> 117;
                case 156 -> 11;
                case 157 -> 125;
                case 158 -> 5;
                case 159 -> 251;
                case 160 -> 242;
                case 161 -> 102;
                case 162 -> 160;
                case 163 -> 47;
                case 164 -> 119;
                case 165 -> 196;
                case 166 -> 143;
                case 167 -> 231;
                case 168 -> 28;
                case 169 -> 69;
                case 170 -> 48;
                case 171 -> 110;
                case 172 -> 239;
                case 173 -> 140;
                case 174 -> 106;
                case 175 -> 191;
                case 176 -> 21;
                case 177 -> 122;
                case 178 -> 70;
                case 179 -> 78;
                case 180 -> 68;
                case 181 -> 169;
                case 182 -> 136;
                case 183 -> 213;
                case 184 -> 20;
                case 185 -> 139;
                case 186 -> 149;
                case 187 -> 32;
                case 188 -> 112;
                case 189 -> 105;
                case 190 -> 255;
                case 191 -> 142;
                case 192 -> 126;
                case 193 -> 109;
                case 194 -> 8;
                case 195 -> 130;
                case 196 -> 42;
                case 197 -> 144;
                case 198 -> 189;
                case 199 -> 56;
                case 200 -> 254;
                case 201 -> 26;
                case 202 -> 116;
                case 203 -> 227;
                case 204 -> 86;
                case 205 -> 123;
                case 206 -> 82;
                case 207 -> 194;
                case 208 -> 75;
                case 209 -> 206;
                case 210 -> 99;
                case 211 -> 186;
                case 212 -> 90;
                case 213 -> 60;
                case 214 -> 154;
                case 215 -> 202;
                case 216 -> 97;
                case 217 -> 57;
                case 218 -> 145;
                case 219 -> 52;
                case 220 -> 27;
                case 221 -> 124;
                case 222 -> 234;
                case 223 -> 3;
                case 224 -> 164;
                case 225 -> 63;
                case 226 -> 182;
                case 227 -> 6;
                case 228 -> 181;
                case 229 -> 249;
                case 230 -> 216;
                case 231 -> 200;
                case 232 -> 212;
                case 233 -> 111;
                case 234 -> 167;
                case 235 -> 217;
                case 236 -> 45;
                case 237 -> 180;
                case 238 -> 161;
                case 239 -> 24;
                case 240 -> 229;
                case 241 -> 18;
                case 242 -> 22;
                case 243 -> 100;
                case 244 -> 156;
                case 245 -> 201;
                case 246 -> 166;
                case 247 -> 218;
                case 248 -> 15;
                case 249 -> 96;
                case 250 -> 148;
                case 251 -> 193;
                case 252 -> 222;
                case 253 -> 93;
                case 254 -> 244;
                default -> 138;
            };
            int n7 = ((n2 ^= n3) & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n5 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            WindowsNamedPipeAgentIpc.d[n4] = new String(cArray).intern();
        }
        return d[n4];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 131693940573286L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1653316980 + (char)-21466, -1653316980 + -((char)-19286), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 9503411291302L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.Y();
                            try {
                                hANDLE2 = hANDLE;
                                if (!bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (!bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1351331700 + -18225, 1351331700 + 16610, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1351331700 + -18228, -1351331700 + -10181, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1351331700 + -18227, 1351331700 + 10397, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u001c\u000b\u0098&\u00a8\u0086\u0019`\u00102\u00ad\u00acS\u0094\u0093g\u009b\u00f5H\u001e\u00bb\u00ceV\u0089\u0085";
                    var4_3 = "\u001c\u000b\u0098&\u00a8\u0086\u0019`\u00102\u00ad\u00acS\u0094\u0093g\u009b\u00f5H\u001e\u00bb\u00ceV\u0089\u0085".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 98;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = ")T\u00c12\f5\u00d0\u00a6\u00e9\u0000\u00db?iZ\u00bc4Z\u000bNUc\u0090\u00e0\u000f\\I\u00d5\u00d1\u008d\u00db\u0001\u00de\u00b8\u00cb\u0094\u00d2.\u00d2\u00f1\u00ac\u00af\u00de\u00d0\u00f0\u00b4<\u00bc\u00de\u00a0\u0004\u00ca\u00d1\rjjJk\u00a8\u00db";
                        var4_3 = ")T\u00c12\f5\u00d0\u00a6\u00e9\u0000\u00db?iZ\u00bc4Z\u000bNUc\u0090\u00e0\u000f\\I\u00d5\u00d1\u008d\u00db\u0001\u00de\u00b8\u00cb\u0094\u00d2.\u00d2\u00f1\u00ac\u00af\u00de\u00d0\u00f0\u00b4<\u00bc\u00de\u00a0\u0004\u00ca\u00d1\rjjJk\u00a8\u00db".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 55;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 51;
                                break;
                            }
                            case 1: {
                                v15 = 98;
                                break;
                            }
                            case 2: {
                                v15 = 93;
                                break;
                            }
                            case 3: {
                                v15 = 4;
                                break;
                            }
                            case 4: {
                                v15 = 16;
                                break;
                            }
                            case 5: {
                                v15 = 68;
                                break;
                            }
                            default: {
                                v15 = 14;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0x4DFC) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 142;
                    case 1 -> 103;
                    case 2 -> 205;
                    case 3 -> 107;
                    case 4 -> 89;
                    case 5 -> 28;
                    case 6 -> 59;
                    case 7 -> 213;
                    case 8 -> 222;
                    case 9 -> 186;
                    case 10 -> 11;
                    case 11 -> 88;
                    case 12 -> 225;
                    case 13 -> 232;
                    case 14 -> 164;
                    case 15 -> 123;
                    case 16 -> 72;
                    case 17 -> 96;
                    case 18 -> 174;
                    case 19 -> 94;
                    case 20 -> 183;
                    case 21 -> 240;
                    case 22 -> 246;
                    case 23 -> 198;
                    case 24 -> 25;
                    case 25 -> 81;
                    case 26 -> 157;
                    case 27 -> 141;
                    case 28 -> 245;
                    case 29 -> 24;
                    case 30 -> 168;
                    case 31 -> 32;
                    case 32 -> 156;
                    case 33 -> 149;
                    case 34 -> 52;
                    case 35 -> 91;
                    case 36 -> 212;
                    case 37 -> 41;
                    case 38 -> 42;
                    case 39 -> 210;
                    case 40 -> 191;
                    case 41 -> 134;
                    case 42 -> 178;
                    case 43 -> 65;
                    case 44 -> 148;
                    case 45 -> 4;
                    case 46 -> 165;
                    case 47 -> 244;
                    case 48 -> 169;
                    case 49 -> 131;
                    case 50 -> 230;
                    case 51 -> 252;
                    case 52 -> 49;
                    case 53 -> 98;
                    case 54 -> 6;
                    case 55 -> 170;
                    case 56 -> 68;
                    case 57 -> 189;
                    case 58 -> 82;
                    case 59 -> 8;
                    case 60 -> 249;
                    case 61 -> 242;
                    case 62 -> 243;
                    case 63 -> 175;
                    case 64 -> 138;
                    case 65 -> 102;
                    case 66 -> 173;
                    case 67 -> 187;
                    case 68 -> 139;
                    case 69 -> 16;
                    case 70 -> 21;
                    case 71 -> 197;
                    case 72 -> 83;
                    case 73 -> 99;
                    case 74 -> 54;
                    case 75 -> 66;
                    case 76 -> 117;
                    case 77 -> 71;
                    case 78 -> 125;
                    case 79 -> 61;
                    case 80 -> 80;
                    case 81 -> 55;
                    case 82 -> 114;
                    case 83 -> 95;
                    case 84 -> 182;
                    case 85 -> 204;
                    case 86 -> 62;
                    case 87 -> 64;
                    case 88 -> 255;
                    case 89 -> 108;
                    case 90 -> 153;
                    case 91 -> 217;
                    case 92 -> 118;
                    case 93 -> 1;
                    case 94 -> 100;
                    case 95 -> 110;
                    case 96 -> 190;
                    case 97 -> 12;
                    case 98 -> 195;
                    case 99 -> 236;
                    case 100 -> 23;
                    case 101 -> 30;
                    case 102 -> 119;
                    case 103 -> 143;
                    case 104 -> 224;
                    case 105 -> 15;
                    case 106 -> 93;
                    case 107 -> 35;
                    case 108 -> 75;
                    case 109 -> 203;
                    case 110 -> 254;
                    case 111 -> 105;
                    case 112 -> 199;
                    case 113 -> 77;
                    case 114 -> 18;
                    case 115 -> 233;
                    case 116 -> 46;
                    case 117 -> 237;
                    case 118 -> 154;
                    case 119 -> 70;
                    case 120 -> 67;
                    case 121 -> 129;
                    case 122 -> 177;
                    case 123 -> 73;
                    case 124 -> 166;
                    case 125 -> 159;
                    case 126 -> 228;
                    case 127 -> 151;
                    case 128 -> 181;
                    case 129 -> 17;
                    case 130 -> 226;
                    case 131 -> 231;
                    case 132 -> 247;
                    case 133 -> 160;
                    case 134 -> 45;
                    case 135 -> 218;
                    case 136 -> 132;
                    case 137 -> 241;
                    case 138 -> 14;
                    case 139 -> 69;
                    case 140 -> 115;
                    case 141 -> 211;
                    case 142 -> 137;
                    case 143 -> 176;
                    case 144 -> 19;
                    case 145 -> 97;
                    case 146 -> 90;
                    case 147 -> 200;
                    case 148 -> 26;
                    case 149 -> 193;
                    case 150 -> 48;
                    case 151 -> 135;
                    case 152 -> 31;
                    case 153 -> 207;
                    case 154 -> 188;
                    case 155 -> 180;
                    case 156 -> 163;
                    case 157 -> 43;
                    case 158 -> 122;
                    case 159 -> 250;
                    case 160 -> 60;
                    case 161 -> 109;
                    case 162 -> 127;
                    case 163 -> 111;
                    case 164 -> 56;
                    case 165 -> 209;
                    case 166 -> 29;
                    case 167 -> 121;
                    case 168 -> 92;
                    case 169 -> 120;
                    case 170 -> 147;
                    case 171 -> 234;
                    case 172 -> 144;
                    case 173 -> 172;
                    case 174 -> 214;
                    case 175 -> 221;
                    case 176 -> 0;
                    case 177 -> 36;
                    case 178 -> 106;
                    case 179 -> 79;
                    case 180 -> 84;
                    case 181 -> 133;
                    case 182 -> 146;
                    case 183 -> 63;
                    case 184 -> 202;
                    case 185 -> 215;
                    case 186 -> 78;
                    case 187 -> 37;
                    case 188 -> 53;
                    case 189 -> 158;
                    case 190 -> 152;
                    case 191 -> 34;
                    case 192 -> 196;
                    case 193 -> 38;
                    case 194 -> 87;
                    case 195 -> 136;
                    case 196 -> 112;
                    case 197 -> 9;
                    case 198 -> 39;
                    case 199 -> 20;
                    case 200 -> 140;
                    case 201 -> 248;
                    case 202 -> 251;
                    case 203 -> 161;
                    case 204 -> 128;
                    case 205 -> 229;
                    case 206 -> 86;
                    case 207 -> 219;
                    case 208 -> 253;
                    case 209 -> 130;
                    case 210 -> 27;
                    case 211 -> 220;
                    case 212 -> 201;
                    case 213 -> 40;
                    case 214 -> 145;
                    case 215 -> 2;
                    case 216 -> 124;
                    case 217 -> 208;
                    case 218 -> 76;
                    case 219 -> 116;
                    case 220 -> 85;
                    case 221 -> 192;
                    case 222 -> 47;
                    case 223 -> 194;
                    case 224 -> 162;
                    case 225 -> 58;
                    case 226 -> 184;
                    case 227 -> 50;
                    case 228 -> 150;
                    case 229 -> 74;
                    case 230 -> 179;
                    case 231 -> 7;
                    case 232 -> 57;
                    case 233 -> 238;
                    case 234 -> 171;
                    case 235 -> 13;
                    case 236 -> 185;
                    case 237 -> 101;
                    case 238 -> 239;
                    case 239 -> 167;
                    case 240 -> 126;
                    case 241 -> 223;
                    case 242 -> 5;
                    case 243 -> 51;
                    case 244 -> 33;
                    case 245 -> 22;
                    case 246 -> 155;
                    case 247 -> 44;
                    case 248 -> 104;
                    case 249 -> 235;
                    case 250 -> 3;
                    case 251 -> 206;
                    case 252 -> 113;
                    case 253 -> 10;
                    case 254 -> 216;
                    default -> 227;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 7040694486452L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "gPArq_v>\t`ZRx<\u001dk\"\u001c";
                    var5_4 = "gPArq_v>\t`ZRx<\u001dk\"\u001c".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 113;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 125;
                                    break;
                                }
                                case 1: {
                                    v11 = 68;
                                    break;
                                }
                                case 2: {
                                    v11 = 66;
                                    break;
                                }
                                case 3: {
                                    v11 = 109;
                                    break;
                                }
                                case 4: {
                                    v11 = 101;
                                    break;
                                }
                                case 5: {
                                    v11 = 66;
                                    break;
                                }
                                default: {
                                    v11 = 52;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 34079916409083L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "a;.tt\u0002\f\u0004g%\"n\nk:)nx\u0000\u0014A; \tk:)nx\u0000\u0014M1\rl<4cr\r\u000eM63is\u0004";
                    var5_4 = "a;.tt\u0002\f\u0004g%\"n\nk:)nx\u0000\u0014A; \tk:)nx\u0000\u0014M1\rl<4cr\r\u000eM63is\u0004".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 106;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "8j{ '^T\u00068j{ +T";
                        var5_4 = "8j{ '^T\u00068j{ +T".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 57;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 66;
                                break;
                            }
                            case 1: {
                                v15 = 63;
                                break;
                            }
                            case 2: {
                                v15 = 45;
                                break;
                            }
                            case 3: {
                                v15 = 106;
                                break;
                            }
                            case 4: {
                                v15 = 119;
                                break;
                            }
                            case 5: {
                                v15 = 9;
                                break;
                            }
                            default: {
                                v15 = 10;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 126524825320701L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-616291140 - -((char)-12685), -616291140 - -28036, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 91325331811563L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00e2X\u008b\u00b7\u00ba\u0003\u00b1\u00f7U\u0005\u00c3\u00e4\u0089\u00e4\u0019\r\u0091\u00f7\u00f5\u00ccc\u00fd\u00ac\u0019\u00eev\u00a1\u00d2\u00d7\u0010\u00f1\u00dd>b%\u00bdO,[T\u00f4\u00db\u009bDQl\u0005\u00c5}I\u00d7\u00013/<\u0005\u0088\u0097\u00a4)\u001b\u00eaOI\u0091\u00ea\\Sp\u00c3\u00c8SFr\u00bbK\u000b\u00d2G\u00dcO+\u00a2\u00f3A\u0097\u008fb\\\u00c7\u00f7&\u00ca\u0084\u00bb;\u00ce\u00dd:\u009d\u00ca\u0010\u00e3\u0080";
                    var4_3 = "\u00e2X\u008b\u00b7\u00ba\u0003\u00b1\u00f7U\u0005\u00c3\u00e4\u0089\u00e4\u0019\r\u0091\u00f7\u00f5\u00ccc\u00fd\u00ac\u0019\u00eev\u00a1\u00d2\u00d7\u0010\u00f1\u00dd>b%\u00bdO,[T\u00f4\u00db\u009bDQl\u0005\u00c5}I\u00d7\u00013/<\u0005\u0088\u0097\u00a4)\u001b\u00eaOI\u0091\u00ea\\Sp\u00c3\u00c8SFr\u00bbK\u000b\u00d2G\u00dcO+\u00a2\u00f3A\u0097\u008fb\\\u00c7\u00f7&\u00ca\u0084\u00bb;\u00ce\u00dd:\u009d\u00ca\u0010\u00e3\u0080".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 106;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\n\u00ae\u00b1\u00fc$\u009e\u009f\u00b8\u00b16Yg\u00de#\tpL\u00a5\u0018\u00b3\u00e0N\u00d5\u00bc\u00bf\\EH\u00b0\u00f2W\u001f\u0087\u00bf\u0017\u00d3\u00bb\u00fa\u0090\u0080<x\u00ba\\\u00c61*\u00af\u00cf\u00fc@\u008eI\u0098{\u0007\u00cdfVX\u00feT\u0012\u0097\u0007S\u009e\u00f0C\u00f2H\u000eg\bv\u0091\"\u000e\u0006bH\u00c7\u00a222\u00d7\u00fc\u00ed\"\u000e\u009c\u00e8]";
                        var4_3 = "\n\u00ae\u00b1\u00fc$\u009e\u009f\u00b8\u00b16Yg\u00de#\tpL\u00a5\u0018\u00b3\u00e0N\u00d5\u00bc\u00bf\\EH\u00b0\u00f2W\u001f\u0087\u00bf\u0017\u00d3\u00bb\u00fa\u0090\u0080<x\u00ba\\\u00c61*\u00af\u00cf\u00fc@\u008eI\u0098{\u0007\u00cdfVX\u00feT\u0012\u0097\u0007S\u009e\u00f0C\u00f2H\u000eg\bv\u0091\"\u000e\u0006bH\u00c7\u00a222\u00d7\u00fc\u00ed\"\u000e\u009c\u00e8]".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 92;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 4;
                                break;
                            }
                            case 1: {
                                v15 = 11;
                                break;
                            }
                            case 2: {
                                v15 = 88;
                                break;
                            }
                            case 3: {
                                v15 = 31;
                                break;
                            }
                            case 4: {
                                v15 = 90;
                                break;
                            }
                            case 5: {
                                v15 = 38;
                                break;
                            }
                            default: {
                                v15 = 80;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0x4FD2) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 52;
                    case 1 -> 247;
                    case 2 -> 31;
                    case 3 -> 37;
                    case 4 -> 25;
                    case 5 -> 203;
                    case 6 -> 34;
                    case 7 -> 90;
                    case 8 -> 168;
                    case 9 -> 250;
                    case 10 -> 57;
                    case 11 -> 93;
                    case 12 -> 35;
                    case 13 -> 15;
                    case 14 -> 5;
                    case 15 -> 178;
                    case 16 -> 135;
                    case 17 -> 220;
                    case 18 -> 99;
                    case 19 -> 190;
                    case 20 -> 173;
                    case 21 -> 69;
                    case 22 -> 167;
                    case 23 -> 72;
                    case 24 -> 68;
                    case 25 -> 84;
                    case 26 -> 50;
                    case 27 -> 189;
                    case 28 -> 111;
                    case 29 -> 32;
                    case 30 -> 192;
                    case 31 -> 233;
                    case 32 -> 30;
                    case 33 -> 118;
                    case 34 -> 212;
                    case 35 -> 144;
                    case 36 -> 228;
                    case 37 -> 244;
                    case 38 -> 44;
                    case 39 -> 199;
                    case 40 -> 59;
                    case 41 -> 177;
                    case 42 -> 249;
                    case 43 -> 75;
                    case 44 -> 79;
                    case 45 -> 60;
                    case 46 -> 225;
                    case 47 -> 129;
                    case 48 -> 28;
                    case 49 -> 121;
                    case 50 -> 63;
                    case 51 -> 211;
                    case 52 -> 181;
                    case 53 -> 219;
                    case 54 -> 176;
                    case 55 -> 197;
                    case 56 -> 202;
                    case 57 -> 124;
                    case 58 -> 157;
                    case 59 -> 96;
                    case 60 -> 191;
                    case 61 -> 253;
                    case 62 -> 117;
                    case 63 -> 248;
                    case 64 -> 55;
                    case 65 -> 27;
                    case 66 -> 103;
                    case 67 -> 136;
                    case 68 -> 78;
                    case 69 -> 6;
                    case 70 -> 146;
                    case 71 -> 39;
                    case 72 -> 141;
                    case 73 -> 127;
                    case 74 -> 106;
                    case 75 -> 43;
                    case 76 -> 213;
                    case 77 -> 2;
                    case 78 -> 156;
                    case 79 -> 159;
                    case 80 -> 230;
                    case 81 -> 66;
                    case 82 -> 243;
                    case 83 -> 24;
                    case 84 -> 38;
                    case 85 -> 7;
                    case 86 -> 97;
                    case 87 -> 123;
                    case 88 -> 143;
                    case 89 -> 41;
                    case 90 -> 120;
                    case 91 -> 62;
                    case 92 -> 172;
                    case 93 -> 46;
                    case 94 -> 148;
                    case 95 -> 33;
                    case 96 -> 183;
                    case 97 -> 105;
                    case 98 -> 226;
                    case 99 -> 45;
                    case 100 -> 158;
                    case 101 -> 122;
                    case 102 -> 184;
                    case 103 -> 112;
                    case 104 -> 71;
                    case 105 -> 175;
                    case 106 -> 107;
                    case 107 -> 82;
                    case 108 -> 98;
                    case 109 -> 20;
                    case 110 -> 108;
                    case 111 -> 204;
                    case 112 -> 140;
                    case 113 -> 201;
                    case 114 -> 81;
                    case 115 -> 186;
                    case 116 -> 252;
                    case 117 -> 166;
                    case 118 -> 14;
                    case 119 -> 163;
                    case 120 -> 17;
                    case 121 -> 51;
                    case 122 -> 125;
                    case 123 -> 224;
                    case 124 -> 1;
                    case 125 -> 64;
                    case 126 -> 232;
                    case 127 -> 74;
                    case 128 -> 8;
                    case 129 -> 91;
                    case 130 -> 61;
                    case 131 -> 221;
                    case 132 -> 171;
                    case 133 -> 217;
                    case 134 -> 193;
                    case 135 -> 80;
                    case 136 -> 170;
                    case 137 -> 67;
                    case 138 -> 154;
                    case 139 -> 23;
                    case 140 -> 208;
                    case 141 -> 133;
                    case 142 -> 73;
                    case 143 -> 142;
                    case 144 -> 179;
                    case 145 -> 240;
                    case 146 -> 89;
                    case 147 -> 149;
                    case 148 -> 94;
                    case 149 -> 235;
                    case 150 -> 245;
                    case 151 -> 236;
                    case 152 -> 206;
                    case 153 -> 109;
                    case 154 -> 215;
                    case 155 -> 92;
                    case 156 -> 76;
                    case 157 -> 223;
                    case 158 -> 239;
                    case 159 -> 216;
                    case 160 -> 246;
                    case 161 -> 119;
                    case 162 -> 19;
                    case 163 -> 9;
                    case 164 -> 126;
                    case 165 -> 182;
                    case 166 -> 16;
                    case 167 -> 196;
                    case 168 -> 195;
                    case 169 -> 0;
                    case 170 -> 131;
                    case 171 -> 87;
                    case 172 -> 150;
                    case 173 -> 10;
                    case 174 -> 128;
                    case 175 -> 21;
                    case 176 -> 26;
                    case 177 -> 198;
                    case 178 -> 242;
                    case 179 -> 161;
                    case 180 -> 3;
                    case 181 -> 114;
                    case 182 -> 40;
                    case 183 -> 147;
                    case 184 -> 255;
                    case 185 -> 214;
                    case 186 -> 54;
                    case 187 -> 227;
                    case 188 -> 104;
                    case 189 -> 83;
                    case 190 -> 138;
                    case 191 -> 4;
                    case 192 -> 56;
                    case 193 -> 238;
                    case 194 -> 234;
                    case 195 -> 130;
                    case 196 -> 153;
                    case 197 -> 36;
                    case 198 -> 231;
                    case 199 -> 134;
                    case 200 -> 102;
                    case 201 -> 47;
                    case 202 -> 100;
                    case 203 -> 207;
                    case 204 -> 222;
                    case 205 -> 174;
                    case 206 -> 139;
                    case 207 -> 22;
                    case 208 -> 200;
                    case 209 -> 209;
                    case 210 -> 155;
                    case 211 -> 85;
                    case 212 -> 185;
                    case 213 -> 160;
                    case 214 -> 210;
                    case 215 -> 187;
                    case 216 -> 194;
                    case 217 -> 229;
                    case 218 -> 132;
                    case 219 -> 12;
                    case 220 -> 152;
                    case 221 -> 151;
                    case 222 -> 115;
                    case 223 -> 113;
                    case 224 -> 101;
                    case 225 -> 116;
                    case 226 -> 18;
                    case 227 -> 188;
                    case 228 -> 110;
                    case 229 -> 65;
                    case 230 -> 13;
                    case 231 -> 254;
                    case 232 -> 86;
                    case 233 -> 49;
                    case 234 -> 169;
                    case 235 -> 95;
                    case 236 -> 11;
                    case 237 -> 251;
                    case 238 -> 58;
                    case 239 -> 77;
                    case 240 -> 180;
                    case 241 -> 164;
                    case 242 -> 145;
                    case 243 -> 70;
                    case 244 -> 205;
                    case 245 -> 137;
                    case 246 -> 29;
                    case 247 -> 218;
                    case 248 -> 241;
                    case 249 -> 165;
                    case 250 -> 237;
                    case 251 -> 42;
                    case 252 -> 88;
                    case 253 -> 53;
                    case 254 -> 162;
                    default -> 48;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeReadableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 68539652932935L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-564780630 + -((char)-19160), 564780630 + (char)-12745, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 872920646821L;
                    boolean bl = SshAgentIpcService.Y();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1042268640 + -20671, 1042268640 + (char)-27114, (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (!bl2) break block7;
                            if (n != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n = intByReference.getValue();
            }
            return n;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 83813033146684L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "v\u00cc\u00e6\u008a\u00b9\u0003\u0096\u008a\u00ac";
                var4_3 = "v\u00cc\u00e6\u008a\u00b9\u0003\u0096\u008a\u00ac".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 33;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 3;
                                break;
                            }
                            case 1: {
                                v11 = 30;
                                break;
                            }
                            case 2: {
                                v11 = 101;
                                break;
                            }
                            case 3: {
                                v11 = 48;
                                break;
                            }
                            case 4: {
                                v11 = 113;
                                break;
                            }
                            case 5: {
                                v11 = 127;
                                break;
                            }
                            default: {
                                v11 = 33;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0xFFFFE9C5) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 106;
                    case 1 -> 42;
                    case 2 -> 189;
                    case 3 -> 72;
                    case 4 -> 255;
                    case 5 -> 147;
                    case 6 -> 40;
                    case 7 -> 100;
                    case 8 -> 19;
                    case 9 -> 174;
                    case 10 -> 107;
                    case 11 -> 56;
                    case 12 -> 163;
                    case 13 -> 227;
                    case 14 -> 64;
                    case 15 -> 203;
                    case 16 -> 223;
                    case 17 -> 205;
                    case 18 -> 17;
                    case 19 -> 173;
                    case 20 -> 128;
                    case 21 -> 245;
                    case 22 -> 133;
                    case 23 -> 244;
                    case 24 -> 170;
                    case 25 -> 58;
                    case 26 -> 92;
                    case 27 -> 186;
                    case 28 -> 219;
                    case 29 -> 33;
                    case 30 -> 190;
                    case 31 -> 59;
                    case 32 -> 126;
                    case 33 -> 241;
                    case 34 -> 148;
                    case 35 -> 156;
                    case 36 -> 15;
                    case 37 -> 165;
                    case 38 -> 230;
                    case 39 -> 68;
                    case 40 -> 1;
                    case 41 -> 75;
                    case 42 -> 231;
                    case 43 -> 60;
                    case 44 -> 137;
                    case 45 -> 150;
                    case 46 -> 226;
                    case 47 -> 74;
                    case 48 -> 119;
                    case 49 -> 210;
                    case 50 -> 141;
                    case 51 -> 228;
                    case 52 -> 85;
                    case 53 -> 214;
                    case 54 -> 77;
                    case 55 -> 242;
                    case 56 -> 125;
                    case 57 -> 184;
                    case 58 -> 20;
                    case 59 -> 62;
                    case 60 -> 187;
                    case 61 -> 177;
                    case 62 -> 51;
                    case 63 -> 6;
                    case 64 -> 154;
                    case 65 -> 112;
                    case 66 -> 97;
                    case 67 -> 5;
                    case 68 -> 211;
                    case 69 -> 247;
                    case 70 -> 78;
                    case 71 -> 115;
                    case 72 -> 99;
                    case 73 -> 55;
                    case 74 -> 235;
                    case 75 -> 221;
                    case 76 -> 192;
                    case 77 -> 87;
                    case 78 -> 229;
                    case 79 -> 73;
                    case 80 -> 142;
                    case 81 -> 57;
                    case 82 -> 102;
                    case 83 -> 158;
                    case 84 -> 149;
                    case 85 -> 104;
                    case 86 -> 191;
                    case 87 -> 197;
                    case 88 -> 11;
                    case 89 -> 238;
                    case 90 -> 109;
                    case 91 -> 254;
                    case 92 -> 160;
                    case 93 -> 10;
                    case 94 -> 66;
                    case 95 -> 198;
                    case 96 -> 183;
                    case 97 -> 234;
                    case 98 -> 243;
                    case 99 -> 208;
                    case 100 -> 209;
                    case 101 -> 182;
                    case 102 -> 164;
                    case 103 -> 32;
                    case 104 -> 123;
                    case 105 -> 157;
                    case 106 -> 152;
                    case 107 -> 145;
                    case 108 -> 28;
                    case 109 -> 175;
                    case 110 -> 217;
                    case 111 -> 84;
                    case 112 -> 23;
                    case 113 -> 159;
                    case 114 -> 139;
                    case 115 -> 193;
                    case 116 -> 86;
                    case 117 -> 233;
                    case 118 -> 176;
                    case 119 -> 4;
                    case 120 -> 7;
                    case 121 -> 52;
                    case 122 -> 200;
                    case 123 -> 93;
                    case 124 -> 237;
                    case 125 -> 14;
                    case 126 -> 111;
                    case 127 -> 127;
                    case 128 -> 63;
                    case 129 -> 49;
                    case 130 -> 53;
                    case 131 -> 67;
                    case 132 -> 94;
                    case 133 -> 225;
                    case 134 -> 91;
                    case 135 -> 44;
                    case 136 -> 251;
                    case 137 -> 114;
                    case 138 -> 135;
                    case 139 -> 180;
                    case 140 -> 30;
                    case 141 -> 22;
                    case 142 -> 89;
                    case 143 -> 204;
                    case 144 -> 116;
                    case 145 -> 124;
                    case 146 -> 171;
                    case 147 -> 121;
                    case 148 -> 82;
                    case 149 -> 105;
                    case 150 -> 146;
                    case 151 -> 253;
                    case 152 -> 167;
                    case 153 -> 12;
                    case 154 -> 79;
                    case 155 -> 95;
                    case 156 -> 155;
                    case 157 -> 207;
                    case 158 -> 240;
                    case 159 -> 195;
                    case 160 -> 88;
                    case 161 -> 69;
                    case 162 -> 213;
                    case 163 -> 218;
                    case 164 -> 27;
                    case 165 -> 96;
                    case 166 -> 222;
                    case 167 -> 151;
                    case 168 -> 48;
                    case 169 -> 113;
                    case 170 -> 185;
                    case 171 -> 252;
                    case 172 -> 39;
                    case 173 -> 130;
                    case 174 -> 196;
                    case 175 -> 202;
                    case 176 -> 3;
                    case 177 -> 36;
                    case 178 -> 98;
                    case 179 -> 250;
                    case 180 -> 140;
                    case 181 -> 35;
                    case 182 -> 153;
                    case 183 -> 212;
                    case 184 -> 37;
                    case 185 -> 131;
                    case 186 -> 34;
                    case 187 -> 132;
                    case 188 -> 169;
                    case 189 -> 80;
                    case 190 -> 143;
                    case 191 -> 13;
                    case 192 -> 2;
                    case 193 -> 232;
                    case 194 -> 199;
                    case 195 -> 134;
                    case 196 -> 194;
                    case 197 -> 168;
                    case 198 -> 46;
                    case 199 -> 61;
                    case 200 -> 9;
                    case 201 -> 188;
                    case 202 -> 215;
                    case 203 -> 120;
                    case 204 -> 16;
                    case 205 -> 138;
                    case 206 -> 136;
                    case 207 -> 110;
                    case 208 -> 71;
                    case 209 -> 246;
                    case 210 -> 249;
                    case 211 -> 239;
                    case 212 -> 201;
                    case 213 -> 172;
                    case 214 -> 18;
                    case 215 -> 90;
                    case 216 -> 54;
                    case 217 -> 122;
                    case 218 -> 43;
                    case 219 -> 206;
                    case 220 -> 103;
                    case 221 -> 0;
                    case 222 -> 248;
                    case 223 -> 76;
                    case 224 -> 21;
                    case 225 -> 162;
                    case 226 -> 181;
                    case 227 -> 117;
                    case 228 -> 45;
                    case 229 -> 161;
                    case 230 -> 83;
                    case 231 -> 41;
                    case 232 -> 38;
                    case 233 -> 26;
                    case 234 -> 47;
                    case 235 -> 179;
                    case 236 -> 50;
                    case 237 -> 70;
                    case 238 -> 178;
                    case 239 -> 216;
                    case 240 -> 166;
                    case 241 -> 220;
                    case 242 -> 236;
                    case 243 -> 101;
                    case 244 -> 129;
                    case 245 -> 118;
                    case 246 -> 65;
                    case 247 -> 81;
                    case 248 -> 144;
                    case 249 -> 31;
                    case 250 -> 224;
                    case 251 -> 25;
                    case 252 -> 108;
                    case 253 -> 8;
                    case 254 -> 24;
                    default -> 29;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeWritableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }
}

