/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.google.gson.JsonObject;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceInitialState;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.prettierjs.PrettierBundle;
import com.intellij.prettierjs.PrettierLanguageService;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrettierLanguageServiceImpl
extends JSLanguageServiceBase
implements PrettierLanguageService {
    private final VirtualFile myWorkingDirectory;
    private volatile boolean myFlushConfigCache;

    public PrettierLanguageServiceImpl(@NotNull Project project, @NotNull VirtualFile workingDirectory) {
        if (project == null) {
            PrettierLanguageServiceImpl.$$$reportNull$$$0(0);
        }
        if (workingDirectory == null) {
            PrettierLanguageServiceImpl.$$$reportNull$$$0(1);
        }
        super(project);
        this.myWorkingDirectory = workingDirectory;
        project.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileContentChangeEvent && !PrettierUtil.isConfigFileOrPackageJson(vFileEvent.getFile())) continue;
                    PrettierLanguageServiceImpl.this.myFlushConfigCache = true;
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/prettierjs/PrettierLanguageServiceImpl$1", "after"));
            }
        });
    }

    @Override
    @Nullable
    public CompletableFuture<PrettierLanguageService.FormatResult> format(@NotNull String filePath, @Nullable String ignoreFilePath, @NotNull String text, @NotNull NodePackage prettierPackage, @Nullable TextRange range) {
        if (filePath == null) {
            PrettierLanguageServiceImpl.$$$reportNull$$$0(2);
        }
        if (text == null) {
            PrettierLanguageServiceImpl.$$$reportNull$$$0(3);
        }
        if (prettierPackage == null) {
            PrettierLanguageServiceImpl.$$$reportNull$$$0(4);
        }
        filePath = JSLanguageServiceUtil.normalizeNameAndPath((String)filePath);
        ignoreFilePath = JSLanguageServiceUtil.normalizeNameAndPath((String)ignoreFilePath);
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null || !process.isValid()) {
            return CompletableFuture.completedFuture(PrettierLanguageService.FormatResult.error(PrettierBundle.message("service.not.started.message", new Object[0])));
        }
        boolean forceLineBreakAtEof = range != null && range.getEndOffset() < text.length() && text.endsWith("\n");
        ReformatFileCommand command = new ReformatFileCommand(this.myProject, filePath, prettierPackage, ignoreFilePath, text, range, this.myFlushConfigCache);
        return process.execute((JSLanguageServiceCommand)command, (ignored, response) -> {
            this.myFlushConfigCache = false;
            return PrettierLanguageServiceImpl.parseReformatResponse(response, forceLineBreakAtEof);
        });
    }

    @NotNull
    private static PrettierLanguageService.FormatResult parseReformatResponse(@NotNull JSLanguageServiceAnswer response, boolean forceLineBreakAtEof) {
        JsonObject jsonObject;
        String error;
        if (response == null) {
            PrettierLanguageServiceImpl.$$$reportNull$$$0(5);
        }
        if (!StringUtil.isEmpty((String)(error = JsonUtil.getChildAsString((JsonObject)(jsonObject = response.getElement()), (String)"error")))) {
            PrettierLanguageService.FormatResult formatResult = PrettierLanguageService.FormatResult.error(error);
            if (formatResult == null) {
                PrettierLanguageServiceImpl.$$$reportNull$$$0(6);
            }
            return formatResult;
        }
        if (JsonUtil.getChildAsBoolean((JsonObject)jsonObject, (String)"ignored", (boolean)false)) {
            PrettierLanguageService.FormatResult formatResult = PrettierLanguageService.FormatResult.IGNORED;
            if (formatResult == null) {
                PrettierLanguageServiceImpl.$$$reportNull$$$0(7);
            }
            return formatResult;
        }
        if (JsonUtil.getChildAsBoolean((JsonObject)jsonObject, (String)"unsupported", (boolean)false)) {
            PrettierLanguageService.FormatResult formatResult = PrettierLanguageService.FormatResult.UNSUPPORTED;
            if (formatResult == null) {
                PrettierLanguageServiceImpl.$$$reportNull$$$0(8);
            }
            return formatResult;
        }
        Object formattedResult = JsonUtil.getChildAsString((JsonObject)jsonObject, (String)"formatted");
        JSLanguageServiceQueue.Holder.LOGGER.assertTrue(formattedResult != null);
        if (forceLineBreakAtEof && !((String)formattedResult).endsWith("\n")) {
            formattedResult = (String)formattedResult + "\n";
        }
        PrettierLanguageService.FormatResult formatResult = PrettierLanguageService.FormatResult.formatted((String)formattedResult);
        if (formatResult == null) {
            PrettierLanguageServiceImpl.$$$reportNull$$$0(9);
        }
        return formatResult;
    }

    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        return new JSLanguageServiceQueueImpl(this.myProject, (JSLanguageServiceProtocol)new Protocol(this.myProject, o -> {}), this.myProcessConnector, (JSLanguageServiceQueue.ServiceInfoReporter)this.myDefaultReporter, (JSLanguageServiceCacheData)new JSLanguageServiceDefaultCacheData());
    }

    protected boolean needInitToolWindow() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prettierPackage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/prettierjs/PrettierLanguageServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/prettierjs/PrettierLanguageServiceImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReformatResponse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseReformatResponse";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class ReformatFileCommand
    implements JSLanguageServiceObject,
    JSLanguageServiceSimpleCommand {
        public final LocalFilePath path;
        public final LocalFilePath prettierPath;
        @Nullable
        public final LocalFilePath packageJsonPath;
        @Nullable
        public final String ignoreFilePath;
        public final String content;
        public Integer start;
        public Integer end;
        public final boolean flushConfigCache;

        ReformatFileCommand(@NotNull Project project, @NotNull String filePath, @NotNull NodePackage prettierPackage, @Nullable String ignoreFilePath, @NotNull String content, @Nullable TextRange range, boolean flushConfigCache) {
            if (project == null) {
                ReformatFileCommand.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                ReformatFileCommand.$$$reportNull$$$0(1);
            }
            if (prettierPackage == null) {
                ReformatFileCommand.$$$reportNull$$$0(2);
            }
            if (content == null) {
                ReformatFileCommand.$$$reportNull$$$0(3);
            }
            this.path = LocalFilePath.create((String)filePath);
            Pair<LocalFilePath, LocalFilePath> pair = ReformatFileCommand.createPackagePath(project, prettierPackage);
            this.prettierPath = (LocalFilePath)pair.first;
            this.packageJsonPath = (LocalFilePath)pair.second;
            this.ignoreFilePath = ignoreFilePath;
            this.content = content;
            this.flushConfigCache = flushConfigCache;
            if (range != null) {
                this.start = range.getStartOffset();
                this.end = range.getEndOffset();
            }
        }

        @NotNull
        private static Pair<LocalFilePath, LocalFilePath> createPackagePath(@NotNull Project project, @NotNull NodePackage prettierPackage) {
            String packageJsonPath;
            String packagePath;
            if (project == null) {
                ReformatFileCommand.$$$reportNull$$$0(4);
            }
            if (prettierPackage == null) {
                ReformatFileCommand.$$$reportNull$$$0(5);
            }
            if (prettierPackage instanceof YarnPnpNodePackage) {
                YarnPnpNodePackage pnpPkg = (YarnPnpNodePackage)prettierPackage;
                packagePath = pnpPkg.getName();
                packageJsonPath = pnpPkg.getPackageJsonPath(project);
                if (packageJsonPath == null) {
                    throw new IllegalStateException("Cannot find package.json for " + pnpPkg);
                }
                packageJsonPath = FileUtil.toSystemDependentName((String)packageJsonPath);
            } else {
                packagePath = prettierPackage.getSystemDependentPath();
                packageJsonPath = null;
            }
            Pair pair = Pair.create((Object)LocalFilePath.create((String)packagePath), (Object)LocalFilePath.create(packageJsonPath));
            if (pair == null) {
                ReformatFileCommand.$$$reportNull$$$0(6);
            }
            return pair;
        }

        @NotNull
        public JSLanguageServiceObject toSerializableObject() {
            ReformatFileCommand reformatFileCommand = this;
            if (reformatFileCommand == null) {
                ReformatFileCommand.$$$reportNull$$$0(7);
            }
            return reformatFileCommand;
        }

        @NotNull
        public String getCommand() {
            return "reformat";
        }

        @Nullable
        public String getPresentableText(@NotNull Project project) {
            if (project == null) {
                ReformatFileCommand.$$$reportNull$$$0(8);
            }
            return PrettierBundle.message("progress.title", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prettierPackage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/prettierjs/PrettierLanguageServiceImpl$ReformatFileCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/prettierjs/PrettierLanguageServiceImpl$ReformatFileCommand";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPackagePath";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toSerializableObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createPackagePath";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentableText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private class Protocol
    extends JSLanguageServiceNodeStdProtocolBase {
        Protocol(@NotNull Project project, Consumer<?> readyConsumer) {
            if (project == null) {
                Protocol.$$$reportNull$$$0(0);
            }
            if (readyConsumer == null) {
                Protocol.$$$reportNull$$$0(1);
            }
            super("prettier", project, readyConsumer);
        }

        protected void addNodeProcessAdditionalArguments(@NotNull NodeTargetRun targetRun) {
            if (targetRun == null) {
                Protocol.$$$reportNull$$$0(2);
            }
            super.addNodeProcessAdditionalArguments(targetRun);
            targetRun.path(JSLanguageServiceUtil.getPluginDirectory(((Object)((Object)this)).getClass(), (String)"prettierLanguageService").getAbsolutePath());
        }

        protected String getWorkingDirectory() {
            VirtualFile file;
            Application application = ApplicationManager.getApplication();
            if (application != null && application.isUnitTestMode() && (file = ProjectUtil.guessProjectDir((Project)this.myProject)) != null) {
                return file.getPath();
            }
            return FileUtil.toSystemDependentName((String)PrettierLanguageServiceImpl.this.myWorkingDirectory.getPath());
        }

        protected boolean needReadActionToCreateState() {
            return false;
        }

        protected JSLanguageServiceInitialState createState() {
            JSLanguageServiceInitialState state = new JSLanguageServiceInitialState();
            File service = new File(JSLanguageServiceUtil.getPluginDirectory(((Object)((Object)this)).getClass(), (String)"prettierLanguageService"), "prettier-plugin-provider.js");
            if (!service.exists()) {
                JSLanguageServiceQueue.Holder.LOGGER.error("prettier language service plugin not found");
            }
            state.pluginName = "prettier";
            state.pluginPath = LocalFilePath.create((String)service.getAbsolutePath());
            return state;
        }

        public void dispose() {
        }

        @NotNull
        protected NodeCommandLineConfigurator.Options getNodeCommandLineConfiguratorOptions(@NotNull Project project) {
            if (project == null) {
                Protocol.$$$reportNull$$$0(3);
            }
            NodeCommandLineConfigurator.Options options = NodeCommandLineConfigurator.defaultOptions((Project)this.myProject);
            if (options == null) {
                Protocol.$$$reportNull$$$0(4);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readyConsumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRun";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/prettierjs/PrettierLanguageServiceImpl$Protocol";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/prettierjs/PrettierLanguageServiceImpl$Protocol";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeCommandLineConfiguratorOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addNodeProcessAdditionalArguments";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getNodeCommandLineConfiguratorOptions";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

