/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.MergingCharSequence;
import com.jetbrains.python.lexer.PythonLexer;
import com.jetbrains.python.psi.PyReparseableTokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyReparseableIdentifier
extends PyReparseableTokenType {
    private static final Logger LOG = Logger.getInstance(PyReparseableTokenType.class);

    public PyReparseableIdentifier(@NotNull String debugName) {
        if (debugName == null) {
            PyReparseableIdentifier.$$$reportNull$$$0(0);
        }
        super(debugName);
    }

    @Nullable
    public ASTNode reparseLeaf(@NotNull ASTNode leaf, @NotNull CharSequence newText) {
        if (leaf == null) {
            PyReparseableIdentifier.$$$reportNull$$$0(1);
        }
        if (newText == null) {
            PyReparseableIdentifier.$$$reportNull$$$0(2);
        }
        if (!Registry.is((String)"python.ast.leaves.incremental.reparse")) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to reparse leaf element of type" + this + "\nold text: \n" + leaf.getText() + "\n\nnew text: \n" + newText);
        }
        if (newText.isEmpty()) {
            LOG.debug("New text is empty");
            return null;
        }
        ASTNode lexingContainer = leaf.getTreeParent();
        if (lexingContainer == null) {
            LOG.debug("No re-lexing container for a leaf");
            return null;
        }
        CharSequence originalCharSequence = lexingContainer.getChars();
        TextRange originalLeafRangeInLexingContainer = leaf.getTextRange().shiftLeft(lexingContainer.getStartOffset());
        MergingCharSequence updatedCharSequence = StringUtil.replaceSubSequence((CharSequence)originalCharSequence, (int)originalLeafRangeInLexingContainer.getStartOffset(), (int)originalLeafRangeInLexingContainer.getEndOffset(), (CharSequence)newText);
        LeafElement currentLeaf = TreeUtil.findFirstLeaf((ASTNode)lexingContainer);
        PythonLexer lexer = new PythonLexer();
        lexer.start((CharSequence)updatedCharSequence);
        while (true) {
            if (currentLeaf == null) {
                LOG.debug("We are out of original leaves");
                return null;
            }
            IElementType tokenType = lexer.getTokenType();
            if (currentLeaf instanceof PsiWhiteSpace) {
                currentLeaf = TreeUtil.nextLeaf((LeafElement)currentLeaf);
                lexer.advance();
                continue;
            }
            if (tokenType != currentLeaf.getElementType()) {
                LOG.debug("Wrong token type lexed: ", new Object[]{tokenType, " instead of ", currentLeaf.getElementType()});
                return null;
            }
            TextRange currentLeafRangeInLexingContainer = currentLeaf.getTextRange().shiftLeft(lexingContainer.getStartOffset());
            if (currentLeaf == leaf) {
                int expectedEndOffset = currentLeafRangeInLexingContainer.getStartOffset() + newText.length();
                if (lexer.getTokenEnd() == expectedEndOffset) break;
                LOG.debug("Wrong end offset, got ", new Object[]{lexer.getTokenEnd(), " instead of ", expectedEndOffset});
                return null;
            }
            if (currentLeafRangeInLexingContainer.getEndOffset() != lexer.getTokenEnd()) {
                LOG.debug("Wrong token end offset for: ", new Object[]{tokenType, "; got ", lexer.getTokenEnd(), " instead of ", currentLeafRangeInLexingContainer.getEndOffset()});
                return null;
            }
            currentLeaf = TreeUtil.nextLeaf((LeafElement)currentLeaf);
            lexer.advance();
        }
        LOG.debug("Reparse is successful");
        return ASTFactory.leaf((IElementType)this, (CharSequence)newText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/PyReparseableIdentifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reparseLeaf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

