/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.json;

import com.intellij.clouds.docker.gateway.utils.UtilsKt;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.image.DockerImagePsiReference;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/clouds/docker/gateway/json/DevcontainerJsonImageReferenceContributor;", "Lcom/intellij/psi/PsiReferenceContributor;", "<init>", "()V", "registerReferenceProviders", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "ImagePsiReferenceProvider", "intellij.clouds.docker.gateway"})
public final class DevcontainerJsonImageReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        ObjectPattern objectPattern = PlatformPatterns.psiElement(JsonStringLiteral.class).with((PatternCondition)new PatternCondition<JsonStringLiteral>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accepts(JsonStringLiteral t, ProcessingContext context2) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                PsiElement psiElement = t.getParent();
                if (!(psiElement instanceof JsonProperty)) return false;
                JsonProperty jsonProperty = (JsonProperty)psiElement;
                if (jsonProperty == null) {
                    return false;
                }
                JsonProperty prop = jsonProperty;
                PsiElement psiElement2 = prop.getParent();
                if ((psiElement2 != null ? psiElement2.getParent() : null) != prop.getContainingFile()) return false;
                if (!Intrinsics.areEqual((Object)prop.getName(), (Object)"image")) return false;
                if (prop.getValue() != t) return false;
                PsiFile psiFile = t.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                if (!UtilsKt.isDevcontainerFile(psiFile)) return false;
                return true;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        PsiElementPattern.Capture pattern2 = (PsiElementPattern.Capture)objectPattern;
        registrar.registerReferenceProvider((ElementPattern)pattern2, (PsiReferenceProvider)new ImagePsiReferenceProvider());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/clouds/docker/gateway/json/DevcontainerJsonImageReferenceContributor$ImagePsiReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "intellij.clouds.docker.gateway"})
    private static final class ImagePsiReferenceProvider
    extends PsiReferenceProvider {
        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            String string = JsonPsiUtil.stripQuotes((String)element.getText());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stripQuotes(...)");
            String text = string;
            DockerRepoTag dockerRepoTag = DockerRepoTag.fromString((String)text);
            Intrinsics.checkNotNullExpressionValue((Object)dockerRepoTag, (String)"fromString(...)");
            DockerRepoTag parsedTag = dockerRepoTag;
            PsiReference[] psiReferenceArray = new PsiReference[]{DockerImagePsiReference.Companion.createDockerImagePsiReference$default((DockerImagePsiReference.Companion)DockerImagePsiReference.Companion, (PsiElement)element, (DockerRepoTag)parsedTag, null, (int)4, null)};
            return psiReferenceArray;
        }
    }
}

