/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.editor;

import com.intellij.notebooks.ui.editor.MouseHoveredGutterKt;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.ui.visualization.DefaultNotebookEditorAppearanceSizes;
import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.notebooks.ui.visualization.NotebookEditorAppearanceSizes;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.ui.JBColor;
import com.intellij.ui.NewUiValue;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b0\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u001a\u0010,\u001a\u0004\u0018\u00010\u00062\u0006\u0010(\u001a\u00020-2\u0006\u0010*\u001a\u00020+H\u0016J\u001a\u0010.\u001a\u0004\u0018\u00010\u00062\u0006\u0010(\u001a\u00020-2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010(\u001a\u00020)H\u0016J\b\u00101\u001a\u000200H\u0016J\b\u00102\u001a\u00020'H\u0016J\b\u00103\u001a\u00020'H\u0016J\b\u00104\u001a\u00020'H\u0016J\b\u00105\u001a\u00020'H\u0016J\t\u00106\u001a\u000200H\u0096\u0001R\u0016\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0010\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0016\u0010\u0013\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0016\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001c\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000eR\u0016\u0010\u001f\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000eR\u0016\u0010\"\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000eR\u0016\u0010$\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000eR\u0012\u00107\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0012\u0010:\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b;\u00109R\u0012\u0010<\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b=\u00109R\u0012\u0010>\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b?\u00109R\u0012\u0010@\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bA\u00109R\u0012\u0010B\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bC\u00109R\u0012\u0010D\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bE\u00109R\u0012\u0010F\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bG\u00109R\u0012\u0010H\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bI\u00109R\u0012\u0010J\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bK\u00109R\u0012\u0010L\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bM\u00109R\u0012\u0010N\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bO\u00109R\u0012\u0010P\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bQ\u00109R\u0012\u0010R\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bS\u00109R\u0012\u0010T\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bU\u00109R\u0012\u0010V\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bW\u00109R\u0012\u0010X\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bY\u00109R\u0012\u0010Z\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b[\u00109R\u0012\u0010\\\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b]\u00109R\u0012\u0010^\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b_\u00109\u00a8\u0006`"}, d2={"Lcom/intellij/notebooks/ui/editor/DefaultNotebookEditorAppearance;", "Lcom/intellij/notebooks/ui/visualization/NotebookEditorAppearance;", "Lcom/intellij/notebooks/ui/visualization/NotebookEditorAppearanceSizes;", "<init>", "()V", "getCodeCellBackground", "Ljava/awt/Color;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "getCaretRowColor", "GUTTER_INPUT_EXECUTION_COUNT", "Lcom/intellij/openapi/editor/colors/ColorKey;", "Lorg/jetbrains/annotations/NotNull;", "getGUTTER_INPUT_EXECUTION_COUNT", "()Lcom/intellij/openapi/editor/colors/ColorKey;", "getGutterInputExecutionCountForegroundColor", "GUTTER_OUTPUT_EXECUTION_COUNT", "getGUTTER_OUTPUT_EXECUTION_COUNT", "getGutterOutputExecutionCountForegroundColor", "PROGRESS_STATUS_RUNNING_COLOR", "getPROGRESS_STATUS_RUNNING_COLOR", "getProgressStatusRunningColor", "SAUSAGE_BUTTON_APPEARANCE", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getSAUSAGE_BUTTON_APPEARANCE", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getSausageButtonAppearanceBackgroundColor", "getSausageButtonAppearanceForegroundColor", "SAUSAGE_BUTTON_SHORTCUT_COLOR", "getSAUSAGE_BUTTON_SHORTCUT_COLOR", "getSausageButtonShortcutColor", "SAUSAGE_BUTTON_BORDER_COLOR", "getSAUSAGE_BUTTON_BORDER_COLOR", "getSausageButtonBorderColor", "CELL_UNDER_CARET_COMMAND_MODE_STRIPE_COLOR", "getCELL_UNDER_CARET_COMMAND_MODE_STRIPE_COLOR", "CELL_UNDER_CARET_EDITOR_MODE_STRIPE_COLOR", "getCELL_UNDER_CARET_EDITOR_MODE_STRIPE_COLOR", "isCellSelected", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "lines", "Lkotlin/ranges/IntRange;", "getCellStripeColor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "getCellStripeHoverColor", "getCellLeftLineWidth", "", "getCellLeftLineHoverWidth", "shouldShowCellLineNumbers", "shouldShowExecutionCounts", "shouldShowOutExecutionCounts", "shouldShowRunButtonInGutter", "getLeftBorderWidth", "CELL_TOOLBAR_TOTAL_HEIGHT", "getCELL_TOOLBAR_TOTAL_HEIGHT", "()I", "CODE_AND_CODE_BOTTOM_GRAY_HEIGHT", "getCODE_AND_CODE_BOTTOM_GRAY_HEIGHT", "CODE_AND_CODE_TOP_GRAY_HEIGHT", "getCODE_AND_CODE_TOP_GRAY_HEIGHT", "CODE_CELL_LEFT_LINE_PADDING", "getCODE_CELL_LEFT_LINE_PADDING", "COMMAND_MODE_CELL_LEFT_LINE_WIDTH", "getCOMMAND_MODE_CELL_LEFT_LINE_WIDTH", "EDIT_MODE_CELL_LEFT_LINE_WIDTH", "getEDIT_MODE_CELL_LEFT_LINE_WIDTH", "EXECUTION_TIME_HEIGHT", "getEXECUTION_TIME_HEIGHT", "EXTRA_PADDING_EXECUTION_COUNT", "getEXTRA_PADDING_EXECUTION_COUNT", "INNER_CELL_TOOLBAR_HEIGHT", "getINNER_CELL_TOOLBAR_HEIGHT", "JUPYTER_BELOW_OUTPUT_CELL_SPACERS_INLAY_PRIORITY", "getJUPYTER_BELOW_OUTPUT_CELL_SPACERS_INLAY_PRIORITY", "JUPYTER_CELL_SPACERS_INLAY_PRIORITY", "getJUPYTER_CELL_SPACERS_INLAY_PRIORITY", "JUPYTER_CELL_TOOLBAR_INLAY_PRIORITY", "getJUPYTER_CELL_TOOLBAR_INLAY_PRIORITY", "LINE_NUMBERS_MARGIN", "getLINE_NUMBERS_MARGIN", "NOTEBOOK_OUTPUT_INLAY_PRIORITY", "getNOTEBOOK_OUTPUT_INLAY_PRIORITY", "PROGRESS_STATUS_HEIGHT", "getPROGRESS_STATUS_HEIGHT", "SPACER_HEIGHT", "getSPACER_HEIGHT", "SPACE_BELOW_CELL_TOOLBAR", "getSPACE_BELOW_CELL_TOOLBAR", "aboveFirstCellDelimiterHeight", "getAboveFirstCellDelimiterHeight", "cellBorderHeight", "getCellBorderHeight", "distanceBetweenCells", "getDistanceBetweenCells", "intellij.notebooks.ui"})
@SourceDebugExtension(value={"SMAP\nDefaultNotebookEditorAppearance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultNotebookEditorAppearance.kt\ncom/intellij/notebooks/ui/editor/DefaultNotebookEditorAppearance\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1755#2,3:123\n1#3:126\n*S KotlinDebug\n*F\n+ 1 DefaultNotebookEditorAppearance.kt\ncom/intellij/notebooks/ui/editor/DefaultNotebookEditorAppearance\n*L\n67#1:123,3\n*E\n"})
public final class DefaultNotebookEditorAppearance
implements NotebookEditorAppearance,
NotebookEditorAppearanceSizes {
    @NotNull
    public static final DefaultNotebookEditorAppearance INSTANCE = new DefaultNotebookEditorAppearance();
    private final /* synthetic */ DefaultNotebookEditorAppearanceSizes $$delegate_0;
    @NotNull
    private static final ColorKey GUTTER_INPUT_EXECUTION_COUNT;
    @NotNull
    private static final ColorKey GUTTER_OUTPUT_EXECUTION_COUNT;
    @NotNull
    private static final ColorKey PROGRESS_STATUS_RUNNING_COLOR;
    @NotNull
    private static final TextAttributesKey SAUSAGE_BUTTON_APPEARANCE;
    @NotNull
    private static final ColorKey SAUSAGE_BUTTON_SHORTCUT_COLOR;
    @NotNull
    private static final ColorKey SAUSAGE_BUTTON_BORDER_COLOR;
    @NotNull
    private static final ColorKey CELL_UNDER_CARET_COMMAND_MODE_STRIPE_COLOR;
    @NotNull
    private static final ColorKey CELL_UNDER_CARET_EDITOR_MODE_STRIPE_COLOR;

    private DefaultNotebookEditorAppearance() {
        this.$$delegate_0 = DefaultNotebookEditorAppearanceSizes.INSTANCE;
    }

    @Override
    @Nullable
    public Color getCodeCellBackground(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return scheme.getColor(NotebookEditorAppearance.Companion.getCODE_CELL_BACKGROUND());
    }

    @Override
    @Nullable
    public Color getCaretRowColor(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return scheme.getColor(EditorColors.CARET_ROW_COLOR);
    }

    @NotNull
    public final ColorKey getGUTTER_INPUT_EXECUTION_COUNT() {
        return GUTTER_INPUT_EXECUTION_COUNT;
    }

    @Override
    @Nullable
    public Color getGutterInputExecutionCountForegroundColor(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return scheme.getColor(GUTTER_INPUT_EXECUTION_COUNT);
    }

    @NotNull
    public final ColorKey getGUTTER_OUTPUT_EXECUTION_COUNT() {
        return GUTTER_OUTPUT_EXECUTION_COUNT;
    }

    @Override
    @Nullable
    public Color getGutterOutputExecutionCountForegroundColor(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return scheme.getColor(GUTTER_OUTPUT_EXECUTION_COUNT);
    }

    @NotNull
    public final ColorKey getPROGRESS_STATUS_RUNNING_COLOR() {
        return PROGRESS_STATUS_RUNNING_COLOR;
    }

    @Override
    @NotNull
    public Color getProgressStatusRunningColor(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Color color = scheme.getColor(PROGRESS_STATUS_RUNNING_COLOR);
        if (color == null) {
            color = NotebookEditorAppearance.DefaultImpls.getProgressStatusRunningColor(this, scheme);
        }
        return color;
    }

    @NotNull
    public final TextAttributesKey getSAUSAGE_BUTTON_APPEARANCE() {
        return SAUSAGE_BUTTON_APPEARANCE;
    }

    @Override
    @NotNull
    public Color getSausageButtonAppearanceBackgroundColor(@NotNull EditorColorsScheme scheme) {
        Color color;
        Color color2;
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        if (NewUiValue.isEnabled()) {
            color2 = JBUI.CurrentTheme.EditorTabs.background();
        } else {
            TextAttributes textAttributes = scheme.getAttributes(SAUSAGE_BUTTON_APPEARANCE);
            color2 = color = textAttributes != null ? textAttributes.getBackgroundColor() : null;
        }
        if (color2 == null) {
            color = NotebookEditorAppearance.DefaultImpls.getSausageButtonAppearanceBackgroundColor(this, scheme);
        }
        return color;
    }

    @Override
    @NotNull
    public Color getSausageButtonAppearanceForegroundColor(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Object object = scheme.getAttributes(SAUSAGE_BUTTON_APPEARANCE);
        if (object == null || (object = object.getForegroundColor()) == null) {
            object = NotebookEditorAppearance.DefaultImpls.getSausageButtonAppearanceForegroundColor(this, scheme);
        }
        return object;
    }

    @NotNull
    public final ColorKey getSAUSAGE_BUTTON_SHORTCUT_COLOR() {
        return SAUSAGE_BUTTON_SHORTCUT_COLOR;
    }

    @Override
    @NotNull
    public Color getSausageButtonShortcutColor(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Color color = scheme.getColor(SAUSAGE_BUTTON_SHORTCUT_COLOR);
        if (color == null) {
            color = NotebookEditorAppearance.DefaultImpls.getSausageButtonShortcutColor(this, scheme);
        }
        return color;
    }

    @NotNull
    public final ColorKey getSAUSAGE_BUTTON_BORDER_COLOR() {
        return SAUSAGE_BUTTON_BORDER_COLOR;
    }

    @Override
    @NotNull
    public Color getSausageButtonBorderColor(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Color color = scheme.getColor(SAUSAGE_BUTTON_BORDER_COLOR);
        if (color == null) {
            color = NotebookEditorAppearance.DefaultImpls.getSausageButtonBorderColor(this, scheme);
        }
        return color;
    }

    @NotNull
    public final ColorKey getCELL_UNDER_CARET_COMMAND_MODE_STRIPE_COLOR() {
        return CELL_UNDER_CARET_COMMAND_MODE_STRIPE_COLOR;
    }

    @NotNull
    public final ColorKey getCELL_UNDER_CARET_EDITOR_MODE_STRIPE_COLOR() {
        return CELL_UNDER_CARET_EDITOR_MODE_STRIPE_COLOR;
    }

    private final boolean isCellSelected(Editor editor, IntRange lines) {
        boolean bl;
        block5: {
            int cellStartOffset = editor.getDocument().getLineStartOffset(lines.getFirst());
            int cellEndOffset = editor.getDocument().getLineEndOffset(lines.getLast());
            List list = editor.getCaretModel().getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    Caret caret = (Caret)element$iv;
                    boolean bl3 = false;
                    if (caret.getOffset() < caret.getSelectionStart() || caret.getOffset() > caret.getSelectionEnd()) {
                        int n = lines.getFirst();
                        int n2 = lines.getLast();
                        int n3 = caret.getLogicalPosition().line;
                        bl2 = n <= n3 ? n3 <= n2 : false;
                    } else {
                        bl2 = cellStartOffset == caret.getSelectionEnd() && caret.getOffset() < cellStartOffset ? false : cellEndOffset >= caret.getSelectionStart() && caret.getSelectionEnd() >= cellStartOffset;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public Color getCellStripeColor(@NotNull EditorImpl editor, @NotNull IntRange lines) {
        Color color;
        ColorKey color2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        boolean isSelected = this.isCellSelected((Editor)editor, lines);
        ColorKey colorKey = color2 = isSelected && NotebookEditorModeKt.getCurrentMode((Editor)editor) == NotebookEditorMode.COMMAND ? CELL_UNDER_CARET_COMMAND_MODE_STRIPE_COLOR : (isSelected ? CELL_UNDER_CARET_EDITOR_MODE_STRIPE_COLOR : null);
        if (colorKey != null) {
            ColorKey colorKey2 = colorKey;
            EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
            ColorKey p0 = colorKey2;
            boolean $i$f$getCellStripeColor$stub_for_inlining = false;
            boolean bl = false;
            color = editorColorsScheme.getColor(p0);
        } else {
            color = null;
        }
        return color;
    }

    @Override
    @Nullable
    public Color getCellStripeHoverColor(@NotNull EditorImpl editor, @NotNull IntRange lines) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Integer hoveredGutterLine = MouseHoveredGutterKt.getNotebookGutterHoverLine((Editor)editor);
        if (hoveredGutterLine != null && lines.contains(hoveredGutterLine.intValue())) {
            return editor.getColorsScheme().getColor(NotebookEditorAppearance.Companion.getCELL_UNDER_CURSOR_STRIPE_HOVER_COLOR$intellij_notebooks_ui());
        }
        return null;
    }

    @Override
    @NotNull
    public Color getCellStripeHoverColor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Color color = editor.getColorsScheme().getColor(NotebookEditorAppearance.Companion.getCELL_UNDER_CURSOR_STRIPE_HOVER_COLOR$intellij_notebooks_ui());
        if (color == null) {
            JBColor jBColor = JBColor.BLUE;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"BLUE");
            color = (Color)jBColor;
        }
        return color;
    }

    @Override
    @NotNull
    public Color getCellStripeColor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Color color = editor.getColorsScheme().getColor(NotebookEditorAppearance.Companion.getCELL_STRIPE_COLOR$intellij_notebooks_ui());
        if (color == null) {
            JBColor jBColor = JBColor.GRAY;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"GRAY");
            color = (Color)jBColor;
        }
        return color;
    }

    @Override
    public int getCellLeftLineWidth(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return switch (WhenMappings.$EnumSwitchMapping$0[NotebookEditorModeKt.getCurrentMode(editor).ordinal()]) {
            case 1 -> this.getEDIT_MODE_CELL_LEFT_LINE_WIDTH();
            case 2 -> this.getCOMMAND_MODE_CELL_LEFT_LINE_WIDTH();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public int getCellLeftLineHoverWidth() {
        return this.getCOMMAND_MODE_CELL_LEFT_LINE_WIDTH();
    }

    @Override
    public boolean shouldShowCellLineNumbers() {
        return true;
    }

    @Override
    public boolean shouldShowExecutionCounts() {
        return true;
    }

    @Override
    public boolean shouldShowOutExecutionCounts() {
        return false;
    }

    @Override
    public boolean shouldShowRunButtonInGutter() {
        return true;
    }

    @Override
    @NotNull
    public ColorKey getCodeCellBackgroundColorKey() {
        return NotebookEditorAppearance.DefaultImpls.getCodeCellBackgroundColorKey(this);
    }

    @Override
    @NotNull
    public ObservableProperty<Color> getCodeCellBackgroundColor() {
        return NotebookEditorAppearance.DefaultImpls.getCodeCellBackgroundColor(this);
    }

    @Override
    @Nullable
    public Color getInlayBackgroundColor(@NotNull EditorColorsScheme scheme) {
        return NotebookEditorAppearance.DefaultImpls.getInlayBackgroundColor(this, scheme);
    }

    @Override
    @NotNull
    public Color getTextOutputBackground(@NotNull EditorColorsScheme scheme) {
        return NotebookEditorAppearance.DefaultImpls.getTextOutputBackground(this, scheme);
    }

    @Override
    public int getCODE_CELL_LEFT_LINE_PADDING() {
        return this.$$delegate_0.getCODE_CELL_LEFT_LINE_PADDING();
    }

    @Override
    public int getLINE_NUMBERS_MARGIN() {
        return this.$$delegate_0.getLINE_NUMBERS_MARGIN();
    }

    @Override
    public int getCOMMAND_MODE_CELL_LEFT_LINE_WIDTH() {
        return this.$$delegate_0.getCOMMAND_MODE_CELL_LEFT_LINE_WIDTH();
    }

    @Override
    public int getEDIT_MODE_CELL_LEFT_LINE_WIDTH() {
        return this.$$delegate_0.getEDIT_MODE_CELL_LEFT_LINE_WIDTH();
    }

    @Override
    public int getCODE_AND_CODE_TOP_GRAY_HEIGHT() {
        return this.$$delegate_0.getCODE_AND_CODE_TOP_GRAY_HEIGHT();
    }

    @Override
    public int getCODE_AND_CODE_BOTTOM_GRAY_HEIGHT() {
        return this.$$delegate_0.getCODE_AND_CODE_BOTTOM_GRAY_HEIGHT();
    }

    @Override
    public int getINNER_CELL_TOOLBAR_HEIGHT() {
        return this.$$delegate_0.getINNER_CELL_TOOLBAR_HEIGHT();
    }

    @Override
    public int getSPACER_HEIGHT() {
        return this.$$delegate_0.getSPACER_HEIGHT();
    }

    @Override
    public int getEXECUTION_TIME_HEIGHT() {
        return this.$$delegate_0.getEXECUTION_TIME_HEIGHT();
    }

    @Override
    public int getSPACE_BELOW_CELL_TOOLBAR() {
        return this.$$delegate_0.getSPACE_BELOW_CELL_TOOLBAR();
    }

    @Override
    public int getCELL_TOOLBAR_TOTAL_HEIGHT() {
        return this.$$delegate_0.getCELL_TOOLBAR_TOTAL_HEIGHT();
    }

    @Override
    public int getPROGRESS_STATUS_HEIGHT() {
        return this.$$delegate_0.getPROGRESS_STATUS_HEIGHT();
    }

    @Override
    public int getJUPYTER_CELL_SPACERS_INLAY_PRIORITY() {
        return this.$$delegate_0.getJUPYTER_CELL_SPACERS_INLAY_PRIORITY();
    }

    @Override
    public int getJUPYTER_BELOW_OUTPUT_CELL_SPACERS_INLAY_PRIORITY() {
        return this.$$delegate_0.getJUPYTER_BELOW_OUTPUT_CELL_SPACERS_INLAY_PRIORITY();
    }

    @Override
    public int getJUPYTER_CELL_TOOLBAR_INLAY_PRIORITY() {
        return this.$$delegate_0.getJUPYTER_CELL_TOOLBAR_INLAY_PRIORITY();
    }

    @Override
    public int getNOTEBOOK_OUTPUT_INLAY_PRIORITY() {
        return this.$$delegate_0.getNOTEBOOK_OUTPUT_INLAY_PRIORITY();
    }

    @Override
    public int getEXTRA_PADDING_EXECUTION_COUNT() {
        return this.$$delegate_0.getEXTRA_PADDING_EXECUTION_COUNT();
    }

    @Override
    public int getCellBorderHeight() {
        return this.$$delegate_0.getCellBorderHeight();
    }

    @Override
    public int getAboveFirstCellDelimiterHeight() {
        return this.$$delegate_0.getAboveFirstCellDelimiterHeight();
    }

    @Override
    public int getDistanceBetweenCells() {
        return this.$$delegate_0.getDistanceBetweenCells();
    }

    @Override
    public int getLeftBorderWidth() {
        return this.$$delegate_0.getLeftBorderWidth();
    }

    static {
        ColorKey colorKey = ColorKey.createColorKey((String)"JUPYTER.GUTTER_INPUT_EXECUTION_COUNT");
        Intrinsics.checkNotNullExpressionValue((Object)colorKey, (String)"createColorKey(...)");
        GUTTER_INPUT_EXECUTION_COUNT = colorKey;
        ColorKey colorKey2 = ColorKey.createColorKey((String)"JUPYTER.GUTTER_OUTPUT_EXECUTION_COUNT");
        Intrinsics.checkNotNullExpressionValue((Object)colorKey2, (String)"createColorKey(...)");
        GUTTER_OUTPUT_EXECUTION_COUNT = colorKey2;
        ColorKey colorKey3 = ColorKey.createColorKey((String)"JUPYTER.PROGRESS_STATUS_RUNNING_COLOR");
        Intrinsics.checkNotNullExpressionValue((Object)colorKey3, (String)"createColorKey(...)");
        PROGRESS_STATUS_RUNNING_COLOR = colorKey3;
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)"JUPYTER.SAUSAGE_BUTTON_APPEARANCE");
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"createTextAttributesKey(...)");
        SAUSAGE_BUTTON_APPEARANCE = textAttributesKey;
        ColorKey colorKey4 = ColorKey.createColorKey((String)"JUPYTER.SAUSAGE_BUTTON_SHORTCUT_COLOR");
        Intrinsics.checkNotNullExpressionValue((Object)colorKey4, (String)"createColorKey(...)");
        SAUSAGE_BUTTON_SHORTCUT_COLOR = colorKey4;
        ColorKey colorKey5 = ColorKey.createColorKey((String)"JUPYTER.SAUSAGE_BUTTON_BORDER_COLOR");
        Intrinsics.checkNotNullExpressionValue((Object)colorKey5, (String)"createColorKey(...)");
        SAUSAGE_BUTTON_BORDER_COLOR = colorKey5;
        ColorKey colorKey6 = ColorKey.createColorKey((String)"JUPYTER.CELL_UNDER_CARET_COMMAND_MODE_STRIPE_COLOR");
        Intrinsics.checkNotNullExpressionValue((Object)colorKey6, (String)"createColorKey(...)");
        CELL_UNDER_CARET_COMMAND_MODE_STRIPE_COLOR = colorKey6;
        ColorKey colorKey7 = ColorKey.createColorKey((String)"JUPYTER.CELL_UNDER_CARET_EDITOR_MODE_STRIPE_COLOR");
        Intrinsics.checkNotNullExpressionValue((Object)colorKey7, (String)"createColorKey(...)");
        CELL_UNDER_CARET_EDITOR_MODE_STRIPE_COLOR = colorKey7;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotebookEditorMode.values().length];
            try {
                nArray[NotebookEditorMode.EDIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookEditorMode.COMMAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

