/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.notebooks.ui.visualization.NotebookEditorAppearanceUtils;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.inlay.JupyterBoundsChangeHandler;
import com.intellij.notebooks.visualization.inlay.JupyterBoundsChangeListener;
import com.intellij.notebooks.visualization.ui.EditorCellFoldingBar;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.RectanglePainter2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u000f\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001fB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u001b\u001a\u00020\tJ\u0006\u0010\u001c\u001a\u00020\tJ\f\u0010\u001d\u001a\u00060\u001eR\u00020\u0000H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017\u00a8\u0006 "}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellFoldingBar;", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "yAndHeightSupplier", "Lkotlin/Function0;", "Lkotlin/Pair;", "", "toggleListener", "", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "panel", "Ljavax/swing/JComponent;", "boundsChangeListener", "com/intellij/notebooks/visualization/ui/EditorCellFoldingBar$boundsChangeListener$1", "Lcom/intellij/notebooks/visualization/ui/EditorCellFoldingBar$boundsChangeListener$1;", "value", "", "visible", "getVisible", "()Z", "setVisible", "(Z)V", "selected", "getSelected", "setSelected", "dispose", "updateBounds", "createFoldingBar", "Lcom/intellij/notebooks/visualization/ui/EditorCellFoldingBar$EditorCellFoldingBarComponent;", "EditorCellFoldingBarComponent", "intellij.notebooks.visualization"})
@ApiStatus.Internal
public final class EditorCellFoldingBar {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final Function0<Pair<Integer, Integer>> yAndHeightSupplier;
    @NotNull
    private final Function0<Unit> toggleListener;
    @Nullable
    private JComponent panel;
    @NotNull
    private final boundsChangeListener.1 boundsChangeListener;
    private boolean selected;

    public EditorCellFoldingBar(@NotNull EditorImpl editor, @NotNull Function0<Pair<Integer, Integer>> yAndHeightSupplier, @NotNull Function0<Unit> toggleListener) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(yAndHeightSupplier, (String)"yAndHeightSupplier");
        Intrinsics.checkNotNullParameter(toggleListener, (String)"toggleListener");
        this.editor = editor;
        this.yAndHeightSupplier = yAndHeightSupplier;
        this.toggleListener = toggleListener;
        this.boundsChangeListener = new JupyterBoundsChangeListener(this){
            final /* synthetic */ EditorCellFoldingBar this$0;
            {
                this.this$0 = $receiver;
            }

            public void boundsChanged() {
                this.this$0.updateBounds();
            }
        };
    }

    public final boolean getVisible() {
        JComponent jComponent = this.panel;
        return jComponent != null ? jComponent.isVisible() : false;
    }

    public final void setVisible(boolean value) {
        if (this.getVisible() == value) {
            return;
        }
        if (!NotebookEditorAppearanceUtils.INSTANCE.isOrdinaryNotebookEditor((Editor)this.editor)) {
            return;
        }
        if (value) {
            EditorCellFoldingBarComponent panel2 = this.createFoldingBar();
            this.editor.getGutterComponentEx().add((Component)panel2);
            this.panel = panel2;
            JupyterBoundsChangeHandler.Companion.get((Editor)this.editor).subscribe(this.boundsChangeListener);
            this.updateBounds();
        } else {
            this.dispose();
        }
    }

    public final boolean getSelected() {
        return this.selected;
    }

    public final void setSelected(boolean value) {
        block1: {
            if (this.selected == value) break block1;
            this.selected = value;
            JComponent jComponent = this.panel;
            if (jComponent != null) {
                jComponent.repaint();
            }
        }
    }

    public final void dispose() {
        block0: {
            EditorGutterComponentEx editorGutterComponentEx;
            JComponent jComponent = this.panel;
            if (jComponent == null) break block0;
            JComponent it = jComponent;
            boolean bl = false;
            EditorGutterComponentEx $this$dispose_u24lambda_u241_u24lambda_u240 = editorGutterComponentEx = this.editor.getGutterComponentEx();
            boolean bl2 = false;
            $this$dispose_u24lambda_u241_u24lambda_u240.remove((Component)it);
            $this$dispose_u24lambda_u241_u24lambda_u240.repaint();
            JupyterBoundsChangeHandler.Companion.get((Editor)this.editor).unsubscribe(this.boundsChangeListener);
            this.panel = null;
        }
    }

    public final void updateBounds() {
        JComponent jComponent = this.panel;
        if (jComponent == null) {
            return;
        }
        JComponent panel2 = jComponent;
        Pair yAndHeight = (Pair)this.yAndHeightSupplier.invoke();
        panel2.setBounds(this.editor.getGutterComponentEx().getExtraLineMarkerFreePaintersAreaOffset() + 1, ((Number)yAndHeight.getFirst()).intValue(), 6, ((Number)yAndHeight.getSecond()).intValue());
    }

    private final EditorCellFoldingBarComponent createFoldingBar() {
        return new EditorCellFoldingBarComponent();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellFoldingBar$EditorCellFoldingBarComponent;", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCellFoldingBar;)V", "mouseOver", "", "paint", "", "g", "Ljava/awt/Graphics;", "rect", "Ljava/awt/Rectangle;", "intellij.notebooks.visualization"})
    @SourceDebugExtension(value={"SMAP\nEditorCellFoldingBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellFoldingBar.kt\ncom/intellij/notebooks/visualization/ui/EditorCellFoldingBar$EditorCellFoldingBarComponent\n+ 2 NotebookVisualizationUiUtil.kt\ncom/intellij/notebooks/visualization/NotebookVisualizationUiUtilKt\n*L\n1#1,138:1\n22#2,6:139\n*S KotlinDebug\n*F\n+ 1 EditorCellFoldingBar.kt\ncom/intellij/notebooks/visualization/ui/EditorCellFoldingBar$EditorCellFoldingBarComponent\n*L\n117#1:139,6\n*E\n"})
    public final class EditorCellFoldingBarComponent
    extends JComponent {
        private boolean mouseOver;

        public EditorCellFoldingBarComponent() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    mouseOver = true;
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    mouseOver = false;
                    this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    EditorCellFoldingBar.this.toggleListener.invoke();
                }
            });
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            NotebookEditorAppearance appearance = NotebookUtil.INSTANCE.getNotebookAppearance((Editor)EditorCellFoldingBar.this.editor);
            Color color = EditorCellFoldingBar.this.getSelected() ? appearance.getCellStripeHoverColor((Editor)EditorCellFoldingBar.this.editor) : appearance.getCellStripeColor((Editor)EditorCellFoldingBar.this.editor);
            Rectangle rect = this.rect();
            Double arc = ExperimentalUI.Companion.isNewUI() ? Double.valueOf(rect.width) : null;
            Graphics $this$use$iv = g.create();
            boolean $i$f$use = false;
            try {
                Graphics g2 = $this$use$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)g2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D cfr_ignored_0 = (Graphics2D)g2;
                ((Graphics2D)g2).setColor(color);
                RectanglePainter2D.FILL.paint((Graphics2D)g2, (Rectangle2D)rect, arc, LinePainter2D.StrokeType.INSIDE, 1.0, RenderingHints.VALUE_ANTIALIAS_ON);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$use$iv.dispose();
            }
        }

        private final Rectangle rect() {
            Dimension size = this.getSize();
            int width = size.width;
            int height = size.height;
            return this.mouseOver ? new Rectangle(0, 0, width, height) : new Rectangle(1, 1, width - 2, height - 2);
        }
    }
}

