/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.actions.DistractionFreeModeController;
import com.intellij.ide.ui.UISettings;
import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.notebooks.ui.visualization.NotebookEditorAppearanceUtils;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.ui.visualization.markerRenderers.NotebookCodeCellBackgroundLineMarkerRenderer;
import com.intellij.notebooks.visualization.NotebookCellInlayController;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.UpdateContext;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.notebooks.visualization.ui.CellExecutionStatusView;
import com.intellij.notebooks.visualization.ui.ControllerEditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellInput;
import com.intellij.notebooks.visualization.ui.EditorCellOutputsView;
import com.intellij.notebooks.visualization.ui.EditorCellRunGutterButton;
import com.intellij.notebooks.visualization.ui.EditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.EditorCellViewKt;
import com.intellij.notebooks.visualization.ui.NotebookCellHighlighterRenderer;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.notebooks.visualization.ui.UpdateManager;
import com.intellij.notebooks.visualization.ui.UpdateManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Rectangle;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001sB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u00109\u001a\u00020%H\u0002J\b\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u00020\u0015H\u0002J\u000e\u0010>\u001a\u00020;2\u0006\u0010?\u001a\u00020@J\b\u0010A\u001a\u00020;H\u0002J\b\u0010B\u001a\u00020;H\u0002J\b\u0010C\u001a\u00020;H\u0002J\b\u0010D\u001a\u00020;H\u0016J\b\u0010E\u001a\u00020-H\u0002J\b\u0010F\u001a\u00020;H\u0002J\b\u0010G\u001a\u00020-H\u0002J\u000e\u0010H\u001a\b\u0012\u0004\u0012\u00020J0IH\u0002J6\u0010K\u001a\u0004\u0018\u00010\u00152\u0006\u0010L\u001a\u00020M2\u0006\u0010\u0003\u001a\u00020N2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150O2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001e0QH\u0002J#\u0010K\u001a\u0004\u0018\u0001HR\"\u0004\b\u0000\u0010R2\f\u0010L\u001a\b\u0012\u0004\u0012\u0002HR0SH\u0002\u00a2\u0006\u0002\u0010TJ\u0006\u0010U\u001a\u00020;J\u0006\u0010V\u001a\u00020;J\u0006\u0010W\u001a\u00020;J\u001c\u0010X\u001a\u0004\u0018\u0001HR\"\n\b\u0000\u0010R\u0018\u0001*\u00020YH\u0086\b\u00a2\u0006\u0002\u0010ZJ%\u0010X\u001a\u0004\u0018\u0001HR\"\b\b\u0000\u0010R*\u00020Y2\f\u0010[\u001a\b\u0012\u0004\u0012\u0002HR0\\\u00a2\u0006\u0002\u0010]J\u0014\u0010^\u001a\u00020;2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020#0SJ\b\u0010`\u001a\u00020;H\u0002J\b\u0010a\u001a\u00020;H\u0002J\u000e\u0010b\u001a\u00020;2\u0006\u0010(\u001a\u00020-J\b\u0010c\u001a\u00020;H\u0002J\b\u0010d\u001a\u00020;H\u0002J\b\u0010e\u001a\u00020fH\u0016J5\u0010g\u001a\u00020;2\b\u0010h\u001a\u0004\u0018\u00010i2\b\u0010j\u001a\u0004\u0018\u00010k2\b\u0010l\u001a\u0004\u0018\u00010m2\b\u0010n\u001a\u0004\u0018\u00010mH\u0002\u00a2\u0006\u0002\u0010oJ\u0012\u0010p\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030q0IH\u0016J\u0006\u0010r\u001a\u00020;R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\"\u0010*\u001a\u0004\u0018\u00010)2\b\u0010(\u001a\u0004\u0018\u00010)@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R$\u0010.\u001a\u00020-2\u0006\u0010(\u001a\u00020-@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u000e\u00103\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00106\u001a\u00020-2\u0006\u0010(\u001a\u00020-@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00100\"\u0004\b8\u00102\u00a8\u0006t"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellView;", "Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intervals", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "cellInlayManager", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/notebooks/visualization/NotebookCellLines;Lcom/intellij/notebooks/visualization/ui/EditorCell;Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;)V", "getCell", "()Lcom/intellij/notebooks/visualization/ui/EditorCell;", "setCell", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "_controllers", "", "Lcom/intellij/notebooks/visualization/NotebookCellInlayController;", "controllers", "getControllers", "()Ljava/util/List;", "intervalPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "getIntervalPointer", "()Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "getInterval", "()Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "cellHighlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "input", "Lcom/intellij/notebooks/visualization/ui/EditorCellInput;", "getInput", "()Lcom/intellij/notebooks/visualization/ui/EditorCellInput;", "value", "Lcom/intellij/notebooks/visualization/ui/EditorCellOutputsView;", "outputs", "getOutputs", "()Lcom/intellij/notebooks/visualization/ui/EditorCellOutputsView;", "", "selected", "getSelected", "()Z", "setSelected", "(Z)V", "mouseOver", "lastHighLightersLines", "Lkotlin/ranges/IntRange;", "disableActions", "getDisableActions", "setDisableActions", "createEditorCellInput", "dispose", "", "disposeController", "controller", "update", "updateContext", "Lcom/intellij/notebooks/visualization/UpdateContext;", "updateControllers", "recreateControllers", "updateInput", "doCheckAndRebuildInlays", "isInlaysBroken", "updateOutputs", "hasOutputs", "getInputFactories", "Lkotlin/sequences/Sequence;", "Lcom/intellij/notebooks/visualization/NotebookCellInlayController$InputFactory;", "failSafeCompute", "factory", "Lcom/intellij/notebooks/visualization/NotebookCellInlayController$Factory;", "Lcom/intellij/openapi/editor/Editor;", "", "intervalIterator", "", "T", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "onViewportChanges", "mouseExited", "mouseEntered", "getExtension", "", "()Ljava/lang/Object;", "type", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "addCellHighlighter", "provider", "removeCellHighlight", "updateCellHighlight", "updateSelection", "updateFolding", "updateRunButtonVisibility", "calculateBounds", "Ljava/awt/Rectangle;", "updateExecutionStatus", "executionCount", "", "progressStatus", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "startTime", "Ljava/time/ZonedDateTime;", "endTime", "(Ljava/lang/Integer;Lcom/intellij/notebooks/visualization/ui/ProgressStatus;Ljava/time/ZonedDateTime;Ljava/time/ZonedDateTime;)V", "doGetInlays", "Lcom/intellij/openapi/editor/Inlay;", "requestCaret", "NotebookCellDataProvider", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorCellView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellView.kt\ncom/intellij/notebooks/visualization/ui/EditorCellView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,416:1\n1#2:417\n1#2:458\n183#3,2:418\n1863#4,2:420\n295#4,2:426\n1863#4,2:428\n808#4,11:430\n1557#4:441\n1628#4,3:442\n774#4:445\n865#4,2:446\n1611#4,9:448\n1863#4:457\n1864#4:459\n1620#4:460\n1863#4,2:461\n19#5:422\n19#5:423\n24#6:424\n24#6:425\n*S KotlinDebug\n*F\n+ 1 EditorCellView.kt\ncom/intellij/notebooks/visualization/ui/EditorCellView\n*L\n157#1:458\n110#1:418,2\n116#1:420,2\n265#1:426,2\n274#1:428,2\n362#1:430,11\n382#1:441\n382#1:442,3\n154#1:445\n154#1:446,2\n157#1:448,9\n157#1:457\n157#1:459\n157#1:460\n163#1:461,2\n124#1:422\n139#1:423\n142#1:424\n237#1:425\n*E\n"})
public final class EditorCellView
extends EditorCellViewComponent
implements Disposable {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final NotebookCellLines intervals;
    @NotNull
    private EditorCell cell;
    @NotNull
    private final NotebookCellInlayManager cellInlayManager;
    @NotNull
    private final UISettings uiSettings;
    @NotNull
    private List<? extends NotebookCellInlayController> _controllers;
    @NotNull
    private final List<RangeHighlighter> cellHighlighters;
    @NotNull
    private final EditorCellInput input;
    @Nullable
    private EditorCellOutputsView outputs;
    private boolean selected;
    private boolean mouseOver;
    @Nullable
    private IntRange lastHighLightersLines;
    private boolean disableActions;

    public EditorCellView(@NotNull EditorImpl editor, @NotNull NotebookCellLines intervals, @NotNull EditorCell cell, @NotNull NotebookCellInlayManager cellInlayManager) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)intervals, (String)"intervals");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)cellInlayManager, (String)"cellInlayManager");
        this.editor = editor;
        this.intervals = intervals;
        this.cell = cell;
        this.cellInlayManager = cellInlayManager;
        this.uiSettings = UISettings.Companion.getInstance();
        this._controllers = CollectionsKt.emptyList();
        this.cellHighlighters = new ArrayList();
        this.input = this.createEditorCellInput();
        this.cell.getSource().afterChange((Disposable)this, arg_0 -> EditorCellView._init_$lambda$1(this, arg_0));
        this.cell.getSelected().afterChange((Disposable)this, arg_0 -> EditorCellView._init_$lambda$2(this, arg_0));
        this.setSelected(this.cell.getSelected().get());
        this.cell.getExecutionStatus().afterChange((Disposable)this, arg_0 -> EditorCellView._init_$lambda$3(this, arg_0));
        EditorCell.ExecutionStatus executionStatus = (EditorCell.ExecutionStatus)this.cell.getExecutionStatus().get();
        this.updateExecutionStatus(executionStatus.getCount(), executionStatus.getStatus(), executionStatus.getStartTime(), executionStatus.getEndTime());
        this.recreateControllers();
        this.updateSelection(false);
        this.updateOutputs();
        this.updateControllers();
    }

    @NotNull
    public final EditorCell getCell() {
        return this.cell;
    }

    public final void setCell(@NotNull EditorCell editorCell) {
        Intrinsics.checkNotNullParameter((Object)editorCell, (String)"<set-?>");
        this.cell = editorCell;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final List<NotebookCellInlayController> getControllers() {
        Iterable iterable;
        Collection collection = this._controllers;
        EditorCellViewComponent editorCellViewComponent = this.input.getComponent();
        Object object = editorCellViewComponent instanceof ControllerEditorCellViewComponent ? (ControllerEditorCellViewComponent)editorCellViewComponent : null;
        if (object != null && (object = ((ControllerEditorCellViewComponent)object).getController$intellij_notebooks_visualization()) != null) {
            void it;
            Object object2 = object;
            Collection collection2 = collection;
            boolean bl = false;
            List list = CollectionsKt.listOf((Object)it);
            collection = collection2;
            object = list;
            if (list != null) {
                iterable = (Iterable)object;
                return CollectionsKt.plus((Collection)collection, (Iterable)iterable);
            }
        }
        iterable = CollectionsKt.emptyList();
        return CollectionsKt.plus((Collection)collection, (Iterable)iterable);
    }

    private final NotebookIntervalPointer getIntervalPointer() {
        return this.cell.getIntervalPointer();
    }

    private final NotebookCellLines.Interval getInterval() {
        NotebookCellLines.Interval interval = this.getIntervalPointer().get();
        if (interval == null) {
            throw new IllegalStateException("Invalid interval".toString());
        }
        return interval;
    }

    @NotNull
    public final EditorCellInput getInput() {
        return this.input;
    }

    @Nullable
    public final EditorCellOutputsView getOutputs() {
        return this.outputs;
    }

    public final boolean getSelected() {
        return this.selected;
    }

    public final void setSelected(boolean value) {
        this.selected = value;
        this.updateFolding();
        this.updateRunButtonVisibility();
        this.updateCellHighlight();
    }

    public final boolean getDisableActions() {
        return this.disableActions;
    }

    public final void setDisableActions(boolean value) {
        if (this.disableActions == value) {
            return;
        }
        this.disableActions = value;
        this.updateRunButtonVisibility();
    }

    /*
     * WARNING - void declaration
     */
    private final EditorCellInput createEditorCellInput() {
        EditorCellInput editorCellInput;
        NotebookCellInlayController.InputFactory inputFactory;
        Object v0;
        EditorImpl editorImpl;
        block2: {
            void $this$firstOrNull$iv;
            Sequence<NotebookCellInlayController.InputFactory> sequence = this.getInputFactories();
            editorImpl = this.editor;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NotebookCellInlayController.InputFactory it = (NotebookCellInlayController.InputFactory)element$iv;
                boolean bl = false;
                if (!it.supports(this.editor, this.cell)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((inputFactory = (NotebookCellInlayController.InputFactory)v0) == null) {
            inputFactory = EditorCellViewKt.access$getFallbackInputFactory$p();
        }
        EditorCell editorCell = this.cell;
        NotebookCellInlayController.InputFactory inputFactory2 = inputFactory;
        EditorImpl editorImpl2 = editorImpl;
        EditorCellInput it = editorCellInput = new EditorCellInput(editorImpl2, inputFactory2, editorCell);
        boolean bl = false;
        this.add(it);
        return editorCellInput;
    }

    @Override
    public void dispose() {
        super.dispose();
        Iterable $this$forEach$iv = this._controllers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookCellInlayController controller = (NotebookCellInlayController)element$iv;
            boolean bl = false;
            this.disposeController(controller);
        }
        this.removeCellHighlight();
    }

    private final void disposeController(NotebookCellInlayController controller) {
        Inlay<?> inlay = controller.getInlay();
        EditorCustomElementRenderer $this$asSafely$iv = inlay.getRenderer();
        boolean $i$f$asSafely = false;
        EditorCustomElementRenderer editorCustomElementRenderer = $this$asSafely$iv;
        if (!(editorCustomElementRenderer instanceof JComponent)) {
            editorCustomElementRenderer = null;
        }
        JComponent jComponent = (JComponent)editorCustomElementRenderer;
        if (jComponent != null) {
            JComponent it = jComponent;
            boolean bl = false;
            DataManager.removeDataProvider((JComponent)it);
        }
        Disposer.dispose((Disposable)((Disposable)inlay));
    }

    public final void update(@NotNull UpdateContext updateContext) {
        Intrinsics.checkNotNullParameter((Object)updateContext, (String)"updateContext");
        this.input.update();
        this.updateOutputs();
        this.recreateControllers();
        this.updateControllers();
        this.updateCellFolding(updateContext);
    }

    private final void updateControllers() {
        for (NotebookCellInlayController controller : this.getControllers()) {
            Inlay<?> inlay = controller.getInlay();
            EditorCustomElementRenderer $this$asSafely$iv = inlay.getRenderer();
            boolean $i$f$asSafely = false;
            EditorCustomElementRenderer editorCustomElementRenderer = $this$asSafely$iv;
            if (!(editorCustomElementRenderer instanceof JComponent)) {
                editorCustomElementRenderer = null;
            }
            if ((JComponent)editorCustomElementRenderer != null) {
                JComponent component;
                boolean bl = false;
                DataProvider oldProvider = DataManager.getDataProvider((JComponent)component);
                if (oldProvider != null && !(oldProvider instanceof NotebookCellDataProvider)) {
                    EditorCellView $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(EditorCellView.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Overwriting an existing CLIENT_PROPERTY_DATA_PROVIDER. Old provider: " + oldProvider);
                }
                DataManager.removeDataProvider((JComponent)component);
                DataManager.registerDataProvider((JComponent)component, (DataProvider)new NotebookCellDataProvider((Editor)this.editor, component, (Function0<NotebookCellLines.Interval>)((Function0)() -> EditorCellView.updateControllers$lambda$9$lambda$8(this))));
            }
            controller.createGutterRendererLineMarker((EditorEx)this.editor, this.getInterval(), this);
        }
    }

    private final void recreateControllers() {
        UpdateManager.update$default(UpdateManagerKt.getUpdateManager((Editor)this.editor), false, arg_0 -> EditorCellView.recreateControllers$lambda$14(this, arg_0), 1, null);
    }

    private final void updateInput() {
        ActionsKt.runInEdt$default(null, () -> EditorCellView.updateInput$lambda$15(this), (int)1, null);
    }

    @Override
    public void doCheckAndRebuildInlays() {
        if (this.isInlaysBroken()) {
            this.recreateControllers();
        }
    }

    private final boolean isInlaysBroken() {
        Set set = SetsKt.createSetBuilder();
        Set $this$isInlaysBroken_u24lambda_u2416 = set;
        boolean bl = false;
        $this$isInlaysBroken_u24lambda_u2416.add(this.editor.getDocument().getLineStartOffset(this.getInterval().getLines().getFirst()));
        $this$isInlaysBroken_u24lambda_u2416.add(this.editor.getDocument().getLineEndOffset(this.getInterval().getLines().getLast()));
        Set inlaysOffsets = SetsKt.build((Set)set);
        for (Inlay inlay : this.getInlays()) {
            if (inlay.isValid() && inlaysOffsets.contains(inlay.getOffset())) continue;
            return true;
        }
        return false;
    }

    private final void updateOutputs() {
        ActionsKt.runInEdt$default(null, () -> EditorCellView.updateOutputs$lambda$19(this), (int)1, null);
    }

    private final boolean hasOutputs() {
        return this.getInterval().getType() == NotebookCellLines.CellType.CODE && (this.editor.getEditorKind() != EditorKind.DIFF || Registry.Companion.is("jupyter.diff.viewer.output"));
    }

    private final Sequence<NotebookCellInlayController.InputFactory> getInputFactories() {
        return this.cellInlayManager.getInputFactories$intellij_notebooks_visualization();
    }

    private final NotebookCellInlayController failSafeCompute(NotebookCellInlayController.Factory factory, Editor editor, Collection<? extends NotebookCellInlayController> controllers, ListIterator<NotebookCellLines.Interval> intervalIterator) {
        return (NotebookCellInlayController)this.failSafeCompute(() -> EditorCellView.failSafeCompute$lambda$20(factory, editor, controllers, intervalIterator));
    }

    private final <T> T failSafeCompute(Function0<? extends T> factory) {
        try {
            return (T)factory.invoke();
        }
        catch (Throwable t) {
            EditorCellView $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(EditorCellView.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(factory.getClass().getName() + " shouldn't throw exceptions at NotebookCellInlayController.Factory.compute(...)", t);
            return null;
        }
    }

    public final void onViewportChanges() {
        block0: {
            this.input.onViewportChange();
            EditorCellOutputsView editorCellOutputsView = this.outputs;
            if (editorCellOutputsView == null) break block0;
            editorCellOutputsView.onViewportChange();
        }
    }

    public final void mouseExited() {
        this.mouseOver = false;
        this.updateFolding();
        this.updateRunButtonVisibility();
    }

    public final void mouseEntered() {
        this.mouseOver = true;
        this.updateFolding();
        this.updateRunButtonVisibility();
    }

    public final /* synthetic */ <T> T getExtension() {
        boolean $i$f$getExtension = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.getExtension(Reflection.getOrCreateKotlinClass(Object.class));
    }

    @Nullable
    public final <T> T getExtension(@NotNull KClass<T> type) {
        Object v1;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Iterable $this$firstOrNull$iv = this.getControllers();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NotebookCellInlayController it = (NotebookCellInlayController)element$iv;
                boolean bl = false;
                if (!type.isInstance((Object)it)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = v1 = null;
        }
        if (v0 == null) {
            v1 = null;
        }
        return v1;
    }

    public final void addCellHighlighter(@NotNull Function0<? extends RangeHighlighter> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        RangeHighlighter highlighter = (RangeHighlighter)provider.invoke();
        this.cellHighlighters.add(highlighter);
    }

    private final void removeCellHighlight() {
        Iterable $this$forEach$iv = this.cellHighlighters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.cellHighlighters.clear();
    }

    private final void updateCellHighlight() {
        NotebookCellLines.Interval interval = this.getIntervalPointer().get();
        if (interval == null) {
            throw new IllegalStateException("Invalid interval".toString());
        }
        NotebookCellLines.Interval interval2 = interval;
        int startOffset = this.editor.getDocument().getLineStartOffset(interval2.getLines().getFirst());
        int endOffset = this.editor.getDocument().getLineEndOffset(interval2.getLines().getLast());
        if (Intrinsics.areEqual((Object)interval2.getLines(), (Object)this.lastHighLightersLines)) {
            return;
        }
        this.lastHighLightersLines = new IntRange(interval2.getLines().getFirst(), interval2.getLines().getLast());
        this.removeCellHighlight();
        if (interval2.getType() == NotebookCellLines.CellType.CODE && !NotebookEditorAppearanceUtils.INSTANCE.isDiffKind((Editor)this.editor)) {
            this.addCellHighlighter((Function0<? extends RangeHighlighter>)((Function0)() -> EditorCellView.updateCellHighlight$lambda$25(this, startOffset, endOffset)));
        }
        if (interval2.getType() == NotebookCellLines.CellType.CODE) {
            this.addCellHighlighter((Function0<? extends RangeHighlighter>)((Function0)() -> EditorCellView.updateCellHighlight$lambda$30(this, startOffset, endOffset)));
        }
        if (this.uiSettings.getPresentationMode() || DistractionFreeModeController.isDistractionFreeModeEnabled()) {
            this.addCellHighlighter((Function0<? extends RangeHighlighter>)((Function0)() -> EditorCellView.updateCellHighlight$lambda$35(this, startOffset, endOffset)));
        }
        for (NotebookCellInlayController controller : this.getControllers()) {
            controller.createGutterRendererLineMarker((EditorEx)this.editor, interval2, this);
        }
    }

    public final void updateSelection(boolean value) {
        this.setSelected(value);
        this.updateFolding();
        this.updateRunButtonVisibility();
        this.updateCellHighlight();
    }

    private final void updateFolding() {
        block1: {
            this.input.getFolding().setVisible(this.mouseOver || this.selected);
            this.input.getFolding().setSelected(this.selected);
            EditorCellOutputsView editorCellOutputsView = this.outputs;
            if (editorCellOutputsView != null) {
                editorCellOutputsView.setFoldingsVisible(this.mouseOver || this.selected);
            }
            EditorCellOutputsView editorCellOutputsView2 = this.outputs;
            if (editorCellOutputsView2 == null) break block1;
            editorCellOutputsView2.setFoldingsSelected(this.selected);
        }
    }

    private final void updateRunButtonVisibility() {
        block0: {
            EditorCellRunGutterButton editorCellRunGutterButton = this.input.getRunCellButton();
            if (editorCellRunGutterButton == null) break block0;
            editorCellRunGutterButton.setVisible(!this.disableActions && (this.mouseOver || this.selected));
        }
    }

    @Override
    @NotNull
    public Rectangle calculateBounds() {
        int n;
        Object outputRectangle;
        Object object;
        Rectangle inputBounds = this.input.calculateBounds();
        EditorCellOutputsView currentOutputs = this.outputs;
        Object object2 = currentOutputs;
        if (object2 != null && (object2 = ((EditorCellOutputsView)object2).calculateBounds()) != null) {
            Object object3;
            Object it = object3 = object2;
            boolean bl = false;
            object = !((Rectangle)it).isEmpty() ? object3 : null;
        } else {
            object = null;
        }
        Object object4 = outputRectangle = object;
        if (object4 != null) {
            Object it = object4;
            boolean bl = false;
            n = ((Rectangle)it).height + ((Rectangle)it).y - inputBounds.y;
        } else {
            n = inputBounds.height;
        }
        int height = n;
        return new Rectangle(0, inputBounds.y, this.editor.getContentSize().width, height);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateExecutionStatus(Integer executionCount, ProgressStatus progressStatus, ZonedDateTime startTime, ZonedDateTime endTime) {
        block2: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this._controllers;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CellExecutionStatusView)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            CellExecutionStatusView cellExecutionStatusView = (CellExecutionStatusView)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (cellExecutionStatusView != null) {
                cellExecutionStatusView.updateExecutionStatus(executionCount, progressStatus, startTime, endTime);
            }
            EditorCellRunGutterButton editorCellRunGutterButton = this.input.getRunCellButton();
            if (editorCellRunGutterButton == null) break block2;
            editorCellRunGutterButton.updateGutterAction(progressStatus);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Sequence<Inlay<?>> doGetInlays() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getControllers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NotebookCellInlayController notebookCellInlayController = (NotebookCellInlayController)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getInlay());
        }
        return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
    }

    public final void requestCaret() {
        this.input.requestCaret();
    }

    private static final Unit _init_$lambda$1(EditorCellView this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateInput();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(EditorCellView this$0, boolean selected) {
        this$0.setSelected(selected);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(EditorCellView this$0, EditorCell.ExecutionStatus execution) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        this$0.updateExecutionStatus(execution.getCount(), execution.getStatus(), execution.getStartTime(), execution.getEndTime());
        return Unit.INSTANCE;
    }

    private static final NotebookCellLines.Interval updateControllers$lambda$9$lambda$8(EditorCellView this$0) {
        return this$0.getInterval();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit recreateControllers$lambda$14$lambda$13(EditorCellView this$0, InlayModel it) {
        List list;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$filter$iv = NotebookCellInlayController.Factory.EP_NAME.getExtensionList();
        boolean $i$f$filter2 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NotebookCellInlayController.Factory it2 = (NotebookCellInlayController.Factory)element$iv$iv;
            boolean bl = false;
            if (!(!(it2 instanceof NotebookCellInlayController.InputFactory))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List otherFactories = (List)destination$iv$iv;
        Set controllersToDispose = CollectionsKt.toMutableSet((Iterable)this$0._controllers);
        EditorCellView editorCellView = this$0;
        if (!this$0.editor.isDisposed()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable $i$f$filter2 = otherFactories;
            EditorCellView editorCellView2 = editorCellView;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                NotebookCellInlayController it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                NotebookCellInlayController.Factory factory = (NotebookCellInlayController.Factory)element$iv$iv;
                boolean bl2 = false;
                if (this$0.failSafeCompute(factory, (Editor)this$0.editor, (Collection<? extends NotebookCellInlayController>)this$0._controllers, this$0.intervals.getIntervals().listIterator(this$0.getInterval().getOrdinal())) == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            list = (List)destination$iv$iv2;
            editorCellView = editorCellView2;
        } else {
            list = CollectionsKt.emptyList();
        }
        editorCellView._controllers = list;
        controllersToDispose.removeAll(CollectionsKt.toSet((Iterable)this$0._controllers));
        Iterable $this$forEach$iv = controllersToDispose;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookCellInlayController it3 = (NotebookCellInlayController)element$iv;
            boolean bl = false;
            this$0.disposeController(it3);
        }
        this$0.updateControllers();
        return Unit.INSTANCE;
    }

    private static final Unit recreateControllers$lambda$14(EditorCellView this$0, UpdateContext updateContext) {
        Intrinsics.checkNotNullParameter((Object)updateContext, (String)"updateContext");
        updateContext.addInlayOperation((Function1<? super InlayModel, Unit>)((Function1)arg_0 -> EditorCellView.recreateControllers$lambda$14$lambda$13(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit updateInput$lambda$15(EditorCellView this$0) {
        this$0.updateCellHighlight();
        this$0.input.updateInput();
        this$0.checkAndRebuildInlays();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit updateOutputs$lambda$19(EditorCellView this$0) {
        block2: {
            block0: {
                block1: {
                    void it;
                    EditorCellOutputsView editorCellOutputsView;
                    if (!this$0.hasOutputs()) break block0;
                    if (this$0.outputs != null) break block1;
                    EditorCellOutputsView editorCellOutputsView2 = editorCellOutputsView = new EditorCellOutputsView(this$0.editor, this$0.cell, null, 4, null);
                    EditorCellView editorCellView = this$0;
                    boolean bl = false;
                    this$0.add((EditorCellViewComponent)it);
                    editorCellView.outputs = editorCellOutputsView;
                    this$0.updateCellHighlight();
                    this$0.updateFolding();
                    break block2;
                }
                EditorCellOutputsView editorCellOutputsView = this$0.outputs;
                if (editorCellOutputsView == null) break block2;
                editorCellOutputsView.update();
                break block2;
            }
            EditorCellOutputsView editorCellOutputsView = this$0.outputs;
            if (editorCellOutputsView == null) break block2;
            EditorCellOutputsView it = editorCellOutputsView;
            boolean bl = false;
            this$0.remove(it);
            this$0.outputs = null;
        }
        return Unit.INSTANCE;
    }

    private static final NotebookCellInlayController failSafeCompute$lambda$20(NotebookCellInlayController.Factory $factory, Editor $editor, Collection $controllers, ListIterator $intervalIterator) {
        Intrinsics.checkNotNull((Object)$editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        return $factory.compute((EditorImpl)$editor, $controllers, $intervalIterator);
    }

    /*
     * WARNING - void declaration
     */
    private static final RangeHighlighter updateCellHighlight$lambda$25(EditorCellView this$0, int $startOffset, int $endOffset) {
        RangeHighlighter rangeHighlighter;
        void $this$updateCellHighlight_u24lambda_u2425_u24lambda_u2423;
        TextAttributes textAttributes;
        TextAttributes textAttributes2 = textAttributes = new TextAttributes();
        int n = 900;
        int n2 = $endOffset;
        int n3 = $startOffset;
        MarkupModelEx markupModelEx = this$0.editor.getMarkupModel();
        boolean bl = false;
        NotebookEditorAppearance notebookEditorAppearance = NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this$0.editor);
        EditorColorsScheme editorColorsScheme = this$0.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        $this$updateCellHighlight_u24lambda_u2425_u24lambda_u2423.setBackgroundColor(notebookEditorAppearance.getCodeCellBackground(editorColorsScheme));
        Unit unit = Unit.INSTANCE;
        RangeHighlighter rangeHighlighter2 = markupModelEx.addRangeHighlighter(n3, n2, n, textAttributes, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"addRangeHighlighter(...)");
        RangeHighlighter $this$updateCellHighlight_u24lambda_u2425_u24lambda_u2424 = rangeHighlighter = rangeHighlighter2;
        boolean bl2 = false;
        $this$updateCellHighlight_u24lambda_u2425_u24lambda_u2424.setCustomRenderer((CustomHighlighterRenderer)NotebookCellHighlighterRenderer.INSTANCE);
        return rangeHighlighter;
    }

    private static final Pair updateCellHighlight$lambda$30$lambda$28$lambda$27(EditorCellView this$0, Editor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Rectangle it2 = this$0.input.getComponent().calculateBounds();
        boolean bl = false;
        return TuplesKt.to((Object)it2.y, (Object)it2.height);
    }

    private static final Unit updateCellHighlight$lambda$30$lambda$28(EditorCellView this$0, RangeHighlighterEx o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        o.setLineMarkerRenderer((LineMarkerRenderer)new NotebookCodeCellBackgroundLineMarkerRenderer((RangeHighlighter)o, arg_0 -> EditorCellView.updateCellHighlight$lambda$30$lambda$28$lambda$27(this$0, arg_0), false, 4, null));
        return Unit.INSTANCE;
    }

    private static final void updateCellHighlight$lambda$30$lambda$29(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final RangeHighlighter updateCellHighlight$lambda$30(EditorCellView this$0, int $startOffset, int $endOffset) {
        RangeHighlighterEx rangeHighlighterEx = this$0.editor.getMarkupModel().addRangeHighlighterAndChangeAttributes(null, $startOffset, $endOffset, 900, HighlighterTargetArea.LINES_IN_RANGE, false, arg_0 -> EditorCellView.updateCellHighlight$lambda$30$lambda$29(arg_0 -> EditorCellView.updateCellHighlight$lambda$30$lambda$28(this$0, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
        return (RangeHighlighter)rangeHighlighterEx;
    }

    private static final Pair updateCellHighlight$lambda$35$lambda$33$lambda$32(EditorCellView this$0, Editor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Rectangle it2 = this$0.input.getComponent().calculateBounds();
        boolean bl = false;
        return TuplesKt.to((Object)it2.y, (Object)it2.height);
    }

    private static final Unit updateCellHighlight$lambda$35$lambda$33(EditorCellView this$0, RangeHighlighterEx o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        o.setLineMarkerRenderer((LineMarkerRenderer)new NotebookCodeCellBackgroundLineMarkerRenderer((RangeHighlighter)o, (Function1<? super Editor, Pair<Integer, Integer>>)((Function1)arg_0 -> EditorCellView.updateCellHighlight$lambda$35$lambda$33$lambda$32(this$0, arg_0)), true));
        return Unit.INSTANCE;
    }

    private static final void updateCellHighlight$lambda$35$lambda$34(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final RangeHighlighter updateCellHighlight$lambda$35(EditorCellView this$0, int $startOffset, int $endOffset) {
        RangeHighlighterEx rangeHighlighterEx = this$0.editor.getMarkupModel().addRangeHighlighterAndChangeAttributes(null, $startOffset, $endOffset, 900, HighlighterTargetArea.LINES_IN_RANGE, false, arg_0 -> EditorCellView.updateCellHighlight$lambda$35$lambda$34(arg_0 -> EditorCellView.updateCellHighlight$lambda$35$lambda$33(this$0, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
        return (RangeHighlighter)rangeHighlighterEx;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellView$NotebookCellDataProvider;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "editor", "Lcom/intellij/openapi/editor/Editor;", "component", "Ljavax/swing/JComponent;", "intervalProvider", "Lkotlin/Function0;", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljavax/swing/JComponent;Lkotlin/jvm/functions/Function0;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getComponent", "()Ljavax/swing/JComponent;", "getIntervalProvider", "()Lkotlin/jvm/functions/Function0;", "getData", "", "key", "", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.notebooks.visualization"})
    public static final class NotebookCellDataProvider
    implements DataProvider {
        @NotNull
        private final Editor editor;
        @NotNull
        private final JComponent component;
        @NotNull
        private final Function0<NotebookCellLines.Interval> intervalProvider;

        public NotebookCellDataProvider(@NotNull Editor editor, @NotNull JComponent component, @NotNull Function0<NotebookCellLines.Interval> intervalProvider) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter(intervalProvider, (String)"intervalProvider");
            this.editor = editor;
            this.component = component;
            this.intervalProvider = intervalProvider;
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }

        @NotNull
        public final Function0<NotebookCellLines.Interval> getIntervalProvider() {
            return this.intervalProvider;
        }

        @Nullable
        public Object getData(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String string = key;
            return Intrinsics.areEqual((Object)string, (Object)NotebookDataContext.INSTANCE.getNOTEBOOK_CELL_LINES_INTERVAL().getName()) ? this.intervalProvider.invoke() : (Intrinsics.areEqual((Object)string, (Object)PlatformCoreDataKeys.CONTEXT_COMPONENT.getName()) ? this.component : (Intrinsics.areEqual((Object)string, (Object)PlatformDataKeys.EDITOR.getName()) ? this.editor : null));
        }

        @NotNull
        public final Editor component1() {
            return this.editor;
        }

        @NotNull
        public final JComponent component2() {
            return this.component;
        }

        @NotNull
        public final Function0<NotebookCellLines.Interval> component3() {
            return this.intervalProvider;
        }

        @NotNull
        public final NotebookCellDataProvider copy(@NotNull Editor editor, @NotNull JComponent component, @NotNull Function0<NotebookCellLines.Interval> intervalProvider) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter(intervalProvider, (String)"intervalProvider");
            return new NotebookCellDataProvider(editor, component, intervalProvider);
        }

        public static /* synthetic */ NotebookCellDataProvider copy$default(NotebookCellDataProvider notebookCellDataProvider, Editor editor, JComponent jComponent, Function0 function0, int n, Object object) {
            if ((n & 1) != 0) {
                editor = notebookCellDataProvider.editor;
            }
            if ((n & 2) != 0) {
                jComponent = notebookCellDataProvider.component;
            }
            if ((n & 4) != 0) {
                function0 = notebookCellDataProvider.intervalProvider;
            }
            return notebookCellDataProvider.copy(editor, jComponent, function0);
        }

        @NotNull
        public String toString() {
            return "NotebookCellDataProvider(editor=" + this.editor + ", component=" + this.component + ", intervalProvider=" + this.intervalProvider + ")";
        }

        public int hashCode() {
            int result = this.editor.hashCode();
            result = result * 31 + this.component.hashCode();
            result = result * 31 + this.intervalProvider.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NotebookCellDataProvider)) {
                return false;
            }
            NotebookCellDataProvider notebookCellDataProvider = (NotebookCellDataProvider)other;
            if (!Intrinsics.areEqual((Object)this.editor, (Object)notebookCellDataProvider.editor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.component, (Object)notebookCellDataProvider.component)) {
                return false;
            }
            return Intrinsics.areEqual(this.intervalProvider, notebookCellDataProvider.intervalProvider);
        }
    }
}

