/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.examples.server;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.httpClient.examples.server.GetCommentsWithFunction;
import com.intellij.httpClient.examples.server.GetUserFunction;
import com.intellij.httpClient.examples.server.GraphQLExecutor;
import com.intellij.httpClient.examples.server.GraphQLQuery;
import com.intellij.httpClient.examples.server.GraphQLRequest;
import com.intellij.httpClient.examples.server.GraphQLResponse;
import com.intellij.httpClient.examples.server.HttpClientExampleServerManager;
import com.intellij.httpClient.examples.server.HttpClientExamplesServerKt;
import com.intellij.httpClient.examples.server.NewCommentFunction;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/examples/server/GraphQLClientHttpHandler;", "Lorg/jetbrains/ide/HttpRequestHandler;", "<init>", "()V", "executor", "Lcom/intellij/httpClient/examples/server/GraphQLExecutor;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "isAccessible", "Lio/netty/handler/codec/http/HttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientExamplesServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/GraphQLClientHttpHandler\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n+ 3 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/HttpClientExamplesServerKt\n+ 4 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,611:1\n306#2:612\n430#3,2:613\n433#3,2:617\n58#4:615\n51#4:616\n*S KotlinDebug\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/GraphQLClientHttpHandler\n*L\n107#1:612\n137#1:613,2\n137#1:617,2\n137#1:615\n137#1:616\n*E\n"})
final class GraphQLClientHttpHandler
extends HttpRequestHandler {
    @NotNull
    private final GraphQLExecutor executor;
    @NotNull
    private final ObjectMapper mapper;

    /*
     * WARNING - void declaration
     */
    public GraphQLClientHttpHandler() {
        void $this$executor_u24lambda_u240;
        Map map2;
        boolean $i$f$enumMapOf = false;
        Map map3 = map2 = (Map)new EnumMap(GraphQLQuery.Operation.class);
        GraphQLClientHttpHandler graphQLClientHttpHandler = this;
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"getUser", (Object)GetUserFunction.INSTANCE), TuplesKt.to((Object)"getCommentsWith", (Object)GetCommentsWithFunction.INSTANCE)};
        $this$executor_u24lambda_u240.put(GraphQLQuery.Operation.QUERY, MapsKt.mapOf((Pair[])pairArray));
        $this$executor_u24lambda_u240.put(GraphQLQuery.Operation.MUTATION, MapsKt.mapOf((Pair)TuplesKt.to((Object)"newComment", (Object)NewCommentFunction.INSTANCE)));
        Map map4 = map2;
        graphQLClientHttpHandler.executor = new GraphQLExecutor(map4);
        this.mapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.POST)) {
            if (!Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.GET)) return false;
        }
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"/http-client/examples/graphql", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean isAccessible(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return super.isAccessible(request) && HttpClientExampleServerManager.Companion.getInstance().isRequestScheduled();
    }

    /*
     * WARNING - void declaration
     */
    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.GET)) {
            HttpResponse httpResponse = (HttpResponse)Responses.response$default((CharSequence)"\ntype Query {\n    getUser(userName: String): User\n    getCommentsWith(text: String): [Comment]\n}\n\ntype Mutation {\n    newComment(userName: String, text: String): Comment\n}\n\ntype Subscription {\n    newComments : Comment\n}\n\ntype User {\n    name: String,\n    comments: [Comment]\n}\n\ntype Comment {\n    text: String,\n    by: String\n}\n", null, (int)2, null);
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)request), (HttpHeaders)HttpClientExamplesServerKt.access$contentType("application/graphql"));
            return true;
        }
        ByteBuf content2 = request.content();
        CharSequence body2 = content2.readCharSequence(content2.readableBytes(), Charsets.UTF_8);
        ObjectMapper objectMapper = this.mapper;
        Intrinsics.checkNotNull((Object)body2);
        CharSequence json$iv = body2;
        boolean $i$f$fromJson = false;
        try {
            void $this$readValue$iv$iv;
            void $this$fromJson$iv;
            void var10_9 = $this$fromJson$iv;
            String content$iv$iv = ((Object)json$iv).toString();
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            object = $this$readValue$iv$iv.readValue(content$iv$iv, (TypeReference)new TypeReference<GraphQLRequest>(){});
        }
        catch (JacksonException e$iv) {
            JacksonException it = e$iv;
            boolean bl = false;
            FullHttpResponse fullHttpResponse = Responses.response$default((CharSequence)"{\"error\": \"malformed JSON\"}", null, (int)2, null).setStatus(HttpResponseStatus.BAD_REQUEST);
            Intrinsics.checkNotNullExpressionValue((Object)fullHttpResponse, (String)"setStatus(...)");
            HttpResponse httpResponse = (HttpResponse)fullHttpResponse;
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)request), (HttpHeaders)HttpClientExamplesServerKt.access$contentType("application/json"));
            return true;
        }
        GraphQLRequest jsonBody = (GraphQLRequest)object;
        GraphQLQuery parsedQuery = HttpClientExamplesServerKt.access$parseQuery(jsonBody);
        if (parsedQuery == null) {
            HttpResponse httpResponse = (HttpResponse)Responses.response$default((CharSequence)"{\"error\": \"malformed GraphQL request\"}", null, (int)2, null);
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)request), (HttpHeaders)HttpClientExamplesServerKt.access$contentType("application/json"));
            return true;
        }
        GraphQLResponse executionResult = this.executor.execute(parsedQuery, jsonBody.getVariables());
        if (executionResult == null) {
            HttpResponse httpResponse = (HttpResponse)Responses.response$default((CharSequence)"{\"error\": \"malformed GraphQL request\"}", null, (int)2, null);
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)request), (HttpHeaders)HttpClientExamplesServerKt.access$contentType("application/json"));
            return true;
        }
        if (!(executionResult instanceof GraphQLResponse.Single)) {
            throw new IllegalStateException("Cannot be here!!".toString());
        }
        String string = this.mapper.writeValueAsString((Object)executionResult);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        HttpResponse httpResponse = (HttpResponse)Responses.response$default((CharSequence)string, null, (int)2, null);
        Channel channel = context.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        Responses.send((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)request), (HttpHeaders)HttpClientExamplesServerKt.access$contentType("application/json"));
        return true;
    }
}

