/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.cookies.annotator;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.cookies.HttpRequestCookiesStorage;
import com.intellij.httpClient.http.request.cookies.psi.CookieDate;
import com.intellij.httpClient.http.request.cookies.psi.CookieDomain;
import com.intellij.httpClient.http.request.cookies.psi.CookieElementVisitor;
import com.intellij.httpClient.http.request.cookies.psi.CookiePath;
import com.intellij.httpClient.http.request.cookies.psi.MalformedCookie;
import com.intellij.httpClient.http.request.cookies.psi.RecordRest;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.text.ParseException;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

class CookieLanguageAnnotatorVisitor
extends CookieElementVisitor {
    private final AnnotationHolder myHolder;

    CookieLanguageAnnotatorVisitor(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            CookieLanguageAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitMalformedCookie(@NotNull MalformedCookie malformedCookie) {
        if (malformedCookie == null) {
            CookieLanguageAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        super.visitMalformedCookie(malformedCookie);
        String value2 = malformedCookie.getText();
        if (value2 != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RestClientBundle.message("http.request.cookie.jar.inspection.attributes.missing", new Object[0])).create();
        }
    }

    @Override
    public void visitRecordRest(@NotNull RecordRest cookieRecordRest) {
        if (cookieRecordRest == null) {
            CookieLanguageAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        super.visitRecordRest(cookieRecordRest);
        String value2 = cookieRecordRest.getText();
        if (value2 != null && !value2.isEmpty()) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RestClientBundle.message("http.request.cookie.jar.inspection.too.many.attributes", new Object[0])).create();
        }
    }

    @Override
    public void visitCookieDomain(@NotNull CookieDomain cookieDomain) {
        if (cookieDomain == null) {
            CookieLanguageAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        super.visitCookieDomain(cookieDomain);
        String value2 = cookieDomain.getText();
        PsiElement rightSibling = cookieDomain.getNextSibling();
        if (value2 != null && StringUtil.isEmptyOrSpaces((String)value2)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RestClientBundle.message("http.request.cookie.jar.inspection.empty.domain", new Object[0])).create();
        }
    }

    @Override
    public void visitCookiePath(@NotNull CookiePath cookiePath) {
        if (cookiePath == null) {
            CookieLanguageAnnotatorVisitor.$$$reportNull$$$0(4);
        }
        super.visitCookiePath(cookiePath);
        String value2 = cookiePath.getText();
        PsiElement rightSibling = cookiePath.getNextSibling();
        if (value2 != null && StringUtil.isEmptyOrSpaces((String)value2)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RestClientBundle.message("http.request.cookie.jar.inspection.empty.path", new Object[0])).create();
        }
    }

    @Override
    public void visitCookieDate(@NotNull CookieDate cookieDate) {
        if (cookieDate == null) {
            CookieLanguageAnnotatorVisitor.$$$reportNull$$$0(5);
        }
        super.visitCookieDate(cookieDate);
        String value2 = cookieDate.getText();
        if (value2 != null && StringUtil.isEmptyOrSpaces((String)value2)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RestClientBundle.message("http.request.cookie.jar.inspection.empty.date", new Object[0])).afterEndOfLine().create();
        } else if (value2 != null && !value2.equals("-1")) {
            try {
                Date date = new HttpRequestCookiesStorage.CookieDateFormat().parse(value2);
                if (date.compareTo(new Date()) < 0) {
                    this.myHolder.newAnnotation(HighlightSeverity.WARNING, RestClientBundle.message("http.request.cookie.jar.inspection.expired.cookie", new Object[0])).create();
                }
            }
            catch (ParseException e) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RestClientBundle.message("http.request.cookie.jar.inspection.date.format", new Object[0])).create();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "malformedCookie";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookieRecordRest";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookieDomain";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookiePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookieDate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/cookies/annotator/CookieLanguageAnnotatorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMalformedCookie";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRecordRest";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCookieDomain";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCookiePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCookieDate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

