/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.environment.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.httpClient.executor.util.PartialResult;
import com.intellij.httpClient.http.request.HttpRequestExecutionEnvironment;
import com.intellij.httpClient.http.request.HttpVariableNameInfo;
import com.intellij.httpClient.http.request.environment.HttpClientEnvironmentsProvider;
import com.intellij.httpClient.http.request.environment.HttpClientSelectedEnvironments;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironmentDistDetailsService;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironmentFileNames;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironmentSslConfigUtil;
import com.intellij.httpClient.http.request.environment.auth.AuthConfiguration;
import com.intellij.httpClient.http.request.environment.auth.HttpAuthAwareEnvironment;
import com.intellij.httpClient.http.request.environment.auth.HttpClientEnvironmentAuthConfigExtractor;
import com.intellij.httpClient.http.request.environment.auth.HttpClientEnvironmentAuthStorage;
import com.intellij.httpClient.http.request.environment.auth.HttpClientStoredAuthInfo;
import com.intellij.httpClient.http.request.environment.impl.HttpRequestSyntheticAwareEnvironment;
import com.intellij.httpClient.http.request.psi.references.HttpClientJsonPsiUtilKt;
import com.intellij.httpClient.http.request.run.HttpClientJsonVariablesHelperKt;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.httpClient.http.request.substitution.HttpDynamicVariableProvider;
import com.intellij.httpClient.http.request.substitution.HttpDynamicVariableProviderKt;
import com.intellij.httpClient.http.request.substitution.HttpEnvironmentContextProviderKt;
import com.intellij.httpClient.http.request.variables.HttpClientEnvContext;
import com.intellij.httpClient.http.request.variables.HttpListVariableSubstitutionInfo;
import com.intellij.httpClient.http.request.variables.HttpSingleVariableSubstitutionInfo;
import com.intellij.httpClient.http.request.variables.HttpVariableSubstitutionInfo;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class HttpRequestEnvironmentDistDetailsServiceImpl
implements HttpRequestEnvironmentDistDetailsService {
    private static final String DEFAULT_EXECUTION_ENVIRONMENT = "rest.client.default.execution.environment";
    private static final String FORCE_DEFAULT_EXECUTION_ENVIRONMENT = "rest.client.force.default.execution.enironment";

    @Override
    public void setDefaultEnvName(@NotNull Project project, @Nullable String env) {
        if (project == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(0);
        }
        PropertiesComponent.getInstance((Project)project).setValue(DEFAULT_EXECUTION_ENVIRONMENT, env);
    }

    @Override
    @Nullable
    public String getDefaultEnvName(@NotNull Project project) {
        if (project == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(1);
        }
        return PropertiesComponent.getInstance((Project)project).getValue(DEFAULT_EXECUTION_ENVIRONMENT);
    }

    @Override
    @Nullable
    public String getDefaultEnvName(@NotNull Project project, @Nullable PsiFile contextFile) {
        if (project == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(2);
        }
        if (contextFile == null || contextFile.getVirtualFile() == null) {
            return null;
        }
        String env = HttpClientSelectedEnvironments.getInstance(contextFile.getProject()).get(contextFile.getVirtualFile());
        if (HttpClientSelectedEnvironments.isSelectBeforeRun(env)) {
            return this.getDefaultEnvName(project);
        }
        return env;
    }

    @Override
    public HttpRequestEnvironment getDefault(@NotNull Project project, @NotNull PsiFile contextFile) throws HttpRequestValidationException {
        if (project == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(3);
        }
        if (contextFile == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(4);
        }
        if (contextFile.getVirtualFile() == null) {
            return HttpRequestEnvironment.empty();
        }
        String selectedEnv = HttpClientSelectedEnvironments.getInstance(project).get(contextFile.getVirtualFile());
        if (HttpClientSelectedEnvironments.isSelectBeforeRun(selectedEnv)) {
            return this.getStoredDefault(project, contextFile);
        }
        return selectedEnv == null ? HttpRequestEnvironment.empty() : this.create(project, selectedEnv, contextFile);
    }

    @Override
    @Nullable
    public HttpRequestEnvironment getStoredDefault(@NotNull Project project, @NotNull PsiFile contextFile) throws HttpRequestValidationException {
        String env;
        if (project == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(5);
        }
        if (contextFile == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(6);
        }
        return StringUtil.isNotEmpty((String)(env = PropertiesComponent.getInstance((Project)project).getValue(DEFAULT_EXECUTION_ENVIRONMENT))) ? this.create(project, env, contextFile) : null;
    }

    @Override
    public boolean isNextForcedToUseStored(@NotNull Project project) {
        if (project == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(7);
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean(FORCE_DEFAULT_EXECUTION_ENVIRONMENT);
    }

    @Override
    public void clearForcingToUseStored(@NotNull Project project) {
        if (project == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(8);
        }
        PropertiesComponent.getInstance((Project)project).setValue(FORCE_DEFAULT_EXECUTION_ENVIRONMENT, false);
    }

    @Override
    public void forceNextUsingStored(@NotNull Project project) {
        if (project == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(9);
        }
        PropertiesComponent.getInstance((Project)project).setValue(FORCE_DEFAULT_EXECUTION_ENVIRONMENT, true);
    }

    @Override
    public boolean isDefaultEnvironmentValid(@NotNull Project project, @NotNull PsiFile contextFile) {
        String env;
        if (project == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(10);
        }
        if (contextFile == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(11);
        }
        return StringUtil.isEmpty((String)(env = HttpRequestEnvironmentDistDetailsServiceImpl.getEnvironmentForContext(project, contextFile))) || HttpClientEnvironmentsProvider.INSTANCE.getByName(contextFile, env) != null;
    }

    @Override
    public void clearDefaultIfInvalid(@NotNull Project project, @NotNull PsiFile contextFile) {
        String env;
        if (project == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(12);
        }
        if (contextFile == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmpty((String)(env = HttpRequestEnvironmentDistDetailsServiceImpl.getEnvironmentForContext(project, contextFile))) || HttpClientEnvironmentsProvider.INSTANCE.getByName(contextFile, env) == null) {
            PropertiesComponent.getInstance((Project)project).setValue(DEFAULT_EXECUTION_ENVIRONMENT, null);
        }
    }

    @Override
    public HttpRequestEnvironment create(@NotNull Project project, @Nullable String env, @NotNull PsiFile contextFile) throws HttpRequestValidationException {
        if (project == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(14);
        }
        if (contextFile == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(15);
        }
        if (StringUtil.isNotEmpty((String)env)) {
            HttpClientEnvironmentsProvider.EnvironmentDescriptor descriptor = HttpClientEnvironmentsProvider.INSTANCE.getByName(contextFile, env);
            if (descriptor == null) {
                if (DumbService.isDumb((Project)project) && HttpClientEnvironmentsProvider.INSTANCE.getByNameFast$intellij_restClient(contextFile, env) == null) {
                    throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.cannot.find.non.dumb.environment", env));
                }
                throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.cannot.find.environment", env));
            }
            return HttpRequestEnvironmentDistDetailsServiceImpl.createComposite(project, env, descriptor);
        }
        return HttpRequestEnvironment.empty();
    }

    @NotNull
    @RequiresReadLock
    public static HttpRequestEnvironment createComposite(@NotNull Project project, @NotNull String env, @NotNull HttpClientEnvironmentsProvider.EnvironmentDescriptor descriptor) {
        if (project == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(16);
        }
        if (env == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(17);
        }
        if (descriptor == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(18);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (descriptor.isSingle()) {
            return HttpRequestEnvironmentDistDetailsServiceImpl.createEnv(project, env, descriptor.single());
        }
        HttpRequestEnvironment publicEnv = HttpRequestEnvironmentDistDetailsServiceImpl.createEnv(project, env, descriptor.getForcedPublicEnv());
        HttpRequestEnvironment privateEnv = HttpRequestEnvironmentDistDetailsServiceImpl.createEnv(project, env, descriptor.getForcedPrivateEnvFile());
        return new HttpCompositeEnvironment(publicEnv, privateEnv);
    }

    @NotNull
    private static HttpRequestEnvironment createEnv(@NotNull Project project, @NotNull String env, @NotNull PsiFile file) {
        JsonObject environment;
        if (project == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(19);
        }
        if (env == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(20);
        }
        if (file == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(21);
        }
        if ((environment = HttpRequestEnvironmentDistDetailsServiceImpl.findEnvironmentObjectInFile(env, file)) != null) {
            boolean isPrivate = HttpRequestEnvironmentFileNames.isPrivateEnvFile(file.getName());
            VirtualFile vFile = file.getVirtualFile();
            return new HttpRequestJsonEnvironment(environment, isPrivate, ScratchRootType.getInstance().containsFile(vFile), !isPrivate ? null : () -> {
                SmartList values = new SmartList();
                values.add(vFile.getParent().getPresentableUrl());
                if (ScratchRootType.getInstance().containsFile(vFile)) {
                    VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
                    String projectPath = projectDir != null ? projectDir.getPresentableUrl() : null;
                    ContainerUtil.addIfNotNull((Collection)values, (Object)projectPath);
                }
                return values;
            }, env);
        }
        HttpRequestEnvironment httpRequestEnvironment = HttpRequestEnvironment.empty();
        if (httpRequestEnvironment == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(22);
        }
        return httpRequestEnvironment;
    }

    @Nullable
    private static String getEnvironmentForContext(@NotNull Project project, @Nullable PsiFile contextFile) {
        if (project == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(23);
        }
        if (contextFile == null) {
            return PropertiesComponent.getInstance((Project)project).getValue(DEFAULT_EXECUTION_ENVIRONMENT);
        }
        if (contextFile.getVirtualFile() != null) {
            String env = HttpClientSelectedEnvironments.getInstance(project).get(contextFile.getVirtualFile());
            if (HttpClientSelectedEnvironments.isSelectBeforeRun(env)) {
                return PropertiesComponent.getInstance((Project)project).getValue(DEFAULT_EXECUTION_ENVIRONMENT);
            }
            return env;
        }
        return null;
    }

    @Nullable
    public static JsonObject findEnvironmentObjectInFile(@NotNull String env, @NotNull PsiFile file) {
        if (env == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(24);
        }
        if (file == null) {
            HttpRequestEnvironmentDistDetailsServiceImpl.$$$reportNull$$$0(25);
        }
        if (file instanceof JsonFile) {
            JsonValue value2 = ((JsonFile)file).getTopLevelValue();
            return value2 instanceof JsonObject ? (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)((JsonObject)value2), (String)env, JsonObject.class) : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 17: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/environment/impl/HttpRequestEnvironmentDistDetailsServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/environment/impl/HttpRequestEnvironmentDistDetailsServiceImpl";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultEnvName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultEnvName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefault";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStoredDefault";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isNextForcedToUseStored";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clearForcingToUseStored";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forceNextUsingStored";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultEnvironmentValid";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearDefaultIfInvalid";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createComposite";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createEnv";
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironmentForContext";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findEnvironmentObjectInFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 22 -> new IllegalStateException(string);
        };
    }

    private static class HttpCompositeEnvironment
    extends HttpRequestEnvironment
    implements HttpAuthAwareEnvironment,
    HttpRequestSyntheticAwareEnvironment {
        private final HttpRequestEnvironment myApplicationEnv;
        private final HttpRequestEnvironment myPrivateEnv;

        HttpCompositeEnvironment(@NotNull HttpRequestEnvironment applicationEnv, @NotNull HttpRequestEnvironment privateEnv) {
            if (applicationEnv == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(0);
            }
            if (privateEnv == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(1);
            }
            super(applicationEnv.getEnvironmentName());
            this.myApplicationEnv = applicationEnv;
            this.myPrivateEnv = privateEnv;
        }

        @Override
        @Nullable
        public String getVariableValue(@NotNull String name) {
            String value2;
            if (name == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(2);
            }
            if ((value2 = this.myPrivateEnv.getVariableValue(name)) != null) {
                return value2;
            }
            return this.myApplicationEnv.getVariableValue(name);
        }

        @Override
        @Nullable
        public SslConfiguration getSslConfiguration() {
            return this.myPrivateEnv.getSslConfiguration();
        }

        @Override
        @NotNull
        public List<HttpRequestExecutionEnvironment.VariableInfo> getAllVariables() {
            VirtualFile privateFile;
            HttpRequestEnvironment httpRequestEnvironment = this.myApplicationEnv;
            if (!(httpRequestEnvironment instanceof HttpRequestJsonEnvironment)) {
                List list2 = ContainerUtil.concat(this.myApplicationEnv.getAllVariables(), this.myPrivateEnv.getAllVariables());
                if (list2 == null) {
                    HttpCompositeEnvironment.$$$reportNull$$$0(3);
                }
                return list2;
            }
            HttpRequestJsonEnvironment jsonAppEnvironment = (HttpRequestJsonEnvironment)httpRequestEnvironment;
            HttpRequestEnvironment httpRequestEnvironment2 = this.myPrivateEnv;
            if (!(httpRequestEnvironment2 instanceof HttpRequestJsonEnvironment)) {
                privateFile = null;
            } else {
                HttpRequestJsonEnvironment jsonPrivateEnvironment = (HttpRequestJsonEnvironment)httpRequestEnvironment2;
                privateFile = jsonPrivateEnvironment.getFile();
            }
            List list3 = ContainerUtil.concat((List[])new List[]{jsonAppEnvironment.getAllNonSyntheticVariables(), this.myPrivateEnv.getAllVariables(), jsonAppEnvironment.getStoredAuthAsSyntheticVariables(this, privateFile)});
            if (list3 == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(4);
            }
            return list3;
        }

        @Override
        @NotNull
        public HttpClientEnvContext getHttpClientEnvContext(@NotNull HttpClientEnvContext existingEnv, boolean validateVariables, @NotNull HttpDynamicVariableProvider dynamicVariableProvider) {
            if (existingEnv == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(5);
            }
            if (dynamicVariableProvider == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(6);
            }
            ObjectNode env = this.myApplicationEnv.getHttpClientEnvContext(existingEnv, validateVariables, dynamicVariableProvider).getPublic();
            ObjectNode privateEnv = this.myPrivateEnv.getHttpClientEnvContext(existingEnv, validateVariables, dynamicVariableProvider).getPrivate();
            return new HttpClientEnvContext(env, privateEnv);
        }

        @Override
        @Nullable
        public HttpClientStoredAuthInfo getStoredAuth(@NotNull String id) {
            HttpRequestEnvironment httpRequestEnvironment;
            if (id == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(7);
            }
            if (!((httpRequestEnvironment = this.myApplicationEnv) instanceof HttpRequestJsonEnvironment)) {
                return null;
            }
            HttpRequestJsonEnvironment jsonAppEnvironment = (HttpRequestJsonEnvironment)httpRequestEnvironment;
            HttpRequestEnvironment httpRequestEnvironment2 = this.myPrivateEnv;
            if (!(httpRequestEnvironment2 instanceof HttpRequestJsonEnvironment)) {
                return jsonAppEnvironment.getStoredAuth(id);
            }
            HttpRequestJsonEnvironment jsonPrivateEnvironment = (HttpRequestJsonEnvironment)httpRequestEnvironment2;
            HttpClientEnvironmentAuthConfigExtractor extractor = jsonAppEnvironment.getConfigExtractor(id, this);
            extractor.extractConfiguration();
            VirtualFile usedPrivateFile = extractor.isPrivateVariablesUsed() ? jsonPrivateEnvironment.getFile() : null;
            return jsonAppEnvironment.authStorage().getAuthState(jsonAppEnvironment.getFile(), this.getEnvironmentName(), id, usedPrivateFile);
        }

        @Override
        @NotNull
        public PartialResult.ConcreteResult<AuthConfiguration<?>, String> getConfig(@NotNull String id) {
            HttpRequestEnvironment httpRequestEnvironment;
            if (id == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(8);
            }
            if ((httpRequestEnvironment = this.myApplicationEnv) instanceof HttpRequestJsonEnvironment) {
                HttpRequestJsonEnvironment jsonEnvironment = (HttpRequestJsonEnvironment)httpRequestEnvironment;
                Object object = jsonEnvironment.getConfigExtractor(id, this).extractConfiguration();
                if (object == null) {
                    HttpCompositeEnvironment.$$$reportNull$$$0(9);
                }
                return object;
            }
            return new PartialResult.Error<String>("No config");
        }

        @Override
        public void storeAuth(@NotNull String id, @NotNull HttpClientStoredAuthInfo authInfo) {
            HttpRequestEnvironment httpRequestEnvironment;
            if (id == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(10);
            }
            if (authInfo == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(11);
            }
            if (!((httpRequestEnvironment = this.myApplicationEnv) instanceof HttpRequestJsonEnvironment)) {
                return;
            }
            HttpRequestJsonEnvironment appJsonEnvironment = (HttpRequestJsonEnvironment)httpRequestEnvironment;
            HttpRequestEnvironment httpRequestEnvironment2 = this.myPrivateEnv;
            if (!(httpRequestEnvironment2 instanceof HttpRequestJsonEnvironment)) {
                appJsonEnvironment.storeAuth(id, authInfo);
                return;
            }
            HttpRequestJsonEnvironment privateJsonEnvironment = (HttpRequestJsonEnvironment)httpRequestEnvironment2;
            HttpClientEnvironmentAuthConfigExtractor extractor = appJsonEnvironment.getConfigExtractor(id, this);
            extractor.extractConfiguration();
            VirtualFile privateFileUsed = extractor.isPrivateVariablesUsed() ? privateJsonEnvironment.getFile() : null;
            appJsonEnvironment.authStorage().putAuthState(appJsonEnvironment.getFile(), this.getEnvironmentName(), id, privateFileUsed, authInfo);
        }

        @Override
        public void deleteAuth(@NotNull String id) {
            HttpRequestEnvironment httpRequestEnvironment;
            if (id == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(12);
            }
            if (!((httpRequestEnvironment = this.myApplicationEnv) instanceof HttpRequestJsonEnvironment)) {
                return;
            }
            HttpRequestJsonEnvironment appJsonEnvironment = (HttpRequestJsonEnvironment)httpRequestEnvironment;
            HttpRequestEnvironment httpRequestEnvironment2 = this.myPrivateEnv;
            if (!(httpRequestEnvironment2 instanceof HttpRequestJsonEnvironment)) {
                appJsonEnvironment.deleteAuth(id);
                return;
            }
            HttpRequestJsonEnvironment privateJsonEnvironment = (HttpRequestJsonEnvironment)httpRequestEnvironment2;
            HttpClientEnvironmentAuthConfigExtractor extractor = appJsonEnvironment.getConfigExtractor(id, this);
            extractor.extractConfiguration();
            VirtualFile privateFileUsed = extractor.isPrivateVariablesUsed() ? privateJsonEnvironment.getFile() : null;
            appJsonEnvironment.authStorage().deleteAuthState(appJsonEnvironment.getFile(), this.getEnvironmentName(), id, privateFileUsed);
        }

        @Override
        @Nullable
        public PsiElement getConfigDeclaration(@NotNull String id) {
            PsiElement psiElement;
            HttpRequestEnvironment httpRequestEnvironment;
            if (id == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(13);
            }
            if ((httpRequestEnvironment = this.myApplicationEnv) instanceof HttpAuthAwareEnvironment) {
                HttpAuthAwareEnvironment authAwareEnvironment = (HttpAuthAwareEnvironment)((Object)httpRequestEnvironment);
                psiElement = authAwareEnvironment.getConfigDeclaration(id);
            } else {
                psiElement = null;
            }
            return psiElement;
        }

        @Override
        public boolean containsConfig(@NotNull String id) {
            HttpAuthAwareEnvironment authAwareEnvironment;
            HttpRequestEnvironment httpRequestEnvironment;
            if (id == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(14);
            }
            return (httpRequestEnvironment = this.myApplicationEnv) instanceof HttpAuthAwareEnvironment && (authAwareEnvironment = (HttpAuthAwareEnvironment)((Object)httpRequestEnvironment)).containsConfig(id);
        }

        @Override
        public boolean isAuthAcquired(@NotNull String id) {
            HttpAuthAwareEnvironment authAwareEnvironment;
            HttpRequestEnvironment httpRequestEnvironment;
            if (id == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(15);
            }
            return (httpRequestEnvironment = this.myApplicationEnv) instanceof HttpAuthAwareEnvironment && (authAwareEnvironment = (HttpAuthAwareEnvironment)((Object)httpRequestEnvironment)).isAuthAcquired(id);
        }

        @Override
        @NotNull
        public List<HttpRequestExecutionEnvironment.VariableInfo> getAllNonSyntheticVariables() {
            HttpRequestEnvironment httpRequestEnvironment = this.myApplicationEnv;
            if (!(httpRequestEnvironment instanceof HttpRequestJsonEnvironment)) {
                List<HttpRequestExecutionEnvironment.VariableInfo> list2 = this.getAllVariables();
                if (list2 == null) {
                    HttpCompositeEnvironment.$$$reportNull$$$0(16);
                }
                return list2;
            }
            HttpRequestJsonEnvironment appJsonEnvironment = (HttpRequestJsonEnvironment)httpRequestEnvironment;
            List list3 = ContainerUtil.concat(appJsonEnvironment.getAllNonSyntheticVariables(), this.myPrivateEnv.getAllVariables());
            if (list3 == null) {
                HttpCompositeEnvironment.$$$reportNull$$$0(17);
            }
            return list3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 9, 16, 17 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "applicationEnv";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "privateEnv";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/environment/impl/HttpRequestEnvironmentDistDetailsServiceImpl$HttpCompositeEnvironment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingEnv";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dynamicVariableProvider";
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "authInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/environment/impl/HttpRequestEnvironmentDistDetailsServiceImpl$HttpCompositeEnvironment";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllVariables";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfig";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllNonSyntheticVariables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariableValue";
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 16: 
                case 17: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getHttpClientEnvContext";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getStoredAuth";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfig";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "storeAuth";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteAuth";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigDeclaration";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "containsConfig";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "isAuthAcquired";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 9, 16, 17 -> new IllegalStateException(string);
            };
        }
    }

    private static class HttpRequestJsonEnvironment
    extends HttpRequestEnvironment
    implements HttpAuthAwareEnvironment,
    HttpRequestSyntheticAwareEnvironment {
        private final boolean myIsPrivate;
        @Nullable
        private final Supplier<List<String>> myBasePathProvider;
        @NotNull
        private final JsonObject myVariables;
        private final boolean myIsScratch;

        HttpRequestJsonEnvironment(@NotNull JsonObject variables2, boolean isPrivate, boolean scratch, @Nullable Supplier<List<String>> basePathProvider, @NotNull String name) {
            if (variables2 == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(0);
            }
            if (name == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(1);
            }
            super(name);
            this.myVariables = variables2;
            this.myIsPrivate = isPrivate;
            this.myBasePathProvider = basePathProvider;
            this.myIsScratch = scratch;
        }

        @Override
        @Nullable
        public String getVariableValue(@NotNull String name) {
            if (name == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(2);
            }
            if (StringUtil.isEmpty((String)name)) {
                return null;
            }
            HttpClientEnvContext context = this.getHttpClientEnvContext(new HttpClientEnvContext(), false, HttpDynamicVariableProviderKt.emptyHttpDynamicVariableProvider());
            HttpVariableSubstitutionInfo substitutionInfo = HttpEnvironmentContextProviderKt.tryToFindVariableSubstitution(new HttpVariableNameInfo(name, 0), context);
            if (substitutionInfo == null || substitutionInfo instanceof HttpListVariableSubstitutionInfo) {
                return null;
            }
            return ((HttpSingleVariableSubstitutionInfo)substitutionInfo).getVariableValue();
        }

        @Override
        @Nullable
        public HttpClientStoredAuthInfo getStoredAuth(@NotNull String id) {
            if (id == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(3);
            }
            if (this.myIsPrivate) {
                return null;
            }
            return this.authStorage().getAuthState(this.getFile(), this.getEnvironmentName(), id, null);
        }

        @Override
        @NotNull
        public PartialResult.ConcreteResult<AuthConfiguration<?>, String> getConfig(@NotNull String id) {
            if (id == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(4);
            }
            if (this.myIsPrivate) {
                PartialResult.ConcreteResult<AuthConfiguration<?>, String> concreteResult = HttpClientEnvironmentAuthConfigExtractor.privateEnvironmentError((PsiElement)this.myVariables);
                if (concreteResult == null) {
                    HttpRequestJsonEnvironment.$$$reportNull$$$0(5);
                }
                return concreteResult;
            }
            Object object = this.getConfigExtractor(id, this).extractConfiguration();
            if (object == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(6);
            }
            return object;
        }

        @NotNull
        private HttpClientEnvironmentAuthConfigExtractor getConfigExtractor(@NotNull String id, HttpRequestSyntheticAwareEnvironment environment) {
            if (id == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(7);
            }
            return new HttpClientEnvironmentAuthConfigExtractor(id, environment, this.myVariables, this.myIsScratch);
        }

        @Override
        public void storeAuth(@NotNull String id, @NotNull HttpClientStoredAuthInfo authInfo) {
            if (id == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(8);
            }
            if (authInfo == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(9);
            }
            if (this.myIsPrivate) {
                return;
            }
            this.authStorage().putAuthState(this.getFile(), this.getEnvironmentName(), id, null, authInfo);
        }

        @Override
        public void deleteAuth(@NotNull String id) {
            if (id == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(10);
            }
            if (this.myIsPrivate) {
                return;
            }
            this.authStorage().deleteAuthState(this.getFile(), this.getEnvironmentName(), id, null);
        }

        @NotNull
        HttpClientEnvironmentAuthStorage authStorage() {
            HttpClientEnvironmentAuthStorage httpClientEnvironmentAuthStorage = HttpClientEnvironmentAuthStorage.getInstance(this.myVariables.getProject());
            if (httpClientEnvironmentAuthStorage == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(11);
            }
            return httpClientEnvironmentAuthStorage;
        }

        @NotNull
        VirtualFile getFile() {
            VirtualFile virtualFile = this.myVariables.getContainingFile().getVirtualFile();
            if (virtualFile == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(12);
            }
            return virtualFile;
        }

        @Override
        @Nullable
        public PsiElement getConfigDeclaration(@NotNull String id) {
            if (id == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(13);
            }
            if (this.myIsPrivate) {
                return null;
            }
            return this.getConfigExtractor(id, this).getAuthConfigProperty();
        }

        @Override
        public boolean containsConfig(@NotNull String id) {
            if (id == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(14);
            }
            if (this.myIsPrivate) {
                return false;
            }
            return this.getConfigExtractor(id, this).getAuthConfigProperty() != null;
        }

        @Override
        public boolean isAuthAcquired(@NotNull String id) {
            if (id == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(15);
            }
            if (this.myIsPrivate) {
                return false;
            }
            return this.authStorage().hasSomething$intellij_restClient(this.getFile(), this.getEnvironmentName(), id);
        }

        @Override
        @NotNull
        public HttpClientEnvContext getHttpClientEnvContext(@NotNull HttpClientEnvContext existingEnv, boolean validateVariables, @NotNull HttpDynamicVariableProvider dynamicVariableProvider) {
            if (existingEnv == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(16);
            }
            if (dynamicVariableProvider == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(17);
            }
            ObjectNode root = HttpClientJsonVariablesHelperKt.newObjNode();
            JsonNode node = HttpClientJsonPsiUtilKt.convertToJson(this.myVariables);
            node.properties().forEach(prop -> root.set((String)prop.getKey(), (JsonNode)prop.getValue()));
            return this.myIsPrivate ? new HttpClientEnvContext(HttpClientJsonVariablesHelperKt.newObjNode(), root) : new HttpClientEnvContext(root, HttpClientJsonVariablesHelperKt.newObjNode());
        }

        @Nullable
        private static String getValueAsString(@Nullable JsonLiteral value2) {
            if (value2 instanceof JsonStringLiteral) {
                JsonStringLiteral stringLiteral = (JsonStringLiteral)value2;
                return stringLiteral.getValue();
            }
            if (value2 instanceof JsonBooleanLiteral) {
                JsonBooleanLiteral booleanLiteral = (JsonBooleanLiteral)value2;
                return String.valueOf(booleanLiteral.getValue());
            }
            return value2 != null ? value2.getText() : null;
        }

        @Override
        @Nullable
        public SslConfiguration getSslConfiguration() {
            return this.myIsPrivate ? HttpRequestEnvironmentSslConfigUtil.extractConfigFromJson(this.myVariables, this.myBasePathProvider, this.myIsScratch) : null;
        }

        @Override
        @NotNull
        public List<HttpRequestExecutionEnvironment.VariableInfo> getAllVariables() {
            if (this.myIsPrivate) {
                List<HttpRequestExecutionEnvironment.VariableInfo> list2 = this.getAllNonSyntheticVariables();
                if (list2 == null) {
                    HttpRequestJsonEnvironment.$$$reportNull$$$0(18);
                }
                return list2;
            }
            List list3 = ContainerUtil.concat(this.getAllNonSyntheticVariables(), this.getStoredAuthAsSyntheticVariables(this, null));
            if (list3 == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(19);
            }
            return list3;
        }

        @Override
        @NotNull
        public List<HttpRequestExecutionEnvironment.VariableInfo> getAllNonSyntheticVariables() {
            List list2 = StreamEx.of((Collection)this.myVariables.getPropertyList()).map(property -> {
                if (!(property.getValue() instanceof JsonLiteral)) {
                    return null;
                }
                String value2 = HttpRequestJsonEnvironment.getValueAsString((JsonLiteral)property.getValue());
                if (value2 == null) {
                    return null;
                }
                return new HttpRequestExecutionEnvironment.VariableInfo(property.getName(), value2, this.myIsPrivate);
            }).nonNull().toList();
            if (list2 == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(20);
            }
            return list2;
        }

        @NotNull
        List<HttpRequestExecutionEnvironment.VariableInfo> getStoredAuthAsSyntheticVariables(@NotNull HttpRequestSyntheticAwareEnvironment environment, @Nullable VirtualFile privateFile) {
            if (environment == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(21);
            }
            List<String> ids = this.getDeclaredAuthIds();
            List<HttpRequestExecutionEnvironment.VariableInfo> list2 = ids.stream().flatMap(id -> {
                HttpClientEnvironmentAuthConfigExtractor extract = this.getConfigExtractor((String)id, environment);
                extract.extractConfiguration();
                HttpClientStoredAuthInfo storedState = this.authStorage().getAuthState(this.myVariables.getContainingFile().getVirtualFile(), environment.getEnvironmentName(), (String)id, (VirtualFile)(extract.isPrivateVariablesUsed() ? privateFile : null));
                if (storedState == null) {
                    return Stream.empty();
                }
                String variableName = "$auth.token(\"" + id + "\")";
                return StreamEx.of(storedState.getVisibleSecrets()).map(secret -> new HttpRequestExecutionEnvironment.VariableInfo(variableName, (String)secret, true, true));
            }).toList();
            if (list2 == null) {
                HttpRequestJsonEnvironment.$$$reportNull$$$0(22);
            }
            return list2;
        }

        private List<String> getDeclaredAuthIds() {
            JsonObject authObject = this.getConfigExtractor("", this).getAuthObject();
            if (authObject == null) {
                return List.of();
            }
            return ((StreamEx)StreamEx.of((Collection)authObject.getPropertyList()).filter(property -> property.getValue() instanceof JsonObject)).map(property -> property.getName()).toList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 11, 12, 18, 19, 20, 22 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variables";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 10: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 5: 
                case 6: 
                case 11: 
                case 12: 
                case 18: 
                case 19: 
                case 20: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/environment/impl/HttpRequestEnvironmentDistDetailsServiceImpl$HttpRequestJsonEnvironment";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "authInfo";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingEnv";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dynamicVariableProvider";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/environment/impl/HttpRequestEnvironmentDistDetailsServiceImpl$HttpRequestJsonEnvironment";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfig";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "authStorage";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllVariables";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllNonSyntheticVariables";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStoredAuthAsSyntheticVariables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariableValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getStoredAuth";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfig";
                    break;
                }
                case 5: 
                case 6: 
                case 11: 
                case 12: 
                case 18: 
                case 19: 
                case 20: 
                case 22: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigExtractor";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "storeAuth";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteAuth";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigDeclaration";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "containsConfig";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "isAuthAcquired";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getHttpClientEnvContext";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getStoredAuthAsSyntheticVariables";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 11, 12, 18, 19, 20, 22 -> new IllegalStateException(string);
            };
        }
    }
}

