/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.substitution;

import com.intellij.httpClient.http.request.HttpRequestPersistentSubstitutor;
import com.intellij.httpClient.http.request.HttpRequestPsiFactory;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutionKey;
import com.intellij.httpClient.http.request.dynamicVariables.HttpClientDynamicVariables;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariable;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariableExpr;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J$\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c2\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\fH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/httpClient/http/request/substitution/HttpDynamicVariableProvider;", "", "persistentSubstitutor", "Lcom/intellij/httpClient/http/request/HttpRequestPersistentSubstitutor;", "validateVariables", "", "ignoreDynamicVariables", "environment", "Lcom/intellij/httpClient/http/request/environment/HttpRequestEnvironment;", "<init>", "(Lcom/intellij/httpClient/http/request/HttpRequestPersistentSubstitutor;ZZLcom/intellij/httpClient/http/request/environment/HttpRequestEnvironment;)V", "getDynamicVariable", "", "name", "defaultValue", "key", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutionKey;", "project", "Lcom/intellij/openapi/project/Project;", "dynamicVariable", "Lcom/intellij/httpClient/http/request/psi/HttpDynamicVariable;", "getVariable", "variable", "getDynamicVariableValue", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "intellij.httpClient.executor"})
public final class HttpDynamicVariableProvider {
    @NotNull
    private final HttpRequestPersistentSubstitutor persistentSubstitutor;
    private final boolean validateVariables;
    private final boolean ignoreDynamicVariables;
    @NotNull
    private final HttpRequestEnvironment environment;

    public HttpDynamicVariableProvider(@NotNull HttpRequestPersistentSubstitutor persistentSubstitutor, boolean validateVariables, boolean ignoreDynamicVariables, @NotNull HttpRequestEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)persistentSubstitutor, (String)"persistentSubstitutor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.persistentSubstitutor = persistentSubstitutor;
        this.validateVariables = validateVariables;
        this.ignoreDynamicVariables = ignoreDynamicVariables;
        this.environment = environment;
    }

    public /* synthetic */ HttpDynamicVariableProvider(HttpRequestPersistentSubstitutor httpRequestPersistentSubstitutor, boolean bl, boolean bl2, HttpRequestEnvironment httpRequestEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(httpRequestPersistentSubstitutor, bl, bl2, httpRequestEnvironment);
    }

    @NotNull
    public final String getDynamicVariable(@NotNull String name, @Nullable String defaultValue, @Nullable HttpRequestVariableSubstitutionKey key, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = HttpRequestElementTypes.DYNAMIC_SIGN.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String variableExprText = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)name, (String)string, null, (int)2, null))).toString();
        HttpDynamicVariable httpDynamicVariable = HttpRequestPsiFactory.createDynamicVariable(project, variableExprText);
        Intrinsics.checkNotNullExpressionValue((Object)httpDynamicVariable, (String)"createDynamicVariable(...)");
        HttpDynamicVariable dynamicVariable = httpDynamicVariable;
        return this.getVariable(dynamicVariable, key, defaultValue);
    }

    @NotNull
    public final String getDynamicVariable(@NotNull HttpDynamicVariable dynamicVariable, @Nullable HttpRequestVariableSubstitutionKey key) {
        Intrinsics.checkNotNullParameter((Object)dynamicVariable, (String)"dynamicVariable");
        return this.getVariable(dynamicVariable, key, dynamicVariable.getText());
    }

    private final String getVariable(HttpDynamicVariable variable, HttpRequestVariableSubstitutionKey key, String defaultValue) {
        if (key == null || Intrinsics.areEqual((Object)"auth.token", (Object)variable.getName())) {
            return this.getDynamicVariableValue(variable, defaultValue);
        }
        return this.persistentSubstitutor.retrieve(key, (Function0<String>)((Function0)() -> HttpDynamicVariableProvider.getVariable$lambda$0(this, variable, defaultValue)));
    }

    @Contract(value="_, !null -> !null")
    private final String getDynamicVariableValue(HttpDynamicVariable variable, String defaultValue) {
        if (this.ignoreDynamicVariables) {
            String string = defaultValue;
            if (string == null) {
                string = "";
            }
            return string;
        }
        HttpDynamicVariableExpr httpDynamicVariableExpr = variable.getDynamicVariableExpr();
        if (httpDynamicVariableExpr == null) {
            String string = defaultValue;
            if (string == null) {
                string = "";
            }
            return string;
        }
        HttpDynamicVariableExpr expr = httpDynamicVariableExpr;
        String computed = HttpClientDynamicVariables.Companion.computeDynamicVariable(this.environment, this.validateVariables, expr);
        String string = computed;
        if (string == null && (string = defaultValue) == null) {
            string = "";
        }
        return string;
    }

    private final HttpRequestPersistentSubstitutor component1() {
        return this.persistentSubstitutor;
    }

    private final boolean component2() {
        return this.validateVariables;
    }

    private final boolean component3() {
        return this.ignoreDynamicVariables;
    }

    private final HttpRequestEnvironment component4() {
        return this.environment;
    }

    @NotNull
    public final HttpDynamicVariableProvider copy(@NotNull HttpRequestPersistentSubstitutor persistentSubstitutor, boolean validateVariables, boolean ignoreDynamicVariables, @NotNull HttpRequestEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)persistentSubstitutor, (String)"persistentSubstitutor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return new HttpDynamicVariableProvider(persistentSubstitutor, validateVariables, ignoreDynamicVariables, environment);
    }

    public static /* synthetic */ HttpDynamicVariableProvider copy$default(HttpDynamicVariableProvider httpDynamicVariableProvider, HttpRequestPersistentSubstitutor httpRequestPersistentSubstitutor, boolean bl, boolean bl2, HttpRequestEnvironment httpRequestEnvironment, int n, Object object) {
        if ((n & 1) != 0) {
            httpRequestPersistentSubstitutor = httpDynamicVariableProvider.persistentSubstitutor;
        }
        if ((n & 2) != 0) {
            bl = httpDynamicVariableProvider.validateVariables;
        }
        if ((n & 4) != 0) {
            bl2 = httpDynamicVariableProvider.ignoreDynamicVariables;
        }
        if ((n & 8) != 0) {
            httpRequestEnvironment = httpDynamicVariableProvider.environment;
        }
        return httpDynamicVariableProvider.copy(httpRequestPersistentSubstitutor, bl, bl2, httpRequestEnvironment);
    }

    @NotNull
    public String toString() {
        return "HttpDynamicVariableProvider(persistentSubstitutor=" + this.persistentSubstitutor + ", validateVariables=" + this.validateVariables + ", ignoreDynamicVariables=" + this.ignoreDynamicVariables + ", environment=" + this.environment + ")";
    }

    public int hashCode() {
        int result2 = this.persistentSubstitutor.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.validateVariables);
        result2 = result2 * 31 + Boolean.hashCode(this.ignoreDynamicVariables);
        result2 = result2 * 31 + this.environment.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpDynamicVariableProvider)) {
            return false;
        }
        HttpDynamicVariableProvider httpDynamicVariableProvider = (HttpDynamicVariableProvider)other;
        if (!Intrinsics.areEqual((Object)this.persistentSubstitutor, (Object)httpDynamicVariableProvider.persistentSubstitutor)) {
            return false;
        }
        if (this.validateVariables != httpDynamicVariableProvider.validateVariables) {
            return false;
        }
        if (this.ignoreDynamicVariables != httpDynamicVariableProvider.ignoreDynamicVariables) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.environment, (Object)httpDynamicVariableProvider.environment);
    }

    private static final String getVariable$lambda$0(HttpDynamicVariableProvider this$0, HttpDynamicVariable $variable, String $defaultValue) {
        return this$0.getDynamicVariableValue($variable, $defaultValue);
    }
}

