/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.RegExpPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.StringPrototypeBuiltins;
import com.oracle.truffle.js.builtins.helper.IsPristineObjectNode;
import com.oracle.truffle.js.builtins.helper.JSRegExpExecIntlNode;
import com.oracle.truffle.js.builtins.helper.ReplaceStringParser;
import com.oracle.truffle.js.nodes.CompileRegexNode;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.nodes.cast.JSToLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import com.oracle.truffle.js.nodes.cast.LongToIntOrDoubleNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.JSRegExpObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import com.oracle.truffle.js.runtime.util.StringBuilderProfile;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import com.oracle.truffle.js.runtime.util.TRegexUtilFactory;
import java.util.EnumSet;

public final class RegExpPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<RegExpPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new RegExpPrototypeBuiltins();

    protected RegExpPrototypeBuiltins() {
        super(JSRegExp.PROTOTYPE_NAME, RegExpPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, RegExpPrototype builtinEnum) {
        switch (builtinEnum) {
            case exec: {
                if (context.getEcmaScriptVersion() >= 6) {
                    return RegExpPrototypeBuiltinsFactory.JSRegExpExecNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                return RegExpPrototypeBuiltinsFactory.JSRegExpExecES5NodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case test: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpTestNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case toString: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpToStringNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case _match: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpMatchNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case _replace: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpReplaceNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case _search: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpSearchNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case _split: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpSplitNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case compile: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpCompileNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case _matchAll: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpMatchAllNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException createNoRegExpError(Object obj) {
        TruffleString objName = Strings.fromObject(JSRuntime.toPrimitive(obj, JSToPrimitiveNode.Hint.String));
        return Errors.createTypeError(Strings.toJavaString(objName) + " is not a RegExp");
    }

    public static enum RegExpPrototype implements BuiltinEnum<RegExpPrototype>
    {
        exec(1),
        test(1),
        toString(0),
        _match(1, Symbol.SYMBOL_MATCH),
        _replace(2, Symbol.SYMBOL_REPLACE),
        _search(1, Symbol.SYMBOL_SEARCH),
        _split(2, Symbol.SYMBOL_SPLIT),
        compile(2),
        _matchAll(1, Symbol.SYMBOL_MATCH_ALL);

        private final int length;
        private final Symbol key;

        private RegExpPrototype(int length2) {
            this(length2, null);
        }

        private RegExpPrototype(int length2, Symbol symbol) {
            this.length = length2;
            this.key = symbol;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isAnnexB() {
            return this == compile;
        }

        @Override
        public int getECMAScriptVersion() {
            if (EnumSet.of(_match, _replace, _search, _split).contains(this)) {
                return 6;
            }
            if (this.equals(_matchAll)) {
                return 10;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }

        @Override
        public Object getKey() {
            return this.key != null ? this.key : BuiltinEnum.super.getKey();
        }
    }

    public static abstract class JSRegExpExecNode
    extends JSBuiltinNode {
        @Node.Child
        private JSRegExpExecIntlNode.JSRegExpExecBuiltinNode regExpNode;

        JSRegExpExecNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            assert (context.getEcmaScriptVersion() >= 6);
            this.regExpNode = JSRegExpExecIntlNode.JSRegExpExecBuiltinNode.create(context);
        }

        @Specialization
        JSDynamicObject doString(JSRegExpObject thisRegExp, TruffleString inputStr) {
            return (JSDynamicObject)this.regExpNode.execute(thisRegExp, inputStr);
        }

        @Specialization(replaces={"doString"})
        JSDynamicObject doObject(JSRegExpObject thisRegExp, Object input, @Cached JSToStringNode toStringNode) {
            return (JSDynamicObject)this.regExpNode.execute(thisRegExp, toStringNode.executeString(input));
        }

        @Fallback
        Object doNoRegExp(Object thisObj, Object input) {
            throw RegExpPrototypeBuiltins.createNoRegExpError(thisObj);
        }
    }

    @ImportStatic(value={JSRegExp.class})
    public static abstract class JSRegExpExecES5Node
    extends JSBuiltinNode {
        protected JSRegExpExecES5Node(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            assert (context.getEcmaScriptVersion() < 6);
        }

        public abstract JSDynamicObject execute(Object var1, Object var2);

        @Specialization
        protected JSDynamicObject exec(JSRegExpObject thisRegExp, Object input, @Bind(value="this") Node node, @Cached JSToStringNode toStringNode, @Cached(value="create(getContext())") JSRegExpExecIntlNode.JSRegExpExecBuiltinNode regExpNode, @Cached(inline=true) TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached(inline=true) TRegexUtil.InteropReadIntMemberNode readGroupCount, @Cached(inline=true) TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached(inline=true) TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached InlinedCountingConditionProfile ifIsMatch, @Cached(value="create(INDEX, false, getContext(), false)") PropertySetNode setIndexNode, @Cached(value="create(INPUT, false, getContext(), false)") PropertySetNode setInputNode) {
            assert (this.getContext().getEcmaScriptVersion() < 6);
            TruffleString inputStr = toStringNode.executeString(input);
            Object result2 = regExpNode.execute(thisRegExp, inputStr);
            if (ifIsMatch.profile(node, TRegexUtil.TRegexResultAccessor.isMatch(result2, node, readIsMatch))) {
                int groupCount = TRegexUtil.TRegexCompiledRegexAccessor.groupCount(JSRegExp.getCompiledRegex(thisRegExp), node, readGroupCount);
                Object[] matches = TRegexUtil.TRegexMaterializeResult.materializeFull(this.getContext(), result2, groupCount, inputStr, node, substringNode, getStart, getEnd);
                JSArrayObject array = JSArray.createConstant(this.getContext(), this.getRealm(), matches);
                setIndexNode.setValueInt(array, TRegexUtil.TRegexResultAccessor.captureGroupStart(result2, 0, node, getStart));
                setInputNode.setValue(array, inputStr);
                return array;
            }
            return Null.instance;
        }

        @Fallback
        protected static JSDynamicObject exec(Object thisObj, Object input) {
            throw RegExpPrototypeBuiltins.createNoRegExpError(thisObj);
        }

        @NeverDefault
        static JSRegExpExecES5Node create(JSContext context) {
            return RegExpPrototypeBuiltinsFactory.JSRegExpExecES5NodeGen.create(context, null, null);
        }
    }

    public static abstract class JSRegExpTestNode
    extends JSBuiltinNode {
        protected JSRegExpTestNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(thisObj)"}, limit="1")
        protected Object testGeneric(JSDynamicObject thisObj, Object input, @Bind(value="this") Node node, @Cached IsJSObjectNode isObjectNode, @Cached JSToStringNode toStringNode, @Cached(value="create(getContext())") JSRegExpExecIntlNode regExpNode, @Cached(inline=true) TRegexUtil.InteropReadBooleanMemberNode readIsMatch) {
            TruffleString inputStr = toStringNode.executeString(input);
            Object result2 = regExpNode.execute(thisObj, inputStr);
            if (this.getContext().getEcmaScriptVersion() >= 6) {
                return result2 != Null.instance;
            }
            return readIsMatch.execute(node, result2, "isMatch");
        }

        @Fallback
        protected Object testError(Object thisNonObj, Object input) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.test", thisNonObj);
        }
    }

    public static abstract class JSRegExpToStringNode
    extends JSBuiltinNode {
        @Node.Child
        private PropertyGetNode getSourceNode;
        @Node.Child
        private PropertyGetNode getFlagsNode;

        protected JSRegExpToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getFlagsNode = PropertyGetNode.create(Strings.FLAGS, false, context);
            this.getSourceNode = PropertyGetNode.create(Strings.SOURCE, false, context);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(thisObj)"}, limit="1")
        protected Object toString(JSDynamicObject thisObj, @Cached IsJSObjectNode isObjectNode, @Cached JSToStringNode toString1Node, @Cached JSToStringNode toString2Node) {
            TruffleString source = toString1Node.executeString(this.getSourceNode.getValue(thisObj));
            TruffleString flags = toString2Node.executeString(this.getFlagsNode.getValue(thisObj));
            return JSRegExpToStringNode.toStringIntl(source, flags);
        }

        @Fallback
        protected Object toString(Object thisNonObj) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.toString", thisNonObj);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object toStringIntl(TruffleString source, TruffleString flags) {
            return Strings.concatAll(Strings.SLASH, source, Strings.SLASH, flags);
        }
    }

    @ImportStatic(value={JSRegExp.class})
    public static abstract class JSRegExpMatchNode
    extends RegExpPrototypeSymbolOperation {
        protected JSRegExpMatchNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(rx)"}, limit="1")
        protected Object match(JSDynamicObject rx, Object param, @Bind(value="this") Node node, @Cached IsJSObjectNode isObjectNode, @Cached(value="create(FLAGS, getContext())") PropertyGetNode getFlagsNode, @Cached JSToStringNode toStringNodeForFlags, @Cached TruffleString.ByteIndexOfCodePointNode stringIndexOfNode, @Cached JSToStringNode toString1Node, @Cached JSToStringNode toString2Node, @Cached JSToLengthNode toLengthNode, @Cached InlinedConditionProfile isGlobal, @Cached InlinedConditionProfile isUnicode, @Cached AdvanceStringIndexUnicodeNode advanceStringIndexUnicode) {
            TruffleString s = toString1Node.executeString(param);
            TruffleString flags = toStringNodeForFlags.executeString(getFlagsNode.getValue(rx));
            if (isGlobal.profile(node, Strings.indexOf(stringIndexOfNode, flags, 103) == -1)) {
                return this.regexExecIntl(rx, s);
            }
            boolean fullUnicode = Strings.indexOf(stringIndexOfNode, flags, 117) != -1;
            this.setLastIndex((Object)rx, 0);
            JSArrayObject array = JSArray.createEmptyZeroLength(this.getContext(), this.getRealm());
            int n = 0;
            JSDynamicObject result2;
            while ((result2 = (JSDynamicObject)this.regexExecIntl(rx, s)) != Null.instance) {
                TruffleString matchStr = toString2Node.executeString(this.read(result2, 0));
                this.write(array, n, matchStr);
                if (Strings.length(matchStr) == 0) {
                    int lastI = (int)toLengthNode.executeLong(this.getLastIndex(rx));
                    this.setLastIndex((Object)rx, isUnicode.profile(node, fullUnicode) ? advanceStringIndexUnicode.execute(node, s, lastI) : lastI + 1);
                }
                ++n;
            }
            return n == 0 ? Null.instance : array;
        }

        @Fallback
        protected static Object match(Object thisObj, Object string) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@match", thisObj);
        }
    }

    public static abstract class JSRegExpReplaceNode
    extends RegExpPrototypeSymbolOperation
    implements ReplaceStringConsumerTRegex.ParentNode {
        @Node.Child
        private JSToStringNode toString2Node;
        @Node.Child
        private JSToStringNode toString3Node;
        @Node.Child
        private JSToStringNode toString4Node;
        @Node.Child
        private IsJSObjectNode isObjectNode;
        @Node.Child
        private IsCallableNode isCallableNode;
        @Node.Child
        private ReadElementNode readNamedCaptureGroupNode;
        @Node.Child
        private JSToObjectNode toObjectNode;
        @Node.Child
        private IsPristineObjectNode isPristineObjectNode;
        @Node.Child
        private TruffleStringBuilder.AppendStringNode appendStringNode;
        @Node.Child
        private TruffleStringBuilder.AppendSubstringByteIndexNode appendSubStringNode;
        @Node.Child
        private TruffleStringBuilder.ToStringNode builderToStringNode;
        final StringBuilderProfile stringBuilderProfile;
        final BranchProfile invalidGroupNumberProfile = BranchProfile.create();
        @Node.Child
        private TRegexUtil.InvokeGetGroupBoundariesMethodNode getStartNode = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();
        @Node.Child
        private TRegexUtil.InvokeGetGroupBoundariesMethodNode getEndNode = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();
        @Node.Child
        private TRegexUtil.InteropReadMemberNode readGroupsNode = TRegexUtil.InteropReadMemberNode.create();
        @Node.Child
        private InteropLibrary namedCaptureGroupInterop = InteropLibrary.getFactory().createDispatched(5);
        @Node.Child
        private TRegexUtil.InteropToIntNode toIntNode = TRegexUtilFactory.InteropToIntNodeGen.create();

        JSRegExpReplaceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.isObjectNode = IsJSObjectNode.create();
            this.isCallableNode = IsCallableNode.create();
            this.stringBuilderProfile = StringBuilderProfile.create(context.getStringLengthLimit());
        }

        @Specialization(guards={"stringEquals(equalsNode, cachedReplaceValue, replaceValue)"}, limit="1")
        protected Object replaceStringCached(JSDynamicObject rx, Object searchValue, TruffleString replaceValue, @Cached(value="replaceValue") TruffleString cachedReplaceValue, @Cached(value="parseReplaceValueWithNCG(replaceValue)", dimensions=1) ReplaceStringParser.Token[] cachedParsedReplaceValueWithNamedCG, @Cached(value="parseReplaceValueWithoutNCG(replaceValue)", dimensions=1) ReplaceStringParser.Token[] cachedParsedReplaceValueWithoutNamedCG, @Cached.Shared @Cached JSToStringNode toString1Node, @Cached TruffleString.EqualNode equalsNode, @Cached @Cached.Shared ReplaceInternalNode replaceInternal, @Cached @Cached.Shared ReplaceAccordingToSpecNode replaceAccordingToSpec) {
            this.checkObject(rx);
            TruffleString searchString = toString1Node.executeString(searchValue);
            if (this.isPristine(rx)) {
                return replaceInternal.execute(rx, searchString, cachedReplaceValue, cachedParsedReplaceValueWithNamedCG, cachedParsedReplaceValueWithoutNamedCG, this.getContext(), this);
            }
            return replaceAccordingToSpec.execute(rx, searchString, cachedReplaceValue, false, this.getContext(), this);
        }

        @Specialization(replaces={"replaceStringCached"})
        protected Object replaceString(JSDynamicObject rx, Object searchValue, TruffleString replaceValue, @Cached.Shared @Cached JSToStringNode toString1Node, @Cached @Cached.Shared ReplaceInternalNode replaceInternal, @Cached @Cached.Shared ReplaceAccordingToSpecNode replaceAccordingToSpec) {
            this.checkObject(rx);
            TruffleString searchString = toString1Node.executeString(searchValue);
            if (this.isPristine(rx)) {
                return replaceInternal.execute(rx, searchString, replaceValue, null, null, this.getContext(), this);
            }
            return replaceAccordingToSpec.execute(rx, searchString, replaceValue, false, this.getContext(), this);
        }

        @Specialization(replaces={"replaceString"})
        protected Object replaceDynamic(JSDynamicObject rx, Object searchValue, Object replaceValue, @Cached.Shared @Cached JSToStringNode toString1Node, @Cached @Cached.Shared ReplaceInternalNode replaceInternal, @Cached @Cached.Shared ReplaceAccordingToSpecNode replaceAccordingToSpec, @Cached InlinedConditionProfile functionalReplaceProfile) {
            Object replaceVal;
            this.checkObject(rx);
            TruffleString searchString = toString1Node.executeString(searchValue);
            boolean functionalReplace = functionalReplaceProfile.profile(this, this.isCallableNode.executeBoolean(replaceValue));
            if (functionalReplace) {
                replaceVal = replaceValue;
            } else {
                TruffleString replaceString = this.toString2(replaceValue);
                replaceVal = replaceString;
                if (this.isPristine(rx)) {
                    return replaceInternal.execute(rx, searchString, replaceString, null, null, this.getContext(), this);
                }
            }
            return replaceAccordingToSpec.execute(rx, searchString, replaceVal, functionalReplace, this.getContext(), this);
        }

        @Fallback
        protected Object doNoObject(Object rx, Object searchString, Object replaceValue) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@replace", rx);
        }

        private void checkObject(JSDynamicObject rx) {
            if (!this.isObjectNode.executeBoolean(rx)) {
                throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@replace", (Object)rx);
            }
        }

        ReplaceStringParser.Token[] parseReplaceValueWithNCG(TruffleString replaceValue) {
            return this.parseReplaceValue(replaceValue, true);
        }

        ReplaceStringParser.Token[] parseReplaceValueWithoutNCG(TruffleString replaceValue) {
            return this.parseReplaceValue(replaceValue, false);
        }

        ReplaceStringParser.Token[] parseReplaceValue(TruffleString replaceValue, boolean parseNamedCG) {
            return ReplaceStringParser.parse(this.getContext(), replaceValue, 100, parseNamedCG);
        }

        private TruffleString toString2(Object obj) {
            if (this.toString2Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString2Node = this.insert(JSToStringNode.create());
            }
            return this.toString2Node.executeString(obj);
        }

        private TruffleString toString3(Object obj) {
            if (this.toString3Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString3Node = this.insert(JSToStringNode.create());
            }
            return this.toString3Node.executeString(obj);
        }

        final TruffleString toString4(Object obj) {
            if (this.toString4Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString4Node = this.insert(JSToStringNode.create());
            }
            return this.toString4Node.executeString(obj);
        }

        private boolean isPristine(JSDynamicObject rx) {
            if (this.isPristineObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isPristineObjectNode = this.insert(IsPristineObjectNode.createRegExpExecAndMatch(this.getContext()));
            }
            return this.isPristineObjectNode.execute(rx);
        }

        final Object readNamedCaptureGroup(Object namedCaptureGroups, Object groupNameStr) {
            if (this.readNamedCaptureGroupNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readNamedCaptureGroupNode = this.insert(ReadElementNode.create(this.getContext()));
            }
            return this.readNamedCaptureGroupNode.executeWithTargetAndIndex(namedCaptureGroups, groupNameStr);
        }

        private Object toObject(Object obj) {
            if (this.toObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toObjectNode = this.insert(JSToObjectNode.create());
            }
            return this.toObjectNode.execute(obj);
        }

        @Override
        public void append(TruffleStringBuilder sb, TruffleString s) {
            if (this.appendStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.appendStringNode = this.insert(TruffleStringBuilder.AppendStringNode.create());
            }
            this.stringBuilderProfile.append(this.appendStringNode, sb, s);
        }

        @Override
        public void append(TruffleStringBuilder sb, TruffleString s, int fromIndex, int toIndex) {
            if (this.appendSubStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.appendSubStringNode = this.insert(TruffleStringBuilder.AppendSubstringByteIndexNode.create());
            }
            this.stringBuilderProfile.append(this.appendSubStringNode, sb, s, fromIndex, toIndex);
        }

        private TruffleString builderToString(TruffleStringBuilder sb) {
            if (this.builderToStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.builderToStringNode = this.insert(TruffleStringBuilder.ToStringNode.create());
            }
            return StringBuilderProfile.toString(this.builderToStringNode, sb);
        }

        @Override
        public BranchProfile getInvalidGroupNumberProfile() {
            return this.invalidGroupNumberProfile;
        }

        @Override
        public TRegexUtil.InvokeGetGroupBoundariesMethodNode getGetStartNode() {
            return this.getStartNode;
        }

        @Override
        public TRegexUtil.InvokeGetGroupBoundariesMethodNode getGetEndNode() {
            return this.getEndNode;
        }

        @ImportStatic(value={JSRegExp.class})
        protected static abstract class ReplaceInternalNode
        extends JavaScriptBaseNode {
            protected ReplaceInternalNode() {
            }

            protected abstract TruffleString execute(JSDynamicObject var1, TruffleString var2, TruffleString var3, ReplaceStringParser.Token[] var4, ReplaceStringParser.Token[] var5, JSContext var6, JSRegExpReplaceNode var7);

            @Specialization(guards={"getCompiledRegex(rx) == tRegexCompiledRegex"}, limit="1")
            protected static TruffleString doCached(JSDynamicObject rx, TruffleString s, TruffleString replaceString, ReplaceStringParser.Token[] parsedWithNamedCG, ReplaceStringParser.Token[] parsedWithoutNamedCG, JSContext context, JSRegExpReplaceNode parent, @Bind(value="this") Node node, @Cached(value="getCompiledRegex(rx)") Object tRegexCompiledRegex, @Cached(value="create(context, false)") @Cached.Shared JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode execIgnoreLastIndexNode, @Cached @Cached.Shared AdvanceStringIndexUnicodeNode advanceStringIndexUnicode, @Cached @Cached.Shared JSToLengthNode toLength, @Cached @Cached.Shared InlinedConditionProfile unicodeProfile, @Cached @Cached.Shared InlinedConditionProfile globalProfile, @Cached @Cached.Shared InlinedConditionProfile stickyProfile, @Cached @Cached.Shared InlinedConditionProfile noMatchProfile, @Cached @Cached.Shared InlinedConditionProfile hasNamedCaptureGroupsProfile, @Cached @Cached.Shared InlinedBranchProfile dollarProfile, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readGlobal, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readSticky, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readUnicode, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached(inline=true) @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached(inline=true) @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadMemberNode readFlags, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadMemberNode readGroups, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadIntMemberNode readGroupCount) {
                Object tRegexFlags = TRegexUtil.TRegexCompiledRegexAccessor.flags(tRegexCompiledRegex, node, readFlags);
                boolean global = globalProfile.profile(node, TRegexUtil.TRegexFlagsAccessor.global(tRegexFlags, node, readGlobal));
                boolean unicode = unicodeProfile.profile(node, TRegexUtil.TRegexFlagsAccessor.unicode(tRegexFlags, node, readUnicode));
                boolean sticky = stickyProfile.profile(node, TRegexUtil.TRegexFlagsAccessor.sticky(tRegexFlags, node, readSticky));
                int length2 = Strings.length(s);
                TruffleStringBuilder sb = parent.stringBuilderProfile.newStringBuilder(length2 + 16);
                int lastMatchEnd = 0;
                int matchStart = -1;
                int lastIndex = sticky ? (int)toLength.executeLong(parent.getLastIndex(rx)) : 0;
                Object lastRegexResult = null;
                while (lastIndex <= length2) {
                    Object tRegexResult = execIgnoreLastIndexNode.execute(rx, s, lastIndex);
                    if (noMatchProfile.profile(node, !TRegexUtil.TRegexResultAccessor.isMatch(tRegexResult, node, readIsMatch))) {
                        if (matchStart >= 0) break;
                        if (global || sticky) {
                            parent.setLastIndex((Object)rx, 0);
                        }
                        return s;
                    }
                    if (!context.getRegExpStaticResultUnusedAssumption().isValid()) {
                        lastRegexResult = tRegexResult;
                    }
                    matchStart = TRegexUtil.TRegexResultAccessor.captureGroupStart(tRegexResult, 0, node, getStart);
                    int matchEnd = TRegexUtil.TRegexResultAccessor.captureGroupEnd(tRegexResult, 0, node, getEnd);
                    assert (matchStart >= 0 && matchStart <= length2 && matchStart >= lastMatchEnd);
                    parent.append(sb, s, lastMatchEnd, matchStart);
                    Object namedCG = TRegexUtil.TRegexCompiledRegexAccessor.namedCaptureGroups(tRegexCompiledRegex, node, readGroups);
                    boolean hasNamedCG = hasNamedCaptureGroupsProfile.profile(node, !parent.namedCaptureGroupInterop.isNull(namedCG));
                    int groupCount = TRegexUtil.TRegexCompiledRegexAccessor.groupCount(tRegexCompiledRegex, node, readGroupCount);
                    if (parsedWithNamedCG == null) {
                        ReplaceStringParser.process(context, replaceString, groupCount, hasNamedCG, new ReplaceStringConsumerTRegex(sb, s, replaceString, matchStart, matchEnd, tRegexResult, tRegexCompiledRegex, groupCount), parent, node, dollarProfile);
                    } else {
                        ReplaceStringParser.processParsed(hasNamedCG ? parsedWithNamedCG : parsedWithoutNamedCG, new ReplaceStringConsumerTRegex(sb, s, replaceString, matchStart, matchEnd, tRegexResult, tRegexCompiledRegex, groupCount), parent);
                    }
                    lastMatchEnd = matchEnd;
                    if (!global) break;
                    if (matchStart == matchEnd) {
                        lastIndex = unicode ? advanceStringIndexUnicode.execute(node, s, matchEnd) : matchEnd + 1;
                        continue;
                    }
                    lastIndex = matchEnd;
                }
                if (context.isOptionRegexpStaticResult() && matchStart >= 0) {
                    JSRealm.get(node).setStaticRegexResult(context, tRegexCompiledRegex, s, matchStart, lastRegexResult);
                }
                if (global || sticky) {
                    parent.setLastIndex((Object)rx, sticky ? lastMatchEnd : 0);
                }
                if (lastMatchEnd < length2) {
                    parent.append(sb, s, lastMatchEnd, length2);
                }
                return parent.builderToString(sb);
            }

            @Specialization(replaces={"doCached"})
            protected static TruffleString doUncached(JSDynamicObject rx, TruffleString s, TruffleString replaceString, ReplaceStringParser.Token[] parsedWithNamedCG, ReplaceStringParser.Token[] parsedWithoutNamedCG, JSContext context, JSRegExpReplaceNode parent, @Bind(value="this") Node node, @Cached(value="create(context, false)") @Cached.Shared JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode execIgnoreLastIndexNode, @Cached @Cached.Shared AdvanceStringIndexUnicodeNode advanceStringIndexUnicode, @Cached @Cached.Shared JSToLengthNode toLength, @Cached @Cached.Shared InlinedConditionProfile unicodeProfile, @Cached @Cached.Shared InlinedConditionProfile globalProfile, @Cached @Cached.Shared InlinedConditionProfile stickyProfile, @Cached @Cached.Shared InlinedConditionProfile noMatchProfile, @Cached @Cached.Shared InlinedConditionProfile hasNamedCaptureGroupsProfile, @Cached @Cached.Shared InlinedBranchProfile dollarProfile, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readGlobal, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readSticky, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readUnicode, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached(inline=true) @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached(inline=true) @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadMemberNode readFlags, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadMemberNode readGroups, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadIntMemberNode readGroupCount) {
                return ReplaceInternalNode.doCached(rx, s, replaceString, parsedWithNamedCG, parsedWithoutNamedCG, context, parent, node, JSRegExp.getCompiledRegex(rx), execIgnoreLastIndexNode, advanceStringIndexUnicode, toLength, unicodeProfile, globalProfile, stickyProfile, noMatchProfile, hasNamedCaptureGroupsProfile, dollarProfile, readGlobal, readSticky, readUnicode, readIsMatch, getStart, getEnd, readFlags, readGroups, readGroupCount);
            }
        }

        @ImportStatic(value={JSRegExp.class, JSConfig.class, JSAbstractArray.class})
        protected static abstract class ReplaceAccordingToSpecNode
        extends JavaScriptBaseNode {
            protected ReplaceAccordingToSpecNode() {
            }

            protected abstract TruffleString execute(JSDynamicObject var1, TruffleString var2, Object var3, boolean var4, JSContext var5, JSRegExpReplaceNode var6);

            @Specialization
            protected static TruffleString replaceAccordingToSpec(JSDynamicObject rx, TruffleString s, Object replaceValue, boolean functionalReplace, JSContext context, JSRegExpReplaceNode parent, @Bind(value="this") Node node, @Cached AdvanceStringIndexUnicodeNode advanceStringIndexUnicode, @Cached JSToLengthNode toLength, @Cached JSToIntegerAsIntNode toIntegerNode, @Cached JSToStringNode toStringForFlagsNode, @Cached TruffleString.ByteIndexOfCodePointNode indexOfNode, @Cached(value="create(LENGTH, context)") PropertyGetNode getLength, @Cached(value="create(INDEX, context)") PropertyGetNode getIndexNode, @Cached(value="create(GROUPS, context)") PropertyGetNode getGroupsNode, @Cached(value="create(FLAGS, context)") PropertyGetNode getFlagsNode, @CachedLibrary(limit="InteropLibraryLimit") DynamicObjectLibrary getLazyRegexResult, @Cached(value="create(LAZY_REGEX_RESULT_ID)") HasHiddenKeyCacheNode hasLazyRegexResult, @Cached(value="createCall()") JSFunctionCallNode callFunction, @Cached InlinedBranchProfile growProfile, @Cached InlinedConditionProfile unicodeProfile, @Cached InlinedConditionProfile globalProfile, @Cached InlinedConditionProfile noMatchProfile, @Cached InlinedConditionProfile lazyResultArrayProfile, @Cached InlinedConditionProfile validPositionProfile, @Cached InlinedBranchProfile dollarProfile) {
                TruffleString replaceString = null;
                JSDynamicObject replaceFunction = null;
                if (functionalReplace) {
                    replaceFunction = (JSDynamicObject)replaceValue;
                } else {
                    replaceString = (TruffleString)replaceValue;
                }
                TruffleString flags = toStringForFlagsNode.executeString(getFlagsNode.getValue(rx));
                boolean global = globalProfile.profile(node, Strings.indexOf(indexOfNode, flags, 103) != -1);
                boolean fullUnicode = false;
                if (global) {
                    fullUnicode = unicodeProfile.profile(node, Strings.indexOf(indexOfNode, flags, 117) != -1);
                    parent.setLastIndex((Object)rx, 0);
                }
                SimpleArrayList<JSDynamicObject> results = null;
                if (functionalReplace) {
                    results = new SimpleArrayList<JSDynamicObject>();
                }
                int length2 = Strings.length(s);
                TruffleStringBuilder sb = parent.stringBuilderProfile.newStringBuilder(length2 + 16);
                int nextSourcePosition = 0;
                int matchLength = -1;
                while (true) {
                    JSDynamicObject result2;
                    if (noMatchProfile.profile(node, (result2 = (JSDynamicObject)parent.regexExecIntl(rx, s)) == Null.instance)) {
                        if (matchLength >= 0) break;
                        return s;
                    }
                    matchLength = lazyResultArrayProfile.profile(node, ReplaceAccordingToSpecNode.isLazyResultArray(result2, hasLazyRegexResult)) ? ReplaceAccordingToSpecNode.getLazyLength(result2, getLazyRegexResult, parent) : ReplaceAccordingToSpecNode.processNonLazy(result2, toLength, getLength, parent);
                    if (functionalReplace) {
                        results.add(result2, node, growProfile);
                    } else {
                        int position = Math.max(Math.min(toIntegerNode.executeInt(getIndexNode.getValue(result2)), Strings.length(s)), 0);
                        if (validPositionProfile.profile(node, position >= nextSourcePosition)) {
                            parent.append(sb, s, nextSourcePosition, position);
                            Object namedCaptures = getGroupsNode.getValue(result2);
                            if (namedCaptures != Undefined.instance) {
                                namedCaptures = parent.toObject(namedCaptures);
                            }
                            ReplaceStringParser.process(context, replaceString, (int)toLength.executeLong(getLength.getValue(result2)), namedCaptures != Undefined.instance, new ReplaceStringConsumer(sb, s, replaceString, position, Math.min(position + matchLength, Strings.length(s)), result2, (JSDynamicObject)namedCaptures), parent, node, dollarProfile);
                            nextSourcePosition = position + matchLength;
                        }
                    }
                    if (!global) break;
                    if (matchLength != 0) continue;
                    long lastI = toLength.executeLong(parent.getLastIndex(rx));
                    long nextIndex = lastI + 1L;
                    if (JSRuntime.longIsRepresentableAsInt(nextIndex)) {
                        parent.setLastIndex((Object)rx, fullUnicode ? advanceStringIndexUnicode.execute(node, s, (int)lastI) : (int)nextIndex);
                        continue;
                    }
                    parent.setLastIndex((Object)rx, nextIndex);
                }
                if (functionalReplace) {
                    for (int i = 0; i < results.size(); ++i) {
                        JSDynamicObject result3 = (JSDynamicObject)results.get(i);
                        int position = Math.max(Math.min(toIntegerNode.executeInt(getIndexNode.getValue(result3)), Strings.length(s)), 0);
                        int resultsLength = (int)toLength.executeLong(getLength.getValue(result3));
                        Object namedCaptures = getGroupsNode.getValue(result3);
                        boolean hasNamedCG = namedCaptures != Undefined.instance;
                        Object[] arguments = JSArguments.createInitial(Undefined.instance, replaceFunction, resultsLength + 2 + (hasNamedCG ? 1 : 0));
                        for (int i1 = 0; i1 < resultsLength; ++i1) {
                            JSArguments.setUserArgument(arguments, i1, parent.read(result3, i1));
                        }
                        JSArguments.setUserArgument(arguments, resultsLength, position);
                        JSArguments.setUserArgument(arguments, resultsLength + 1, s);
                        if (hasNamedCG) {
                            JSArguments.setUserArgument(arguments, resultsLength + 2, namedCaptures);
                        }
                        Object callResult = callFunction.executeCall(arguments);
                        TruffleString replacement = parent.toString2(callResult);
                        if (!validPositionProfile.profile(node, position >= nextSourcePosition)) continue;
                        parent.append(sb, s, nextSourcePosition, position);
                        parent.append(sb, replacement);
                        nextSourcePosition = lazyResultArrayProfile.profile(node, ReplaceAccordingToSpecNode.isLazyResultArray(result3, hasLazyRegexResult)) ? position + ReplaceAccordingToSpecNode.getLazyLength(result3, getLazyRegexResult, parent) : position + Strings.length((TruffleString)parent.read(result3, 0));
                    }
                }
                if (nextSourcePosition < length2) {
                    parent.append(sb, s, nextSourcePosition, length2);
                }
                return parent.builderToString(sb);
            }

            private static boolean isLazyResultArray(JSDynamicObject result2, HasHiddenKeyCacheNode hasLazyRegexResultNode) {
                boolean isLazyResultArray = hasLazyRegexResultNode.executeHasHiddenKey(result2);
                assert (isLazyResultArray == JSDynamicObject.hasProperty(result2, JSArray.LAZY_REGEX_RESULT_ID));
                return isLazyResultArray;
            }

            private static int getLazyLength(JSDynamicObject obj, DynamicObjectLibrary lazyRegexResultNode, JSRegExpReplaceNode parent) {
                Object regexResult = JSAbstractArray.arrayGetRegexResult(obj, lazyRegexResultNode);
                return TRegexUtil.TRegexResultAccessor.captureGroupLength(regexResult, 0, null, parent.getStartNode, parent.getEndNode);
            }

            private static int processNonLazy(JSDynamicObject result2, JSToLengthNode toLength, PropertyGetNode getLength, JSRegExpReplaceNode parent) {
                int resultLength = (int)toLength.executeLong(getLength.getValue(result2));
                TruffleString result0Str = parent.toString3(parent.read(result2, 0));
                parent.write(result2, 0, result0Str);
                for (int n = 1; n < resultLength; ++n) {
                    Object value2 = parent.read(result2, n);
                    if (value2 == Undefined.instance) continue;
                    parent.write(result2, n, parent.toString3(value2));
                }
                return Strings.length(result0Str);
            }
        }
    }

    public static abstract class JSRegExpSearchNode
    extends RegExpPrototypeSymbolOperation {
        @Node.Child
        private PropertyGetNode getIndexNode;
        @Node.Child
        private JSIdenticalNode sameValueNode;

        protected JSRegExpSearchNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getIndexNode = PropertyGetNode.create(JSRegExp.INDEX, false, context);
            this.sameValueNode = JSIdenticalNode.createSameValue();
        }

        @Specialization(guards={"isObjectNode.executeBoolean(rx)"}, limit="1")
        protected Object search(JSDynamicObject rx, Object param, @Cached IsJSObjectNode isObjectNode, @Cached JSToStringNode toString1Node) {
            TruffleString s = toString1Node.executeString(param);
            Object previousLastIndex = this.getLastIndex(rx);
            if (!this.sameValueNode.executeBoolean(previousLastIndex, 0)) {
                this.setLastIndex((Object)rx, 0);
            }
            Object result2 = this.regexExecIntl(rx, s);
            Object currentLastIndex = this.getLastIndex(rx);
            if (!this.sameValueNode.executeBoolean(currentLastIndex, previousLastIndex)) {
                this.setLastIndex((Object)rx, previousLastIndex);
            }
            return result2 == Null.instance ? Integer.valueOf(-1) : this.getIndexNode.getValue(result2);
        }

        @Fallback
        protected Object search(Object thisObj, Object string) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@search", thisObj);
        }
    }

    @ImportStatic(value={JSGuards.class})
    public static abstract class JSRegExpSplitNode
    extends RegExpPrototypeSymbolOperation {
        @Node.Child
        private IsJSObjectNode isObjectNode;
        @Node.Child
        private JSToStringNode toString1Node;
        @Node.Child
        private IsPristineObjectNode isPristineObjectNode;

        JSRegExpSplitNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        JSDynamicObject splitIntLimit(JSDynamicObject rx, Object input, int limit, @Cached @Cached.Shared JSToUInt32Node toUInt32, @Cached @Cached.Shared InlinedBranchProfile limitZeroBranch, @Cached @Cached.Shared SplitInternalNode splitInternal, @Cached @Cached.Shared SplitAccordingToSpecNode splitAccordingToSpec) {
            return this.doSplit(rx, input, toUInt32.executeLong(limit), this, limitZeroBranch, splitInternal, splitAccordingToSpec);
        }

        @Specialization
        JSDynamicObject splitLongLimit(JSDynamicObject rx, Object input, long limit, @Cached @Cached.Shared JSToUInt32Node toUInt32, @Cached @Cached.Shared InlinedBranchProfile limitZeroBranch, @Cached @Cached.Shared SplitInternalNode splitInternal, @Cached @Cached.Shared SplitAccordingToSpecNode splitAccordingToSpec) {
            return this.doSplit(rx, input, toUInt32.executeLong(limit), this, limitZeroBranch, splitInternal, splitAccordingToSpec);
        }

        @Specialization(guards={"isUndefined(limit)"})
        JSDynamicObject splitUndefinedLimit(JSDynamicObject rx, Object input, Object limit, @Cached @Cached.Shared InlinedBranchProfile limitZeroBranch, @Cached @Cached.Shared SplitInternalNode splitInternal, @Cached @Cached.Shared SplitAccordingToSpecNode splitAccordingToSpec) {
            return this.doSplit(rx, input, JSRuntime.MAX_SAFE_INTEGER_LONG, this, limitZeroBranch, splitInternal, splitAccordingToSpec);
        }

        @Specialization(guards={"!isUndefined(limit)"})
        JSDynamicObject splitObjectLimit(JSDynamicObject rx, Object input, Object limit, @Cached @Cached.Shared SplitAccordingToSpecNode splitAccordingToSpec) {
            this.checkObject(rx);
            TruffleString str = this.toString1(input);
            JSDynamicObject constructor = this.getSpeciesConstructor(rx);
            return splitAccordingToSpec.execute(rx, str, limit, constructor, this.getContext(), this);
        }

        @Fallback
        static Object doNoObject(Object rx, Object input, Object flags) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@split", rx);
        }

        private JSDynamicObject doSplit(JSDynamicObject rx, Object input, long limit, Node node, InlinedBranchProfile limitZeroBranch, SplitInternalNode splitInternal, SplitAccordingToSpecNode splitAccordingToSpec) {
            this.checkObject(rx);
            TruffleString str = this.toString1(input);
            if (limit == 0L) {
                limitZeroBranch.enter(node);
                return JSArray.createEmptyZeroLength(this.getContext(), this.getRealm());
            }
            JSDynamicObject constructor = this.getSpeciesConstructor(rx);
            if (constructor == this.getRealm().getRegExpConstructor() && this.isPristine(rx)) {
                return splitInternal.execute(rx, str, limit, this.getContext(), this);
            }
            return splitAccordingToSpec.execute(rx, str, limit, constructor, this.getContext(), this);
        }

        private void checkObject(JSDynamicObject rx) {
            if (!this.isJSObject(rx)) {
                throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@split", (Object)rx);
            }
        }

        private JSDynamicObject getSpeciesConstructor(JSDynamicObject rx) {
            JSFunctionObject regexpConstructor = this.getRealm().getRegExpConstructor();
            return this.getArraySpeciesConstructorNode().speciesConstructor(rx, regexpConstructor);
        }

        static Object callRegExpConstructor(JSDynamicObject constructor, JSDynamicObject rx, TruffleString newFlags, JSFunctionCallNode constructorCall) {
            return constructorCall.executeCall(JSArguments.create(JSFunction.CONSTRUCT, constructor, rx, newFlags));
        }

        private boolean isJSObject(JSDynamicObject rx) {
            if (this.isObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isObjectNode = this.insert(IsJSObjectNode.create());
            }
            return this.isObjectNode.executeBoolean(rx);
        }

        private TruffleString toString1(Object obj) {
            if (this.toString1Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString1Node = this.insert(JSToStringNode.create());
            }
            return this.toString1Node.executeString(obj);
        }

        private boolean isPristine(JSDynamicObject rx) {
            if (this.isPristineObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isPristineObjectNode = this.insert(IsPristineObjectNode.createRegExpExecAndMatch(this.getContext()));
            }
            return this.isPristineObjectNode.execute(rx);
        }

        static int movePosition(TruffleString s, boolean unicodeMatching, int lastIndex, Node node, InlinedConditionProfile isUnicode, AdvanceStringIndexUnicodeNode advanceIndex) {
            return isUnicode.profile(node, unicodeMatching) ? advanceIndex.execute(node, s, lastIndex) : lastIndex + 1;
        }

        @ImportStatic(value={JSRegExp.class})
        protected static abstract class SplitInternalNode
        extends JavaScriptBaseNode {
            protected SplitInternalNode() {
            }

            protected abstract JSDynamicObject execute(JSDynamicObject var1, TruffleString var2, long var3, JSContext var5, JSRegExpSplitNode var6);

            @Specialization(guards={"getCompiledRegex(rx) == tRegexCompiledRegex"}, limit="1")
            protected static JSDynamicObject doCached(JSDynamicObject rx, TruffleString str, long lim, JSContext context, JSRegExpSplitNode parent, @Bind(value="this") Node node, @Cached(value="getCompiledRegex(rx)") Object tRegexCompiledRegex, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadMemberNode readFlags, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readSticky, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readUnicode, @Cached @Cached.Shared RemoveStickyFlagNode removeStickyFlag, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadIntMemberNode readGroupCount, @Cached(inline=true) @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached(inline=true) @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached(value="createNew()") @Cached.Shared JSFunctionCallNode constructorCall, @Cached(value="create(context, false)") @Cached.Shared JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode execIgnoreLastIndex, @Cached @Cached.Shared TruffleString.SubstringByteIndexNode substringNode, @Cached @Cached.Shared AdvanceStringIndexUnicodeNode advanceStringIndexUnicode, @Cached @Cached.Shared InlinedConditionProfile sizeIsZero, @Cached @Cached.Shared InlinedConditionProfile resultIsNull, @Cached @Cached.Shared InlinedConditionProfile isUnicode, @Cached @Cached.Shared InlinedConditionProfile stickyFlagSet, @Cached @Cached.Shared InlinedBranchProfile prematureReturnBranch) {
                JSDynamicObject splitter;
                Object tRegexFlags = TRegexUtil.TRegexCompiledRegexAccessor.flags(tRegexCompiledRegex, node, readFlags);
                boolean unicodeMatching = TRegexUtil.TRegexFlagsAccessor.unicode(tRegexFlags, node, readUnicode);
                JSRealm realm = JSRealm.get(node);
                if (stickyFlagSet.profile(node, TRegexUtil.TRegexFlagsAccessor.sticky(tRegexFlags, node, readSticky))) {
                    JSFunctionObject regexpConstructor = realm.getRegExpConstructor();
                    TruffleString newFlags = removeStickyFlag.execute(node, tRegexFlags);
                    splitter = (JSDynamicObject)JSRegExpSplitNode.callRegExpConstructor(regexpConstructor, rx, newFlags, constructorCall);
                } else {
                    splitter = rx;
                }
                JSArrayObject array = JSArray.createEmptyZeroLength(context, realm);
                int size = Strings.length(str);
                int arrayLength = 0;
                int prevMatchEnd = 0;
                int fromIndex = 0;
                int matchStart = -1;
                int matchEnd = -1;
                Object lastRegexResult = null;
                do {
                    Object tRegexResult;
                    if (resultIsNull.profile(node, !TRegexUtil.TRegexResultAccessor.isMatch(tRegexResult = execIgnoreLastIndex.execute(splitter, str, fromIndex), node, readIsMatch))) {
                        if (!sizeIsZero.profile(node, size == 0) && matchStart >= 0) break;
                        parent.write(array, 0, str);
                        return array;
                    }
                    if (!context.getRegExpStaticResultUnusedAssumption().isValid()) {
                        lastRegexResult = tRegexResult;
                    }
                    matchStart = TRegexUtil.TRegexResultAccessor.captureGroupStart(tRegexResult, 0, node, getStart);
                    matchEnd = TRegexUtil.TRegexResultAccessor.captureGroupEnd(tRegexResult, 0, node, getEnd);
                    if (matchEnd == prevMatchEnd) {
                        fromIndex = JSRegExpSplitNode.movePosition(str, unicodeMatching, fromIndex, node, isUnicode, advanceStringIndexUnicode);
                        continue;
                    }
                    parent.write(array, arrayLength++, Strings.substring(context, substringNode, str, prevMatchEnd, matchStart - prevMatchEnd));
                    if ((long)arrayLength == lim) {
                        prematureReturnBranch.enter(node);
                        return array;
                    }
                    prevMatchEnd = matchEnd;
                    long numberOfCaptures = TRegexUtil.TRegexCompiledRegexAccessor.groupCount(tRegexCompiledRegex, node, readGroupCount);
                    int i = 1;
                    while ((long)i < numberOfCaptures) {
                        parent.write(array, arrayLength, TRegexUtil.TRegexMaterializeResult.materializeGroup(context, tRegexResult, i, str, node, substringNode, getStart, getEnd));
                        if ((long)(++arrayLength) == lim) {
                            prematureReturnBranch.enter(node);
                            return array;
                        }
                        ++i;
                    }
                    fromIndex = matchStart == matchEnd ? JSRegExpSplitNode.movePosition(str, unicodeMatching, fromIndex, node, isUnicode, advanceStringIndexUnicode) : matchEnd;
                } while (fromIndex < size);
                if (context.isOptionRegexpStaticResult() && matchStart >= 0 && matchStart < size) {
                    realm.setStaticRegexResult(context, tRegexCompiledRegex, str, matchStart, lastRegexResult);
                }
                if (matchStart != matchEnd || prevMatchEnd < size) {
                    parent.write(array, arrayLength, Strings.substring(context, substringNode, str, prevMatchEnd, size - prevMatchEnd));
                }
                return array;
            }

            @Specialization(replaces={"doCached"})
            protected static JSDynamicObject doUncached(JSDynamicObject rx, TruffleString str, long lim, JSContext context, JSRegExpSplitNode parent, @Bind(value="this") Node node, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadMemberNode readFlags, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readSticky, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readUnicode, @Cached @Cached.Shared RemoveStickyFlagNode removeStickyFlag, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached(inline=true) @Cached.Shared TRegexUtil.InteropReadIntMemberNode readGroupCount, @Cached(inline=true) @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached(inline=true) @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached(value="createNew()") @Cached.Shared JSFunctionCallNode constructorCall, @Cached(value="create(context, false)") @Cached.Shared JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode execIgnoreLastIndex, @Cached @Cached.Shared TruffleString.SubstringByteIndexNode substringNode, @Cached @Cached.Shared AdvanceStringIndexUnicodeNode advanceStringIndexUnicode, @Cached @Cached.Shared InlinedConditionProfile sizeIsZero, @Cached @Cached.Shared InlinedConditionProfile resultIsNull, @Cached @Cached.Shared InlinedConditionProfile isUnicode, @Cached @Cached.Shared InlinedConditionProfile stickyFlagSet, @Cached @Cached.Shared InlinedBranchProfile prematureReturnBranch) {
                return SplitInternalNode.doCached(rx, str, lim, context, parent, node, JSRegExp.getCompiledRegex(rx), readFlags, readSticky, readUnicode, removeStickyFlag, readIsMatch, readGroupCount, getStart, getEnd, constructorCall, execIgnoreLastIndex, substringNode, advanceStringIndexUnicode, sizeIsZero, resultIsNull, isUnicode, stickyFlagSet, prematureReturnBranch);
            }
        }

        @ImportStatic(value={JSRegExp.class, Strings.class})
        protected static abstract class SplitAccordingToSpecNode
        extends JavaScriptBaseNode {
            protected SplitAccordingToSpecNode() {
            }

            protected abstract JSDynamicObject execute(JSDynamicObject var1, TruffleString var2, Object var3, JSDynamicObject var4, JSContext var5, JSRegExpSplitNode var6);

            @Specialization
            protected static JSDynamicObject split(JSDynamicObject rx, TruffleString str, Object limit, JSDynamicObject constructor, JSContext context, JSRegExpSplitNode parent, @Bind(value="this") Node node, @Cached(value="create(FLAGS, context)") PropertyGetNode getFlags, @Cached(value="create(LENGTH, context)") PropertyGetNode getLength, @Cached JSToStringNode toString2, @Cached JSToUInt32Node toUInt32, @Cached TruffleString.ByteIndexOfCodePointNode indexOfNode, @Cached EnsureStickyNode ensureSticky, @Cached(value="createNew()") JSFunctionCallNode constructorCall, @Cached JSToLengthNode toLength, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached AdvanceStringIndexUnicodeNode advanceStringIndexUnicode, @Cached InlinedConditionProfile limitUndefined, @Cached InlinedConditionProfile sizeIsZero, @Cached InlinedConditionProfile resultIsNull, @Cached InlinedConditionProfile sameMatchEnd, @Cached InlinedConditionProfile isUnicode, @Cached InlinedBranchProfile prematureReturnBranch) {
                long lim;
                TruffleString flags = toString2.executeString(getFlags.getValue(rx));
                boolean unicodeMatching = Strings.indexOf(indexOfNode, flags, 117) >= 0;
                TruffleString newFlags = ensureSticky.execute(node, flags);
                JSDynamicObject splitter = (JSDynamicObject)JSRegExpSplitNode.callRegExpConstructor(constructor, rx, newFlags, constructorCall);
                JSArrayObject array = JSArray.createEmptyZeroLength(context, JSRealm.get(node));
                if (limitUndefined.profile(node, limit == Undefined.instance)) {
                    lim = JSRuntime.MAX_SAFE_INTEGER_LONG;
                } else {
                    lim = toUInt32.executeLong(limit);
                    if (lim == 0L) {
                        prematureReturnBranch.enter(node);
                        return array;
                    }
                }
                int size = Strings.length(str);
                if (sizeIsZero.profile(node, size == 0)) {
                    if (parent.regexExecIntl(splitter, str) == Null.instance) {
                        parent.write(array, 0, str);
                    }
                    return array;
                }
                int arrayLength = 0;
                int prevMatchEnd = 0;
                int fromIndex = 0;
                while (fromIndex < size) {
                    parent.setLastIndex((Object)splitter, fromIndex);
                    JSDynamicObject regexResult = (JSDynamicObject)parent.regexExecIntl(splitter, str);
                    if (resultIsNull.profile(node, regexResult == Null.instance)) {
                        fromIndex = JSRegExpSplitNode.movePosition(str, unicodeMatching, fromIndex, node, isUnicode, advanceStringIndexUnicode);
                        continue;
                    }
                    int matchEnd = (int)toLength.executeLong(parent.getLastIndex(splitter));
                    if (sameMatchEnd.profile(node, matchEnd == prevMatchEnd)) {
                        fromIndex = JSRegExpSplitNode.movePosition(str, unicodeMatching, fromIndex, node, isUnicode, advanceStringIndexUnicode);
                        continue;
                    }
                    parent.write(array, arrayLength, Strings.substring(context, substringNode, str, prevMatchEnd, fromIndex - prevMatchEnd));
                    if ((long)(++arrayLength) == lim) {
                        prematureReturnBranch.enter(node);
                        return array;
                    }
                    prevMatchEnd = matchEnd;
                    fromIndex = matchEnd;
                    long numberOfCaptures = toLength.executeLong(getLength.getValue(regexResult));
                    int i = 1;
                    while ((long)i < numberOfCaptures) {
                        parent.write(array, arrayLength, parent.read(regexResult, i));
                        if ((long)(++arrayLength) == lim) {
                            prematureReturnBranch.enter(node);
                            return array;
                        }
                        ++i;
                    }
                }
                int begin2 = Math.min(prevMatchEnd, Strings.length(str));
                parent.write(array, arrayLength, Strings.substring(context, substringNode, str, begin2, size - begin2));
                return array;
            }
        }

        @GenerateInline
        @GenerateCached(value=false)
        protected static abstract class EnsureStickyNode
        extends JavaScriptBaseNode {
            protected EnsureStickyNode() {
            }

            protected abstract TruffleString execute(Node var1, Object var2);

            @Specialization
            static TruffleString ensureSticky(Node node, TruffleString flags, @Cached InlinedConditionProfile emptyFlags, @Cached InlinedConditionProfile stickyFlagSet, @Cached(inline=false) TruffleString.ByteIndexOfCodePointNode indexOfNode, @Cached(inline=false) TruffleString.ConcatNode concatNode) {
                if (emptyFlags.profile(node, Strings.length(flags) == 0)) {
                    return Strings.Y;
                }
                if (stickyFlagSet.profile(node, Strings.indexOf(indexOfNode, flags, 121) >= 0)) {
                    return flags;
                }
                return Strings.concat(concatNode, flags, Strings.Y);
            }
        }

        @GenerateInline
        @GenerateCached(value=false)
        protected static abstract class RemoveStickyFlagNode
        extends JavaScriptBaseNode {
            protected RemoveStickyFlagNode() {
            }

            protected abstract TruffleString execute(Node var1, Object var2);

            @Specialization
            static TruffleString removeStickyFlag(Node node, Object tRegexFlags, @Cached TRegexUtil.InteropReadBooleanMemberNode readGlobalNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readMultilineNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readIgnoreCaseNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readUnicodeNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readDotAllNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readHasIndicesNode) {
                char[] flags = new char[6];
                int len = 0;
                if (TRegexUtil.TRegexFlagsAccessor.hasIndices(tRegexFlags, node, readHasIndicesNode)) {
                    flags[len++] = 100;
                }
                if (TRegexUtil.TRegexFlagsAccessor.global(tRegexFlags, node, readGlobalNode)) {
                    flags[len++] = 103;
                }
                if (TRegexUtil.TRegexFlagsAccessor.ignoreCase(tRegexFlags, node, readIgnoreCaseNode)) {
                    flags[len++] = 105;
                }
                if (TRegexUtil.TRegexFlagsAccessor.multiline(tRegexFlags, node, readMultilineNode)) {
                    flags[len++] = 109;
                }
                if (TRegexUtil.TRegexFlagsAccessor.dotAll(tRegexFlags, node, readDotAllNode)) {
                    flags[len++] = 115;
                }
                if (TRegexUtil.TRegexFlagsAccessor.unicode(tRegexFlags, node, readUnicodeNode)) {
                    flags[len++] = 117;
                }
                if (len == 0) {
                    return Strings.EMPTY_STRING;
                }
                return Strings.fromCharArray(flags, 0, len);
            }
        }
    }

    @ImportStatic(value={JSRegExp.class})
    public static abstract class JSRegExpCompileNode
    extends JSBuiltinNode {
        protected JSRegExpCompileNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSRegExpObject compile(JSRegExpObject thisRegExp, Object patternObj, Object flagsObj, @Bind(value="this") Node node, @Cached(value="create(LAST_INDEX, false, getContext(), true)") PropertySetNode setLastIndexNode, @Cached(value="create(getContext())") CompileRegexNode compileRegexNode, @Cached(value="createUndefinedToEmpty()") JSToStringNode toStringNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isRegExpProfile, @Cached(inline=true) TRegexUtil.InteropReadStringMemberNode readPattern, @Cached(inline=true) TRegexUtil.InteropReadMemberNode readFlags, @Cached(inline=true) TRegexUtil.InteropReadStringMemberNode readSource) {
            Object flags;
            Object pattern;
            Object regex;
            if (this.getRealm() != JSRegExp.getRealm(thisRegExp)) {
                errorBranch.enter(node);
                throw Errors.createTypeError("RegExp.prototype.compile cannot be used on a RegExp from a different Realm.");
            }
            if (!JSRegExp.getLegacyFeaturesEnabled(thisRegExp)) {
                errorBranch.enter(node);
                throw Errors.createTypeError("RegExp.prototype.compile cannot be used on subclasses of RegExp.");
            }
            boolean isRegExp = isRegExpProfile.profile(node, JSRegExp.isJSRegExp(patternObj));
            if (isRegExp) {
                if (flagsObj != Undefined.instance) {
                    errorBranch.enter(node);
                    throw Errors.createTypeError("flags must be undefined", node);
                }
                regex = JSRegExp.getCompiledRegex((JSDynamicObject)patternObj);
                pattern = TRegexUtil.TRegexCompiledRegexAccessor.pattern(regex, node, readPattern);
                flags = TRegexUtil.TRegexFlagsAccessor.source(TRegexUtil.TRegexCompiledRegexAccessor.flags(regex, node, readFlags), node, readSource);
            } else {
                pattern = toStringNode.executeString(patternObj);
                flags = toStringNode.executeString(flagsObj);
            }
            regex = compileRegexNode.compile(pattern, flags);
            JSRegExp.updateCompilation(this.getContext(), thisRegExp, regex);
            setLastIndexNode.setValueInt(thisRegExp, 0);
            return thisRegExp;
        }

        @Fallback
        protected Object compile(Object thisObj, Object pattern, Object flags) {
            throw RegExpPrototypeBuiltins.createNoRegExpError(thisObj);
        }
    }

    @ImportStatic(value={JSRegExp.class})
    public static abstract class JSRegExpMatchAllNode
    extends JSBuiltinNode {
        public JSRegExpMatchAllNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(regex)"}, limit="1")
        protected final Object matchAll(JSDynamicObject regex, Object stringObj, @Bind(value="this") Node node, @Cached JSToStringNode toStringNodeForInput, @Cached(value="create(getContext(), false)") ArrayPrototypeBuiltins.ArraySpeciesConstructorNode speciesConstructNode, @Cached(value="create(FLAGS, getContext())") PropertyGetNode getFlagsNode, @Cached JSToStringNode toStringNodeForFlags, @Cached(value="create(LAST_INDEX, getContext())") PropertyGetNode getLastIndexNode, @Cached JSToLengthNode toLengthNode, @Cached(value="create(LAST_INDEX, false, getContext(), true)") PropertySetNode setLastIndexNode, @Cached(value="createCreateRegExpStringIteratorNode()") StringPrototypeBuiltins.CreateRegExpStringIteratorNode createRegExpStringIteratorNode, @Cached IsJSObjectNode isObjectNode, @Cached(inline=true) LongToIntOrDoubleNode indexToNumber, @Cached TruffleString.ByteIndexOfCodePointNode stringIndexOfNode) {
            TruffleString string = toStringNodeForInput.executeString(stringObj);
            JSFunctionObject regExpConstructor = this.getRealm().getRegExpConstructor();
            JSDynamicObject constructor = speciesConstructNode.speciesConstructor(regex, regExpConstructor);
            TruffleString flags = toStringNodeForFlags.executeString(getFlagsNode.getValue(regex));
            Object matcher = speciesConstructNode.construct(constructor, regex, flags);
            long lastIndex = toLengthNode.executeLong(getLastIndexNode.getValue(regex));
            setLastIndexNode.setValue(matcher, indexToNumber.fromIndex(node, lastIndex));
            boolean global = Strings.indexOf(stringIndexOfNode, flags, 103) != -1;
            boolean fullUnicode = Strings.indexOf(stringIndexOfNode, flags, 117) != -1;
            return createRegExpStringIteratorNode.createIterator(matcher, string, global, fullUnicode);
        }

        @NeverDefault
        StringPrototypeBuiltins.CreateRegExpStringIteratorNode createCreateRegExpStringIteratorNode() {
            return new StringPrototypeBuiltins.CreateRegExpStringIteratorNode(this.getContext());
        }

        @Fallback
        protected Object matchAll(Object thisObj, Object string) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@matchAll", thisObj);
        }
    }

    static abstract class CompiledRegexPatternAccessor
    extends JSBuiltinNode {
        CompiledRegexPatternAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        Object doRegExp(JSRegExpObject obj, @Cached(inline=true) TRegexUtil.InteropReadStringMemberNode readPatternNode) {
            return JSRegExp.escapeRegExpPattern(readPatternNode.execute(this, JSRegExp.getCompiledRegex(obj), "pattern"));
        }

        @Specialization(guards={"isRegExpPrototype(obj)"})
        Object doPrototype(JSDynamicObject obj) {
            return Strings.EMPTY_REGEX;
        }

        @Fallback
        public Object doObject(Object obj) {
            throw Errors.createTypeErrorIncompatibleReceiver(obj);
        }

        boolean isRegExpPrototype(JSDynamicObject obj) {
            return obj == this.getRealm().getRegExpPrototype();
        }

        static CompiledRegexPatternAccessor create(JSContext context, JSBuiltin builtin, JavaScriptNode[] args) {
            return RegExpPrototypeBuiltinsFactory.CompiledRegexPatternAccessorNodeGen.create(context, builtin, args);
        }
    }

    static abstract class CompiledRegexFlagPropertyAccessor
    extends JSBuiltinNode {
        private final String flagName;

        CompiledRegexFlagPropertyAccessor(JSContext context, JSBuiltin builtin, String flagName) {
            super(context, builtin);
            this.flagName = flagName;
        }

        @Specialization
        Object doRegExp(JSRegExpObject obj, @Cached TRegexUtil.TRegexCompiledRegexSingleFlagAccessorNode readFlag) {
            return readFlag.execute(this, JSRegExp.getCompiledRegex(obj), this.flagName);
        }

        @Specialization(guards={"isRegExpPrototype(obj)"})
        Object doPrototype(JSDynamicObject obj) {
            return Undefined.instance;
        }

        @Fallback
        public Object doObject(Object obj) {
            throw Errors.createTypeErrorIncompatibleReceiver(obj);
        }

        boolean isRegExpPrototype(JSDynamicObject obj) {
            return obj == this.getRealm().getRegExpPrototype();
        }

        public static CompiledRegexFlagPropertyAccessor create(JSContext context, JSBuiltin builtin, String flagName, JavaScriptNode[] args) {
            return RegExpPrototypeBuiltinsFactory.CompiledRegexFlagPropertyAccessorNodeGen.create(context, builtin, flagName, args);
        }
    }

    public static abstract class RegExpFlagsGetterNode
    extends JSBuiltinNode {
        @Node.Child
        private PropertyGetNode getGlobal;
        @Node.Child
        private PropertyGetNode getIgnoreCase;
        @Node.Child
        private PropertyGetNode getMultiline;
        @Node.Child
        private PropertyGetNode getDotAll;
        @Node.Child
        private PropertyGetNode getUnicode;
        @Node.Child
        private PropertyGetNode getSticky;
        @Node.Child
        private PropertyGetNode getHasIndices;
        @Node.Child
        private JSToBooleanNode toBoolean;

        public RegExpFlagsGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getGlobal = PropertyGetNode.create(JSRegExp.GLOBAL, context);
            this.getIgnoreCase = PropertyGetNode.create(JSRegExp.IGNORE_CASE, context);
            this.getMultiline = PropertyGetNode.create(JSRegExp.MULTILINE, context);
            if (context.getEcmaScriptVersion() >= 9) {
                this.getDotAll = PropertyGetNode.create(JSRegExp.DOT_ALL, context);
            }
            this.getUnicode = PropertyGetNode.create(JSRegExp.UNICODE, context);
            this.getSticky = PropertyGetNode.create(JSRegExp.STICKY, context);
            if (context.isOptionRegexpMatchIndices()) {
                this.getHasIndices = PropertyGetNode.create(JSRegExp.HAS_INDICES, context);
            }
        }

        @Specialization(guards={"isObjectNode.executeBoolean(rx)"}, limit="1")
        protected Object doObject(JSDynamicObject rx, @Cached IsJSObjectNode isObjectNode, @Cached TruffleString.FromCharArrayUTF16Node fromCharArrayNode) {
            char[] flags = new char[7];
            int len = 0;
            if (this.getHasIndices != null && this.getFlag(rx, this.getHasIndices)) {
                flags[len++] = 100;
            }
            if (this.getFlag(rx, this.getGlobal)) {
                flags[len++] = 103;
            }
            if (this.getFlag(rx, this.getIgnoreCase)) {
                flags[len++] = 105;
            }
            if (this.getFlag(rx, this.getMultiline)) {
                flags[len++] = 109;
            }
            if (this.getDotAll != null && this.getFlag(rx, this.getDotAll)) {
                flags[len++] = 115;
            }
            if (this.getFlag(rx, this.getUnicode)) {
                flags[len++] = 117;
            }
            if (this.getFlag(rx, this.getSticky)) {
                flags[len++] = 121;
            }
            if (len == 0) {
                return Strings.EMPTY_STRING;
            }
            return Strings.fromCharArray(fromCharArrayNode, flags, 0, len);
        }

        @Fallback
        protected Object doNotObject(Object thisObj) {
            throw Errors.createTypeErrorNotAnObject(thisObj);
        }

        private boolean getFlag(JSDynamicObject re, PropertyGetNode getNode) {
            boolean flag;
            if (this.toBoolean == null) {
                try {
                    flag = getNode.getValueBoolean(re);
                }
                catch (UnexpectedResultException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.toBoolean = this.insert(JSToBooleanNode.create());
                    flag = this.toBoolean.executeBoolean(e.getResult());
                }
            } else {
                flag = this.toBoolean.executeBoolean(getNode.getValue(re));
            }
            return flag;
        }
    }

    public static final class RegExpPrototypeGetterBuiltins
    extends JSBuiltinsContainer.SwitchEnum<RegExpPrototypeGetters> {
        public static final JSBuiltinsContainer BUILTINS = new RegExpPrototypeGetterBuiltins();

        protected RegExpPrototypeGetterBuiltins() {
            super(JSRegExp.PROTOTYPE_NAME, RegExpPrototypeGetters.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, RegExpPrototypeGetters builtinEnum) {
            switch (builtinEnum) {
                case source: {
                    return CompiledRegexPatternAccessor.create(context, builtin, RegExpPrototypeGetterBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
                }
                case flags: {
                    return RegExpPrototypeBuiltinsFactory.RegExpFlagsGetterNodeGen.create(context, builtin, RegExpPrototypeGetterBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
                }
            }
            return CompiledRegexFlagPropertyAccessor.create(context, builtin, builtinEnum.name(), RegExpPrototypeGetterBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
        }

        public static enum RegExpPrototypeGetters implements BuiltinEnum<RegExpPrototypeGetters>
        {
            flags(0),
            source(0),
            global(0),
            multiline(0),
            ignoreCase(0),
            sticky(0),
            unicode(0),
            dotAll(0),
            hasIndices(0);

            private final int length;

            private RegExpPrototypeGetters(int length2) {
                this.length = length2;
            }

            @Override
            public int getLength() {
                return this.length;
            }

            @Override
            public int getECMAScriptVersion() {
                if (EnumSet.of(sticky, unicode).contains(this)) {
                    return 6;
                }
                if (this == dotAll) {
                    return 9;
                }
                return BuiltinEnum.super.getECMAScriptVersion();
            }

            @Override
            public boolean isGetter() {
                return true;
            }
        }
    }

    public static final class ReplaceStringConsumerTRegex
    implements ReplaceStringParser.Consumer<ParentNode, TruffleStringBuilder> {
        private final TruffleStringBuilder sb;
        private final TruffleString input;
        private final TruffleString replaceStr;
        private final int startPos;
        private final int endPos;
        private final Object tRegexResult;
        private final Object tRegexCompiledRegex;
        private final int groupCount;

        public ReplaceStringConsumerTRegex(TruffleStringBuilder sb, TruffleString input, TruffleString replaceStr, int startPos, int endPos, Object tRegexResult, Object tRegexCompiledRegex, int groupCount) {
            this.sb = sb;
            this.input = input;
            this.replaceStr = replaceStr;
            this.startPos = startPos;
            this.endPos = endPos;
            this.tRegexResult = tRegexResult;
            this.tRegexCompiledRegex = tRegexCompiledRegex;
            this.groupCount = groupCount;
        }

        @Override
        public void literal(ParentNode node, int start2, int end) {
            node.append(this.sb, this.replaceStr, start2, end);
        }

        @Override
        public void match(ParentNode node) {
            node.append(this.sb, this.input, this.startPos, this.endPos);
        }

        @Override
        public void matchHead(ParentNode node) {
            node.append(this.sb, this.input, 0, this.startPos);
        }

        @Override
        public void matchTail(ParentNode node) {
            node.append(this.sb, this.input, this.endPos, Strings.length(this.input));
        }

        @Override
        public void captureGroup(ParentNode parent, int groupNumber, int literalStart, int literalEnd) {
            Node node = (Node)((Object)parent);
            if (groupNumber < this.groupCount) {
                int start2 = TRegexUtil.TRegexResultAccessor.captureGroupStart(this.tRegexResult, groupNumber, node, parent.getGetStartNode());
                if (start2 >= 0) {
                    parent.append(this.sb, this.input, start2, TRegexUtil.TRegexResultAccessor.captureGroupEnd(this.tRegexResult, groupNumber, node, parent.getGetEndNode()));
                }
            } else if (groupNumber > 9 && groupNumber / 10 < this.groupCount) {
                int start3 = TRegexUtil.TRegexResultAccessor.captureGroupStart(this.tRegexResult, groupNumber / 10, node, parent.getGetStartNode());
                if (start3 >= 0) {
                    parent.append(this.sb, this.input, start3, TRegexUtil.TRegexResultAccessor.captureGroupEnd(this.tRegexResult, groupNumber / 10, node, parent.getGetEndNode()));
                }
                parent.append(this.sb, this.replaceStr, literalStart + 2, literalEnd);
            } else {
                parent.getInvalidGroupNumberProfile().enter();
                parent.append(this.sb, this.replaceStr, literalStart, literalEnd);
            }
        }

        @Override
        public void namedCaptureGroup(ParentNode node, TruffleString groupName) {
            int groupNumber;
            int start2;
            JSRegExpReplaceNode parent = (JSRegExpReplaceNode)node;
            Object map2 = TRegexUtil.TRegexCompiledRegexAccessor.namedCaptureGroups(this.tRegexCompiledRegex, parent, parent.readGroupsNode);
            if (TRegexUtil.TRegexNamedCaptureGroupsAccessor.hasGroup(map2, groupName, parent.namedCaptureGroupInterop) && (start2 = TRegexUtil.TRegexResultAccessor.captureGroupStart(this.tRegexResult, groupNumber = TRegexUtil.TRegexNamedCaptureGroupsAccessor.getGroupNumber(map2, groupName, parent.namedCaptureGroupInterop, parent.toIntNode, parent), parent, parent.getStartNode)) >= 0) {
                node.append(this.sb, this.input, start2, TRegexUtil.TRegexResultAccessor.captureGroupEnd(this.tRegexResult, groupNumber, parent, parent.getEndNode));
            }
        }

        @Override
        public TruffleStringBuilder getResult() {
            return this.sb;
        }

        public static interface ParentNode {
            public void append(TruffleStringBuilder var1, TruffleString var2);

            public void append(TruffleStringBuilder var1, TruffleString var2, int var3, int var4);

            public BranchProfile getInvalidGroupNumberProfile();

            public TRegexUtil.InvokeGetGroupBoundariesMethodNode getGetStartNode();

            public TRegexUtil.InvokeGetGroupBoundariesMethodNode getGetEndNode();
        }
    }

    public static final class ReplaceStringConsumer
    implements ReplaceStringParser.Consumer<JSRegExpReplaceNode, TruffleStringBuilder> {
        private final TruffleStringBuilder sb;
        private final TruffleString input;
        private final TruffleString replaceStr;
        private final int startPos;
        private final int endPos;
        private final JSDynamicObject result;
        private final JSDynamicObject namedCaptures;

        private ReplaceStringConsumer(TruffleStringBuilder sb, TruffleString input, TruffleString replaceStr, int startPos, int endPos, JSDynamicObject result2, JSDynamicObject namedCaptures) {
            this.sb = sb;
            this.input = input;
            this.replaceStr = replaceStr;
            this.startPos = startPos;
            this.endPos = endPos;
            this.result = result2;
            this.namedCaptures = namedCaptures;
        }

        @Override
        public void literal(JSRegExpReplaceNode node, int start2, int end) {
            node.append(this.sb, this.replaceStr, start2, end);
        }

        @Override
        public void match(JSRegExpReplaceNode node) {
            node.append(this.sb, (TruffleString)node.read(this.result, 0));
        }

        @Override
        public void matchHead(JSRegExpReplaceNode node) {
            node.append(this.sb, this.input, 0, this.startPos);
        }

        @Override
        public void matchTail(JSRegExpReplaceNode node) {
            node.append(this.sb, this.input, this.endPos, Strings.length(this.input));
        }

        @Override
        public void captureGroup(JSRegExpReplaceNode node, int groupNumber, int literalStart, int literalEnd) {
            Object capture = node.read(this.result, groupNumber);
            if (capture != Undefined.instance) {
                node.append(this.sb, (TruffleString)capture);
            }
        }

        @Override
        public void namedCaptureGroup(JSRegExpReplaceNode node, TruffleString groupName) {
            Object namedCapture = node.readNamedCaptureGroup(this.namedCaptures, groupName);
            if (namedCapture != Undefined.instance) {
                node.append(this.sb, node.toString4(namedCapture));
            }
        }

        @Override
        public TruffleStringBuilder getResult() {
            return this.sb;
        }
    }

    public static abstract class RegExpPrototypeSymbolOperation
    extends JSBuiltinNode {
        @Node.Child
        private JSRegExpExecIntlNode regexExecIntlNode;
        @Node.Child
        private PropertyGetNode getLastIndexNode;
        @Node.Child
        private PropertySetNode setLastIndexNode;
        @Node.Child
        private WriteElementNode writeNode;
        @Node.Child
        private ReadElementNode readNode;
        @Node.Child
        private ArrayPrototypeBuiltins.ArraySpeciesConstructorNode arraySpeciesCreateNode;

        public RegExpPrototypeSymbolOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected Object read(Object target, int index) {
            if (this.readNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readNode = this.insert(ReadElementNode.create(this.getContext()));
            }
            return this.readNode.executeWithTargetAndIndex(target, index);
        }

        protected void write(Object target, int index, Object value2) {
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeNode = this.insert(WriteElementNode.create(this.getContext(), true, true));
            }
            this.writeNode.executeWithTargetAndIndexAndValue(target, index, value2);
        }

        protected final ArrayPrototypeBuiltins.ArraySpeciesConstructorNode getArraySpeciesConstructorNode() {
            if (this.arraySpeciesCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arraySpeciesCreateNode = this.insert(ArrayPrototypeBuiltins.ArraySpeciesConstructorNode.create(this.getContext(), false));
            }
            return this.arraySpeciesCreateNode;
        }

        private void initLastIndexNode() {
            if (this.setLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setLastIndexNode = this.insert(PropertySetNode.create(JSRegExp.LAST_INDEX, false, this.getContext(), true));
            }
        }

        protected void setLastIndex(Object obj, int value2) {
            this.initLastIndexNode();
            this.setLastIndexNode.setValueInt(obj, value2);
        }

        protected void setLastIndex(Object obj, Object value2) {
            this.initLastIndexNode();
            this.setLastIndexNode.setValue(obj, value2);
        }

        protected Object getLastIndex(Object obj) {
            if (this.getLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getLastIndexNode = this.insert(PropertyGetNode.create(JSRegExp.LAST_INDEX, false, this.getContext()));
            }
            return this.getLastIndexNode.getValue(obj);
        }

        protected Object regexExecIntl(JSDynamicObject regex, Object input) {
            if (this.regexExecIntlNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.regexExecIntlNode = this.insert(JSRegExpExecIntlNode.create(this.getContext()));
            }
            return this.regexExecIntlNode.execute(regex, input);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class AdvanceStringIndexUnicodeNode
    extends JavaScriptBaseNode {
        protected AdvanceStringIndexUnicodeNode() {
        }

        public abstract int execute(Node var1, TruffleString var2, int var3);

        @Specialization
        protected static int advanceStringIndexUnicode(Node node, TruffleString s, int index, @Cached(inline=false) TruffleString.ReadCharUTF16Node readChar, @Cached InlinedConditionProfile advanceIndexLength, @Cached InlinedConditionProfile advanceIndexFirst, @Cached InlinedConditionProfile advanceIndexSecond) {
            if (advanceIndexLength.profile(node, index + 1 >= Strings.length(s))) {
                return index + 1;
            }
            char first = Strings.charAt(readChar, s, index);
            if (advanceIndexFirst.profile(node, first < '\ud800' || first > '\udbff')) {
                return index + 1;
            }
            char second = Strings.charAt(readChar, s, index + 1);
            if (advanceIndexSecond.profile(node, second < '\udc00' || second > '\udfff')) {
                return index + 1;
            }
            return index + 2;
        }
    }
}

