/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.decorators;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.decorators.CreateDecoratorContextObjectNodeGen;
import com.oracle.truffle.js.nodes.JSFrameSlot;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ObjectLiteralNode;
import com.oracle.truffle.js.nodes.access.PrivateBrandCheckNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldGetNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldSetNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.arguments.AccessFunctionNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.arguments.AccessThisNode;
import com.oracle.truffle.js.nodes.function.ClassElementDefinitionRecord;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;

@ImportStatic(value={Strings.class})
public abstract class CreateDecoratorContextObjectNode
extends JavaScriptBaseNode {
    private static final TruffleString FIELD_KIND = Strings.constant("field");
    private static final TruffleString GETTER_KIND = Strings.constant("getter");
    private static final TruffleString SETTER_KIND = Strings.constant("setter");
    private static final TruffleString METHOD_KIND = Strings.constant("method");
    private static final TruffleString CLASS_KIND = Strings.constant("class");
    private static final TruffleString AUTO_ACCESSOR_KIND = Strings.constant("accessor");
    private static final TruffleString ADD_INITIALIZER = Strings.constant("addInitializer");
    private static final TruffleString NAME = Strings.constant("name");
    private static final TruffleString KIND = Strings.constant("kind");
    private static final TruffleString ACCESS = Strings.constant("access");
    private static final HiddenKey INIT_KEY = new HiddenKey(":initializers");
    protected static final HiddenKey DECORATION_STATE_KEY = new HiddenKey("DecorationState");
    protected static final HiddenKey ELEMENT_RECORD_KEY = new HiddenKey("ClassElementDefinitionRecord");
    protected static final HiddenKey BACKING_STORAGE_KEY = new HiddenKey("BackingStorageKey");
    static final int LIMIT = 3;
    @Node.Child
    private ScopeFrameNode privateScopeNode;
    private final int privateMemberSlotIndex;
    private final int privateBrandSlotIndex;
    @Node.Child
    private CreateObjectNode createObjectNode;
    @Node.Child
    private PropertySetNode setInitializersKey;
    @Node.Child
    private PropertySetNode setDecorationState;
    @Node.Child
    private CreateDataPropertyNode defineKind;
    @Node.Child
    private CreateDataPropertyNode defineName;
    @Node.Child
    private CreateDataPropertyNode defineAddInitializer;
    @Node.Child
    private CreateDataPropertyNode defineAccess;
    @Node.Child
    private CreateDataPropertyNode defineStatic;
    @Node.Child
    private CreateDataPropertyNode definePrivate;
    @Node.Child
    private CreateDataPropertyNode defineGet;
    @Node.Child
    private CreateDataPropertyNode defineSet;
    protected final boolean isStatic;
    protected final boolean isPrivate;
    protected final JSContext context;

    @NeverDefault
    public static CreateDecoratorContextObjectNode create(JSContext context, ObjectLiteralNode.ObjectLiteralMemberNode member) {
        ScopeFrameNode privateScopeNode = null;
        int privateMemberSlotIndex = -1;
        int privateBrandSlotIndex = -1;
        if (member.isPrivate()) {
            ObjectLiteralNode.PrivateClassElementNode privateMember = (ObjectLiteralNode.PrivateClassElementNode)member;
            privateScopeNode = privateMember.getPrivateScopeNode();
            privateMemberSlotIndex = privateMember.getPrivateMemberSlotIndex();
            privateBrandSlotIndex = privateMember.getPrivateBrandSlotIndex();
        }
        return CreateDecoratorContextObjectNodeGen.create(context, member.isStatic(), member.isPrivate(), privateScopeNode, privateMemberSlotIndex, privateBrandSlotIndex, false);
    }

    public static CreateDecoratorContextObjectNode createForClass(JSContext context) {
        return CreateDecoratorContextObjectNodeGen.create(context, false, false, null, -1, -1, true);
    }

    public abstract JSObject executeContext(VirtualFrame var1, ClassElementDefinitionRecord var2, Object var3, DecorationState var4);

    CreateDecoratorContextObjectNode(JSContext context, boolean isStatic, boolean isPrivate, ScopeFrameNode privateScopeNode, int privateMemberSlotIndex, int privateBrandSlotIndex, boolean classDef) {
        this.createObjectNode = CreateObjectNode.create(context);
        this.setInitializersKey = PropertySetNode.createSetHidden(INIT_KEY, context);
        this.setDecorationState = PropertySetNode.createSetHidden(DECORATION_STATE_KEY, context);
        this.defineKind = CreateDataPropertyNode.create(context, KIND);
        this.defineName = CreateDataPropertyNode.create(context, NAME);
        this.defineAddInitializer = CreateDataPropertyNode.create(context, ADD_INITIALIZER);
        if (!classDef) {
            this.defineAccess = CreateDataPropertyNode.create(context, ACCESS);
            this.defineStatic = CreateDataPropertyNode.create(context, Strings.STATIC);
            this.definePrivate = CreateDataPropertyNode.create(context, Strings.PRIVATE);
            this.defineGet = CreateDataPropertyNode.create(context, Strings.GET);
            this.defineSet = CreateDataPropertyNode.create(context, Strings.SET);
        }
        this.isStatic = isStatic;
        this.isPrivate = isPrivate;
        this.privateMemberSlotIndex = privateMemberSlotIndex;
        this.privateBrandSlotIndex = privateBrandSlotIndex;
        this.privateScopeNode = privateScopeNode;
        this.context = context;
    }

    public final JSObject evaluateClass(VirtualFrame frame, Object className, Object initializers, DecorationState state) {
        return this.createContextObject(frame, CLASS_KIND, className, initializers, state, null, null, true);
    }

    @Specialization(guards={"!isPrivate", "record.isMethod()", "nameEquals(strEq, record, cachedName)"}, limit="LIMIT")
    public JSObject doPublicMethodCached(VirtualFrame frame, ClassElementDefinitionRecord record, Object initializers, DecorationState state, @Cached(value="record.getKey()") Object cachedName, @Cached @Cached.Shared TruffleString.EqualNode strEq, @Cached(value="createPropertyGetterCached(cachedName, context)") JSFunctionData valueGetterFunctionData) {
        JSFunctionObject getter = JSFunction.create(this.getRealm(), valueGetterFunctionData);
        return this.createContextObject(frame, cachedName, initializers, state, getter, null, METHOD_KIND);
    }

    @Specialization(guards={"!isPrivate", "record.isMethod()"}, replaces={"doPublicMethodCached"})
    public JSObject doPublicMethodUncached(VirtualFrame frame, ClassElementDefinitionRecord record, Object initializers, DecorationState state, @Cached(value="createSetHidden(ELEMENT_RECORD_KEY, context)") @Cached.Shared PropertySetNode setElementRecord, @Cached(value="createGetterFromPropertyUncached(context)") @Cached.Shared(value="propertyGetterUncached") JSFunctionData valueGetterFunctionData) {
        Object description = record.getKey();
        JSObject getter = this.createFunctionWithElementRecordField(record, valueGetterFunctionData, setElementRecord);
        return this.createContextObject(frame, description, initializers, state, getter, null, METHOD_KIND);
    }

    @Specialization(guards={"isPrivate", "record.isMethod()"})
    public JSObject doPrivateMethod(VirtualFrame frame, ClassElementDefinitionRecord record, Object initializers, DecorationState state, @Cached(value="getName(record.getKey())") Object description, @Cached(value="createGetterForPrivateMethodOrAccessor()") @Cached.Exclusive JSFunctionData valueGetterFunctionData) {
        assert (description.equals(this.getName(record.getKey())));
        JSFunctionObject getter = JSFunction.create(this.getRealm(), valueGetterFunctionData, this.getScopeFrame(frame));
        return this.createContextObject(frame, description, initializers, state, getter, null, METHOD_KIND);
    }

    @Specialization(guards={"!isPrivate", "record.isField()", "nameEquals(strEq, record, cachedName)"}, limit="LIMIT")
    public JSObject doPublicFieldCached(VirtualFrame frame, ClassElementDefinitionRecord record, Object initializers, DecorationState state, @Cached(value="record.getKey()") Object cachedName, @Cached @Cached.Shared TruffleString.EqualNode strEq, @Cached(value="createPropertyGetterCached(cachedName, context)") JSFunctionData valueGetterFunctionData, @Cached(value="createPropertySetterCached(cachedName, context)") JSFunctionData valueSetterFunctionData) {
        JSFunctionObject getter = JSFunction.create(this.getRealm(), valueGetterFunctionData);
        JSFunctionObject setter = JSFunction.create(this.getRealm(), valueSetterFunctionData);
        return this.createContextObject(frame, cachedName, initializers, state, getter, setter, FIELD_KIND);
    }

    @Specialization(guards={"!isPrivate", "record.isField()"}, replaces={"doPublicFieldCached"})
    public JSObject doPublicFieldUncached(VirtualFrame frame, ClassElementDefinitionRecord record, Object initializers, DecorationState state, @Cached(value="createSetHidden(ELEMENT_RECORD_KEY, context)") @Cached.Shared PropertySetNode setElementRecord, @Cached(value="createGetterFromPropertyUncached(context)") @Cached.Shared(value="propertyGetterUncached") JSFunctionData valueGetterFunctionData, @Cached(value="createSetterFromPropertyUncached(context)") @Cached.Shared(value="propertySetterUncached") JSFunctionData valueSetterFunctionData) {
        Object description = record.getKey();
        JSObject getter = this.createFunctionWithElementRecordField(record, valueGetterFunctionData, setElementRecord);
        JSObject setter = this.createFunctionWithElementRecordField(record, valueSetterFunctionData, setElementRecord);
        return this.createContextObject(frame, description, initializers, state, getter, setter, FIELD_KIND);
    }

    @Specialization(guards={"isPrivate", "record.isField()"})
    public JSObject doPrivateField(VirtualFrame frame, ClassElementDefinitionRecord record, Object initializers, DecorationState state, @Cached(value="getName(record.getKey())") Object description, @Cached(value="createSetHidden(BACKING_STORAGE_KEY, context)") PropertySetNode setStorageKeyNode, @Cached(value="createPrivateFieldGetter(context)") JSFunctionData valueGetterFunctionData, @Cached(value="createPrivateFieldSetter(context)") JSFunctionData valueSetterFunctionData) {
        assert (description.equals(this.getName(record.getKey())));
        JSFunctionObject getter = JSFunction.create(this.getRealm(), valueGetterFunctionData);
        setStorageKeyNode.setValue(getter, record.getBackingStorageKey());
        JSFunctionObject setter = JSFunction.create(this.getRealm(), valueSetterFunctionData);
        setStorageKeyNode.setValue(setter, record.getBackingStorageKey());
        return this.createContextObject(frame, description, initializers, state, getter, setter, FIELD_KIND);
    }

    @Specialization(guards={"!isPrivate", "record.isAutoAccessor()", "nameEquals(strEq, record, cachedName)"}, limit="LIMIT")
    public JSObject doPublicAutoAccessorCached(VirtualFrame frame, ClassElementDefinitionRecord record, Object initializers, DecorationState state, @Cached(value="record.getKey()") Object cachedName, @Cached @Cached.Shared TruffleString.EqualNode strEq, @Cached(value="createPropertyGetterCached(cachedName, context)") JSFunctionData valueGetterFunctionData, @Cached(value="createPropertySetterCached(cachedName, context)") JSFunctionData valueSetterFunctionData) {
        JSFunctionObject getter = JSFunction.create(this.getRealm(), valueGetterFunctionData);
        JSFunctionObject setter = JSFunction.create(this.getRealm(), valueSetterFunctionData);
        return this.createContextObject(frame, cachedName, initializers, state, getter, setter, AUTO_ACCESSOR_KIND);
    }

    @Specialization(guards={"!isPrivate", "record.isAutoAccessor()"}, replaces={"doPublicAutoAccessorCached"})
    public JSObject doPublicAutoAccessor(VirtualFrame frame, ClassElementDefinitionRecord record, Object initializers, DecorationState state, @Cached(value="createSetHidden(ELEMENT_RECORD_KEY, context)") @Cached.Shared PropertySetNode setElementRecord, @Cached(value="createGetterFromPropertyUncached(context)") @Cached.Shared(value="propertyGetterUncached") JSFunctionData valueGetterFunctionData, @Cached(value="createSetterFromPropertyUncached(context)") @Cached.Shared(value="propertySetterUncached") JSFunctionData valueSetterFunctionData) {
        Object description = record.getKey();
        JSObject getter = this.createFunctionWithElementRecordField(record, valueGetterFunctionData, setElementRecord);
        JSObject setter = this.createFunctionWithElementRecordField(record, valueSetterFunctionData, setElementRecord);
        return this.createContextObject(frame, description, initializers, state, getter, setter, AUTO_ACCESSOR_KIND);
    }

    @Specialization(guards={"isPrivate", "record.isAutoAccessor()"})
    public JSObject doPrivateAutoAccessor(VirtualFrame frame, ClassElementDefinitionRecord record, Object initializers, DecorationState state, @Cached(value="getName(record.getKey())") Object description, @Cached(value="createGetterForPrivateMethodOrAccessor()") @Cached.Exclusive JSFunctionData valueGetterFunctionData, @Cached(value="createSetterForPrivateAccessor()") @Cached.Exclusive JSFunctionData valueSetterFunctionData) {
        assert (description.equals(this.getName(record.getKey())));
        JSFunctionObject getter = JSFunction.create(this.getRealm(), valueGetterFunctionData, this.getScopeFrame(frame));
        JSFunctionObject setter = JSFunction.create(this.getRealm(), valueSetterFunctionData, this.getScopeFrame(frame));
        return this.createContextObject(frame, description, initializers, state, getter, setter, AUTO_ACCESSOR_KIND);
    }

    @Specialization(guards={"!isPrivate", "record.isGetter()", "nameEquals(strEq, record, cachedName)"}, limit="LIMIT")
    public JSObject doPublicGetterCached(VirtualFrame frame, ClassElementDefinitionRecord record, Object initializers, DecorationState state, @Cached(value="record.getKey()") Object cachedName, @Cached @Cached.Shared TruffleString.EqualNode strEq, @Cached(value="createPropertyGetterCached(cachedName, context)") JSFunctionData valueGetterFunctionData) {
        JSFunctionObject getter = JSFunction.create(this.getRealm(), valueGetterFunctionData);
        return this.createContextObject(frame, cachedName, initializers, state, getter, null, GETTER_KIND);
    }

    @Specialization(guards={"!isPrivate", "record.isGetter()"}, replaces={"doPublicGetterCached"})
    public JSObject doPublicGetterUncached(VirtualFrame frame, ClassElementDefinitionRecord record, Object initializers, DecorationState state, @Cached(value="createSetHidden(ELEMENT_RECORD_KEY, context)") @Cached.Shared PropertySetNode setElementRecord, @Cached(value="createGetterFromPropertyUncached(context)") @Cached.Shared(value="propertyGetterUncached") JSFunctionData valueGetterFunctionData) {
        Object name = record.getKey();
        JSObject getter = this.createFunctionWithElementRecordField(record, valueGetterFunctionData, setElementRecord);
        return this.createContextObject(frame, name, initializers, state, getter, null, GETTER_KIND);
    }

    @Specialization(guards={"isPrivate", "record.isGetter()"})
    public JSObject doPrivateGetter(VirtualFrame frame, ClassElementDefinitionRecord record, Object initializers, DecorationState state, @Cached(value="getName(record.getKey())") Object description, @Cached(value="createGetterForPrivateMethodOrAccessor()") @Cached.Exclusive JSFunctionData valueGetterFunctionData) {
        assert (description.equals(this.getName(record.getKey())));
        JSFunctionObject getter = JSFunction.create(this.getRealm(), valueGetterFunctionData, this.getScopeFrame(frame));
        return this.createContextObject(frame, description, initializers, state, getter, null, GETTER_KIND);
    }

    @Specialization(guards={"!isPrivate", "record.isSetter()", "nameEquals(strEq, record, cachedName)"}, limit="LIMIT")
    public JSObject doPublicSetterCached(VirtualFrame frame, ClassElementDefinitionRecord record, Object initializers, DecorationState state, @Cached(value="record.getKey()") Object cachedName, @Cached @Cached.Shared TruffleString.EqualNode strEq, @Cached(value="createPropertySetterCached(cachedName, context)") JSFunctionData valueSetterFunctionData) {
        JSFunctionObject setter = JSFunction.create(this.getRealm(), valueSetterFunctionData);
        return this.createContextObject(frame, cachedName, initializers, state, null, setter, SETTER_KIND);
    }

    @Specialization(guards={"!isPrivate", "record.isSetter()"}, replaces={"doPublicSetterCached"})
    public JSObject doPublicSetterUncached(VirtualFrame frame, ClassElementDefinitionRecord record, Object initializers, DecorationState state, @Cached(value="createSetHidden(ELEMENT_RECORD_KEY, context)") @Cached.Shared PropertySetNode setElementRecord, @Cached(value="createSetterFromPropertyUncached(context)") @Cached.Shared(value="propertySetterUncached") JSFunctionData valueSetterFunctionData) {
        Object name = record.getKey();
        JSObject setter = this.createFunctionWithElementRecordField(record, valueSetterFunctionData, setElementRecord);
        return this.createContextObject(frame, name, initializers, state, null, setter, SETTER_KIND);
    }

    @Specialization(guards={"isPrivate", "record.isSetter()"})
    public JSObject doPrivateSetter(VirtualFrame frame, ClassElementDefinitionRecord record, Object initializers, DecorationState state, @Cached(value="getName(record.getKey())") Object description, @Cached(value="createSetterForPrivateAccessor()") @Cached.Exclusive JSFunctionData valueSetterFunctionData) {
        assert (description.equals(this.getName(record.getKey())));
        JSFunctionObject setter = JSFunction.create(this.getRealm(), valueSetterFunctionData, this.getScopeFrame(frame));
        return this.createContextObject(frame, description, initializers, state, null, setter, SETTER_KIND);
    }

    private JSObject createFunctionWithElementRecordField(ClassElementDefinitionRecord record, JSFunctionData functionData, PropertySetNode setElementRecord) {
        assert (!record.isPrivate());
        JSFunctionObject function = JSFunction.create(this.getRealm(), functionData);
        setElementRecord.setValue(function, record);
        return function;
    }

    private MaterializedFrame getScopeFrame(VirtualFrame frame) {
        return (MaterializedFrame)this.privateScopeNode.executeFrame(frame);
    }

    protected static boolean nameEquals(TruffleString.EqualNode strEq, ClassElementDefinitionRecord record, Object expected) {
        if (record.getKey() instanceof TruffleString && expected instanceof TruffleString) {
            return Strings.equals(strEq, (TruffleString)expected, (TruffleString)record.getKey());
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    @NeverDefault
    protected Object getName(Object key) {
        if (key instanceof HiddenKey) {
            String name = ((HiddenKey)key).getName();
            String description = name.charAt(0) == '#' ? name.substring(1) : name;
            return Strings.fromJavaString(description);
        }
        return key;
    }

    private JSFunctionObject createAddInitializerFunction(Object initializers, DecorationState state) {
        JSFunctionObject addInitializerFunction = JSFunction.create(JSRealm.get(this), CreateDecoratorContextObjectNode.getAddInitializerFunctionData(this.context));
        this.setInitializersKey.setValue(addInitializerFunction, initializers);
        this.setDecorationState.setValue(addInitializerFunction, state);
        return addInitializerFunction;
    }

    public JSObject createContextObject(VirtualFrame frame, Object name, Object initializers, DecorationState state, JSObject getter, JSObject setter, TruffleString kindName) {
        return this.createContextObject(frame, kindName, name, initializers, state, getter, setter, false);
    }

    private JSObject createContextObject(VirtualFrame frame, TruffleString kindName, Object name, Object initializers, DecorationState state, JSObject getter, JSObject setter, boolean isClass) {
        JSObject contextObj = this.createObjectNode.execute(frame);
        this.defineKind.executeVoid(contextObj, KIND, kindName);
        if (!isClass) {
            JSObject accessObject = this.createObjectNode.execute(frame);
            if (getter != null) {
                this.defineGet.executeVoid(accessObject, Strings.GET, getter);
            }
            if (setter != null) {
                this.defineSet.executeVoid(accessObject, Strings.SET, setter);
            }
            this.defineAccess.executeVoid(contextObj, ACCESS, accessObject);
            this.defineStatic.executeVoid(contextObj, Strings.STATIC, this.isStatic);
            this.definePrivate.executeVoid(contextObj, Strings.PRIVATE, this.isPrivate);
        }
        this.defineName.executeVoid(contextObj, NAME, name);
        this.defineAddInitializer.executeVoid(contextObj, ADD_INITIALIZER, this.createAddInitializerFunction(initializers, state));
        return contextObj;
    }

    @NeverDefault
    private static JSFunctionData getAddInitializerFunctionData(JSContext ctx) {
        return ctx.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.DecoratorContextAddInitializer, CreateDecoratorContextObjectNode::createAddInitializerFunctionData);
    }

    private static JSFunctionData createAddInitializerFunctionData(final JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        RootCallTarget callTarget = new JavaScriptRootNode(context.getLanguage()){
            @Node.Child
            private PropertyGetNode getDecorationState;
            @Node.Child
            private PropertyGetNode getInitializersKey;
            {
                super(lang);
                this.getDecorationState = PropertyGetNode.createGetHidden(DECORATION_STATE_KEY, context);
                this.getInitializersKey = PropertyGetNode.createGetHidden(INIT_KEY, context);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                JSFunctionObject self = (JSFunctionObject)JSArguments.getFunctionObject(frame.getArguments());
                DecorationState state = (DecorationState)this.getDecorationState.getValue(self);
                SimpleArrayList initializers = (SimpleArrayList)this.getInitializersKey.getValue(self);
                if (state.finished) {
                    throw Errors.createTypeError("Bad decorator initializer state");
                }
                Object[] args = frame.getArguments();
                JSDynamicObject value2 = JSArguments.getUserArgumentCount(args) > 0 ? JSArguments.getUserArgument(args, 0) : Undefined.instance;
                initializers.addUncached(value2);
                return Undefined.instance;
            }
        }.getCallTarget();
        return JSFunctionData.createCallOnly(context, callTarget, 1, ADD_INITIALIZER);
    }

    @NeverDefault
    protected static JSFunctionData createPropertyGetterCached(final Object name, final JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        assert (JSRuntime.isPropertyKey(name)) : name;
        RootCallTarget getter = new JavaScriptRootNode(context.getLanguage()){
            @Node.Child
            private PropertyGetNode propertyGetNode;
            {
                super(lang);
                this.propertyGetNode = PropertyGetNode.create(name, context);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object thiz = JSFrameUtil.getThisObj(frame);
                return this.propertyGetNode.getValue(thiz);
            }
        }.getCallTarget();
        return JSFunctionData.createCallOnly(context, getter, 0, Strings.GET);
    }

    @NeverDefault
    protected static JSFunctionData createPropertySetterCached(final Object name, final JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        assert (JSRuntime.isPropertyKey(name)) : name;
        RootCallTarget callTarget = new JavaScriptRootNode(context.getLanguage()){
            @Node.Child
            private PropertySetNode propertySetNode;
            {
                super(lang);
                this.propertySetNode = PropertySetNode.create(name, false, context, true);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object thiz = JSFrameUtil.getThisObj(frame);
                Object[] args = frame.getArguments();
                JSDynamicObject newValue = JSArguments.getUserArgumentCount(args) > 0 ? JSArguments.getUserArgument(args, 0) : Undefined.instance;
                this.propertySetNode.setValue(thiz, newValue);
                return Undefined.instance;
            }
        }.getCallTarget();
        return JSFunctionData.createCallOnly(context, callTarget, 1, Strings.SET);
    }

    @NeverDefault
    protected static JSFunctionData createPrivateFieldGetter(final JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        JavaScriptRootNode getter = new JavaScriptRootNode(context.getLanguage()){
            @Node.Child
            private PrivateFieldGetNode privateFieldGet;
            {
                super(lang);
                this.privateFieldGet = PrivateFieldGetNode.create(AccessThisNode.create(), PropertyNode.createGetHidden(context, AccessFunctionNode.create(), BACKING_STORAGE_KEY), context);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                return this.privateFieldGet.execute(frame);
            }
        };
        return JSFunctionData.createCallOnly(context, getter.getCallTarget(), 0, Strings.GET);
    }

    @NeverDefault
    protected static JSFunctionData createPrivateFieldSetter(final JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        JavaScriptRootNode setter = new JavaScriptRootNode(context.getLanguage()){
            @Node.Child
            private PrivateFieldSetNode privateFieldSet;
            {
                super(lang);
                this.privateFieldSet = PrivateFieldSetNode.create(AccessThisNode.create(), PropertyNode.createGetHidden(context, AccessFunctionNode.create(), BACKING_STORAGE_KEY), AccessIndexedArgumentNode.create(0), context);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                this.privateFieldSet.executeVoid(frame);
                return Undefined.instance;
            }
        };
        return JSFunctionData.createCallOnly(context, setter.getCallTarget(), 1, Strings.SET);
    }

    @NeverDefault
    protected final JSFunctionData createGetterForPrivateMethodOrAccessor() {
        return CreateDecoratorContextObjectNode.createPrivateGetter(this.context, this.isStatic, this.privateMemberSlotIndex, this.privateBrandSlotIndex);
    }

    @NeverDefault
    protected final JSFunctionData createSetterForPrivateAccessor() {
        return CreateDecoratorContextObjectNode.createPrivateSetter(this.context, this.isStatic, this.privateMemberSlotIndex, this.privateBrandSlotIndex);
    }

    private static JSFunctionData createPrivateGetter(final JSContext context, final boolean isStatic, final int memberSlot, final int constructorSlot) {
        CompilerAsserts.neverPartOfCompilation();
        RootCallTarget callTarget = new JavaScriptRootNode(context.getLanguage()){
            @Node.Child
            private PrivateFieldGetNode privateGetNode;

            @Override
            public Object execute(VirtualFrame frame) {
                if (this.privateGetNode == null) {
                    this.initialize(frame);
                }
                return this.privateGetNode.execute(frame);
            }

            private void initialize(VirtualFrame frame) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                ScopeFrameNode enclosingFrameNode = ScopeFrameNode.create(1);
                FrameDescriptor frameDescriptor = enclosingFrameNode.executeFrame(frame).getFrameDescriptor();
                assert (frameDescriptor.getNumberOfSlots() > 0) : frameDescriptor;
                JSReadFrameSlotNode readConstructor = JSReadFrameSlotNode.create(JSFrameSlot.fromIndexedFrameSlot(frameDescriptor, constructorSlot), enclosingFrameNode, false);
                JavaScriptNode readBrand = isStatic ? readConstructor : PropertyNode.createGetHidden(context, readConstructor, JSFunction.PRIVATE_BRAND_ID);
                JSReadFrameSlotNode readPrivateMemberSlot = JSReadFrameSlotNode.create(JSFrameSlot.fromIndexedFrameSlot(frameDescriptor, memberSlot), enclosingFrameNode, false);
                this.privateGetNode = this.insert(PrivateFieldGetNode.create(PrivateBrandCheckNode.create(AccessThisNode.create(), readBrand), readPrivateMemberSlot, context));
            }
        }.getCallTarget();
        return JSFunctionData.createCallOnly(context, callTarget, 0, Strings.GET);
    }

    private static JSFunctionData createPrivateSetter(final JSContext context, final boolean isStatic, final int memberSlot, final int constructorSlot) {
        CompilerAsserts.neverPartOfCompilation();
        RootCallTarget callTarget = new JavaScriptRootNode(context.getLanguage()){
            @Node.Child
            private PrivateFieldSetNode privateSetNode;

            @Override
            public Object execute(VirtualFrame frame) {
                if (this.privateSetNode == null) {
                    this.initialize(frame);
                }
                this.privateSetNode.executeVoid(frame);
                return Undefined.instance;
            }

            private void initialize(VirtualFrame frame) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                ScopeFrameNode enclosingFrameNode = ScopeFrameNode.create(1);
                FrameDescriptor frameDescriptor = enclosingFrameNode.executeFrame(frame).getFrameDescriptor();
                assert (frameDescriptor.getNumberOfSlots() > 0) : frameDescriptor;
                JSReadFrameSlotNode readConstructor = JSReadFrameSlotNode.create(JSFrameSlot.fromIndexedFrameSlot(frameDescriptor, constructorSlot), enclosingFrameNode, false);
                JavaScriptNode readBrand = isStatic ? readConstructor : PropertyNode.createGetHidden(context, readConstructor, JSFunction.PRIVATE_BRAND_ID);
                JSReadFrameSlotNode readPrivateMemberSlot = JSReadFrameSlotNode.create(JSFrameSlot.fromIndexedFrameSlot(frameDescriptor, memberSlot), enclosingFrameNode, false);
                this.privateSetNode = this.insert(PrivateFieldSetNode.create(PrivateBrandCheckNode.create(AccessThisNode.create(), readBrand), readPrivateMemberSlot, AccessIndexedArgumentNode.create(0), context));
            }
        }.getCallTarget();
        return JSFunctionData.createCallOnly(context, callTarget, 1, Strings.SET);
    }

    @NeverDefault
    protected static JSFunctionData createGetterFromPropertyUncached(final JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        RootCallTarget callTarget = new JavaScriptRootNode(context.getLanguage()){
            @Node.Child
            private PropertyGetNode getElementRecord;
            @Node.Child
            private ReadElementNode propertyGetNode;
            {
                super(lang);
                this.getElementRecord = PropertyGetNode.createGetHidden(ELEMENT_RECORD_KEY, context);
                this.propertyGetNode = ReadElementNode.create(context);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object thiz = JSFrameUtil.getThisObj(frame);
                JSFunctionObject function = JSFrameUtil.getFunctionObject(frame);
                ClassElementDefinitionRecord record = (ClassElementDefinitionRecord)this.getElementRecord.getValue(function);
                assert (!record.isPrivate());
                return this.propertyGetNode.executeWithTargetAndIndex(thiz, record.getKey());
            }
        }.getCallTarget();
        return JSFunctionData.createCallOnly(context, callTarget, 0, Strings.GET);
    }

    @NeverDefault
    protected static JSFunctionData createSetterFromPropertyUncached(final JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        RootCallTarget callTarget = new JavaScriptRootNode(context.getLanguage()){
            @Node.Child
            private PropertyGetNode getElementRecord;
            @Node.Child
            private WriteElementNode propertySetNode;
            {
                super(lang);
                this.getElementRecord = PropertyGetNode.createGetHidden(ELEMENT_RECORD_KEY, context);
                this.propertySetNode = WriteElementNode.create(context, false);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object thiz = JSFrameUtil.getThisObj(frame);
                JSFunctionObject function = JSFrameUtil.getFunctionObject(frame);
                ClassElementDefinitionRecord record = (ClassElementDefinitionRecord)this.getElementRecord.getValue(function);
                assert (!record.isPrivate());
                Object[] args = frame.getArguments();
                JSDynamicObject newValue = JSArguments.getUserArgumentCount(args) > 0 ? JSArguments.getUserArgument(args, 0) : Undefined.instance;
                this.propertySetNode.executeWithTargetAndIndexAndValue(thiz, record.getKey(), (Object)newValue);
                return Undefined.instance;
            }
        }.getCallTarget();
        return JSFunctionData.createCallOnly(context, callTarget, 1, Strings.SET);
    }

    public static class DecorationState {
        boolean finished = false;
    }
}

