/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.function.AbstractFunctionRootNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.AsyncRootNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public final class TopLevelAwaitModuleBodyNode
extends JavaScriptNode {
    private final JSContext context;
    @Node.Child
    private JSWriteFrameSlotNode writeAsyncResult;
    @Node.Child
    private JSWriteFrameSlotNode writeAsyncContextNode;
    private final TopLevelAwaitModuleRootNode resumptionRootNode;
    @Node.Child
    private volatile DirectCallNode asyncCallNode;

    private TopLevelAwaitModuleBodyNode(JSContext context, JSWriteFrameSlotNode writeAsyncContextNode, TopLevelAwaitModuleRootNode resumptionRootNode) {
        this.context = context;
        this.writeAsyncContextNode = writeAsyncContextNode;
        this.resumptionRootNode = resumptionRootNode;
    }

    public static JavaScriptNode create(JSContext context, JavaScriptNode moduleBody, JSWriteFrameSlotNode writeAsyncResult, JSWriteFrameSlotNode writeAsyncContext, SourceSection functionSourceSection, ScriptOrModule activeScriptOrModule) {
        TopLevelAwaitModuleRootNode resumptionRootNode = new TopLevelAwaitModuleRootNode(context, moduleBody, writeAsyncResult, functionSourceSection, activeScriptOrModule);
        return new TopLevelAwaitModuleBodyNode(context, writeAsyncContext, resumptionRootNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object[] arguments = frame.getArguments();
        JSModuleRecord moduleRecord = (JSModuleRecord)JSArguments.getUserArgument(arguments, 0);
        MaterializedFrame moduleFrame = moduleRecord.getEnvironment() != null ? JSFrameUtil.castMaterializedFrame(moduleRecord.getEnvironment()) : frame.materialize();
        PromiseCapabilityRecord promiseCapability = JSArguments.getUserArgumentCount(arguments) >= 2 ? (PromiseCapabilityRecord)JSArguments.getUserArgument(arguments, 1) : null;
        this.ensureAsyncCallTargetInitialized();
        if (promiseCapability != null) {
            this.writeAsyncContextNode.executeWrite(moduleFrame, AsyncRootNode.createAsyncContext(this.asyncCallNode.getCallTarget(), promiseCapability, moduleFrame));
        }
        Object unusedInitialResult = null;
        this.asyncCallNode.call(JSArguments.createResumeArguments(moduleFrame, promiseCapability, Completion.Type.Normal, unusedInitialResult));
        if (promiseCapability == null) {
            return Undefined.instance;
        }
        return promiseCapability.getPromise();
    }

    private void ensureAsyncCallTargetInitialized() {
        if (this.asyncCallNode == null) {
            this.initializeAsyncCallTarget();
        }
    }

    private void initializeAsyncCallTarget() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.asyncCallNode = this.insert(DirectCallNode.create(this.resumptionRootNode.getCallTarget()));
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new TopLevelAwaitModuleBodyNode(this.context, TopLevelAwaitModuleBodyNode.cloneUninitialized(this.writeAsyncContextNode, materializedTags), this.resumptionRootNode);
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (!materializedTags.isEmpty()) {
            this.resumptionRootNode.getCallTarget();
        }
        return this;
    }

    public static final class TopLevelAwaitModuleRootNode
    extends AbstractFunctionRootNode {
        private final JSContext context;
        @Node.Child
        private JavaScriptNode functionBody;
        @Node.Child
        private JSFunctionCallNode callResolveNode;
        @Node.Child
        private JSFunctionCallNode callRejectNode;
        @Node.Child
        private JSWriteFrameSlotNode writeAsyncResult;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

        TopLevelAwaitModuleRootNode(JSContext context, JavaScriptNode body2, JSWriteFrameSlotNode asyncResult, SourceSection functionSourceSection, ScriptOrModule activeScriptOrModule) {
            super(context.getLanguage(), functionSourceSection, null, activeScriptOrModule);
            this.context = context;
            this.functionBody = body2;
            this.callResolveNode = JSFunctionCallNode.createCall();
            this.writeAsyncResult = asyncResult;
        }

        @Override
        public Object executeInRealm(VirtualFrame frame) {
            Object[] arguments = frame.getArguments();
            MaterializedFrame asyncFrame = JSArguments.getResumeExecutionContext(arguments);
            PromiseCapabilityRecord promiseCapability = (PromiseCapabilityRecord)JSArguments.getResumeGeneratorOrPromiseCapability(arguments);
            Completion resumptionValue = JSArguments.getResumeCompletion(arguments);
            this.writeAsyncResult.executeWrite(asyncFrame, resumptionValue);
            JSModuleRecord moduleRecord = (JSModuleRecord)JSArguments.getUserArgument(asyncFrame.getArguments(), 0);
            try {
                Object returnValue = this.functionBody.execute(asyncFrame);
                assert (promiseCapability != null);
                this.promiseCapabilityResolve(promiseCapability, returnValue);
            }
            catch (YieldException e) {
                assert (promiseCapability != null ? e.isAwait() : e.isYield());
                if (e.isYield()) {
                    moduleRecord.setEnvironment(JSFrameUtil.castMaterializedFrame(asyncFrame));
                } else assert (e.isAwait());
            }
            catch (AbstractTruffleException e) {
                if (promiseCapability != null) {
                    this.promiseCapabilityReject(promiseCapability, e);
                }
                throw e;
            }
            return Undefined.instance;
        }

        @Override
        public boolean isResumption() {
            return true;
        }

        @Override
        public String getName() {
            return ":top-level-await-module";
        }

        private void promiseCapabilityResolve(PromiseCapabilityRecord promiseCapability, Object result2) {
            this.callResolveNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getResolve(), result2));
        }

        private void promiseCapabilityReject(PromiseCapabilityRecord promiseCapability, AbstractTruffleException e) {
            if (this.getErrorObjectNode == null || this.callRejectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getErrorObjectNode = this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
                this.callRejectNode = this.insert(JSFunctionCallNode.createCall());
            }
            Object result2 = this.getErrorObjectNode.execute(e);
            this.callRejectNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getReject(), result2));
        }
    }
}

