/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;

public abstract class ToDateTimeOptionsNode
extends JavaScriptBaseNode {
    private static final String ALL = "all";
    private static final String ANY = "any";
    private static final String DATE = "date";
    private static final String TIME = "time";
    final JSContext context;

    public JSContext getContext() {
        return this.context;
    }

    public ToDateTimeOptionsNode(JSContext context) {
        this.context = context;
    }

    public abstract JSDynamicObject execute(Object var1, String var2, String var3);

    @Specialization(guards={"isUndefined(opts)"})
    public JSDynamicObject fromUndefined(Object opts, String required, String defaults) {
        return ToDateTimeOptionsNode.setDefaultsIfNeeded(JSOrdinary.createWithNullPrototype(this.getContext()), required, defaults);
    }

    @Specialization(guards={"!isUndefined(opts)"})
    public JSDynamicObject fromOtherThenUndefined(Object opts, String required, String defaults, @Cached JSToObjectNode toObjectNode, @Cached(value="createOrdinaryWithPrototype(context)") CreateObjectNode.CreateObjectWithPrototypeNode createObjectNode, @Cached InlinedBranchProfile errorBranch) {
        Object optionObject = toObjectNode.execute(opts);
        if (JSDynamicObject.isJSDynamicObject(optionObject)) {
            JSObject options = createObjectNode.execute((JSDynamicObject)optionObject);
            return ToDateTimeOptionsNode.setDefaultsIfNeeded(options, required, defaults);
        }
        errorBranch.enter(this);
        throw Errors.createTypeErrorInvalidPrototype(optionObject);
    }

    private static JSDynamicObject setDefaultsIfNeeded(JSDynamicObject options, String required, String defaults) {
        boolean needDefaults = true;
        if (required != null) {
            if (DATE.equals(required) || ANY.equals(required)) {
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, Strings.WEEKDAY));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, Strings.YEAR));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, Strings.MONTH));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, Strings.DAY));
            }
            if (TIME.equals(required) || ANY.equals(required)) {
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, IntlUtil.KEY_DAY_PERIOD));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, Strings.HOUR));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, Strings.MINUTE));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, Strings.SECOND));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, IntlUtil.KEY_FRACTIONAL_SECOND_DIGITS));
            }
        }
        Object dateStyle = JSObject.get(options, Strings.DATE_STYLE);
        Object timeStyle = JSObject.get(options, Strings.TIME_STYLE);
        if (dateStyle != Undefined.instance || timeStyle != Undefined.instance) {
            needDefaults = false;
        }
        if (DATE.equals(required) && timeStyle != Undefined.instance) {
            throw Errors.createTypeError("timeStyle option is not allowed here");
        }
        if (TIME.equals(required) && dateStyle != Undefined.instance) {
            throw Errors.createTypeError("dateStyle option is not allowed here");
        }
        if (defaults != null) {
            if (needDefaults && (DATE.equals(defaults) || ALL.equals(defaults))) {
                JSRuntime.createDataPropertyOrThrow(options, Strings.YEAR, Strings.NUMERIC);
                JSRuntime.createDataPropertyOrThrow(options, Strings.MONTH, Strings.NUMERIC);
                JSRuntime.createDataPropertyOrThrow(options, Strings.DAY, Strings.NUMERIC);
            }
            if (needDefaults && (TIME.equals(defaults) || ALL.equals(defaults))) {
                JSRuntime.createDataPropertyOrThrow(options, Strings.HOUR, Strings.NUMERIC);
                JSRuntime.createDataPropertyOrThrow(options, Strings.MINUTE, Strings.NUMERIC);
                JSRuntime.createDataPropertyOrThrow(options, Strings.SECOND, Strings.NUMERIC);
            }
        }
        return options;
    }
}

