/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.Interner;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class WeakInterner<T>
extends Interner<T> {
    private final ConcurrentMap<T, T> map;

    protected WeakInterner() {
        this.map = CollectionFactory.createConcurrentWeakKeyWeakValueMap();
    }

    public WeakInterner(@NotNull HashingStrategy<? super T> strategy) {
        if (strategy == null) {
            WeakInterner.$$$reportNull$$$0(0);
        }
        this.map = CollectionFactory.createConcurrentWeakKeyWeakValueMap(strategy);
    }

    @Override
    @NotNull
    public T intern(@NotNull T name) {
        T old;
        if (name == null) {
            WeakInterner.$$$reportNull$$$0(1);
        }
        T t = (old = this.map.putIfAbsent(name, name)) == null ? name : old;
        if (t == null) {
            WeakInterner.$$$reportNull$$$0(2);
        }
        return t;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @NotNull
    public Set<T> getValues() {
        return new HashSet(this.map.values());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/WeakInterner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/WeakInterner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

